unit soutbuf ;

  {
   pixel output buffer routines
  }

interface

  uses

    CNV ;

  procedure open_pixel_file(parse_info   : parse_infotype ;
                            var display_info : display_infotype) ;

  procedure close_pixel_file ;

  procedure pixel_write(b : byte) ;

  procedure pixel_write_string(stri : string) ;

implementation

  uses

    DOS, CRT ;

  const

    buffersize = 8192*2 ;

  var

    outputfile    : file ;
    output_buffer : array[1..buffersize] of byte ;
    bufferpos     : integer ;


  procedure open_pixel_file(parse_info   : parse_infotype ;
                            var display_info : display_infotype) ;

    var

      stat : integer ;
      output_name : string ;
      default_name : string ;
      ch : char ;
      dir   : dirstr ;
      name  : namestr ;
      ext   : extstr ;

    begin

      with display_info do
        begin
          if display = msxfile
            then
              begin
                default_name := '';
                if msx_type = mscreen
                  then
                    begin
                      if msx_screen = scr5
                        then
                          default_name := 'SC5'
                      else if msx_screen = scr6
                        then
                          default_name := 'SC6'
                      else if msx_screen = scr7
                        then
                          default_name := 'SC7'
                      else if msx_screen = scr8
                        then
                          default_name := 'SC8'
                      else if msx_screen = scr12
                        then
                          default_name := 'SCC'
                    end
                  else { Copy }
                      if msx_screen = scr5
                        then
                          default_name := 'CC5'
                      else if msx_screen = scr6
                        then
                          default_name := 'CC6'
                      else if msx_screen = scr7
                        then
                          default_name := 'CC7'
                      else if msx_screen = scr8
                        then
                          default_name := 'CC8'
                     else if msx_screen = stp6
                      then
                        default_name := 'STP'
              end
            else if display = pcxfile
              then
                default_name := 'PCX'
            else if display = sixelfile
              then
                default_name := 'SXL'
            else
              default_name := '';
          end ;
      output_name := parse_info.filename + '.' + default_name ;
         assign(outputfile, output_name) ;
         {$I-}
         reset(outputfile) ;
         {$I+}
         stat := IOresult ;
         if stat = 0
           then
	     begin
               writeln('File ',output_name, ' already exists') ;
               write('Overwrite [Y/n] ?') ;
               repeat
                 ch := Readkey ;
                 if ch = chr(13)
                   then
                     ch := 'Y' ;
                 ch := upcase(ch) ;
               until (ch = 'Y') or (ch = 'N') ;
               writeln(ch) ;
	       stat := 0 ;
               if (ch = 'N')
                 then
		   halt(1)  ;
	     end
	   else
	     stat := 0 ;
	 if stat = 0
           then
             begin
               {$I-}
               rewrite(outputfile,1) ;
               {$I+}
               stat := IOresult ;
               if stat <> 0
                 then
                   writeln('Could not create outputfile') ;
            end ;
      Fsplit(output_name, dir, name, ext) ;

      display_info.filename := name ;
      display_info.filext   := ext  ;
      bufferpos := 0 ;

  end ; { Open_pixel_file }


  procedure close_pixel_file ;

    begin

      if bufferpos > 0
        then
          blockwrite(outputfile,output_buffer,bufferpos) ;
      close(outputfile) ;


    end ; { close_pixel_file }


  procedure pixel_write(b : byte) ;

    begin

      if bufferpos = buffersize
        then
          begin
            blockwrite(outputfile,output_buffer,buffersize) ;
            bufferpos := 0 ;
          end ;
      inc(bufferpos) ;

      output_buffer[bufferpos] := b ;

    end ; { pixel_write }

  procedure pixel_write_string(stri : string) ;

    var

      count : integer ;

    begin

      for count := 1 to length(stri) do
        pixel_write(ord(stri[count])) ;

    end ; { pixel_write_string }


end. { unit soutbuf }
