unit screate ;

 interface

 {
   Module  : SCREATE

   Author  : Hans Otten

   Version : 1.3  13-march-1991

   Facility: Sixel/PCX/MSX routines

   Purpose : output pixels to
               - video display
               - MSX Copy or Screen, 5-8, STP
               - PCX
               - sixel
               - PCT (Dyn Pub picture)
               - PCSTP (Dyn Pub PC stamp)



}
   uses

     CNV, SGRAPH, SMSXCR, SSIXELCR, SPCXCR ;

   {
     feeds pixel output of display_* procedures
     to selected output
   }

  procedure Init_output(display_info : display_infotype ;
                        parse_info : parse_infotype ;
                        colormap : colormap_type ;
                        vdisplay : vdisplay_type ) ;

  procedure Close_output(colormap : colormap_type) ;

  procedure Add_pixel(x,y,color : integer );


implementation

  uses

    SOUTBUF ;



  var

    cdisplay_info : display_infotype ;


  procedure Init_output(display_info : display_infotype ;
                        parse_info   : parse_infotype ;
                        colormap     : colormap_type ;
                        vdisplay     : vdisplay_type ) ;


    begin { main Init_output }

      reset_error ;
      cdisplay_info := display_info ;
      with cdisplay_info do
        begin
          if display <> video
            then
              Open_pixel_file(parse_info, display_info) ;
          if display = msxfile
            then
              init_output_msx(display_info,
                             parse_info,
                             colormap)
          else if display = sixelfile
            then
              init_output_sixel(display_info,
                                parse_info,
                                colormap)
          else if display = PCXfile
            then
              Init_output_PCX(display_info,
                              parse_info,
                              colormap)
          else if display = video
            then
              Graph_Init(parse_info,
                         colormap,
                         display_info,
                         vdisplay) ;
        end ;

    end ; { Init_output }


  procedure Close_output(colormap : colormap_type) ;

    { close output stream }


    begin

      with cdisplay_info do
        begin
          if display = msxfile
            then
              close_output_msx
          else if display = pcxfile
            then
              close_output_pcx(colormap)
          else if display = sixelfile
            then
              close_output_sixel
          else if display = video
            then
              Close_Graph ;
          if display <> video
            then
              close_pixel_file ;
        end ;

    end ; { Close_output }


  procedure Add_pixel(x,y,color : integer) ;


    {
     add current pixel to output device selected
     x,y coordinates of original picture
       (1..max_parse_col) (1..max_parse_row)
     cdisplay_info.current_col,row
     coordinates in output picture
       (1..(end_view_row - start_view_row + 1)
     within boundaries given by cdisplay_info.start, end row, col

    }



    begin { main Add_pixel }

      with cdisplay_info do
        begin
          { check if within display boundaries }
          if ( x >= start_view_col) and
             ( x <= end_view_col  ) and
             ( y >= start_view_row) and
             ( y <= end_view_row  )
            then
              begin
                if inverse
                  then
                    color := color xor 1 ;
                { transform coordinates to display coordinates }
                x := x - start_view_col + 1 ;
                y := y - start_view_row + 1 ;
                if display = video
                  then
                    Display_pixel(x,y,color)
                else if display = msxfile
                  then
                    Add_pixel_MSX(x,y,color)
                else if display = PCXfile
                  then
                   Add_pixel_PCX(x,y,color)
                else if display = sixelfile
                  then
                    Add_pixel_sixel(x,y,color) ;
              end ;
        end ;

    end ; { Add_Pixel }

end. { unit screate }
