unit cnv ;
{$V-}

{

   Module  : CNV

   Author  : Hans Otten

   Version : 2.0  22-may-1991

   Facility: MSX/Sixel/PCX convert/display routines

   Purpose : definitions, general purpose routines


}

interface

  uses

    DOS ;

  const

    sxl_maxrow = 6   ;     { 6 pixels in sixel   }
    max_color  = 255 ;     { entries in colormap }
    colormax   = 255 ;     { color value maximum }

    max_pixel_col = 1024 ;
    { error messages }

    max_error      = 10 ;               { stop processing if more than 10 }
    premature_end  = 1 ;                { Premature end of file           }
    invalid_backg  = 2 ;                { Invalid background parameter    }
    invalid_raster = 3 ;                { Invalid raster attributes       }
    invalid_DCS    = 4 ;                { Invalid char's in DCS           }
    skipped_dcs    = 5 ;                { skipped char's before DCS       }
    invalid_repeat = 6 ;                { invalid repeat sequence         }
    invalid_color  = 7 ;                { invalid color sequence          }
    not_msx_screen = 8 ;                { Invalid ID byte in MSX screen   }
    inv_pcx_vers   = 9 ;                { not supported PCX version       }
    inv_pcx_format = 10 ;               { invalid PCX format              }
    pcx_no_color   = 11 ;               { no colormap in PCX file         }
    not_implement  = 12 ;               { not implemented stub            }
    nopalette      = 13 ;               { palette file not found/invalid  }
    toobig         = 14 ;               { picture too wide                }
    not_PCT        = 15 ;               { not a DP PCT file               }

    { type of error messages }
    fatal          = true  ;
    warning        = false ;

    { picture file types }
    MSX5S  = 'SC5'  ;
    MSX6S  = 'SC6'  ;
    MSX7S  = 'SC7'  ;
    MSX8S  = 'SC8'  ;
    MSX12S = 'SCC' ;
    MSX5C  = 'CC5'  ;
    MSX6C  = 'CC6'  ;
    MSX7C  = 'CC7'  ;
    MSX8C  = 'CC8'  ;
    STP    = 'STP'    ;
    SIXEL  = 'SIXEL'  ;
    screen = 'SCREEN' ;
    exi    = 'END'  ;
    PCX    = 'PCX'    ;
    PCT    = 'PCT'    ;
    PCSTP  = 'PCSTP'  ;

    { sixel devices }
    LJ250  = 'LJ250'  ;
    LA75   = 'LA75'   ;
    LN03   = 'LN03'   ;
    NO_DEV = 'NO'   ;

  type

    string6          = string[6] ;
    vdisplay_type    = (low, high, auto) ;
    display_type     = (parse,
                        msxfile,pcxfile,sixelfile,pctfile, pcstpfile,
                        video, quit) ;
    msx_screentype   = (scr5,scr6,scr7,scr8,scr12,stp6,noscr) ;
    msx_type         = (mscreen, mcopy, none) ;
    sixel_devicetype = (sla75,slj250,sln03,snodevice) ;

    display_infotype = record
                         start_view_col,
                         end_view_col,
                         start_view_row,
                         end_view_row    : integer ;
                         display : display_type ;
                         msx_screen : msx_screentype ;
                         msx_type : msx_type ;
                         enlarge_h  : byte ;
                         enlarge_v  : byte ;
                         sdevice   : sixel_devicetype ;
                         inverse   : boolean ;
                         filename         : namestr ;
                         filext           : extstr ;
                       end ;

    videotype    = (vlow, vhigh, vmono) ;

    color_values = (c_red,c_green,c_blue) ;

    colortype = record
                  colors  : array[c_red..c_blue] of byte ;
                  defined : boolean ;
                  used    : boolean ;
                end ;

    colormap_type  = array[0..max_color] of colortype ;

    parse_infotype =
      record

        max_parse_row,
                         { max sixel column }
        max_parse_col    : integer ;
        parse_type       : display_type ;
        parse_msx_screen : msx_screentype ;
        parse_msx_type   : msx_type ;
        filename         : namestr ;
        filext           : extstr ;
                         { current writing color }
        current_color    : integer ;
                         { nr of colors in use in picture }
        defined_colors,
        used_colors      : integer ;

	mono             : boolean ;

	DCS_skipped      : boolean ;
                         { parameter results empty is 0 is default }
        ps               : array[1..4] of integer  ;
                         { nr of defined parameters }
        pcount           : integer ;
                         { raster attributes sequence parameters 0 = default }
        r_attributes     : array[1..4] of integer;
                         { true if valid raster attributes found }
        raster_valid     : boolean ;
                         { selects fixed horiz grid size (pixel width)
                           and aspect ratio }
        macro_parameter  : integer ;
                         { 0 or 2 : current background 1: write current color }
        background       : integer ;
                         { grid size (pixel width, device dependent }
        horizontalgrid   : integer ;
      end ;


  function Getvalue(default_value : integer) : integer ;

  procedure Get_String(var str : string ; len : integer) ;

  procedure reset_error ;

  procedure report_error(error_nr : integer ;
                         error_level : boolean ;
                         display : display_type) ;

  procedure init_parse(var parse_info: parse_infotype ;
                       var colormap : colormap_type) ;

  procedure display_parse_info (var parse_info : parse_infotype) ;


implementation

  uses

    CRT,
    SGraph ;

  var

    error_count : integer ;    { keep track of nr of errors    }


  function Getvalue(default_value : integer) : integer ;

    { reads integer value form keyboard }

    var

      ch      : char ;
      valstr  : array[1..20] of char ;
      ch_count,
      count,
      value   : integer;

    begin

      ch_count := 0 ;
      repeat
        ch := ReadKey ;
        if ch in ['0'..'9']
          then
            begin
              inc(ch_count) ;
              write(ch) ;
              valstr[ch_count] := ch ;
            end
          else if (ch = chr(8)) and
                  (ch_count > 0 )
            then
              begin
                write(ch) ;
                write(' ') ;
                write(ch) ;
                dec(ch_count) ;
              end ;
      until ch = chr(13) ;
      writeln ;

      value := 0 ;
      if ch_count > 0
        then
          begin
            for count := 1 to ch_count do
              value := value * 10 + ord(valstr[count]) - ord('0') ;
            Getvalue := value ;
          end
        else
          Getvalue := default_value

    end ; { Getvalue }

    procedure Get_String(var str : string ; len : integer) ;

      var

        ch : char ;
        counter,
        count : integer ;
        inpstr : array [1..256] of char ;

      begin

        str := '' ;
        count := 0 ;
        repeat
          ch := readkey ;
          ch := Upcase(ch) ;
          if ch in ['A'..'Z','0'..'9',
                   '&','%','-','_','!','(',')',
                    '.',':','\']
            then
              begin
                inc(count) ;
                write(ch) ;
                inpstr[count] := ch ;
              end
          else if ch = chr(8)
            then
              begin
               if count > 0
                 then
                   begin
                     dec(count) ;
                     write(ch) ;
                     write(' ') ;
                     write(ch) ;
                   end
               end
         until (ch = chr(13)) or (ch = chr(27)) ;
         writeln ;

         if ch = chr(27)
           then
             str := ch
         else if count > 0
           then
             begin
               if count > len
                 then
                   count := len ;
               for counter := 1 to count do
                 str := str + inpstr[counter] ;
             end ;
      end ;


  procedure reset_error ;

    begin

      error_count := 0 ;

    end ;

  procedure report_error(error_nr : integer ;
                         error_level : boolean ;
                         display : display_type) ;

   { report error }

    begin

      if (display = video) and (error_level = fatal)
        then
          Close_Graph ;
      if (display <> video)  or
         ((display = video) and (error_level = fatal) )
        then
          case error_nr of
            premature_end  : writeln('Premature end of file') ;
            invalid_backg  : writeln('Invalid background parameter') ;
            invalid_raster : writeln('Invalid raster attributes') ;
            invalid_dcs    : writeln('Invalid characters in DCS') ;
            skipped_dcs    : writeln('Skipped characters before sixel DCS') ;
            invalid_repeat : writeln('Invalid repeat sequence') ;
            invalid_color  : writeln('Invalid color sequence') ;
            not_msx_screen : writeln('Format MSX file unknown') ;
            inv_pcx_format : writeln('Format PCX file unknown') ;
            inv_pcx_vers   : writeln('Unsupported PCX version') ;
            nopalette      : writeln('No valid palette file') ;
            not_implement  : writeln('Not implemented yet') ;
            toobig         : writeln('Picture too wide, max = ',
                                     max_pixel_col: 1 ) ;
            not_PCT        : writeln('Not a Dynamic Publisher picture') ;
        end ;

    if (error_level = fatal) or (error_count > 10)
      then
        begin
          writeln ;
          writeln('Fatal error') ;
          halt(1) ;
	end ;

     error_count := error_count + 1 ;

    end ; { report_error }


  procedure init_parse(var parse_info: parse_infotype ;
                       var colormap : colormap_type) ;

    { fill parse info and colormap with defaults }

    var

      count : integer ;
      color_count : color_values ;

    begin

      reset_error ;
      with parse_info do
        begin
          for count := 1 to 4 do
            begin
              ps[count] := 0 ;
              r_attributes[count] := 0
            end ;
          DCS_skipped := false ;
          raster_valid := false ;
          pcount := 0 ;
          macro_parameter := 0 ;
          background := 0 ;
          horizontalgrid := 0 ;
          current_color := 0 ;
          used_colors := 0 ;
          max_parse_row := 0 ;
	  max_parse_col := 0;
        end ;

      { initialise colormap to black, unused and unspecified }
      for count := 0 to max_color do
        begin
          colormap[count].defined := false ;
          colormap[count].used    := false ;
          { unspecified colors are black }
          for color_count := c_red to c_blue do
            colormap[count].colors[color_count] := 0 ;
        end ;

    end ; { init_parse }


  procedure display_parse_info (var parse_info : parse_infotype) ;

    begin

      with parse_info do
        begin
          writeln ;
          if DCS_skipped
            then
              writeln('Skipped characters before DCS') ;
          if (pcount > 0)
            then
              begin
                writeln('Protocol Selectors') ;
                writeln('Macro parameter = ', ps[1]:1) ;
              end ;
          if pcount > 1
            then
              begin
                write('Background color parameter = ',ps[2]:1,' : ') ;
                if (ps[2] = 0) or (ps[2] = 2)
                  then
                    writeln('Overwrite')
                else if ps[2] = 1
                  then
                    writeln('Overstrike')
                else
                  begin
                    writeln('Invalid background parameter, default overwrite') ;
                    ps[2] := 0 ;
                  end ;
              end ;
          if pcount > 2
            then
              writeln('Horizontal grid size parameter = ',ps[3]:1) ;

          { Raster attributes }
          if raster_valid
            then
              begin
                writeln('Raster attributes found: ') ;
                writeln('  Pan = ', r_attributes[1] ) ;
                write  ('  Pad = ', r_attributes[2] ) ;
                writeln('  aspect ratio ', r_attributes[1]:1, ':',
                                           r_attributes[2]:1 ) ;
                writeln('  Background horizontal size = ', r_attributes[3] ) ;
                writeln('             vertical size   = ', r_attributes[4] ) ;
              end ;

          writeln('Picture ',filename, filext,
                   ' is ', max_parse_col:1 ,' columns by ',
                   max_parse_row:1, ' rows') ;
          writeln('Used colors    = ',used_colors:1) ;
          writeln('Defined colors = ',defined_colors:1) ;


        end ;

    end ; { display_parse_info }

end. { unit CNV }
