unit SBUFFER ;

interface

  uses

    DOS,
    CNV ;

  const

    CTRLZ = #26 ;
    CR  = #13 ;
    LF  = #10 ;

  procedure OpenFiles(picture_name : pathstr) ;

  procedure CloseFiles ;

  function GetNextByte : char ;

  procedure GetNextChar(var next_char : char) ;

  procedure Get_PCX_Colormap(var colormap: colormap_type ;
                             display : display_type) ;

  procedure Reset_PCX_picture ;

  procedure Reset_MSX_picture ;

{

   Module  : Buffered file I/O routines Turbo Pascal V5.5

   Author  : Hans Otten

   Version : 1.1  4-jan-1990

   Facility: Sixel routines

   Purpose : Handle file input: buffered input of sixel file


   Routines:
              Procedure OpenFiles

               opens sixel file for input
               any error is fatal
               sixelfile   = handle
               sixel_name  = string containing filename
               forces buffered reading

             Procedure CloseFiles

               closes all files opened in OpenFiles

             Procedure GetNextChar

               returns next_char from sixel file, CTRLZ if end-of-file
               CR and LF skipped
}

implementation

  const

    bufsize = 8192 * 2 ;

  type

    buffertype   = array[1..bufsize] of char ;

  var

    buffer : buffertype ;      { during processing of picture  }
    bufferlen,                 { total char's in line          }
    bufferpos  : integer ;     { position in line              }

    picture_file : file ;      { Input file no structure       }

  procedure OpenFiles(picture_name : pathstr) ;

  {
    open input file, picture_name is filespec
    Turbo pascal V5 style: record size = 1
  }

    begin

      assign(picture_file, picture_name) ;
      {$I-}
      reset(picture_file,1) ;
      {$I+}
      if IOresult <> 0
      then
        begin
          writeln('Kan bestand niet openen: ',picture_name,' for input') ;
          halt(1) ;
        end ;

      { force buffered reading if GetNext* called first time }
      bufferpos := 0 ;
      bufferlen := 0 ;

    end ; { OpenFiles }


  procedure CloseFiles ;

    begin

      close(picture_file) ;

    end ; { CloseFiles }

   procedure get_buffer ;

    {
     returns next buffer from input file
     expects file to be opened
     uses blockread to read file unstructured

     modifies

       bufferpos
       bufferlen
       buffer
    }

    begin

      bufferpos := 0 ;
      blockread(picture_file,buffer,bufsize,bufferlen) ;
      if bufferlen = 0
        then
          begin
            bufferlen := 1 ;
            buffer[1] := CTRLZ ;
          end ;

     end ; { get_buffer }

  function GetNextByte : char ;

    { returns next byte unfiltered from input }

    begin

      if bufferpos = bufferlen
        then
          get_buffer ;
       bufferpos := bufferpos + 1 ;
       GetNextByte := buffer[bufferpos] ;

    end ; { GetNextByte }

  procedure GetNextchar ;

    {
     returns next_char from input
     CR and LF ignored
    }

  begin { main GetNextChar }

    repeat
      next_char := GetNextByte
    until (next_char <> LF) and (next_char <> CR) ;

  end ; { GetNextChar }

  procedure Get_PCX_Colormap(var colormap: colormap_type ;
                              display : display_type) ;

    var

      color_nr : integer ;

    begin

      { position at colormap startpoint }
      seek(picture_file,filesize(picture_file)-769) ;
      get_buffer ;
      if (buffer[1]  = chr(12)) and (bufferlen = 769)
        then
            for color_nr := 0 to max_color do
              begin
                colormap[color_nr].defined := true ;
                colormap[color_nr].colors[c_red] :=
                   round(ord(buffer[color_nr*3 + 2])) ;
                colormap[color_nr].colors[c_green] :=
                   round(ord(buffer[color_nr*3 + 3])) ;
                colormap[color_nr].colors[c_blue] :=
                   round(ord(buffer[color_nr*3 + 4])) ;
             end

    end ;

procedure Reset_PCX_picture ;

  begin

    seek(picture_file,128) ;
    { force buffered reading if GetNext* called first time }
    bufferpos := 0 ;
    bufferlen := 0 ;

  end ;

procedure Reset_MSX_picture ;

  begin

    seek(picture_file,0) ;
    { force buffered reading if GetNext* called first time }
    bufferpos := 0 ;
    bufferlen := 0 ;

  end ;

end. { Unit sbuffer }