PROGRAM CNVS ( input, output) ;
{$V-}

  { collection of routines to manipulate sixel, PCX and MSX picture files }

  { V2.1        Turbo Pascal V5.5

                Hans Otten,

                last update 21-oct-1991 }

uses

  DOS, CRT,
  CNV, SGRAPH, SBUFFER, SSIXEL, SMSX, SPCX, SPCT, SCREATE ;


var

    { variables filled in during parse stage }
    parse_info        : parse_infotype ;

    { holds colormap in RGB format  }
    colormap          : colormap_type ;

    { input picture file information }

    display_info      : display_infotype; { parse or display/convert type }

    picture_name      : pathstr ;


Procedure CheckParameters ;

  {

    command line syntax:

      CNVS picture-file qualifiers


    To work upon a picture-file we need to know the following:

      - name of picture-file
      - source type
          o MSX-5,6,7,8,12 screen
          o MSX 5,6,7,8 copy
          o sixel
          o PCX
          o DP PCT
      - destination type
          o MSX-5,6,7,8,12 screen
          o MSX 5,6,7,8 copy
          o sixel
          o PCX
          o video
      - window to show or convert
        if video
          preferred display-mode
            VGA       320x200 in 256 colors
            EGA/VGA   640x350 in 16  colors
            Automatic (dependent colors/resolution)

      Checkparameters asks for name and inputfile

  }

  var

    input_type   : string6 ;
    dir   : dirstr ;
    name  : namestr ;
    ext   : extstr ;
    count : integer ;
    valid_extension : boolean ;

  procedure ShowHelp ;

    {
      show of argument is help a screen full of information
    }

    begin

      writeln('') ;
      writeln('V2.1 (C) Hans Otten 1991') ;
      writeln('') ;
      writeln('Commando regel syntax:') ;
      writeln('') ;
      writeln('  CNVS [plaatje [type]]') ;
      writeln('') ;
      writeln('waarbij') ;
      writeln('') ;
      writeln('    plaatje is file voor conversie of display') ;
      writeln('') ;
      writeln('    type is: sixel, MSX*C, MSX*S, STP, PCX, PCT') ;
      writeln('') ;
      writeln('      en MSX-screen mode * is: 5,6,7,8,12') ;
      writeln('') ;
      writeln('CNVS help : toont dit help scherm') ;
      writeln('') ;

    end ; { ShowHelp }


  begin

    picture_name   := '' ;

    { see if help wanted }
    if (paramcount = 1) and
       ( (paramstr(1) = 'help') or (paramstr(1) = 'HELP'))
      then
        begin
          ShowHelp ;
          halt(0) ;
        end ;


    if paramcount >= 1
      then
        picture_name := paramstr(1)
    else
      begin
        write('Naam van bestand met plaatje? ');
        Get_String(picture_name) ;
        if (length(picture_name) = 0) or (picture_name = chr(27))
          then
            halt(0) ;
      end ;

    Fsplit(picture_name, dir, name, ext) ;

    if length(ext) > 0
      then
        begin
          ext := copy(ext, 2, length(ext) - 1) ;
          if length(ext) > 0
            then
              begin
                for count := 1 to length(ext) do
                  ext[count] := Upcase(ext[count]) ;
                valid_extension := true ;
              end ;
        end ;

    repeat
      if not valid_extension
        then
          begin
            write('Type plaatje? ') ;
            Get_String(input_type) ;
            if (length(input_type) = 0) or (input_type = chr(27))
               then
                 halt(0) ;
          end ;

        valid_extension := true ;
        if (ext = 'PCX') or (ext = 'PCC')
          then
            input_type := PCX
        else if (ext = 'SXL') or
                (ext = 'SLS') or
                (ext = 'SIX')
          then
            input_type := SIXEL
        else if (ext = 'SC8') or
                (ext = 'PIC')
          then
            input_type := MSX8S
        else if (ext = 'SC7')
          then
            input_type := MSX7S
        else if (ext = 'SC6')
          then
            input_type := MSX6S
        else if (ext = 'SC5')
          then
            input_type := MSX5S
        else if (ext = 'CC5')
          then
            input_type := MSX5C
        else if (ext = 'CC6')
          then
            input_type := MSX6C
        else if (ext = 'CC7')
          then
            input_type := MSX7C
        else if (ext = 'CC8')
          then
            input_type := MSX8C
        else if (ext = 'STP')
          then
            input_type := STP
        else if (ext = 'SCC') or (ext = 'SRS')
          then
            input_type := MSX12S
        else if (ext = 'PCT')
          then
            input_type := PCT
        else
          valid_extension := false ;

    until (input_type = MSX5S ) or
          (input_type = MSX6S ) or
          (input_type = MSX7S ) or
          (input_type = MSX8S ) or
          (input_type = MSX12S) or
          (input_type = MSX5C ) or
          (input_type = MSX6C ) or
          (input_type = STP   ) or
          (input_type = MSX7C ) or
          (input_type = MSX8C ) or
          (input_type = PCX   ) or
          (input_type = PCT   ) or
          (input_type = SIXEL ) ;

    with parse_info do
      begin
	mono := false ;
        filename := name ;
        filext   := '.' + ext  ;
        if input_type = PCX
          then
            parse_type := pcxfile
        else if input_type = PCT
          then
            parse_type := pctfile
        else if input_type = SIXEL
          then
            parse_type := sixelfile
        else
          begin
            parse_type := msxfile ;
            if input_type = MSX5S
              then
                begin
                  parse_msx_type := mscreen ;
                  parse_msx_screen := scr5 ;
                end
            else if input_type = MSX6S
              then
                begin
                  parse_msx_type := mscreen ;
                  parse_msx_screen := scr6 ;
                end
            else if input_type = MSX7S
              then
                begin
                  parse_msx_type := mscreen ;
                  parse_msx_screen := scr7 ;
                end
            else if input_type = MSX12S
              then
                begin
                  parse_msx_type := mscreen ;
                  parse_msx_screen := scr12 ;
                end
            else if input_type = MSX8S
              then
                begin
                  parse_msx_type := mscreen ;
                  parse_msx_screen := scr8 ;
                end
            else if input_type = MSX5C
              then
                begin
                  parse_msx_type := mcopy ;
                  parse_msx_screen := scr5 ;
                end
            else if input_type = MSX6C
              then
                begin
                  parse_msx_type := mcopy ;
                  parse_msx_screen := scr6 ;
                end
            else if input_type = MSX7C
              then
                begin
                  parse_msx_type := mcopy ;
                  parse_msx_screen := scr7 ;
                end
            else if input_type = MSX8C
              then
                begin
                  parse_msx_type := mcopy ;
                  parse_msx_screen := scr8 ;
		end
            else if input_type = STP
              then
                begin
                  parse_msx_type := mcopy ;
                  parse_msx_screen := stp6 ;
		  mono := true ;
                end

          end ;
      end ;

  end ; { CheckParameters }


procedure AskDisplayInfo (parse_info : parse_infotype) ;

  {
    Inquire user about: - output device (video display, sixel or MSX)
                        - viewport for display/convert
  }

  var

    ch : char ;
    count : integer ;
    valid_sixeldevice,
    valid_window : boolean ;
    device,
    output_type : string6 ;

  begin

    with display_info do
      begin
        repeat
          while keypressed do
            ch := Readkey ;
          write('Bestemming (scherm, einde, sixel, PCX, MSX*C, MSX*S, STP) ? ') ;
          Get_String(output_type) ;
          if output_type = chr(27)
            then
              halt(0) ;
          if length(output_type) = 0
            then
              output_type := exi ;
          for count := 1 to length(output_type) do
            output_type[count] := Upcase(output_type[count]) ;
        until (output_type = MSX5S )  or
              (output_type = MSX6S )  or
              (output_type = MSX7S )  or
              (output_type = MSX8S )  or
              (output_type = MSX12S)  or
              (output_type = MSX5C )  or
              (output_type = MSX6C )  or
              (output_type = STP   )  or
              (output_type = MSX7C )  or
              (output_type = MSX8C )  or
              (output_type = SIXEL )  or
              (output_type = PCX   )  or
              (output_type = SCREEN) or
              (output_type = EXI) ;
        if output_type = EXI
          then
            halt(0)
        else if output_type = screen
          then
            display := video
        else if output_type = PCX
          then
            display := pcxfile
        else if output_type = SIXEL
          then
            display := sixelfile
        else
          begin
            display := msxfile ;
            if output_type = MSX5S
              then
                begin
                  msx_type := mscreen ;
                  msx_screen := scr5 ;
                end
            else if output_type = MSX6S
              then
                begin
                  msx_type := mscreen ;
                  msx_screen := scr6 ;
                end
            else if output_type = MSX7S
              then
                begin
                  msx_type := mscreen ;
                  msx_screen := scr7 ;
                end
            else if output_type = MSX8S
              then
                begin
                  msx_type := mscreen ;
                  msx_screen := scr8 ;
                end
            else if output_type = MSX12S
              then
                begin
                  msx_type := mscreen ;
                  msx_screen := scr12 ;
                end
            else if output_type = MSX5C
              then
                begin
                  msx_type := mcopy ;
                  msx_screen := scr5 ;
                end
            else if output_type = MSX6C
              then
                begin
                  msx_type := mcopy ;
                  msx_screen := scr6 ;
                end
            else if output_type = MSX7C
              then
                begin
                  msx_type := mcopy ;
                  msx_screen := scr7 ;
                end
            else if output_type = MSX8C
              then
                begin
                  msx_type := mcopy ;
                  msx_screen := scr8 ;
                end
            else if output_type = STP
              then
                begin
                  msx_type := mcopy ;
                  msx_screen := stp6 ;
                end ;

          end ;
        if display <> quit
          then
            repeat
              start_view_col := 1 ;
              write('Wat is de eerste kolom [',start_view_col:1,'] :' ) ;
              start_view_col:= getvalue(start_view_col) ;

              { MSX screen fixed at 256 or 512 columns }
              if (display = msxfile)
                then
                  begin
                    if (msx_screen = scr5) or
                       (msx_screen = scr8) or
                       (msx_screen = scr12)
                      then
                        end_view_col := start_view_col + 255
                      else
                        end_view_col := start_view_col + 511
                  end
                else  { mcopy }
              end_view_col := parse_info.max_parse_col ;
              write('Wat is de laatste kolom [',end_view_col:1,'] :' ) ;
              end_view_col := getvalue(end_view_col) ;

              start_view_row := 1 ;
              write('Wat is de eerste rij [',start_view_row:1,'] :') ;
              start_view_row := getvalue(start_view_row) ;

              { MSX screen fixed at 212 rows }
              if (display= msxfile)
                then
                  end_view_row := start_view_row + 211
                else { copy }
                    end_view_row := parse_info.max_parse_row ;

              write('Wat is de laatste rij [',end_view_row:1,']: ') ;
              end_view_row := getvalue(end_view_row) ;

              valid_window := true ;

              if (start_view_col < 1) or
                 (end_view_col   < 1) or
                 (start_view_row < 1) or
                 (end_view_row   < 1) or
                 (start_view_col >= end_view_col) or
                 (start_view_row >= end_view_row)
                then
                  valid_window := false ;
              if (display = msxfile) and
                 ((end_view_row - start_view_row) > 211 )
                then
                  valid_window := false  ;
              if (display = msxfile )      and
                 ((msx_screen = scr8) or
                  (msx_screen = scr5) or
                  (msx_screen = scr12)   ) and
                 ( (end_view_col - start_view_col) > 255 )
                then
                  valid_window := false ;
              if (display = msxfile) and
                 ((msx_screen = scr6) or (msx_screen = scr7)) and
                 ( (end_view_col - start_view_col) > 511 )
                then
                  valid_window := false ;

              if not valid_window
                then
                  writeln('Onjuiste kolom/rij, probeer het nog eens')  ;

            until valid_window ;

      enlarge_h := 1 ;
      enlarge_v := 1 ;
      sdevice := snodevice ;
      if display = sixelfile
        then
          begin

            { get scale factor horizontally }
            enlarge_h := 1 ;
            repeat
              if enlarge_h <> 1
                then
                  begin
                    writeln('Vergroting is 1,2,3,...') ;
                    writeln('En maximum = maximum kolommen * vergroting < ',max_pixel_col:1)
                  end ;
              write('Vergroting horizontaal [',enlarge_h:1,'] ? ') ;
              enlarge_h := Getvalue(enlarge_h) ;
            until (enlarge_h > 0) and
                ((enlarge_h * (end_view_col - start_view_col + 1))
                    < max_pixel_col) ;

            { get scale factor vertically }
            enlarge_v := 1 ;
            repeat
              if enlarge_v <> 1
                then
                  begin
                    writeln('Vergroting is 1,2,3,...') ;
                  end ;
              write('Vergroting verticaal [',enlarge_v:1,'] ? ') ;
              enlarge_v := Getvalue(enlarge_v) ;
            until (enlarge_v > 0) ;

            { get sixel device type }
            repeat
              repeat
                write('Sixel device [geen] ? ') ;
                Get_String(device) ;
                if device = ''
                  then
                    device := NO_DEV ;
                for count := 1 to length(device) do
                  device[count] := Upcase(device[count]) ;
              until (device = LJ250) or
                    (device = LA75)  or
                    (device = NO_DEV)  or
                    (device  = LN03) ;
              if device = LJ250
                then
                  sdevice := slj250
              else if device = LA75
                then
                  sdevice := sla75
              else if device = LN03
                then
                  sdevice := sln03
              else if device = NO_DEV
                then
                  sdevice := snodevice ;
              valid_sixeldevice := true ;
              if ((device = LN03) or (device = LA75)) and
                 (parse_info.used_colors > 2)
                then
                  begin
                    writeln('Teveel kleuren voor dit apparaat') ;
                    valid_sixeldevice := false ;
                  end ;
            until valid_sixeldevice ;

          end ;

      inverse := false ;
      if parse_info.mono
        then
          begin
            write('Invers [nee]? ') ;
            Get_String(device) ;
            if device[1] = 'N'
               then device := '' ;
            inverse := (length(device) > 0)
          end ;

    end ;

  end ; { AskDisplayInfo }

procedure Scan_picture_file(var parse_info : parse_infotype ;
                            var colormap : colormap_type) ;

  {
    Scan_picture_file    : first pass through picture file to
                   determine colors used, heigth, width
                   and parameters
  }

  var

    count : integer ;

  begin

    display_info.display := parse ;
    OpenFiles(picture_name) ;
    Init_parse(parse_info, colormap) ;
    case parse_info.parse_type of
      sixelfile  : scan_sixel(parse_info, colormap, display_info) ;
      pcxfile    : scan_PCX(parse_info, display_info, colormap) ;
      pctfile    : scan_PCT(parse_info, display_info, colormap) ;
      msxfile    : scan_msx(parse_info, colormap, display_info)
    end ;

    with parse_info do
      begin
        used_colors := 0 ;
        defined_colors := 0 ;
        for count := 0 to max_color do
          begin
            if colormap[count].used
              then
                used_colors := used_colors + 1 ;
            if colormap[count].defined
              then
                defined_colors := defined_colors + 1 ;
            { make undefined but used colors white }
            if (colormap[count].used) and
               (not colormap[count].defined)
              then
                begin
                  colormap[count].defined := true ;
                  colormap[count].colors[c_red]   := colormax ;
                  colormap[count].colors[c_green] := colormax ;
                  colormap[count].colors[c_blue]  := colormax ;
               end ;
          end ;
	  { no colors used/defined, default to
	    black background and white picture, mostly sixel      }
        if used_colors = 0
          then
            begin
              parse_info.current_color := 1 ;
              colormap[0].used := true ;
              colormap[0].colors[c_red]   := 0 ;
              colormap[0].colors[c_green] := 0 ;
              colormap[0].colors[c_blue]  := 0 ;
              colormap[1].used := true ;
              colormap[1].colors[c_red]   := colormax ;
              colormap[1].colors[c_green] := colormax ;
              colormap[1].colors[c_blue]  := colormax ;
              used_colors := 2 ;
	      defined_colors := 2 ;
	      mono := true ;
            end ;

        if (used_colors = 2)  and
           (colormap[0].used) and
           (colormap[1].used)
          then
            mono := true ;

      end ;

    CloseFiles ;

  end ; { Scan_picturefile }


procedure Display_picture_file (parse_info : parse_infotype ;
                                colormap   : colormap_type) ;

  {
    display/convert picture file to selected display
  }

  var

    vdisplay : vdisplay_type ; { low, high or auto             }

  begin  { main display_picturefile }

    with display_info do
      begin
        repeat
          vdisplay := auto ;
          Display_Parse_info (parse_info) ;
          AskDisplayInfo(parse_info) ;
          if display <> quit
            then
              begin
                OpenFiles(picture_name) ;
                Init_output(display_info,
                            parse_info,
                            colormap,
                            vdisplay) ;
                case parse_info.parse_type of
                  sixelfile  : display_sixel(parse_info,
                                             colormap,
                                             display_info) ;
                  pcxfile    : display_PCX(parse_info,
                                           display_info,
                                           colormap) ;
                  pctfile    : display_PCT(parse_info,
                                           display_info,
                                           colormap) ;
                  msxfile    : display_msx(parse_info,
                                           colormap,
                                           display_info)
                end ;
                CloseFiles ;
                Close_output(colormap) ;
              end ;
        until display = quit ;
    end ;

  end ; { Display_picturefile }


begin { main }

  { say hello }
  writeln('CNVS toon en converteer PCX, sixel and MSX plaatjes') ;
  writeln('V2.1 (c) 1991 Hans Otten') ;
  writeln(' (type CNVS HELP voor meer informatie') ;
  writeln ;
  CheckDisplay ;
  CheckParameters ;
  Scan_picture_file(parse_info,
                    colormap) ;
  Display_picture_file(parse_info,
                       colormap) ;

end.
