procedure screen(nummer:byte);

var scr,mask:byte;

  begin
    if nummer>8 then scr:=8 else scr:=nummer;
    inline($3a/scr/                { LD A,(SCR)          }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$d1/$00/        { LD IX,&H00D1        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb);                   { EI                  }
    if nummer>8 then
      begin
        if nummer=12 then mask:=8 else mask:=24;
        inline($3a/mask/           { LD A,(MASK)         }
               $47/                { LD B,A              }
               $0e/$19/            { LD C,&H19           }
               $fd/$2a/$f7/$fa/    { LD IY,(&HFAF7)      }
               $dd/$21/$2d/$01/    { LD IX,&H012D        }
               $cd/$1c/$00/        { CALL &H001C         }
               $fb)                { EI                  }
      end;
  end;


procedure vpoke(adres:integer;waarde:byte);

  begin
    inline($3a/waarde/             { LD A,(WAARDE)       }
           $2a/adres/              { LD HL,(ADRES)       }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$09/$01/        { LD IX,&H0109        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


function vpeek(adres:integer):byte;

var data:byte;

  begin
    inline($2a/adres/              { LD HL,(ADRES)       }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$0d/$01/        { LD IX,&H010D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/data/               { LD (DATA),A         }
           $fb);                   { EI                  }
    vpeek:=data
  end;


procedure set_scroll(x:integer;y,stil,aantal,scr:byte);

var reg25,reg26,reg27:byte;

procedure wrtvdp(reg,data:byte);

  begin
    inline($3a/reg/                { LD A,(REG)          }
           $4f/                    { LD C,A              }
           $3a/data/               { LD A,(DATA)         }
           $47/                    { LD B,A              }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$2d/$01/        { LD IX,&H012D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

  begin
    if scr=12 then reg25:=8
              else if scr in [10..11] then reg25:=24
              else reg25:=0;
    reg25:=reg25 or (2*stil);
    reg25:=reg25 or aantal;
    reg26:=(x and $fff8) shr 3;
    reg27:=7-(x and $0007);
    wrtvdp(23,y);
    wrtvdp(25,reg25);
    wrtvdp(27,reg27);
    wrtvdp(26,reg26);
  end;


procedure cls;

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$15/$01/        { LD IX,&H0115        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure set_page(x,y:byte);

  begin
    mem[$faf5]:=x;mem[$faf6]:=y;
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$3d/$01/        { LD IX,&H013D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure vdp(reg,waarde:byte);

  begin
    if reg in [9..47] then reg:=reg-1;
    inline($3a/reg/                { LD A,(REG)          }
           $4f/                    { LD C,A              }
           $3a/waarde/             { LD A,(WAARDE)       }
           $47/                    { LD B,A              }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$2d/$01/        { LD IX,&H012D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


function vdp_status_reg(reg:byte):byte;

var waarde:byte;

  begin
    inline($3a/reg/                { LD A,(REG)          }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$31/$01/        { LD IX,&H0131        }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/waarde/             { LD (WAARDE),A       }
           $fb);                   { EI                  }
    vdp_status_reg:=waarde
  end;


procedure width(breedte:byte);

  begin
    inline($3a/breedte/            { LD A,(BREEDTE)      }
           $32/$ae/$f3/            { LD (&HF3AE),A       }
           $32/$af/$f3/            { LD (&HF3AF),A       }
           $3a/$af/$fc/            { LD A,(&HFCAF)       }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$d1/$00/        { LD IX,&H00D1        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure color(voor,achter,rand:byte);

  begin
    mem[$f3e9]:=voor;mem[$f3ea]:=achter;mem[$f3eb]:=rand;
    inline($3a/$af/$fc/            { LD A,(&HFCAF)       }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$11/$01/        { LD IX,&H0111        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure def_color(nummer,rood,groen,blauw:byte);

  begin
    rood:=rood shl 4;
    rood:=rood or blauw;
    inline($3a/nummer/             { LD A,(KLEUR)        }
           $57/                    { LD D,A              }
           $3a/groen/              { LD A,(GROEN)        }
           $5f/                    { LD E,A              }
           $3a/rood/               { LD A,(ROOD)         }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$4d/$01/        { LD IX,&H014D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure color_restore;

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$45/$01/        { LD IX,&H0145        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure color_new;

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$41/$01/        { LD IX,&H0141        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure pset(x,y:integer;kleur,log_op:byte);

  begin
    mem[$f3f2]:=kleur;mem[$fb02]:=log_op;
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$91/$00/        { LD IX,&H0091        }
           $cd/$1c/$00/            { CALL &H001C         }
           $dd/$21/$9d/$00/        { LD IX,&H009D        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


function point(x,y:integer):byte;

var kleur:byte;

  begin
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$91/$00/        { LD IX,&H0091        }
           $cd/$1c/$00/            { CALL &H001C         }
           $dd/$21/$95/$00/        { LD IX,&H0095        }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/kleur/              { LD (KLEUR),A        }
           $fb);                   { EI                  }
    point:=kleur
  end;


procedure print(x,y:integer;tekst:char;kleur,log_op:byte);

var kode,oudkleur:byte;

  begin
    kode:=ord(tekst);
    oudkleur:=mem[$f3e9];mem[$f3e9]:=kleur;
    mem[$fb02]:=log_op;
    mem[$fcb7]:=lo(x);mem[$fcb8]:=hi(x);
    mem[$fcb9]:=lo(y);mem[$fcba]:=hi(y);
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $3a/kode/               { LD A,(KODE)         }
           $dd/$21/$89/$00/        { LD IX,&H0089        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb);                   { EI                  }
    mem[$f3e9]:=oudkleur
  end;


procedure put_kanji(x,y,nummer:integer;kleur,display_mode,log_op:byte);

  begin
    mem[$f3f2]:=kleur;mem[$fb02]:=log_op;
    mem[$fcb7]:=lo(x);mem[$fcb8]:=hi(x);
    mem[$fcb9]:=lo(y);mem[$fcba]:=hi(y);
    inline($ed/$4b/nummer/         { LD BC,(NUMMER)      }
           $3a/display_mode/       { LD A,(DISPLAY_MODE) }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$bd/$01/        { LD IX,&H01BD        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure line(x,y,x2,y2:integer;kleur,log_op:byte);

  begin
    mem[$fcb3]:=lo(x2);mem[$fcb4]:=hi(x2);
    mem[$fcb5]:=lo(y2);mem[$fcb6]:=hi(y2);
    mem[$f3f2]:=kleur;
    mem[$fb02]:=log_op;
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$85/$00/        { LD IX,&H0085        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure line_b(x,y,x2,y2:integer;kleur,log_op:byte);

  begin
    mem[$fcb3]:=lo(x2);mem[$fcb4]:=hi(x2);
    mem[$fcb5]:=lo(y2);mem[$fcb6]:=hi(y2);
    mem[$f3f2]:=kleur;
    mem[$fb02]:=log_op;
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$c9/$00/        { LD IX,&H00C9        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure line_bf(x,y,x2,y2:integer;kleur,log_op:byte);

  begin
    mem[$fcb3]:=lo(x2);mem[$fcb4]:=hi(x2);
    mem[$fcb5]:=lo(y2);mem[$fcb6]:=hi(x2);
    mem[$f3f2]:=kleur;
    mem[$fb02]:=log_op;
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$cd/$00/        { LD IX,&H00CD        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure circle(x,y,straal:integer;kleur:byte;afplatting:real;log_op:byte);

var teller,y2,y_oud,x_max,x1:integer;
    afplat1,afplat2:real;

procedure line(x,y,x2,y2:integer;kleur,log_op:byte);

  begin
    mem[$fcb3]:=lo(x2);mem[$fcb4]:=hi(x2);
    mem[$fcb5]:=lo(y2);mem[$fcb6]:=hi(y2);
    mem[$f3f2]:=kleur;
    mem[$fb02]:=log_op;
    inline($ed/$4b/x/              { LD BC,(X)           }
           $ed/$5b/y/              { LD DE,(Y)           }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$85/$00/        { LD IX,&H0085        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

  begin
    y_oud:=0;afplat1:=1;afplat2:=1;
    if afplatting<1 then afplat2:=1/afplatting;
    if afplatting>1 then afplat1:=afplatting;
    case mem[$fcaf] of
      5,8 : x_max:=255;
      6,7 : x_max:=511;
    end;
    for teller:=-straal+1 to 0 do
      begin
        y2:=round(sqrt(sqr(straal)-sqr(teller))*afplat2);
        x1:=round(teller*afplat1);
        if not((y-y_oud<0) and (y-y2<0)) then
          begin
            if not((x+x1-1<0) or (x+x1>x_max)) then
              line(x+x1-1,y-y_oud,x+x1,y-y2,kleur,log_op);
            if not((x-x1+1>x_max) or (x-x1<0)) then
              line(x-x1+1,y-y_oud,x-x1,y-y2,kleur,log_op)
          end;
        if not((y+y_oud>211) and (y+y2>211)) then
          begin
            if not((x+x1-1<0) or (x+x1>x_max)) then
              line(x+x1-1,y+y_oud,x+x1,y+y2,kleur,log_op);
            if not((x-x1+1>x_max) or (x-x1<0)) then
              line(x-x1+1,y+y_oud,x-x1,y+y2,kleur,log_op)
          end;
        y_oud:=y2
      end;
  end;


procedure copy(x,y,x1,y1:integer;s_page:byte;
               x_dest,y_dest:integer;d_page,log_op:byte);

  begin
    mem[$f562]:=lo(x);mem[$f563]:=hi(x);
    mem[$f564]:=lo(y+256*s_page);mem[$f565]:=hi(y+256*s_page);
    mem[$f566]:=lo(x_dest);mem[$f567]:=hi(x_dest);
    mem[$f568]:=lo(y_dest+256*d_page);mem[$f569]:=hi(y_dest+256*d_page);
    mem[$f56a]:=lo(x1-x+1);mem[$f56b]:=hi(x1-x+1);
    mem[$f56c]:=lo(y1-y+1);mem[$f56d]:=hi(y1-y+1);
    mem[$f570]:=log_op;
    mem[$f56f]:=0;
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$91/$01/        { LD IX,&H0191        }
           $21/$62/$f5/            { LD HL,&HF562        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure scr_off;

  begin
    inline($fd/$2a/$c0/$fc/        { LD IY,(&HFCC0)      }
           $dd/$21/$41/$00/        { LD IX,&H0041        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure scr_on;

  begin
    inline($fd/$2a/$c0/$fc/        { LD IY,(&HFCC0)      }
           $dd/$21/$44/$00/        { LD IX,&H0044        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure set_sprite_size(grootte:byte);

  begin
    mem[$f3e0]:=grootte
  end;


procedure def_sprite(nummer:byte;definitie:txt);

type def=string[32];

var adres,lengte:integer;
    sprite:def absolute $f975;

  begin
    sprite:=definitie;
    case mem[$f3e0] and 2 of
      0 : lengte:=8;
      2 : lengte:=32;
    end;
    adres:=mem[$f926]+256*mem[$f927]+nummer*lengte;
    inline($fd/$2a/$c0/$fc/        { LD IY,(&HFCC0)      }
           $dd/$21/$5c/$00/        { LD IX,&H005C        }
           $21/$76/$f9/            { LD HL,&HF976        }
           $ed/$4b/lengte/         { LD BC,(LENGTE)      }
           $ed/$5b/adres/          { LD DE,(ADRES)       }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure clear_sprites;

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$f5/$00/        { LD IX,&H00F5        }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure put_sprite(vlak,x,y,kleur,nummer:byte);

var adres:integer;
    teller,offset,mult:byte;

procedure vpoke(adres:integer;waarde:byte);

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$09/$01/        { LD IX,&H0109        }
           $2a/adres/              { LD HL,(ADRES)       }
           $3a/waarde/             { LD A,(WAARDE)       }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

  begin
    adres:=mem[$f928]+256*mem[$f929];
    offset:=vlak*4;
    vpoke(adres+offset,y);
    vpoke(adres+offset+1,x);
    if mem[$f3e0] and 2=2 then mult:=4
                          else mult:=1;
    vpoke(adres+offset+2,mult*nummer);
    if kleur<16 then
      begin
        for teller:=0 to 15 do
          vpoke(adres-512+vlak*16+teller,kleur)
      end;
  end;


function sprite_collision:boolean;

var reg:byte;

  begin
    inline($fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $dd/$21/$31/$01/        { LD IX,&H0131        }
           $3e/$00/                { LD A,0              }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/reg/                { LD (REG),A          }
           $fb);                   { EI                  }
    sprite_collision:=((reg and 32)=32)
  end;


procedure color_sprite(vlak:byte;definitie:txt);

type def=string[16];

var adres:integer;
    color:def absolute $f975;

  begin
    color:=definitie;
    adres:=mem[$f928]+256*mem[$f929]-512+vlak*16;
    inline($fd/$2a/$c0/$fc/        { LD IY,(&HFCC0)      }
           $dd/$21/$5c/$00/        { LD IX,&H005C        }
           $21/$76/$f9/            { LD HL,&HF976        }
           $01/$10/$00/            { LD BC,&H10          }
           $ed/$5b/adres/          { LD DE,(ADRES)       }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;


procedure set_blink_values(ta,tg,kv,ka:byte);

var vdp13,vdp14:byte;

procedure write_vdp(reg,waarde:byte);
  begin
    inline($3a/waarde/             { LD A,(WAARDE)       }
           $47/                    { LD B,A              }
           $3a/reg/                { LD A,(REG)          }
           $4f/                    { LD C,A              }
           $dd/$21/$2d/$01/        { LD IX,&H012D        }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

  begin
    vdp13:=kv*16+ka;vdp14:=ta*16+tg;
    write_vdp(12,vdp13);
    write_vdp(13,vdp14)
  end;


procedure set_blink_area(x1,y1,x2,y2:byte);

var nummer,adres,bit_teller,aantal:integer;
    inhoud:byte;
    stop:boolean;

procedure vpoke(adres:integer;waarde:byte);
  begin
    inline($3a/waarde/             { LD A,(WAARDE)       }
           $2a/adres/              { LD HL,(ADRES)       }
           $dd/$21/$09/$01/        { LD IX,&H0109        }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

function vpeek(adres:integer):byte;
  var data:byte;
  begin
    inline($2a/adres/              { LD HL,(ADRES)       }
           $dd/$21/$0d/$01/        { LD IX,&H010D        }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/data/               { LD (DATA),A         }
           $fb);                   { EI                  }
    vpeek:=data
  end;

  begin
    stop:=false;
    nummer:=y1*80+x1;
    adres:=(nummer div 8)+2048;
    aantal:=y2*80+x2+1-nummer;
    bit_teller:=7-(nummer mod 8);
    repeat
      inhoud:=vpeek(adres);
      repeat
        inhoud:=inhoud or (1 shl bit_teller);
        aantal:=aantal-1;
        if aantal=0 then stop:=true;
        bit_teller:=bit_teller-1
      until (bit_teller<0) or (stop);
      vpoke(adres,inhoud);
      adres:=adres+1;
      bit_teller:=7
    until aantal=0
  end;


procedure stop_blinking;

  begin
    inline($3e/$00/                { LD A,0              }
           $21/$00/$08/            { LD HL,&H800         }
           $01/$f0/$00/            { LD BC,&HF0          }
           $dd/$21/$56/$00/        { LD IX,&H0056        }
           $fd/$2a/$c0/$fc/        { LD IY,(&HFCC0)      }
           $cd/$1c/$00/            { CALL &H001C         }
          $fb)                    { EI                  }
    end;


procedure reset_blink_area(x1,y1,x2,y2:byte);

var nummer,adres,bit_teller,aantal:integer;
    inhoud:byte;
    stop:boolean;

procedure vpoke(adres:integer;waarde:byte);
  begin
    inline($3a/waarde/             { LD A,(WAARDE)       }
           $2a/adres/              { LD HL,(ADRES)       }
           $dd/$21/$09/$01/        { LD IX,&H0109        }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $cd/$1c/$00/            { CALL &H001C         }
           $fb)                    { EI                  }
  end;

function vpeek(adres:integer):byte;
  var data:byte;
  begin
    inline($2a/adres/              { LD HL,(ADRES)       }
           $dd/$21/$0d/$01/        { LD IX,&H010D        }
           $fd/$2a/$f7/$fa/        { LD IY,(&HFAF7)      }
           $cd/$1c/$00/            { CALL &H001C         }
           $32/data/               { LD (DATA),A         }
           $fb);                   { EI                  }
    vpeek:=data
  end;

  begin
    stop:=false;
    nummer:=y1*80+x1;
    adres:=(nummer div 8)+2048;
    aantal:=y2*80+x2+1-nummer;
    bit_teller:=7-(nummer mod 8);
    repeat
      inhoud:=vpeek(adres);
      repeat
        inhoud:=inhoud and (255-(1 shl bit_teller));
        aantal:=aantal-1;
        if aantal=0 then stop:=true;
        bit_teller:=bit_teller-1
      until (bit_teller<0) or (stop);
      vpoke(adres,inhoud);
      adres:=adres+1;
      bit_teller:=7
    until aantal=0
  end;


