	org	&hc000
;
; PADKEY - An alternative keyboard using a touchpad - Character set control
;
; New version written by: BiFi'98
;
start:	di
	ld	bc,5
	ld	de,oldHook
	ld	hl,&hfd9f
	push	hl,bc
	ldir
	pop	bc,de
	ld	hl,newHook
	ldir
	ei
	ret
;
newHook:	jp	hook
	ret
	ret
;
hook:	push	af,bc,de,hl
	xor	a	; Check port 1
	call	pad
	jr	c,endHook	; Carry set when pad pressed
	ld	a,4	; Check port 2
	call	pad
	jr	c,endHook	; Carry set when pad pressed
	xor	a
	ld	(pressed),a
endHook:	pop	hl,de,bc,af
oldHook:	ds	5,201
;
getPad:	push	hl
	ld	hl,curPad
	ld	a,(hl)	; Get current pad register
	inc	(hl)	; Set next pad register
	call	&hdb	; Read pad
	pop	hl
	ret
;
curPad:	db	0
graphChar:	db	0	; Graphical character flag
pressed:	db	0	; Pad pressed flag
;
pad:	ld	(curPad),a	; Fill curPad for later use
	call	getPad	; Check if pad pressed
	or	a	; Force NC
	ret	z

	ld	a,(pressed)	; Check still pressed
	or	a	; Set flags and Carry if return
	scf
	ret	nz	; Return if pressed

	ld	a,-1	; Set pressed state
	ld	(pressed),a

	call	getPad	; Put X-coordinate in H
	ld	h,a
	call	getPad	; Put Y-coordinate in L
	ld	l,a
	call	getPad	; Write button text if pressed
	ld	(graphChar),a

	call	calcChar
	ld	b,a
	cp	32
	jr	nc,wrtKBB
	ld	a,(graphChar)
	and	a
	ld	a,b
	jr	z,wrtKBB
	ld	a,1
	call	wrtKBB
	ld	a,b
	add	a,64
	jr	wrtKBB
;
wrtKBB:	push	de,hl
	call	wrtBuf
	pop	hl,de
	scf
	ret
;
wrtBuf:	ld	hl,(&hf3f8)
	ld	(hl),a
	inc	hl
	ld	a,l
	cp	&h18
	jr	nz,noWrap
	ld	hl,&hfbf0
noWrap:	ld	de,(&hf3fa)
	rst	&h20
	ret	z
	ld	(&hf3f8),hl
	ret
;
calcChar:	ld	a,h	; A = HHHHLLLL
	and	240
	ld	b,a
	ld	a,l
	rrca
	rrca
	rrca
	rrca
	and	15
	or	b
	ret
