	org	&h100
;
; TOGGLE version 1.1 - Control every controlable LED on every MSX
;
; Written by: BiFi'97
;
	jp	start
	db	13,"TOGGLE [{-|+}C] [{-|+}K] [{-|+}P] [{-|+}T] "
	db	"[{-|+}?]",26
;
start:	ld	de,tIntro
	call	print

	ld	hl,&h2d
	ld	a,(&hfcc1)
	call	&hc
	ld	(msxVersion),a

	ld	hl,&h80
	ld	c,(hl)
	inc	hl
	inc	c
	dec	c
	jr	z,showStatus

	push	bc,hl	; Keep for later check
	ld	b,"-"	; First parse (turn LEDs off)
	call	parse
	call	ledsOff

	pop	hl,bc	; Get settings back
	ld	b,"+"	; Second parse (turn LEDs on)
	call	parse
	call	ledsOn

showStatus:	ld	de,tCaps
	call	printLed
	in	a,(&haa)
	and	64
	call	printStatInv

	ld	de,tKana
	call	printLed
	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	and	128
	call	printStatInv

	ld	a,(msxVersion)
	cp	3
	jr	c,abort

	ld	de,tPause
	call	printLed
	ld	a,(&hfcb1)
	and	1
	call	printStat

	ld	de,tTurbo
	call	printLed
	ld	a,(&hfcb1)
	and	128
	call	printStat
;
abort:	rst	0
;
; Print status of the LED
;
printStat:	ld	de,tOn
	jr	nz,print
	ld	de,tOff
	jr	print
;
printStatInv:	ld	de,tOff
	jr	nz,print
	ld	de,tOn
	jr	print
;
printLed:	call	print
	ld	de,tLed
	jr	print
;
; Parse parameters
;
parse:	ld	d,b
	ld	b,0
	ld	ix,parseFlags
	ld	(ix+0),0
	ld	(ix+1),0
parseLp:	ld	a,d
	cpir
	ret	nz
	ret	po

	ld	a,(hl)
	cp	"?"
	jr	nz,chChar
	set	7,(ix+1)

chChar:	or	32

	cp	"c"
	jr	nz,chKana
	set	0,(ix+0)

chKana:	cp	"k"
	jr	nz,chPause
	set	1,(ix+0)

chPause:	cp	"p"
	jr	nz,chTurbo
	set	2,(ix+0)

chTurbo:	cp	"t"
	jr	nz,parseLp
	set	3,(ix+0)

	jr	parseLp
;
; Print ASCII$ string through BDOS
;
print:	ld	c,9
	jp	5
;
; Turn LEDs off
;
ledsOff:	bit	7,(ix+1)
	call	nz,restoreLeds

	bit	0,(ix+0)
	call	nz,capsOff

	bit	1,(ix+0)
	call	nz,kanaOff

	bit	2,(ix+0)
	call	nz,pauseOff

	bit	3,(ix+0)
	call	nz,turboOff

	ret
;
; Turn LEDs on
;
ledsOn:	bit	7,(ix+1)
	call	nz,storeLeds

	bit	0,(ix+0)
	call	nz,capsOn

	bit	1,(ix+0)
	call	nz,kanaOn

	bit	2,(ix+0)
	call	nz,pauseOn

	bit	3,(ix+0)
	call	nz,turboOn

	ret
;
; The LED's which can be set or reset by user on the MSX-turboR
;
; Routines by: BiFi'97
;
capsOn:	in	a,(&haa)
	and	191
	out	(&haa),a
	ret
;
capsOff:	in	a,(&haa)
	or	64
	out	(&haa),a
	ret
;
kanaOn:	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	and	127
	out	(&ha1),a
	ret
;
kanaOff:	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	or	128
	out	(&ha1),a
	ret
;
pauseOn:	ld	a,(msxVersion)
	cp	3
	ret	c
	ld	a,(&hfcb1)
	or	1
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
pauseOff:	ld	a,(msxVersion)
	cp	3
	ret	c
	ld	a,(&hfcb1)
	and	254
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
turboOn:	ld	a,(msxVersion)
	cp	3
	ret	c
	ld	a,(&hfcb1)
	or	128
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
turboOff:	ld	a,(msxVersion)
	cp	3
	ret	c
	ld	a,(&hfcb1)
	and	127
	ld	(&hfcb1),a
	out	(&ha7),a
	ret
;
; Check DOS version
;
chkDosVer:	ld	c,&h6f
	call	5
	ld	a,b
	cp	2
	ret
;
parseEnv:	ld	a,(de)
	inc	de
	sub	"0"
	ret
;
addEnv:	add	a,"0"
	ld	(hl),a
	inc	hl
	ret
;
; Store LED settings
;
storeLeds:	call	chkDosVer
	ret	nz

	ld	hl,tEnvVal

	in	a,(&haa)
	and	64
	ld	a,0
	jr	nz,kana
	inc	a

kana:	call	addEnv

	ld	a,15
	out	(&ha0),a
	in	a,(&ha2)
	and	128
	ld	a,0
	jr	nz,pause
	inc	a

pause:	call	addEnv

	ld	a,(msxVersion)
	cp	3
	jr	c,endEnv

	ld	a,(&hfcb1)
	and	1
	ld	a,0
	jr	z,turbo
	inc	a

turbo:	call	addEnv

	ld	a,(&hfcb1)
	and	128
	ld	a,0
	jr	z,endEnv
	inc	a

endEnv:	call	addEnv
	ld	(hl),0
	jr	setEnv
;
; Restore LED settings
;
restoreLeds:	call	chkDosVer
	ret	nz

	ld	bc,&hff6b
	ld	de,tEnvVal
	ld	hl,tEnv
	call	5
	and	a
	ret	nz

	call	parseEnv
	push	af
	call	nz,capsOn
	pop	af
	call	z,capsOff

	call	parseEnv
	push	af
	call	nz,kanaOn
	pop	af
	call	z,kanaOff

	ld	a,(msxVersion)
	cp	3
	jr	c,resEnv

	call	parseEnv
	push	af
	call	nz,pauseOn
	pop	af
	call	z,pauseOff

	call	parseEnv
	push	af
	call	nz,turboOn
	pop	af
	call	z,turboOff

resEnv:	xor	a
	ld	(tEnvVal),a

setEnv:	ld	hl,tEnv
	ld	de,tEnvVal
	ld	c,&h6c
	jp	5
;
; Variables
;
parseFlags:	dw	0	; Offset 0, bit 0 = Caps
;                                      ;           bit 1 = Kana
;                                      ;           bit 2 = Pause
;                                      ;           bit 3 = Turbo
;                                      ; Offset 1, bit 7 = Store / Restore
msxVersion:	db	0
;
; Teksten
;
tIntro:	db	"TOGGLE version 1.1 - Written by: BiFi'97",13,10,10,"$"
tCaps:	db	"CAPS $"
tKana:	db	"KANA $"
tPause:	db	"PAUSE$"
tTurbo:	db	"TURBO$"
tLed:	db	" LED is now: $"
tOn:	db	"On",13,10,"$"
tOff:	db	"Off",13,10,"$"
tEnv:	db	"PUSHLEDS",0
tEnvVal	equ	$
