	org	&h100
;
; Show PCM-data as a graphic bar a la Knight 2000
;
; Written by: BiFi'96/'99 - Audio settings ripped from The Bass Hacker
;
	jp	start
	db	13,"Knight 2000 Graphic Bar for MSX-AUDIO - "
	db	"By: BiFi'96/'99",26
;
start:	ld	hl,(&hf3ea)
	ld	(oldBgc),hl

	ld	hl,0
	ld	(&hf3ea),hl

	ld	a,5
	ld	ix,&h5f
	call	mainRom

	ld	hl,10300
	ld	ix,&h171
	call	mainRom
	ld	hl,grpData
	ld	b,13
graphLoop:	push	bc
	ld	bc,&h898
	otir
	ld	b,248
	xor	a
clearLoop:	out	(&h98),a
	djnz	clearLoop
	pop	bc
	djnz	graphLoop

	call	initAudio
	ld	a,26
	out	(&hc0),a
	call	doMain

	ld	hl,(oldBgc)
	ld	(&hf3ea),hl

	xor	a
	ld	ix,&h1b5
	call	subRom

	ld	c,9
	ld	de,tExtro
	call	5

	rst	0
;
doMain:	in	a,(&hc1)
	neg
	call	setCol
	ld	b,4
delay:	halt
	djnz	delay
	call	snsMat
	ret	z
	jr	doMain
;
snsMat:	in	a,(&haa)	; Currently the SPACE BAR
	and	240
	or	8
	out	(&haa),a
	in	a,(&ha9)
	and	1
	ret
;
mainRom:	ld	iy,(&hfcc0)
	jr	calSlt
;
subRom:	ld	iy,(&hfaf7)
calSlt:	call	&h1c
	ei
	ret
;
initAudio:	ld	hl,regList
initLoop:	ld	a,(hl)
	and	a
	ret	z
	inc	hl
	out	(&hc0),a
	ld	a,(hl)
	inc	hl
	out	(&hc1),a
	jr	initLoop
;
tExtro:	db	"Knight 2000 Graphic Bar MSX-AUDIO version",13,10
	db	"Written by: BiFi'96/'99",13,10,"$"
;
regList:	db	13,223,14,0,8,8,22,255,24,255,25,0,0
oldBgc:	dw	0
palette:	ds	32,0
;
setCol:	bit	7,a	; 8-bit unsigned (signed conversion NEG)
	jr	z,isPositive
	neg

isPositive:	cp	48
	jr	nc,ampOk
	xor	a

ampOk:	ld	c,a
;              push    bc               ; Yellow in stead of Red
	srl	a
	srl	a
	srl	a
	and	15	; B = max-color
	ld	b,a
	inc	a
	ld	a,c	; C = intensity of maxcolor on red
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	and	&h70
	ld	c,a
	push	bc	; Keep em both
	ld	hl,palette
	ld	de,palette+1
	ld	bc,31
	ld	(hl),0
	ldir
	pop	bc
	ld	hl,palette+2
	ld	a,b
	and	a
	jr	z,firstColor
maxIntLoop:	ld	(hl),&h70	; color=(b,7,0,0)
	inc	hl
;              ld      (hl),7           ; Yellow
	ld	(hl),0	; Red
	inc	hl
	djnz	maxIntLoop
firstColor:	ld	(hl),c	; Now color=(b,c,0,0)
	inc	hl
;              pop     bc               ; Yellow
;              ld      a,c
;              and     7
;              ld      (hl),a
	ld	(hl),0	; Red
	di
	xor	a
	out	(&h99),a
	ld	a,128+16
	out	(&h99),a
	ld	bc,&h209a
	ld	hl,palette
	otir
	ei
	ret
;
grpData:	db	&h0f,&hff,&hf0,&h88,&h88,&h0f,&hff,&hf0
	db	&h0d,&hdd,&hd0,&h77,&h77,&h0d,&hdd,&hd0
	db	&h0b,&hbb,&hb0,&h66,&h66,&h0b,&hbb,&hb0
	db	&h09,&h99,&h90,&h55,&h55,&h09,&h99,&h90
	db	&h07,&h77,&h70,&h44,&h44,&h07,&h77,&h70
	db	&h05,&h55,&h50,&h33,&h33,&h05,&h55,&h50
	db	&h04,&h44,&h40,&h22,&h22,&h04,&h44,&h40
	db	&h05,&h55,&h50,&h33,&h33,&h05,&h55,&h50
	db	&h07,&h77,&h70,&h44,&h44,&h07,&h77,&h70
	db	&h09,&h99,&h90,&h55,&h55,&h09,&h99,&h90
	db	&h0b,&hbb,&hb0,&h66,&h66,&h0b,&hbb,&hb0
	db	&h0d,&hdd,&hd0,&h77,&h77,&h0d,&hdd,&hd0
	db	&h0f,&hff,&hf0,&h88,&h88,&h0f,&hff,&hf0
