; TSRFRAME - M        ST TSR
;
; Tsr frame file for COMPASS
;

; Macro definitions
;
tsrName	macro
	db	"ABP PauseTSR"	; TSR ID-Name
	endm
;
mMan	macro	@fnc	; Macro for making MemMan
	ld	e,@fnc	; function calls
	call	&h4002
	endm


;--------------------------------------;
;    Header for the TSR file           ;
;--------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0003	; Header file versie, MemMan 2.4
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;--------------------------------------;
;    Start of TSR-program code         ;
;--------------------------------------;
;
extBio	equ	&hffca	; EXTBIO hook
;
hook	equ	&hfd9f	; Dummy: Hook to be bend by this TSR
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;

;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction routine
;
; In: H = row to check, L = bit to check
;
talk:	ld	(pauseFlag),hl
	ld	hl,pauseFlag
	rlc	(hl)
	rlc	(hl)
	rlc	(hl)
	rlc	(hl)
	ret
;
program:	push	af
	push	hl
pauseLoop:	ld	hl,pauseFlag
	call	snsMat
	jr	nz,testPause
	ld	a,(hl)
	xor	1
	ld	(hl),a
releaseLoop:	call	snsMat
	jr	z,releaseLoop
	jr	noPause

testPause:	bit	0,(hl)
	jr	nz,pauseLoop

noPause:	pop	hl
	pop	af
endProgram:	ex	af,af'	; Save AF
	xor	a	; Reset flags for TsrManager
	ex	af,af'	; Restore AF, flags to A'
	ret		; Return to TsrManager

pauseFlag:	db	&h70	; Bit 7-4 = Row to check
;                                      ; Bit 3-1 = Unused
;                                      ; Bit   0 = Pause flag
testBit:	db	&h10	; Test bit for key

snsMat:	ld	b,(hl)
	srl	b
	srl	b
	srl	b
	srl	b
	inc	hl
	ld	c,(hl)
	dec	hl

	in	a,(&haa)
	and	240
	or	b
	out	(&haa),a
	ex	(sp),hl
	ex	(sp),hl
	in	a,(&ha9)
	and	c
	ret
;
tsrLen	equ	$-base	; Length of TSR programcode


;--------------------------------------;
;     Init-code                        ;
;--------------------------------------;
;
init:	ld	hl,tTsrName	; Pointer to TSR name-string
	mMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	de,tTsrName
	ld	a,2	; Flags in A, no messages
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad

;
tTsrName:	tsrName		; Macro for tsr-name string
;
	db	" - (c) BiFi'95/'97 of The New Image",13,10,10
	db	"The   STOP-key will now act as a full system pause "
	db	"key.",13,10,10,0
;
tDouble:	; Error text, 0-terminated
	db	'This TSR is already installed',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;--------------------------------------;
;    Hook Table                        ;
;--------------------------------------;
;
	TSRHOOKS	; This is for COMPASS

hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook
	dw	program
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;--------------------------------------;
;
	end		; TSRFRAME
;
