; TSRFRAME - MST TSR
;
; Tsr frame file for GEN80 or M80 assemblers
;

; Macro definitions
;
tsrName	macro
	db	"MCM JoySor  "	; TSR ID-Name
	endm
;
memMan	macro	@fnc	; Macro for making MemMan
	ld	e,@fnc	; function calls
	call	memManEntry
	endm


;---------------------------------------;
;    Header for the TSR file            ;
;---------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0002	; Header file versie, MemMan 2.2
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;---------------------------------------;
;    Start of TSR-program code          ;
;---------------------------------------;
;
extBio	equ	0ffcah	; EXTBIO hook
;
hook	equ	0fd9fh	; Hook to be bend by this TSR
gtstck	equ	0d5h	; BIOS call for GetStick
gttrig	equ	0d8h	; BIOS call for GetStrig
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;

;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction routine
;
talk:	ret		; No driver routine
;
program:	ei		; Hook-processing program start
			; Insert your own routine here

	push	af,hl
	ld	hl,delay
	dec	(hl)
	ld	a,(hl)
	jr	nz,endProgram
	ld	(hl),4

	ld	b,2	; 2 joysticks testen
joy1:	push	bc
	ld	a,b
	call	gttrig	; Lees vuurknop
	pop	bc
	or	a	; Ingedrukt?
	jr	nz,trigA	; Ja!
	push	bc
	ld	a,b
	add	a,2
	call	gttrig
	pop	bc
	or	a
	jr	nz,trigB
	djnz	joy1	; Nee? nog eens testen

	ld	b,2	; 2 joysticks testen
joy2:	push	bc
	ld	a,b
	call	gtstck	; Lees joystick status
	pop	bc
	or	a	; Richting?
	jr	nz,beweeg	; Ja? Beweeg hem dan maar
	djnz	joy2	; Nee? nog eens testen

	jr	endProgram	; Be-eindig routine

beweeg:	ld	hl,tabel-1	; vertaal richting
	ld	d,0	; naar bitpatroon
	ld	e,a	; uit tabel
	add	hl,de
	ld	a,(hl)

	ld	b,4	; 4 bits testen
	ld	hl,tabel+8	; schuif rechter bit
bit:	srl	a	; naar carry
	jr	nc,bit2	; nul: volgende bit

	push	af
	ld	a,(hl)	; haal letter uit tabel
	or	a	; =0?
	call	nz,inrij	; Nee? Zet hem in de wachtrij
	pop	af	; herstel A

bit2:	inc	hl	; verhoog tabelwijzer
	djnz	bit	; herhaal totdat b=0

	jr	endProgram	; klaar

trigA:	ld	a,(tabel+12)	; neem laatste getal uit rij
	call	inrij	; zet hem erin
	jr	endProgram	; klaar

trigB:	ld	a,(tabel+13)
	call	inrij
	jr	endProgram

inrij:	push	hl
	ld	hl,(0f3f8h)	; wijzer naar plaats in rij
	ld	(hl),a	; sla A op in rij
	inc	hl	; verhoog wijzer
	ld	a,l
	cp	18h	; l=18h?
	jr	nz,in1	; Nee? alles ok
	ld	hl,0fbf0h	; Anders naar begin rij
in1:	ld	a,(0f3fah)	; L-byte gelijk van wijzer
	cp	l	; Zijn ze gelijk?
	jr	z,inend	; Ja? Doe niets
	ld	(0f3f8h),hl	; Nee? sla nieuwe wijzer op
inend:	pop	hl	; herstel HL
	ret

tabel:	db	1,3,2,6,4,12,8,9,30,28,31,29,32,13
delay:	db	4

endProgram:	pop	hl,af
	ex	af,af'	; Save AF
	ld	a,0	; Reset flags for TsrManager
	ex	af,af'	; Restore AF, flags to A'
	ret		; Return to TsrManager


; memManEntry
;
; Entry address for MemMan function calls
;
memManEntry:	jp	0	; Address filled in by init routine
tsrLen	equ	$-base	; Length of TSR programcode


;---------------------------------------;
;     Init-code                         ;
;---------------------------------------;
;
init:	ld	b,getMemManEnt	; Ask for MemMan entry
	ld	de,256*'M' + info	; Call the MemMan info function
	call	extBio	; Through the ExtBio hook
	ld	(memManEntry+1),hl	; Save the MemMan entry address

	ld	hl,tTsrName	; Pointer to TSR name-string
	memMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	de,tIntro	; Pointer to intro-messie
	ld	a,2	; Flags in A, Messie
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad

;
tTsrName:	tsrName		; Macro for tsr-name string
;
tDouble:	db	'This TSR is already '	; Error text, 0-terminated
	db	'installed',13,10,10,0

tIntro:	db	'JoySor 1.3 kiest automatisch',13,10
	db	'de juiste joystickpoort.',13,10,10
	db	'TSR-conversie door A.Beevendorp',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;---------------------------------------;
;    Hook Table                         ;
;---------------------------------------;
;
hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook
	dw	program
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;---------------------------------------;
;
	end		; TSRFRAME
;
