; TSRFRAME - MST TSR
;
; Tsr frame file for COMPASS
;

; Macro definitions
;
tsrName	macro
	db	"BiFi TgglCPU"	; TSR ID-Name
	endm
;
mMan	macro	@fnc	; Macro for making MemMan
	ld	e,@fnc	; function calls
	call	&h4002
	endm


;--------------------------------------;
;    Header for the TSR file           ;
;--------------------------------------;
;
	db	"MST TSR",13,10	; TSR identifier
	tsrName		; ID-Name
	db	26	; ^Z
	dw	0003	; Header file versie, MemMan 2.4
	dw	base	; Code base address
	dw	init	; Init address
	dw	kill	; Kill address
	dw	talk	; TsrCall entry
	dw	tsrLen	; Programma code lengte
	dw	iniLen	; Init code lengte


;--------------------------------------;
;    Start of TSR-program code         ;
;--------------------------------------;
;
extBio	equ	&hffca	; EXTBIO hook
;
hook	equ	&hfd9f	; Dummy: Hook to be bend by this TSR
;
info	equ	50	; MemMan function
getMemManEnt	equ	6	; Info subfunction
getTsrID	equ	62
;

;
; TSR Base Address
;
base	equ	$	; First byte of program code
;
kill:	ret		; No destruction routine
;
talk:	ret		; No driver routine
;
program:	push	af,bc,de,hl
	di
	call	noKey
	jr	nz,checkNo

selCpuLoop:	call	yesKey
	jr	nz,endHook

	ld	a,(flags)
	and	4
	call	z,savePopUp

	ld	a,(flags)
	and	3
	inc	a
	cp	3
	jr	nz,modeOk
	xor	a
modeOk:	ld	b,a
	ld	a,(flags)
	and	252
	or	b
	ld	(flags),a
	and	3
	ld	hl,tCpuMode
	jr	z,baseCpuText
	ld	b,a
	ld	de,15
getCpuText:	add	hl,de
	djnz	getCpuText
baseCpuText:	call	printPopUp

	di
loseYes:	call	yesKey
	jr	z,loseYes
	jr	selCpuLoop
;
checkNo:	ld	a,(flags)
	and	4
	jr	z,endHook

	ld	a,(flags)
	and	251
	ld	(flags),a

	ld	a,(flags)
	and	3
	or	128
	call	&h180

	ld	a,(&hfcaf)
	cp	2
	jr	nc,endHook

	ld	bc,15
	ld	de,(&hf922)
	ld	hl,oldLine
	call	&h5c
	ei
endHook:	pop	hl,de,bc,af
	sub	a
	ex	af,af'
	ret
;
savePopUp:	call	&h183
	or	4
	ld	(flags),a

	ld	a,(&hfcaf)
	cp	2
	ret	nc

	ld	bc,15
	ld	de,oldLine
	ld	hl,(&hf922)
	jp	&h59
;
printPopUp:	ld	a,(&hfcaf)
	cp	2
	ret	nc

	ld	bc,15
	ld	de,(&hf922)
	jp	&h5c
;
yesKey:	ld	a,11
	call	snsMat
	and	2
	ret
;
noKey:	ld	a,11
	call	snsMat
	and	8
	ret
;
snsMat:	push	bc
	ld	c,a
	in	a,(&haa)
	and	240
	or	c
	out	(&haa),a
	nop
	nop
	in	a,(&ha9)
	pop	bc
	ret
;
flags:	db	0
oldLine:	ds	15,0
tCpuMode:	db	"Z80 (ROM) mode "
	db	"R800 (ROM) mode"
	db	"R800 DRAM mode "
;
tsrLen	equ	$-base	; Length of TSR programcode


;--------------------------------------;
;     Init-code                        ;
;--------------------------------------;
;
init:	ld	hl,tTsrName	; Pointer to TSR name-string
	mMan	getTsrID	; See if this TSR already exists
	jr	nc,initDouble	; Yes, => Double installed error

	ld	de,tIntro
	ld	a,2	; Flags in A, no messages
	ret		; Init ready, return to TsrLoad

initDouble:	ld	de,tDouble	; DE=Text pointer
	ld	a,3	; Flags for TL: Print text & Abort
	ret		; Return to TsrLoad

;
tTsrName:	tsrName		; Macro for tsr-name string
;
tIntro:	db	'The IEE-key (left of spacebar) enables the CPU'
	db	13,10,'toggle mode. The HAI-key (right of spacebar)'
	db	13,10,'toggles the CPU modes',13,10,10,0
;
tDouble:	; Error text, 0-terminated
	db	'This TSR is already installed',13,10,10,0
;
iniLen	equ	$-init	; Length of init-code
;
;--------------------------------------;
;    Hook Table                        ;
;--------------------------------------;
;
	TSRHOOKS	; This is for COMPASS

hooks:	dw	hokTabLen	; Length of HokTab
	dw	hook
	dw	program
;
hokTabLen	equ	$-hooks	; Length of hook-table
;
;--------------------------------------;
;
	end		; TSRFRAME
;
