	org	&h100
;
; IDE Sector Viewer version 1.45 - Idea by: Jaap Mark
;
; Written by: BiFi 2000
;
	jp	start
	db	13,"IDE Sector Viewer version 1.45 - (c) BiFi 2000 & "
	db	"XLR-8. For internal use only!",26
;
start:	call	findIDE
	jr	z,noIDE
	call	initScreen
initMain:	call	getDevSize	; Get the device size
main1:	call	readSector
main2:	call	printSector
mainKey:	call	getKey
	call	lowerCase
	cp	28	; Cursor-right key
	jp	z,lastSector
	cp	29	; Cursor-left key
	jp	z,firstSector
	cp	30	; Cursor-up key
	jp	z,prevSector
	cp	31	; Cursor-down key
	jp	z,nextSector
	cp	"d"
	jp	z,driveConnect
	cp	"f"
	jp	z,findFirst
	cp	"i"
	jp	z,extendInfo
	cp	"l"
	jp	z,logDrives
	cp	"n"
	jp	z,findNext
	cp	"p"
	jp	z,gotoPars
	cp	"q"
	jr	z,quit
	cp	"s"
	jp	z,gotoSector
	cp	"t"
	jp	z,toggle
	jr	mainKey

quit:	call	scRst
	ld	de,tExtro
abort:	ld	c,9
	call	5
	rst	0
;
noIDE:	ld	de,tNoIDE
	jr	abort
;
tExtro:	db	"IDE Sector Viewer version 1.45 - (c) 2000 BiFi & XLR-8"
	db	13,10,"All rights reserved. For internal use only!"
	db	13,10,10,"$"
tNoIDE:	db	13,10,"No IDE Interface found!$"
;
; Device I/O for IDE-Interface &H7F89, &H7F8C in IDE-Interface slot
; In:         AF =>   A = Device select (0 = Master, 1 = Slave)
;                     F = Action select (C = Write, NC = Read)
;             BC =>   B = Number of sectors to transfer (Disk size theory 8 GB)
;                     C = Sector number (bits 23 - 16)
;             DE =>       Sector number (bits 15 - 00)
;             HL =>       Transfer address
; Out:        Possibly identical to Disk-BIOS Disk I/O
; Use:        All
;
deviceIO:	ld	iy,(ideSlot - 1)
	ld	ix,&h7f8c
	jp	c,&h1c
	ld	ix,&h7f89
	jp	&h1c
;
; Find IDE-Interface
; In:         Nothing special
; Out:        AF =>   A = Slot of IDE-Interface
;                     F = Z  = No IDE-Interface found
;                         NZ = Interface found
; Use:        All
;
findIDE:	ld	bc,4*256
	ld	hl,&hfcc1
primSlotLp:	push	bc,hl
	ld	a,c
	call	chkSubSlot
	pop	hl,bc
	jr	z,foundIDE
	inc	c	; Next slot
	inc	hl
	djnz	primSlotLp
	xor	a
	ret
;
foundIDE:	and	a
	ret
;
chkSubSlot:	or	(hl)
	jp	p,check
	ld	b,4
subSlotLp:	push	af,bc,hl
	call	check
	pop	hl,bc
	ex	af,af'
	pop	af
	ex	af,af'
	ret	z
	ex	af,af'
	add	a,4
	djnz	subSlotLp
	ret

check:	ld	(ideSlot),a
	ld	hl,&h7f80
	ld	de,chkStr
	ld	b,3
chkLoop:	push	bc,de,hl
	ld	a,(ideSlot)
	call	&hc
	pop	de,hl,bc
	cp	(hl)
	ex	de,hl
	ret	nz
	inc	de
	inc	hl
	djnz	chkLoop
	ret
;
; Get number of connected drives on the IDE interface
; In:         AF =>   A = Slot to check
; Out:        BC =>   C = Number of connected drives
; Use:        AF, BC, HL
;
countDrive:	ld	hl,&hfb21
	ld	a,(ideSlot)	; << Remove line when other slot >>
	ld	b,4
cntDrvLp:	ld	c,(hl)	; Number of drives
	inc	hl
	cp	(hl)	; Check slot
	ret	z
	inc	hl
	djnz	cntDrvLp
	xor	a	; Make NZ
	dec	a
	ret
;
; Get base address of partition in use list (drives) on IDE interface
; In:         AF =>   A = Slot for IDE-Interface
; Out:        HL =>       Base address
; Use:        AF, BC, HL
;
gParBase:	ld	hl,&hfd0b
	ld	a,(ideSlot)	; << Remove line when other slot >>
	ld	c,a
	and	3
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	or	c
	add	a,a
	and	&h78
	ld	c,a
	ld	b,0
	add	hl,bc
	ld	a,(hl)
	inc	hl
	ld	h,(hl)
	ld	l,a
	ret
;
; HL = HL + (A * 8)
; In:         AF =>   A = Drive (0 = A:, 1 = B:, ...)
;                     A = Partition BIFI-IDE like
;             HL =>       Base address
; Out:        HL =>       Calculated base address
; Use:        AF, BC, HL
;
mulup8:	add	a,a
	add	a,a
	add	a,a
	ld	c,a
	ld	b,0
	add	hl,bc
	ret
;
; HL = HL + (A * 16)
; In:         AF =>   A = Partition HGI-IDE like
;             HL =>       Base address
; Out:        HL =>       Calculated base address
; Use:        AF, BC, HL
;
mulup16:	cpl
	and	31
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	ld	c,a
	ld	a,0
	adc	a,a
	ld	b,a
	add	hl,bc
	ret
;
; DEC DEHL
; In:         DE =>       MSW of number to decrease
;             HL =>       LSW of number to decrease
; Out:        DE =>       MSW result
;             HL =>       LSW result
; Use:        F, BC
;
dec32:	ld	bc,-1	; DEC DEHL
	add	hl,bc
	ret	c
	dec	de
	ret
;
; This routine reads the device-type and other information
; In:         AF =>   A = Device select (0 = Master, 1 = Slave)
;             HL =>       Transfer address
; Out:        None
; Use:        All
;
getIdeInfo:	ld	a,(ideSlot)
	ld	h,&h40
	call	&h24
	ld	a,(device)
	ld	hl,dma
	and	1
	rlca
	rlca
	rlca
	rlca
	or	15
	ld	(&h7e06),a
	ld	a,&h10
	ld	(&h7e02),a
	ld	a,&h91
	ld	(&h7e07),a
	call	waitRdy
	ld	a,&hec
	ld	(&h7e07),a
	call	waitRca
	ld	bc,512
	ld	de,&h7c00
	ex	de,hl
	ldir
	ld	a,(&hf342)
	ld	h,&h40
	jp	&h24
;
; This routine is used by "getIdeInfo"
;
waitRdy:	ld	a,(&h7e07)
	bit	7,a
	ret	z
	jr	waitRdy
;
; This routine is used by "getIdeInfo"
;
waitRca:	ld	a,(&h7e07)
	and	&h88
	cp	8
	ret	z
	jr	waitRca
;
ideSlot:	db	0
chkStr:	db	"ID#"
curSector:	dw	0,0
minSector:	dw	0,0
maxSector:	dw	0,0	; Pure max. &hffffff (dw -1, 255)
maxBackup:	dw	0,0	; Last sector (back-up facility)
device:	db	0
extendFlag:	db	0	; Used when in Extend View mode (SELECT)
sectFlag:	db	0	; Used to keep which half is viewed
caseFlag:	db	0	; Set when NOT case sensitive
fndToGo:	dw	0
srcAddress:	dw	0
maxSearch:	dw	0,0	; Pure max. &hfffffe (dw -2, 255)
bytesPoint:	dw	0	; Address in buffer for HEX-conversion
inputAdr:	dw	0	; Address in V-RAM for BackSpacing
printAdr:	dw	0
printChr:	dw	0
;
; Program specific routines
;
getCtrl:	in	a,(&haa)
	and	240
	or	6
	out	(&haa),a
	in	a,(&ha9)
	and	2
	ret
;
getKey:	rst	&h30
	db	&h80
	dw	&h9c
	jr	z,getKey
	rst	&h30
	db	&h80
	dw	&h9f
	ret
;
setWrt:	ld	a,l
	out	(&h99),a
	ld	a,h
	or	64
	out	(&h99),a
	ret
;
add32:	add	hl,bc
	ld	bc,0
	ex	de,hl
	adc	hl,bc
	ex	de,hl
	ret
;
lowerCase:	cp	"A"
	ret	c
	cp	"Z"+1
	ret	nc
	or	32
	ret
;
upperCase:	cp	"a"
	ret	c
	cp	"z"+1
	ret	nc
	and	223
	ret
;
toggle:	ld	a,(&hf6a0)
	bit	1,a
	jp	z,mainKey
	call	clrOffset
	ld	a,(device)
	xor	1
	ld	(device),a
	ld	hl,0
	ld	(curSector),hl
	ld	(curSector+2),hl
	xor	a
	ld	(sectFlag),a
	call	newDevice
	jp	initMain
;
prevSector:	ld	hl,(curSector+2)
	ld	de,(minSector+2)
	sbc	hl,de
	jr	z,prevLSW
	jr	goDown

prevLSW:	ld	hl,(curSector)
	ld	de,(minSector)
	sbc	hl,de
	jr	z,prevFlag
	jr	goDown

prevFlag:	ld	a,(sectFlag)
	and	a
	jp	z,mainKey	; Already set

goDown:	ld	a,(sectFlag)
	xor	1
	ld	(sectFlag),a
	jp	z,main2

	call	clrOffset
	ld	hl,(curSector)
	ld	de,(curSector+2)

	ld	bc,-1
	add	hl,bc
	jr	c,noMSW
	dec	de

noMSW:	ld	(curSector+2),de
	ld	(curSector),hl
	jp	main1
;
nextSector:	ld	hl,(maxSector+2)
	ld	de,(curSector+2)
	sbc	hl,de
	jr	z,nextLSW
	jr	goUp

nextLSW:	ld	hl,(maxSector)
	ld	de,(curSector)
	sbc	hl,de
	jr	z,nextFlag
	jr	goUp

nextFlag:	ld	a,(sectFlag)
	and	a
	jp	nz,mainKey	; Already set

goUp:	ld	a,(sectFlag)
	xor	1
	ld	(sectFlag),a
	jp	nz,main2

	call	clrOffset
	ld	hl,(curSector)
	ld	de,(curSector+2)

	ld	bc,1
	add	hl,bc
	ld	bc,0
	ex	de,hl
	adc	hl,bc
	ex	de,hl

	ld	(curSector+2),de
	ld	(curSector),hl
	jp	main1
;
firstSector:	call	getCtrl
	jp	nz,mainKey

	ld	hl,(minSector)
	ld	(curSector),hl
	ld	hl,(minSector+2)
	ld	(curSector+2),hl
	xor	a
	ld	(sectFlag),a
	call	clrOffset
	jp	main1
;
lastSector:	call	getCtrl
	jp	nz,mainKey

	ld	hl,(maxSector)
	ld	(curSector),hl
	ld	hl,(maxSector+2)
	ld	(curSector+2),hl
	ld	a,1
	ld	(sectFlag),a
	call	clrOffset
	jp	main1
;
getDevSize:	call	getIdeInfo
	ld	hl,(dma+&h6b)
	ld	de,(dma+&h6d)
	call	dec32
	ld	(maxBackup),hl
	ld	(maxBackup+2),de

resetDevMax:	ld	hl,(maxBackup)
	ld	de,(maxBackup+2)
	ld	(maxSector),hl
	ld	(maxSector+2),de
	call	dec32
	ld	(maxSearch),hl
	ld	(maxSearch+2),de
	ret

extendInfo:	call	getIdeInfo
	xor	a
	ld	(sectFlag),a
	inc	a
	ld	(extendFlag),a
extendMain:	call	printSector
extendKey:	call	getKey
	call	lowerCase
	cp	27	; ESCAPE
	jr	z,extendEnd
	cp	30
	jr	z,extendUp
	cp	31
	jr	z,extendDown
	cp	"q"
	jp	z,quit
	jr	extendKey

extendEnd:	xor	a
	ld	(sectFlag),a
	ld	(extendFlag),a
	jp	main1

extendUp:	xor	a
	ld	(sectFlag),a
	jr	extendMain

extendDown:	ld	a,1
	ld	(sectFlag),a
	jr	extendMain
;
gotoSector:	call	sect2Hex
	call	updateHex
	ld	b,0
	call	inpHexSect
	cp	27
	jp	z,mainKey
	call	getSector
	call	clrOffset
	xor	a
	ld	(sectFlag),a
	ld	hl,0
	ld	(minSector),hl
	ld	(minSector+2),hl
	call	resetDevMax
	jp	main1
;
gotoPars:	ld	hl,1743
	call	setWrt
	ld	hl,tPartition
	call	outAsciiZ
	xor	a
	ld	hl,tHexNumber+4
	call	conv2Hex
	ld	(hl),a
noPar:	ld	b,1
	call	otherInput
	cp	27
	jr	z,escPars
	ld	hl,tHexNumber+4
	call	conv2Bin
	cp	31
	jr	nc,noPar
	ld	hl,dma+1024
	call	mulup16
	ld	de,6
	add	hl,de
	xor	a
	or	(hl)
	ld	e,(hl)
	inc	hl
	or	(hl)
	ld	d,(hl)
	inc	hl
	or	(hl)
	ld	c,(hl)
	inc	hl
	ld	b,0
	ld	(curSector),de
	ld	(minSector),de
	ld	(curSector+2),bc
	ld	(minSector+2),bc
	inc	hl
	or	(hl)
	ld	c,(hl)
	inc	hl
	or	(hl)
	ld	b,(hl)
	jr	z,noPar
doLog:	ld	hl,(minSector)
	ld	de,(minSector+2)
	dec	bc
	call	add32
	ld	(maxSector),hl
	ld	(maxSector+2),de
	dec	hl
	ld	a,h
	and	l
	inc	a
	jr	nz,doSearch
	dec	de
doSearch:	ld	(maxSearch),hl
	ld	(maxSearch+2),de
	ld	hl,1743
	call	setWrt
	ld	hl,tSector
	call	outAsciiZ
	call	clrOffset
	xor	a
	ld	(sectFlag),a
	ld	(findBuf),a
	jp	main1

escPars:	ld	hl,1743
	call	setWrt
	ld	hl,tSector
	call	outAsciiZ
	call	sect2Hex
	call	updateHex
	jp	mainKey
;
logDrives:	call	countDrive
	ld	a,c
	and	a
	jp	z,mainKey
	ld	de,669
	ld	hl,blkLogDrive
	call	winBlk
	ld	hl,767
	call	setWrt
	call	countDrive
	ld	a,"@"
	add	a,c
	out	(&h98),a
noDrive:	call	getKey
	cp	27
	jr	z,noLogDrv
	call	lowerCase
	cp	"a"
	jr	c,noDrive
	push	af
	call	countDrive
	pop	af
	sub	"a"
	cp	c
	jr	nc,noDrive
	ld	c,a
	ld	b,0
	push	bc
	call	gParBase
	pop	bc
	rl	c
	rl	c
	rl	c
	add	hl,bc
	ld	a,(hl)
	and	1
	ld	b,a
	ld	a,(device)
	cp	b
	jr	nz,noLogDrv
	inc	hl
	ld	e,(hl)
	inc	hl
	ld	d,(hl)
	inc	hl
	ld	c,(hl)
	ld	b,0
	ld	(curSector),de
	ld	(minSector),de
	ld	(curSector+2),bc
	ld	(minSector+2),bc
	inc	hl
	ld	c,(hl)
	inc	hl
	ld	b,(hl)
	jp	doLog

noLogDrv:	call	winPop
	jp	mainKey
;
driveConnect:	ld	de,583
	ld	hl,blkParBlock
	call	winBlk
	call	countDrive
	ld	a,c
	and	a
	jp	z,noPars
	cp	7
	jr	c,drivesOk
	ld	c,6
drivesOk:	ld	hl,833
	ld	b,c
	ld	c,0
driveLoop:	push	bc,hl
	call	setWrt
	ld	b,20
clearLoop:	ld	a," "
	out	(&h98),a
	djnz	clearLoop
	ld	de,3
	add	hl,de
	call	setWrt
	push	bc
	call	gParBase
	pop	bc
	ld	b,0
	rl	c
	rl	c
	rl	c
	add	hl,bc
	push	hl
	pop	ix
	ld	hl,tHexNumber
	ld	a,(ix+0)
	and	1
	ld	b,a
	ld	a,(device)
	cp	b
	jr	z,validPar
	pop	hl
	push	hl
	call	setWrt
	ld	hl,tNoDevice
	call	outAsciiZ
	jr	nextPar

validPar:	ld	a,(ix+3)
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,(ix+2)
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,(ix+1)
	call	conv2Hex
	ld	(hl),a
	ld	hl,tHexNumber
	call	outAsciiZ
	pop	hl
	push	hl
	ld	de,16
	add	hl,de
	call	setWrt
	ld	hl,tHexNumber+2
	ld	e,(ix+4)
	ld	d,(ix+5)
	inc	de
	ld	a,d
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,e
	call	conv2Hex
	ld	(hl),a
	ld	hl,tHexNumber+2
	call	outAsciiZ
nextPar:	pop	hl,bc
	ld	de,80
	add	hl,de
	inc	c
	dec	b
	jp	nz,driveLoop
noPars:	call	getKey
	call	winPop
	jp	mainKey
;
findFirst:	ld	de,662
	ld	hl,blkFind
	call	winBlk
	ld	hl,772
	call	setWrt
getFindType:	call	getKey
	call	upperCase
	cp	27
	jp	z,quitFind
	cp	"A"
	jr	z,findAscii
	cp	"H"
	jp	z,findHex
	jr	getFindType
findAscii:	out	(&h98),a
	ld	hl,824
	call	setWrt
	ld	hl,tCase
	call	outAsciiZ
getCase:	call	getKey
	call	upperCase
	cp	27
	jp	z,quitFind
	cp	"Y"
	ld	b,0
	jr	z,setCase
	cp	"N"
	ld	b,1
	jr	z,setCase
	jr	getCase
setCase:	ld	hl,caseFlag
	ld	(hl),b
	out	(&h98),a
	ld	hl,984
	call	setWrt
	ld	hl,tAscii
	call	outAsciiZ
	ld	b,16
	ld	de,989
	ld	hl,tFindBuf
	call	ascInput
	cp	27
	jp	z,quitFind
	ld	a,(caseFlag)
	and	a
	jr	z,noUppers
	push	bc
	ld	hl,tFindBuf
inpUpperLp:	ld	a,(hl)
	call	upperCase
	ld	(hl),a
	inc	hl
	djnz	inpUpperLp
	pop	bc
noUppers:	ld	a,b
	ld	c,b	; Adjust Length
copyHex:	ld	b,0
	and	a
	jr	z,quitFind
	ld	de,findBuf
	ld	hl,tFindBuf
	ld	(de),a
	inc	de
	ldir
	ld	hl,512
	ld	(fndToGo),hl
	ld	hl,dma
	ld	(srcAddress),hl
	ld	hl,(minSector+2)
	ld	(curSector+2),hl
	ld	hl,(minSector)
	ld	(curSector),hl
	jr	startFind

findHex:	out	(&h98),a
	ld	hl,984
	call	setWrt
	ld	hl,tHex
	call	outAsciiZ
	ld	hl,tFindBuf
	ld	(bytesPoint),hl
	ld	hl,991
	ld	(inputAdr),hl
	xor	a
	ld	(caseFlag),a
getBytes:	ld	b,2
	ld	hl,tHexNumber+4
clrHexLoop:	ld	(hl),"0"
	inc	hl
	djnz	clrHexLoop
	ld	b,2
	push	bc
	call	otherInput
	pop	bc
	cp	27
	ld	a,c
	jr	z,copyHex
	xor	a
	ld	hl,tHexNumber+4
	call	conv2Bin
	ld	hl,(bytesPoint)
	ld	(hl),a
	inc	hl
	ld	(bytesPoint),hl
	inc	c
	ld	a,c
	cp	9	; Maximum number of bytes
	jr	z,copyHex
	ld	hl,(inputAdr)
	inc	hl
	inc	hl
	inc	hl
	ld	(inputAdr),hl
	jr	getBytes

quitFind:	call	winPop
	jp	mainKey
startFind:	call	winPop
	rst	&h30
	db	&h80
	dw	&h156
;
findNext:	ld	a,(findBuf)
	and	a
	jp	z,findFirst
	call	clrOffset
	ld	bc,(fndToGo)
	ld	a,b
	or	c
	jp	z,noSrcAbort
	call	sect2Hex
	call	updateHex
	xor	a
	ld	a,(device)
	ld	bc,(curSector+2)
	ld	b,2
	ld	de,(curSector)
	ld	hl,dma
	call	deviceIO
	ld	a,(caseFlag)
	and	a
	call	nz,upCaseSect
findLoop:	ld	hl,(srcAddress)
	ld	bc,(fndToGo)
	ld	a,(findBuf+1)
	cpir
	jr	nz,srcNxtSect
	ld	a,b
	and	1
	xor	1
	ld	(sectFlag),a
	ld	(fndToGo),bc
	ld	(srcAddress),hl
	ld	a,(findBuf)
	dec	a
	jr	z,lastByte
	ld	b,a
	ld	de,findBuf+2
chkFndLoop:	ld	a,(de)
	cp	(hl)
	jr	nz,findAgain
	inc	hl
	inc	de
	djnz	chkFndLoop
lastByte:	ld	hl,1683
	call	setWrt
	ld	a,(sectFlag)
	add	a,"0"
	out	(&h98),a
	ld	hl,(srcAddress)
	ld	de,dma
	sbc	hl,de
	ld	a,l
	dec	a
	ld	hl,tHexNumber+4
	call	conv2Hex
	ld	(hl),a
	ld	hl,tHexNumber+4
	call	outAsciiZ
	jp	main1
findAgain:	ld	bc,(fndToGo)
	ld	a,b
	or	c
	jr	z,srcNxtSect
	ld	hl,(srcAddress)
	jr	findLoop

srcNxtSect:	rst	&h30
	db	&h80
	dw	&h9c
	jr	z,noSrcAbort
	call	getKey
	cp	27
	jp	z,main1

noSrcAbort:	ld	hl,(maxSearch+2)
	ld	de,(curSector+2)
	sbc	hl,de
	jr	z,searchLSW
	jr	srcUp

searchLSW:	ld	hl,(maxSearch)
	ld	de,(curSector)
	sbc	hl,de
	jr	z,findEnd

srcUp:	ld	hl,(curSector)
	ld	de,(curSector+2)

	ld	bc,1
	add	hl,bc
	ld	bc,0
	ex	de,hl
	adc	hl,bc
	ex	de,hl

	ld	(curSector+2),de
	ld	(curSector),hl
	ld	hl,512
	ld	(fndToGo),hl
	ld	hl,dma
	ld	(srcAddress),hl
	jp	findNext

findEnd:	xor	a	; Finished searching
	ld	(findBuf),a
	ld	hl,(maxSector)
	ld	(curSector),hl
	ld	hl,(maxSector+2)
	ld	(curSector+2),hl
	inc	a
	ld	(sectFlag),a
	call	clrOffset
	jp	main1
;
upCaseSect:	ld	bc,512
	ld	hl,dma
upCaseLoop:	ld	a,(hl)
	call	upperCase
	ld	(hl),a
	inc	hl
	dec	bc
	ld	a,b
	or	c
	jr	nz,upCaseLoop
	ret
;
clrOffset:	ei
	ld	hl,1683
	call	setWrt
	halt
	ld	b,3
offsetLoop:	ld	a," "
	out	(&h98),a
	djnz	offsetLoop
	ret
;
initScreen:	call	scInit
	ld	hl,scrMain
	call	scScr
	ld	hl,dma+1536
	call	winInit

	ld	hl,1743
	call	setWrt
	ld	hl,tSector
	call	outAsciiZ
	call	updateHex

reDevice:	ld	hl,194
	call	setWrt
	ld	hl,tDevice
	call	outAsciiZ
newDevice:	ld	hl,205
	call	setWrt
	ld	a,(device)
	add	a,"0"
	out	(&h98),a
	xor	a
	ld	a,(device)
	ld	bc,256
	ld	de,0
	ld	hl,dma+1024
	jp	deviceIO
;
outAsciiZ:	ld	a,(hl)
	and	a
	ret	z
	out	(&h98),a
	inc	hl
	jr	outAsciiZ
;
readSector:	xor	a
	ld	a,(device)
	ld	de,(curSector)
	ld	bc,(curSector+2)
	ld	b,1
	ld	hl,dma
	jp	deviceIO
;
printSector:	di
	ld	hl,323
	ld	b,16
	ld	a,(sectFlag)
	and	a
	ld	de,dma
	jr	z,highSect
	ld	de,dma+256
highSect:	ld	(printAdr),de
	ld	(printChr),de
newLine:	push	af,bc,hl
	call	setWrt
	ld	a,(sectFlag)
	add	a,"0"	; Print first/second 256 bytes
	out	(&h98),a
	pop	hl
	push	hl	; Print Hex bytes
	ld	de,6
	add	hl,de
	call	setWrt
	ld	b,16
fillLine1:	push	bc
	ld	de,(printAdr)
	ld	hl,tHexByte
	ld	a,(de)
	call	conv2Hex
	ld	(hl),a
	ld	hl,tHexByte
	call	outAsciiZ
	inc	de
	ld	(printAdr),de
	pop	bc
	ld	a,b
	cp	9
	call	z,addSpace
	djnz	fillLine1
	pop	hl
	push	hl
	ld	de,57
	add	hl,de
	call	setWrt
	ld	b,16
fillLine2:	ld	de,(printChr)
	ld	a,(de)
	out	(&h98),a
	inc	de
	ld	(printChr),de
	ld	a,b
	cp	9
	call	z,addSpace
	djnz	fillLine2
	pop	hl,bc,af
	ld	de,80
	add	hl,de
	djnz	newLine
	ei
	call	sect2Hex
	jp	updateHex
;
addSpace:	ld	a," "
	out	(&h98),a
	ret
;
sect2Hex:	ld	de,(curSector)
	ld	bc,(curSector+2)
	ld	a,c
	ld	hl,tHexNumber
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,d
	call	conv2Hex
	ld	(hl),a
	inc	hl
	ld	a,e
	call	conv2Hex
	ld	(hl),a
	ret

conv2Hex:	ld	b,a
	rrca
	rrca
	rrca
	rrca
	call	convHex
	ld	(hl),a
	inc	hl
	ld	a,b
convHex:	and	15
	add	a,"0"
	cp	"9"+1
	ret	c
	add	a,7
	ret
;
getSector:	ld	hl,tHexNumber
	call	conv2Bin
	ld	c,a
	call	conv2Bin
	ld	d,a
	call	conv2Bin
	ld	e,a
	ld	b,0
	ld	(curSector),de
	ld	(curSector+2),bc
	ret
;
conv2Bin:	ld	a,(hl)
	inc	hl
	call	convBin
	rlca
	rlca
	rlca
	rlca
	ld	b,a
	ld	a,(hl)
	inc	hl
	call	convBin
	or	b
	ret
;
convBin:	sub	"0"
	cp	10
	ret	c
	sub	7
	ret
;
inpHexSect:	call	getKey
	cp	13
	ret	z
	cp	27
	ret	z
	call	upperCase
	cp	"0"
	jr	c,inpHexSect
	cp	"G"
	jr	nc,inpHexSect
	cp	"9"+1
	jr	c,addHex
	cp	"A"
	jr	nc,addHex
	jr	inpHexSect

addHex:	push	af,bc
	ld	bc,5
	ld	de,tHexNumber
	ld	hl,tHexNumber+1
	ldir
	pop	bc,af
	ld	(de),a
otherInput:	ld	a,b
	and	a
	call	z,updateHex
	cp	1
	call	z,outPars
	cp	2
	call	z,outBytes
	jr	inpHexSect

outPars:	ld	hl,1755
	call	setWrt
	ld	hl,tHexNumber+4
	jp	outAsciiZ

outBytes:	ld	hl,(inputAdr)
	call	setWrt
	ld	hl,tHexNumber+4
	jp	outAsciiZ
;
updateHex:	ld	hl,1751
	call	setWrt
	ld	hl,tHexNumber
	ld	a,(extendFlag)
	and	a
	jp	z,outAsciiZ
	ld	hl,tExtend
	jp	outAsciiZ
;
; Invoer-routine die alleen de ASCII-tekens accepteert.
;
; Geschreven door A.Beevendorp (27-01-94)/(24-06-94)
;
; In :  B = Maximale lengte van de string
;      DE = Begin-adres in V-RAM voor evt. BackSpace (direct VDP-IO)
;      HL = Begin-adres van de string
; Uit:  B = Stringlengte
ascInput:	push	bc	; Bewaar maxteller
	push	hl	; Bewaar pointer
	ld	(inputAdr),de
invClLp:	ld	(hl),0	; Clean de hap
	inc	hl
	djnz	invClLp
	pop	hl	; Haal beide invoerpointers weer terug
	pop	bc
	ld	e,0	; Reinig stringlengte
ascInvoer:	call	getKey
	cp	27
	ret	z
	cp	13	; Test op RETURN
	jr	z,RET	; Pas stringlengte aan en terug
	cp	8	; Test op BS
	jr	z,BS	; Een tekentje terug
	cp	32	; Test op karakter 32 en hoger
	jr	c,ascInvoer	; Zo niet... Dan opnieuw lezen
	cp	126	; Test op karakter 126 en lager
	jr	nc,ascInvoer	; Zo niet... Dan opnieuw lezen

	ld	c,a	; Bewaar karakter in C
	ld	a,e	; Haal huidige stringlengte op
	cp	b	; Gelijk aan elkaar?
	jr	z,ascInvoer	; Zo ja, dan terug
	ld	(hl),c	; Plaats teken in de 'string'
	inc	e	; Verhoog stringlengte-teller
	ld	a,c	; Haal teken weer op voor scherm
	call	chPut	; Plaats teken op het scherm
	inc	hl	; Wijs naar de volgende plaats
	jr	ascInvoer	; Terug voor het volgende teken

BS:	xor	a	; Kijk of stringlengte 0 is
	or	e	;
	jr	z,ascInvoer	; Keer terug indien de lengte 0 is
	dec	e	; Lengte 1 verlagen
	dec	hl	; Pointer 1 verlagen
	ld	a,8	; Plaats BS-teken
	call	chPut	; Plaats de BackSpace
	ld	a,32	; Zet daar een spatie neer
	call	chPut	; Plaats de spatie
	ld	a,8	; Plaats weer een BackSpace
	call	chPut	; Plaats op het scherm
	jr	ascInvoer	; terug naar begin invoer

RET:	ld	a,e	; Kijk of de string leeg is
	or	a
	jr	z,ascInvoer	; Ja... Terug naar main-loop invoer
	ld	b,e	; Zet stringlengte over van E in B
	ret		;                ; Terug naar main-loop
;
chPut:	push	hl
	ld	hl,(inputAdr)
	inc	hl
	cp	8
	jr	nz,noBS
	dec	hl
	dec	hl
noBS:	ld	(inputAdr),hl
	push	af
	call	setWrt
	pop	af
	cp	8
	jr	z,outNoBS
	out	(&h98),a
outNoBS:	pop	hl
	ret
;
tCase:	db	"Case sensitive? (Y/N): ",0
tAscii:	db	"Text: ",0
tHex:	db	"Bytes: ",0
tDevice:	db	"Device ID:",0
tPartition:	db	" Partition: 00",0
tSector:	db	"Sector: ",0
tExtend:	db	"extend",0
tNoDevice:	db	"Used by other device",0
tHexNumber:	db	"000000",0
tHexByte:	db	"00 ",0
tFindBuf:	ds	16,0	; Input string
findBuf:	ds	17,0	; Length + Input string
;
; --- Deze routines zijn geschreven door Ramon van der Winkel ---
;
; scrinc.gen
;
; Dit is een includefile voor gen80. Deze routines doen het ondersteunende
; werk voor de Screen Editor Screens, Lines en Patterns.
; De volgende routines kunnen worden gebruikt:
;
; scInit - Deze routine initialiseert de VDP voor de juiste schermmode en
;          scherm instellingen. Deze routine moet bij het opstarten van de
;          applicatie eenmalig worden aangeroepen. 50/60 Hz niet aangepast.
;
; scRst  - Deze routine herstelt de schermmode naar de instellingen volgens
;          de klok-chip. Deze routine moet bij het verlaten van de applicatie
;          worden aangeroepen.
;
; scScr  - Deze routine maakt een screen actief. Het scherm wordt vanaf regel
;          0 (de bovenste regel) op het scherm gezet. Als het om een blok
;          gaat, dan moet de routine scBlok gebruikt worden. Er moet in
;          register [HL] worden opgegeven waar de scherm defintie staat. Zie
;          de opmerking onderaan over het toevoegen van schermen in de
;          applicatie code.
;
; scLns  - Deze routine doet hetzelfde als scShow, alleen dan voor lines.
;          In register [HL] moet worden opgegeven waar de blok-definitie data
;          staat. In register [A] moet het schermregelnummer worden opgegeven
;          waar vanaf het blok moet worden opgebouwd. Merk op dat deze routine
;          geen controle uitvoert op het overschrijden van de onderste scherm-
;          regel. Zie de opmerking onderaan over het toevoegen van schermen
;          in de applicatie code.
;
; scBlk  - Deze routine zet een blok op het scherm. In register [HL] moet
;          worden opgegeven waar de blok-defintie staat. In register [B] moet
;          de X en in register [C] de Y coordinaat van de linker bovenhoek
;          worden opgegeven. Als voor de X coordinaat -1 wordt opgegeven, dan
;          wordt het blok in het midden gezet. Bij de Y coordinaat geldt
;          hetzelfde.
;
; scPat  - Deze routine maakt een karakterset actief. Er moet in register [HL]
;          worden opgegeven waar de karakterset definitie begint. Zie de
;          opmerking hieronder over het invoegen van een karakterset in de
;          applicatie code.
;
; De karaktersets en schermen of scherm-delen data kunnen in de code van de
; applicatie worden opgenomen. Hiervoor moet de screen-convertor worden
; gebruikt, welke het scherm comprimeert en de source-tekst aflevert van het
; scherm of de karakterset. Deze source files moeten met het include commando
; in de source worden opgenomen. In de door de Screen Convertor aangemaakte
; source staat ook een label naam. Deze bestaat uit de drie beginletters
; scr, lns, blk of pat, met daar aanvast de bestandsnaam van de source tekst
; waaronder de Screen Converter de source heeft weggeschreven. Alleen de
; eerste letter van deze naam is in hoofdletters. Bijvoorbeeld als de Screen
; Convertor het bestand TEST.SCR geconverteerd heeft, dan staat de source nu
; in TEST.SXT en bevat deze het label met de naam scrTest.
;

; scInit
;
; Deze routine initialiseert de Text Mode 2 scherm mode door de VDP direct
; aan te sturen. De VDP-backup variabelen worden dus niet bijgehouden.
;
; - Width 80
; - Screen 0
; - 26.5 regels
; - Scherm constructie op 0000h
; - Inverse video op 0a00h
; - Karakter data op 1000h
; - Eigen pallet data
; - Kleuren 1,2,3,4
; - Karaterset uit het bios ophalen
; - Cursor teken vullen met 255-jes
;
scInit:	di		;Geen INT's tijdens VDP IO

	; wis het tekst en inverse scherm
	;
	sub	a	;Pagina 0 selecteren
	out	(099h),a	;Stuur het pagina nummer
	ld	a,128+14	;Via R#14
	out	(099h),a	;Stuur het commando + register nummer

	sub	a	;Startadres van het tekstscherm
	out	(099h),a	; selecteren
	or	40h	;Schrijf mode
	out	(099h),a

	ld	bc,27*80	;Zoveel tekens in het tekst scherm
scInitClrLp1:	ld	a," "	;Met spaties wissen
	out	(098h),a	;Stuur een spatie om te wissen
	dec	bc	;Een positie minder te wissen
	ld	a,b	;Nog meer posities wissen?
	or	c
	jr	nz,scInitClrLp1	;Ja, meer posities wissen

	sub	a	;Startadres van het inverse scherm
	out	(099h),a	; selecteren
	ld	a,40h+0ah	;Schrijf mode
	out	(099h),a

	ld	bc,27*10	;Zoveel tekens in het inverse scherm
scInitClrLp2:	sub	a	;Met 00-en wissen
	out	(098h),a	;Stuur een 00 om te wissen
	dec	bc	;Een positie minder te wissen
	ld	a,b	;Nog meer posities wissen?
	or	c
	jr	nz,scInitClrLp2	;Ja, meer posities wissen

	; eigen palletten initialiseren
	;
	ld	hl,scInitPalets	;Deze pallet kleuren initialiseren
	call	scPallet	;Maak de te gebruiken palleten zwart

	ei		;Klaar met VDP IO, INT's mogen weer

	; vdp registers aanpassen voor de juiste mode
	;
	ld	a,(0ffe8h)	;Stand van VDP(10) ophalen (50/60 Hz)
	ld	hl,stoReg9+1	;Daar de data opslaan
	or	(hl)	;Verander de settings
	ld	(hl),a	;Sla de nieuwe data op

	ld	hl,scInitRegs	;Te veranderen registers
scInitRegsLp:	ld	c,(hl)	;Register nummer ophalen
	inc	hl	;Naar de data in de tabel
	ld	b,(hl)	;Data ophalen
	inc	hl	;Pointer naar de volgende entry

	ld	ix,047h	;WrtVdp
	ld	iy,(0fcc1h-1)	;SlotID van het BIOS
	call	01ch	;Aanroepen via Interslot call

	ld	a,(hl)	;Volgende register ophalen
	inc	a	;Einde van de tabel? (-1)
	jr	nz,scInitRegsLp	;Meer registers schrijven
	ret

scInitRegs:	db	0,4	;Textmode 2 settings
	db	1,112	;Enable scr, ints; Textmode 2 settings
	db	8,8	;64x4 vram
stoReg9:	db	9,128	;26.5
	db	2,3	;Pattern name table at 0000
	db	3,47	;Color table at A00h
	db	10,0	; idem
	db	4,2	;Pattern generator table at 1000h
	db	13,0f0h	;Inverse-video: Always on, never off
	db	23,0	;Alles op zijn plek
	db	7,12h	;Tekst voor- en achtergrond kleuren
	db	12,34h	;Inverse voor- en achtergrond kleuren
	db	-1	;Einde van de tabel

scInitPalets:	db	0,0,0	;Default pallets voor de kleuren
	db	0,0,0	; die gebruikt worden. Er is expres
	db	0,0,0	; voor zwart gekozen, dan levert het
	db	0,0,0	; geen felle flits op. Aanpasbaar.

; scRst
;
; Deze routine herstelt de scherm mode volgens de instellingen in de klok
; chip. Dit gebeurt door de SubRom routine sDfScr aan te roepen. Op adres
; 0faf8h moet het SlotID van de SubRom staan. Op adres 01ch moet de
; InterSlotCall routine aanroepbaar zijn.
;
scRst:	sub	a	;VDP (14)=0
	ld	(0ffech),a	;Uitlezen gebeurt door sDfScr

	ld	ix,0185h	;sDfScr routine in de SubRom
	ld	iy,(0faf8h-1)	;SlotID van de SubRom ophalen
	jp	01ch	;Roep de routine aan

; scPallet
;
; Deze routine past de pallet kleuren aan er wordt aangeroepen vanuit scInit
; en scShow. De data moet bestaan uit 12 bytes, een R, G en B byte voor alle
; vier de kleuren. De palletten worden in de kleuren 1,2,3 en 4 geschreven.
;
; In: DI
;     HL = Pointer naar de data
;
scPallet:	ld	bc,0401h	;4 registers schrijven, begin bij nr 1
scShowPalLp:	push	bc	;Bewaar de tellers

	ld	d,c	;Color Pallette nummer naar [D]

	ld	a,(hl)	;Rood tint
	inc	hl
	rlca		;Naar hoge bits van [A]
	rlca
	rlca
	rlca

	ld	e,(hl)	;Groen tint naar [E]
	inc	hl

	or	(hl)	;Blauw tint naar lage bits van [A]
	inc	hl	;Naar het volgende pallet

	ld	ix,014dh	;SetPlt routine adres in sub-rom
	ld	iy,(0faf8h-1)	;SlotID van de sub-rom naar IYh
	call	01ch	;Roep de routine aan

	pop	bc	;Herstel de tellers
	inc	c	;Volgende pallet
	djnz	scShowPalLp	;Meer palletten veranderen
	ret

; scScr
;
; Deze routine bouwt een scherm op. Alle andere gegevens op het scherm worden
; gewist.
;
; In: HL = Pointer naar de scherm defintie
;      A = Regel waarop het schermdeel moet beginnen
;
scScr:	di		;Geen INT's tijdens VDP IO

	call	scPallet	;Schrijf de kleuren
	sub	a	;Begin op regel 0

scLns:	di		;Geen INT's tijdens VDP IO

	push	hl	;Bewaar de scherm definitie pointer

	ld	l,a	;Regelnummer naar een 16 bits register
	ld	h,0
	add	hl,hl	;*2
	ld	d,h	;Bewaar *2
	ld	e,l
	add	hl,hl	;*4
	add	hl,hl	;*8
	add	hl,de	;*8 + *2 = *10
	ld	d,h	;Bewaar *10
	ld	e,l
	add	hl,hl	;*20
	add	hl,hl	;*40
	add	hl,hl	;*80

	ld	a,l	;Selecteer het tekst vram adres
	out	(099h),a
	ld	a,h
	or	40h	;Schrijf mode
	out	(099h),a

	pop	hl	;Herstel de scherm defintie pointer
	push	de	;Bewaar de inverse vram offset

	call	scShowBlok	;Bouw het tekst scherm op

	ex	(sp),hl	;Herstel de offset, bewaar de pointer
	ld	de,0a00h	;Basis van het inverse scherm
	add	hl,de	;Bereken het inverse scherm entry adres

	ld	a,l	;Selecteer het inverse vram adres
	out	(099h),a
	ld	a,h
	or	40h	;Schrijf mode
	out	(099h),a

	pop	hl	;Herstel de defintie pointer
	call	scShowBlok	;Bouw het inverse scherm op

	ei		;Klaar met VDP IO, INT's mogen weer
	ret

scShowBlok:	ld	c,098h	;VDP datapoort
scShowBlokLp:	ld	a,(hl)	;Code / Lengte byte ophalen
	inc	hl	;Ophaal pointer naar de databyte
	and	a	;Einde van de definitie?
	ret	z	;Ja, tekst scherm is nu af

	cp	128	;128 of groter? (repeat)
	jr	c,scShowBlokOk	;Nee, dan gewoon x bytes sturen

	sub	128	;Wis het repeat-indicatie bit
	ld	b,a	;Aantal tekens te sturen
	ld	a,(hl)	;Te sturen teken ophalen
	inc	hl	;Ophaal pointer naar het volgende blok
scShwBlokLp2:	out	(098h),a	;Stuur 1 databyte
	djnz	scShwBlokLp2	;Meer databytes sturen

	jr	scShowBlokLp	;Meer gecompresseerde blokken verwerken

scShowBlokOk:	ld	b,a	;Aantal byte te sturen naar [B]
	otir		;Stuur het aantal databytes

	jr	scShowBlokLp	;Meer gecompresseerde blokken verwerken

; scPat
;
; Deze routine activeert de opgegeven karakterset.
;
; In: HL = Pointer naar de karakterset data.
;
scPat:	di		;Geen INT's tijdens VDP IO

	sub	a	;Selecteer adres 1000h
	out	(099h),a
	ld	a,10h.or.40h	;Schrijf mode
	out	(099h),a

	call	scShowBlok	;Karakterset naar het vram

	ei		;Klaar met VDP IO, INT's mogen weer
	ret
;
; scrblk.gen - door Ramon van der Winkel
;

; Deze include file hoort bij de Screen Editor en bevat routines om een
; blok op het scherm te krijgen. Het blok moet in data vorm mee gecompileerd
; worden (de .bxt file dus). Met scBlk kan het blok op iedere plaats op het
; scherm worden gezet.

; scBlk
;
; Deze routine laat een blok zien op de opgegeven coordinaten. Als er geen
; blokken gebruikt worden, kan dit stuk worden weggelaten. Dit scheelt een
; aardig stuk code.
;
; In: HL = Definitie pointer
;     DE = Vram adres van de linker bovenhoek (0..80*27-1)
;
scBlk:	ld	c,(hl)	;Aantal regels te doen
	inc	hl
	ld	b,(hl)	;Aantal tekens op 1 regel te doen
	inc	hl	;Naar de eerste databyte

	push	hl	;Ophaal pointer naar de schaduw
	exx
	pop	hl
	ld	d,0	;Moet nieuwe databyte pakken
	ld	b,0	;Ook geen bits straks
	exx

	push	bc	;Bewaar de tellers voor de inverse data
	push	de	;Bewaar het vram adres

	di		;Geen INT's tijdens VDP IO

	; tekst scherm
	;
scBlkLp1:	push	bc	;Bewaar de tellers

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	or	40h	;Schrijven
	out	(099h),a

scBlkLp2:	call	scBlkGetByte	;Haal een byte op
	out	(098h),a	;Zet die op het scherm

	djnz	scBlkLp2	;Meer tekens op het scherm zetten

	ld	a,80	;80 tekens verder tot de volgende regel
	add	a,e	;DE=DE+A
	ld	e,a
	ld	a,d	;Overflow van het LSB bij het MSB
	adc	a,0	; optellen
	ld	d,a

	pop	bc	;Herstel de tellers
	dec	c	;Een regel minder te doen
	jr	nz,scBlkLp1	;Meer regels schrijven

	; inverse scherm
	;
	pop	de	;Haal het vram adres terug
	ld	a,e	;Bewaar het LSB met de bit offset
	and	7	;Bit offset voor de eerste byte
	ld	l,a	;Bewaar dat aantal voor iedere regel

	srl	d	;/2 Bereken het inverse vram adres,
	rr	e	;    dit is het tekst vram adres /8
	srl	d	;/4
	rr	e
	srl	d	;/8
	rr	e

	ld	a,d	;MSB van het vram adres
	add	a,0ah	;Offset voor het inverse scherm erbij
	ld	d,a

	pop	bc	;Herstel de tellers

	; B   = Aantal tekens per regel
	; C   = Aantal regels nog te gaan
	; DE  = Vram adres
	; L   = Aantal bits aan begin over te nemen
	; HL' = Ophaal adres
	; DE' = Ophaal tellers
	; BC' = Bit tellers
	;
scBlkLp3:	push	bc	;Bewaar de regels teller
	push	hl	;Bewaar het aantal bits vd eerste byte
	push	de	;Bewaar het vram adres

	ld	a,l	;Aantal bits over te nemen
	and	a	;Bits overnemen?
	jr	z,scBlkOk1	;Nee, begin meteen met vullen

	di		;Geen INT's tijdens VDP IO

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	and	3fh	;Lezen
	out	(099h),a

	ex	(sp),hl	;Delay voor opzetten return data
	ex	(sp),hl

	in	a,(098h)	;Lees de databyte uit

	ei		;Klaar met VDP IO, INT's mogen weer

	ld	h,a	;Bewaar de databyte even
	ld	a,l	;Aantal bits over te nemen
scBlkLp4:	rlc	h	;Neem 1 databit over
	dec	a	;Meer bits overnemen?
	jr	nz,scBlkLp4	;Neem meer bits over

scBlkOk1:	ld	a,8	;Maximum aantal bits
	sub	l	;Aantal bits al gebruikt
	ld	l,a	;Zoveel bits nog vrij

	di		;Geen INT's tijdens VDP IO

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	or	40h	;Schrijven
	out	(099h),a

scBlkLp5:	call	scBlkGetBit	;Haal 1 bit op

	rl	h	;Schuif die er bij H in
	dec	l	;Een bit minder ruimte vrij
	jr	nz,scBlkOk2	;Er kan nog meer bij

	ld	a,h	;De gemaakte databyte
	out	(098h),a	;Zet die in het vram
	inc	de	;Naar de volgende vram positie
	ld	l,8	;Weer 8 posities vrij

scBlkOk2:	djnz	scBlkLp5	;Meer bits binnenhalen

	ld	a,l	;Aantal bits nog te plaatsen
	cp	8	;Is de opvul byte leeg?
	jr	z,scBlkOk3	;Ja, laatste byte hoeft niet

	ld	a,1	;2~L-1 = AND filter voor laatste bits
scBlkLp6:	rlca		;Een macht verder
	rl	h	;Een positie doorschuiven voor plaatsen
	dec	l	;Een bit minder minder te behouden
	jr	nz,scBlkLp6	;Meer bits behouden
	dec	a	;Een minder -> AND filter
	ld	l,a	;Sla het AND filter even op

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	and	03fh	;Lezen
	out	(099h),a

	ex	(sp),hl
	ex	(sp),hl

	in	a,(098h)	;Lees een databyte uit
	and	l	;Filter de te bewaren bits
	or	h	;Zet/Wis de nieuwe bits
	ld	h,a	;Bewaar die databyte even

	ld	a,e	;Selecteer het vram adres weer
	out	(099h),a
	ld	a,d
	or	40h	;Schrijven
	out	(099h),a

	ld	a,h	;Schrijf de nieuwe byte naar het vram
	nop		;Benodigde vertraging
	out	(098h),a

scBlkOk3:	ei		;Klaar met VDP IO, INT's mogen weer

	pop	de	;Herstel het vram adres

	ld	a,e	;Naar de volgende regel in het vram
	add	a,10
	ld	e,a
	ld	a,d	;MSB verhogen met overflow van LSB
	adc	a,0
	ld	d,a

	pop	hl	;Herstel aantal bits van de eerste byte
	pop	bc	;Herstel de regels teller
	dec	c	;Een regel minder te doen
	jr	nz,scBlkLp3	;Volgende regel doen

	ret

; scBlkGetBit
;
; Deze routine haalt 1 bit op uit het buffer. Als er geen bits meer aanwezig
; zijn wordt er eerst een nieuwe databyte opgehaald.
;
scBlkGetBit:	exx		;Naar de schaduw registers

	inc	b	;Zijn er nog bits?
	dec	b
	jr	nz,scBlkGetBit2	;Ja, pak er een

	call	scBlkGetBytX	;Haal een nieuwe databyte op
	exx		;Weer naar de schaduw

	ld	c,a	;Sla die
	ld	b,8	;Nog 7 bits over na de ophaal actie

scBlkGetBit2:	rl	c	;Schuif er een bit uit naar de Carry
	dec	b	;Een bit minder beschikbaar
	exx		;Terug naar de gewone registers
	ret


; scBlkGetByte
;
; Deze routine haalt 1 databyte op uit het buffer. Als er een repeat bezig
; is wordt steeds hetzelfde byte opgehaald.
;
; In: HL' = Datablok pointer
;      D' = Aantal teller (0 = Begin nieuw blok, b7 = Repeat mode)
;      E' = Repeater databyte
;
scBlkGetByte:	exx		;Naar de schaduw

scBlkGetBytX:	ld	a,d	;Aantal bytes nog te gaan
	and	127	;Filter het repeat bit eraf
	jr	nz,scBlkGetByt2	;Nog in een blok, pak een byte

	ld	d,(hl)	;Nieuwe counter pakken
	inc	hl
	ld	e,(hl)	;In geval van repeat in E nodig
	inc	hl	;Alvast naar de volgende positie

	ld	a,e	;Databyte ook naar A
	jr	scBlkGtBtEnd	;Afmaken en terugkeren

scBlkGetByt2:	ld	a,e	;Neem de repeater byte
	bit	7,d	;Zitten we in een repeat?
	jr	nz,scBlkGtBtEnd	;Ja, keer terug

	ld	a,(hl)	;Haal een volgende databyte op
	inc	hl	;Naar de volgende positie

scBlkGtBtEnd:	dec	d	;Een byte minder over
	exx		;Terug naar de gewone registers
	ret
;
; scrwin.gen - door Ramon van der Winkel
;

; Deze routines doen het windowing werk.
; De module scrBlk moet ook aanwezig zijn!
;
; winInit - Initialiseren
; winPush - Window opslaan
; winPop  - Laatste window herstellen
; winBlk  - Window pushen en blok opbouwen

; winInit
;
; Deze routine initialiseert de window module variabelen. Het begin van het
; buffer geheugen moet worden opgegeven.
;
; In: HL = Start van het window geheugen
;
winInit:	ld	(hl),0	;Geen vorige defintie, pop werkt niet
	inc	hl
	ld	(hl),0
	inc	hl
	ld	(winBufAd),hl	;Sla het buffer adres op
	ret

; winPush
;
; Deze routine slaat een window in de gewenste grootte op in het window data
; buffer. Met winPop kan deze hersteld worden op het scherm.
;
; In: DE = Vram adres van de linker bovenhoek van het window
;      B = Breedte van het window in tekens
;      C = Aantal regels
;
winPush:	ld	hl,(winBufAd)	;Vanaf daar in het buffer opslaan
	push	hl	;Start adres van deze defintie bewaren

	ld	(hl),e	;Sla het vram adres op
	inc	hl
	ld	(hl),d
	inc	hl
	ld	(hl),c	;Aantal regels opslaan
	inc	hl
	ld	(hl),b	;Breedte opslaan
	inc	hl

	push	bc	;Bewaar de tellers
	push	de	;Bewaar het vram adres

	; tekst scherm doen
	;
winPushLp1:	push	bc	;Bewaar de teller

	di		;Geen INT's tijdens VDP IO

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	and	3fh	;Lezen
	out	(099h),a

	ld	(hl),b	;Zoveel tekens volgen er
	inc	hl	;Naar de opslag positie
	ld	c,098h	;Door de VDP datapoort uitlezen
	inir		;Lees de data uit

	ei		;Klaar met VDP IO, INT's mogen weer

	ld	a,e
	add	a,80	;80 tekens verder tot op de volgende
	ld	e,a	; regel
	ld	a,d
	adc	a,0
	ld	d,a

	pop	bc	;Herstel de tellers
	dec	c	;Een regel minder te doen
	jr	nz,winPushLp1	;Meer regels doen

	; inverse scherm doen
	;
	push	hl	;Opslag adres naar DE'
	exx
	pop	de
	ld	h,d	;Daar de lengte opslaan
	ld	l,e
	ld	(hl),0	;Nog niets opgeslagen
	ld	b,8	;Alle bits nog vrij
	inc	de	;Naar de eerste vrije opslag positie
	exx

	pop	de	;Herstel het vram adres
	ld	a,e	;Bereken de bit offset
	and	7	;Zoveel bits weggooien van 1e byte
	ld	l,a	;Sla het aantal op

	srl	d	;/2
	rr	e
	srl	d	;/4
	rr	e
	srl	d	;/8
	rr	e
	ld	a,d	;+ Inverse base adres
	add	a,0ah
	ld	d,a

	pop	bc	;Herstel de tellers
winPushLp2:	push	bc	;Bewaar de tellers
	push	hl	;Bewaar de weggooi teller

	di		;Geen INT's tijdens VDP IO

	ld	a,e	;Selecteer het vram adres
	out	(099h),a
	ld	a,d
	and	3fh	;Lezen
	out	(099h),a

	ex	(sp),hl	;Kleine setup delay
	ex	(sp),hl

	in	a,(098h)	;Lees de eerste databyte vd regel in
	ld	h,a	;Naar H voor uitschuiven databits
	ld	a,l
	and	a	;Bits weggooien?
	jr	z,winPushOk2	;Nee, laat het zo
winPushLp4:	rl	h	;Gooi een bit weg
	dec	a	;Een bit minder te verwijderen
	jr	nz,winPushLp4	;Meer bits weggooien

winPushOk2:	ld	a,8	;Maximum aantal bits per byte
	sub	l	;Bereken aantal bits nog over
	ld	l,a	;Sla dat op

winPushLp5:	rl	h	;Schuif een bit uit
	call	winPushBit	;Bewaar dit bit
	dec	l	;Zijn er nog meer bits beschikbaar?
	jr	nz,winPushOk3	;Ja, ga rustig door

	in	a,(098h)	;Lees een nieuwe databyte uit
	ld	h,a	;Databyte naar H
	ld	l,8	;Weer 8 bits beschikbaar

winPushOk3:	djnz	winPushLp5	;Meer bits ophalen

	ei		;Klaar met VDP IO, INT's mogen weer

	ld	a,e	;10 tekens tot op de volgende regel
	add	a,10
	ld	e,a
	ld	a,d	;Overflow van het LSB naar het MSB
	adc	a,0
	ld	d,a

	pop	hl	;Herstel weggooi teller 1e databyte
	pop	bc	;Herstel de tellers
	dec	c	;Een regel minder te doen
	jr	nz,winPushLp2	;Meer regels doen

winPushLp3:	exx		;Naar de schaduw registers
	ld	a,b	;Aantal nog vrije bits
	cp	8	;Allemaal nog vrij?
	jr	z,winPushOk1	;Ja, geen bits meer op te slaan
	exx		;Terug naar de gewone registers
	call	winPushBit	;Sla een bit op
	jr	winPushLp3	;Meer opslaan totdat ie vol zit

winPushOk1:	push	de	;Opslag pointer weer naar HL
	exx
	pop	hl

	pop	de	;Adres van vorige defintie
	ld	(hl),e	;Pointer naar deze defintie opslaan
	inc	hl	; voor winPop.
	ld	(hl),d
	inc	hl
	ld	(winBufAd),hl	;Nieuwe opslag pointer opslaan
	ret

; winPushBit
;
; Deze routine slaat 1 bit op. Als deze vol is wordt de byte opgeslagen en
; de teller verhoogt. Als deze zijn maximum heeft bereikt wordt een nieuwe
; teller begonnen.
;
winPushBit:	exx		;Naar de schaduw registers

	rl	c	;Schuif het data bit binnen
	djnz	winPshBitEnd	;Ruimte genoeg, keer terug

	ld	a,(hl)	;Hoeveel bytes zijn er al opgeslagen
	cp	127	;Helemaal vol?
	jr	nz,winPshBitSto	;Nee hoor, sla de databyte maar op

	ld	h,d	;Positie van de aantal teller naar HL
	ld	l,e
	ld	(hl),0	;Nog niets opgeslagen
	inc	de	;Naar de eerste vrije opslag positie

winPshBitSto:	ld	a,c	;Pak de databyte
	ld	(de),a	;Sla de databyte op
	inc	de	;Naar de volgende opslag positie

	ld	b,8	;Weer 8 bits beschikbaar
	inc	(hl)	;Een byte meer opgeslagen

winPshBitEnd:	exx		;Terug naar de gewone registers
	ret

; winPop
;
; Deze routine haalt het laatste opgeslagen window terug en zet deze op het
; scherm op dezelfde positie waar deze opgeslagen werd.
;
; In/Uit: Niets
;
winPop:	ld	hl,(winBufAd)	;Window buffer pointer
	dec	hl	;Pointer naar deze defintie ophalen
	ld	a,(hl)
	dec	hl
	ld	l,(hl)
	ld	h,a	;Is er nog wel een defintie?
	or	l
	ret	z	;Nee, niets te poppen

	ld	(winBufAd),hl	;Sla dit adres op

	ld	e,(hl)	;Haal het vram adres op
	inc	hl
	ld	d,(hl)
	inc	hl
	jp	scBlk	;Als blok herstellen

; winBlk
;
; Deze routine bepaald de grootte van het opgegeven blok, laat winPush een
; window pushen van die grootte en springt daarna naar scrBlk om het blok
; op het scherm te laten zetten.
;
; In: HL = Blok defintie
;     DE = Vram adres van linker bovenhoek
;
winBlk:	push	de	;Bewaar het vram adres
	push	hl	;Bewaar het definitie adres

	ld	c,(hl)	;Haal het aantal regels op
	inc	hl
	ld	b,(hl)	;En de breedte
	call	winPush	;Push het schermdeel op de window stack

	pop	hl	;Herstel het definitie adres
	pop	de	;Herstel het vram adres
	jp	scBlk	;Zet het blok op het scherm

winBufAd:	defw	0	;Pointer naar het window buffer

; Einde van de include file(s)
;
; --- Einde van de routines van Ramon van der Winkel
;
; MAIN.SXT - created bij ScrCnvt - Adjusted by: BiFi 2000
;
scrMain:	db	7,7,7,0,0,5,6,6,1,0,0,0
	db	128+81," ",1,24,128+76,23,34,25,"  ",22
	db	" IDE Sector Viewer version 1.4",128+16," ",34
	db	"By: BiFi 2000 & JOM  (c) 2000 ",22,"  ",20
	db	128+5,23,1,18,128+50,23,1,18,128+19,23,10,19,"  "
	db	22," 000 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 010 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 020 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 030 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 040 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 050 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 060 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 070 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 080 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 090 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0A0 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0B0 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0C0 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0D0 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0E0 ",22,128+50," ",1,22,128+19," ",10,22,"  "
	db	22," 0F0 ",22,128+50," ",1,22,128+19," ",4,22,"  ",20
	db	128+5,23,1,17,128+50,23,1,17,128+19,23,4,19,"  ",22
	db	128+7," ",48,"00 01 02 03 04 05 06 07 "
	db	" 08 09 0A 0B 0C 0D 0E 0F",128+21," ",4,22,"  ",20
	db	128+76,23,84,19,"  ",22," Drivelist, Find Next, Info, "
	db	"Logdrive, Goto Partition, Quit, Sector, Toggle ",22
	db	"  ",26,128+76,23,1,27,128+127," ",128+34," ",0
	db	128+127,0,128+103,0,9,16,2,8,0,16,2,16,"A",1,128+31,0,0
;
; PARBLOCK.BXT - created bij ScrCnvt - Adjusted by: BiFi'99
;
blkParBlock:	db	10,34,69,24,23,23
	db	"-= Partitions in use list =-",23,23,25,22
	db	" Drive   Base Sector   Capacity ",22,20
	db	128+32,23,6,19,22,"  A:",128+5," ",29
	db	"Not connected on IDE   ",22,22,"  B:"
	db	128+5," ",29,"Not connected on IDE   ",22,22,"  C:"
	db	128+5," ",29,"Not connected on IDE   ",22,22,"  D:"
	db	128+5," ",29,"Not connected on IDE   ",22,22,"  E:"
	db	128+5," ",29,"Not connected on IDE   ",22,22,"  F:"
	db	128+5," ",25,"Not connected on IDE   ",22,26,128+32
	db	23,1,27,128+42,0,1,8
;
; LOGDRIVE.BXT - created bij ScrCnvt - Adjusted by: BiFi'99
;
blkLogDrive:	db	3,21,43,24,23,23,"-= Log Drive =-",23,23,25,22
	db	" Log to drive: A-F ",22,26,128+19,23,1,27,128+7,0,1,1
;
; FIND.BXT - created bij ScrCnvt - Adjusted by: BiFi'99
;
blkFind:	db	6,37,1,24,128+9,23,17,"-= Find string =-",128+9,23,31
	db	25,22," ASCII or Hexadecimal? (A/H):",128+6," ",2,22,22
	db	128+35," ",2,22,22,128+35," ",2,22,22,128+35," ",2,22,26
	db	128+35,23,1,27,128+27,0,1,2
;
; --- Einde van schermdata en blockdata
;
dma	equ	$
