	org	&hc000
;
; Routine which filters out ANSI- and VT-52 strings
;
; Written by: BiFi'98
;
start:	call	getByte	; Read a byte
	ret	z	; End Of File?
	cp	27	; Is it ESCAPE?
	jr	nz,nonAnsi	; No ANSI or VT-52 code
	call	getByte
	ret	z
	cp	"["	; Is it ANSI-ID?
	jr	nz,vt52	; It's a VT-52 code
skipAnsi:	call	getByte
	ret	z
	call	upperCase	; Make uppercased character
	cp	"A"	; Any letter ends ANSI-code
	jr	c,skipAnsi
	cp	"Z" + 1
	jr	nc,skipAnsi
	jr	start

nonAnsi:	call	putByte	; Write a byte
	jr	start
;
vt52:	ld	hl,vt52table	; Point to single-byte commands
	ld	d,a
vt52Check:	ld	b,3
	ld	a,d
vt52Loop:	ld	c,a
	xor	a
	cp	(hl)
	ld	a,c
	jr	z,start
	cp	(hl)	; Check existing command
	jr	z,nextVT52chr
nextVT52stp:	inc	hl
	djnz	nextVT52stp	; Ignore other codes
	ld	c,a
	ld	a,-1
	cp	(hl)
	ld	a,c
	jr	nz,vt52Check
	cp	"Y"
	jr	nz,nonAnsi	; All checked but still no command
	call	getByte
	call	getByte
	jr	start

nextVT52chr:	inc	hl
	ld	c,a
	xor	a
	cp	(hl)
	ld	a,c
	jr	z,start
	call	getByte
	djnz	vt52Loop
	jr	nonAnsi

vt52table:	db	"A",0,0,"B",0,0,"C",0,0,"D",0,0,"E",0,0,"H",0,0
	db	"J",0,0,"K",0,0,"L",0,0,"M",0,0,"j",0,0,"l",0,0
	db	"x4",0,"x5",0,"y4",0,"y5",0,-1
;
; Public usable routines
;
getByte:	call	&h9f	; Read from keyboard (for now)
	cp	26	; Zero when 'End Of File'
	ret

putByte:	jp	&ha2	; Write to screen (for now)

upperCase:	cp	"a"	; Lowercased?
	ret	c
	cp	"z" + 1
	ret	nc
	and	223	; Then convert to uppercase
	ret
