	org	&hc000
;
; Deel A door B (A = A div B, rest B) - Byte versie! (c) BiFi'96
;
; In : A = Getal
;      B = Deeltal
;
; Uit: A = Uitkomst
;      B = Rest-waarde
;      Carry reset bij correcte berekening
;
divByte:	inc	b	; Test op deling door nul
	dec	b
	scf		; Zet Carry om fout aan te geven
	ret	z
	cp	b	; Kleiner dan B?
	push	de	; Store used registers
	push	bc
	ld	d,0	; A < B, dus uitkomst is 0
	jr	c,endDiv	; A is dan de rest-waarde, einde
	ld	c,a	; Vergelijkwaarde
	inc	d	; Uitkomst is in elk geval 1
	ld	a,b	; Plaats eerste deeltal

divLoop:	cp	c	; Groter of gelijk aan vergelijkwaarde?
	jr	nc,endDiv	; Dan is restwaarde 0 (NZ i.p.v. NC)
	ld	e,a	; Bereken rest-waarde
	ld	a,c	; Neem maximum-waarde
	sub	e	; Trek daar de huidige waarde vanaf
	cp	b	; Vergelijk met deeltal
	jr	c,endDiv	; Dan is er een rest-waarde
	ld	a,e	; Pak de huidige waarde weer (A * B)
	add	a,b	; Tel daar weer B bij op
	inc	d	; En de uitkomst is weer 1 hoger
	jr	divLoop	; Opnieuw testen

endDiv:	cp	c	; Vergelijk waarde met 'input-A'
	pop	bc	; Restore registers
	ld	b,a	; Rest-waarde in B
	ld	a,d	; Uitkomst van de deling in A
	pop	de
	or	a	; Reset Carry (geldig resultaat)
	ret	nz
	ld	b,0	; Deling is rond, rest-waarde 0
	ret
