	org	&h100
;
; V9990 Util - (to do: V9990 screen adjust)
;
; Written by: BiFi 2001/2002
;
	jp	start
	db	13,"V9990 Util - Written by BiFi 2001/2002",26
;
xAdjust:	dw	0
yAdjust:	dw	0
;
options:	db	0	; Bit 0 = Quiet Output (Batch Files)
;                                      ; Bit 1 = Select V99x8 on Video 9000
;                                      ; Bit 2 = Select V9990 on Video 9000
;                                      ; Bit 3 = Video 9000 Sync (VDP-Freq)
;                                      ; Bit 4 = Select V9990 NTSC
;                                      ; Bit 5 = Select V9990 PAL
;                                      ; Bit 6 = V9990 X-Adjustment
;                                      ; Bit 7 = V9990 Y-Adjustment
bDos	equ	5
;
; V9990 [/AXnn] [/AYnn] [/{P|N}] [/S] [/{V|G}] [/Q]
;         ^^6     ^^7      5 4     3     1 2     0   = options
;
parseOptions:	ld	hl,&h80
	ld	c,(hl)
	ld	b,0
	inc	hl
	inc	c
	dec	c
	ret	z

	ld	de,options
parseLoop:	ld	a,"/"
	cpir
	ret	nz
	ret	po

	ld	a,(hl)
	ex	de,hl
	or	32
	cp	"q"
	jr	nz,parseOptV
	set	0,(hl)

parseOptV:	cp	"v"
	jr	nz,parseOptG
	set	1,(hl)
parseOptG:	cp	"g"
	jr	nz,parseOptS
	set	2,(hl)
parseOptS:	cp	"s"
	jr	nz,parseOptN
	set	3,(hl)
parseOptN:	cp	"n"
	jr	nz,parseOptP
	set	4,(hl)
parseOptP:	cp	"p"
	jr	nz,parseOptA
	set	5,(hl)

parseOptA:	cp	"a"
	jr	nz,parseDone
	call	parseChar
	cp	"x"
	jr	nz,parseAdjY
	set	6,(hl)
	ld	(xAdjust),de
	jr	parseDone

parseAdjY:	cp	"y"
	jr	nz,parseDone
	set	7,(hl)
	ld	(yAdjust),de

parseDone:	ex	de,hl
	jr	parseLoop

parseChar:	dec	bc
	inc	de
	ld	a,(de)
	or	32
	ret
;
printOpt:	ld	a,(options)
	and	1
	ret	nz
printBdos:	ld	c,9
	push	hl
	call	bDos
	pop	hl
	ret
;
printOptCh:	ld	a,(options)
	and	1
	ret	nz
	ld	c,2
	jp	bDos
;
start:	call	parseOptions
	ld	de,tIntro
	ld	a,(options)
	and	254
	jr	nz,checkDouble
printUsage:	call	printBdos
	ld	de,tUsage
	jp	printBdos

checkDouble:	ld	hl,options
	ld	a,(hl)
	and	48
	cp	48
	jr	z,printUsage
	ld	a,(hl)
	and	6
	cp	6
	jr	z,printUsage

	call	printOpt

	bit	1,(hl)
	call	nz,setV99x8
	bit	2,(hl)
	call	nz,setV9990
	bit	4,(hl)
	push	hl
	call	nz,setGfx60
	pop	hl
	bit	5,(hl)
	push	hl
	call	nz,setGfx50
	pop	hl
	bit	6,(hl)
	call	z,getGfxAX
	push	hl
	call	nz,setGfxAX
	pop	hl
	bit	7,(hl)
	call	z,getGfxAY
	push	hl
	call	nz,setGfxAY
	pop	hl
	ld	a,(hl)
	and	192
	call	nz,doGfxAdj
	ret
;
setV99x8:	ld	a,16
	ld	de,tVdp
	jr	outSwitch

setV9990:	xor	a
	ld	de,tGfx

outSwitch:	push	af,de
	ld	de,tOutput
	call	printOpt
	pop	de,af

	out	(&h6f),a
	call	printOpt
printSelect:	ld	de,tSelected
	jp	printOpt

setGfx60:	ld	h,0
	ld	de,tNtsc
	jr	setIntFreq

setGfx50:	ld	h,8
	ld	de,tPal

setIntFreq:	ld	a,(options)
	and	8
	jr	z,setGfxFreq
	push	de
	ld	de,tSync
	call	printOpt
	pop	de

setGfxFreq:	call	printOpt
	ld	a,192+7
	out	(&h64),a
	in	a,(&h63)
	and	247
	or	h
	out	(&h63),a

	ld	a,(options)
	and	8
	jr	z,printSelect

	ld	a,(&hffe8)
	and	253
	rr	h
	rr	h
	or	h
	ld	(&hffe8),a
	di
	out	(&h99),a
	ld	a,128+9
	out	(&h99),a
	ei
	jr	printSelect

getValue:	inc	de
	ld	a,(de)
	cp	"-"
	jr	nz,noMinus
	inc	de
	ld	a,(de)
	cp	"1"
	jr	c,adjError
	cp	"8"
	jr	nc,adjError
	sub	"0"
	neg
	ld	l,a
	ld	h,-1
	jr	adjFlip

noMinus:	ld	a,(de)
	cp	"0"
	jr	c,adjError
	cp	"9"
	jr	nc,adjError
	ld	l,a
	ld	h,0

adjFlip:	xor	a	; from -7 - 8 to VDP-adjust value
	sub	l	; Lamed from SUB-ROM
	ld	l,a
	sbc	a,h
	sub	l
	ld	h,a
	ret

adjError:	pop	af,af
	ld	de,tAdjustErr
	jp	printOpt

setGfxAX:	ld	de,(xAdjust)
	call	getValue
	ld	(xAdjust),hl
	ret

setGfxAY:	ld	de,(yAdjust)
	call	getValue
	ld	(yAdjust),hl
	ret

getGfxAX:	ld	a,192+16
	out	(&h64),a
	in	a,(&h63)
	and	15
	ld	(xAdjust),a
	xor	a
	ret

getGfxAY:	ld	a,192+16
	out	(&h64),a
	in	a,(&h63)
	rrca
	rrca
	rrca
	rrca
	and	15
	ld	(yAdjust),a
	xor	a
	ret

doGfxAdj:	ld	a,(yAdjust)
	and	15
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	ld	b,a
	ld	a,(xAdjust)
	and	15
	or	b
	ld	b,a
	ld	a,192+16
	out	(&h64),a
	ld	a,b
	out	(&h63),a
	ld	de,tAdjust
	call	printOpt
	call	printAdjX
	ld	e,","
	call	printOptCh
	call	printAdjY
	ld	de,tAdjBrace
	jp	printOpt
;
printAdjX:	ld	a,(xAdjust)
	jr	printAdj
printAdjY:	ld	a,(yAdjust)
printAdj:	neg
	and	15
	cp	9
	jr	c,adjPrnt
	push	af
	ld	e,"-"
	call	printOptCh
	pop	af
	neg
	and	15
adjPrnt:	add	a,"0"
	ld	e,a
	jp	printOptCh
;
tIntro:	db	"V9990 Util version 1.0",13,10
	db	"Written by BiFi 2001/2002",13,10,10,"$"
tUsage:	db	"Usage: V9990 [/AXnn] [/AYnn] [/{P|N}] [/S] [/{V|G}] [/Q]"
	db	13,10,9,"/AXnn = Adjust X to <nn>"
	db	13,10,9,"/AYnn = Adjust Y to <nn>"
	db	13,10,9,"/P    = Select PAL Mode"
	db	13,10,9,"/N    = Select NTSC Mode"
	db	13,10,9,"/S    = Frequency Sync. (Video 9000)"
	db	13,10,9,"/V    = V99x8 Output Select (Video 9000)"
	db	13,10,9,"/G    = V9990 Output Select (Video 9000)"
	db	13,10,9,"/Q    = Quiet (Batch files)$"
tAdjustErr:	db	"Adjust values between -7 and 8",13,10,"$"
tAdjust:	db	"Screen adjusted to ($"
tAdjBrace:	db	")",13,10,"$"
tNtsc:	db	"NTSC$"
tPal:	db	"PAL$"
tSync:	db	"Video 9000 synced $"
tOutput:	db	"V99$"
tSelected:	db	" selected",13,10,"$"
tVdp:	db	"x8$"
tGfx:	db	"90$"
