	org	&h100
;
bDos	equ	5
;
; Magic Replayer Skin setter
;
; Written by: BiFi 2001
;
	jp	start
	db	13,"Magic Replayer Skin setter. BiFi 2001",26
;
start:	ld	de,tIntro	; Write intro
	call	printBDos

	ld	c,&h6f	; Check DOS version
	call	bDos
	ld	a,b
	cp	2	; DOS2 or higher?
	jr	nc,dos2

	ld	de,tNoDos2	; It isn't, write error and quit
printBDos:	ld	c,9
	jp	bDos

noFile:	pop	de
	ld	de,tNoName	; No filename given
	jr	printBDos

noSkin:	ld	de,tNoSkin
	jr	printBDos
;
dos2:	ld	hl,&h80	; Check length of command line
	ld	a,(hl)
	and	a	; Write usage and quit when it's empty
	ld	de,tUsage
	jr	z,printBDos
	ex	de,hl	; Put the command line pointer in DE

findPath:	inc	de	; Find first valid character for name
	ld	a,(de)
	cp	32	; Space is an invalid character
	jr	z,findPath
	cp	9	; TAB is an invalid charcter
	jr	z,findPath

	push	de
	ld	bc,&h5b	; Parse pathname
	call	bDos

	ld	a,(tDrive)
	add	a,c
	ld	(tDrive),a

	call	dCompR
	jr	z,noFile

	bit	4,b
	jr	nz,hasExt

	ld	bc,4
	ld	hl,tDefaultExt
	ldir

hasExt:	xor	a
	ld	(de),a
	pop	de

	ld	bc,&h40
	ld	ix,fib
	call	bDos
	jr	nz,noSkin

	ld	c,&h5e
	ld	de,tFullPath
	call	bDos

	ld	c,&h6c
	ld	de,tEnvValue
	ld	hl,tEnvName
	call	bDos
	ld	de,tErrorSet
	jr	nz,printBDos
	ld	de,tDoneSet
	jr	printBDos
;
dCompR:	ld	a,h
	cp	d
	ret	nz
	ld	a,l
	cp	e
	ret
;
tIntro:	db	"SKIN version 1.0 - Written by: BiFi 2001",13,10
	db	"Easilly enable skin setting for Magic Replayer"
	db	13,10,10,"$"
tUsage:	db	"SKIN <pathspec>",13,10,10,"$"
tDoneSet:	db	"Skin succesfully changed",13,10,"$"
tErrorSet:	db	"Error detected. Skin not changed",13,10,"$"
tNoSkin:	db	"Error detected. Skinfile not found",13,10,"$"
tNoName:	db	"No skinfile given",13,10,"$"
tNoDos2:	db	"SKIN requires MSX-DOS2",13,10,"$"
tDefaultExt:	db	".SKN"
tEnvName:	db	"SKIN",0
tEnvValue	equ	$
tDrive:	db	"@:\"
tFullPath:	ds	64
fib	equ	$
