	org	&h100
;
; ROM-image executer in Snatcher- or SD-Snatcher Sound-Cartridge
;
; Written by: BiFi'97 / 2002
;
bDos	equ	5
asc16Base	equ	&hf230
;
	jp	start
	db	13,"BiFi's ROM loader. Up to 1MegaROM supported",26
;
start:	ld	de,tIntro
	call	printBDos

	ld	a,(&h80)
	and	a
	call	nz,parseSlot

	ld	bc,&h6f
	call	bDos
	ld	hl,types
	ld	a,b
	cp	2
	set	7,(hl)
	jr	nc,checkSnScc
	res	7,(hl)

checkSnScc:	ld	bc,&h0800	; Locate Snatcher Sound-Cartridge
	call	fndKonamiRAM
	ld	(slot1),a
	inc	a
	ld	hl,types
	jr	z,checkSdScc
	set	0,(hl)

checkSdScc:	ld	bc,&h0808	; Locate SD-Snatcher Sound-Cartridge
	call	fndKonamiRAM
	ld	(slot2),a
	inc	a
	ld	hl,types
	jr	z,checkTypes
	set	1,(hl)

checkTypes:	ld	a,(hl)
	and	3
	jp	z,noRamScc
	inc	hl
	ld	a,(hl)	; A = Slot1
	inc	hl
	cp	(hl)	; (HL) = Slot2, Slot1 = Slot2?
	jr	z,type128K	; Then a 128K addition found

	ld	hl,types
	push	hl
	bit	0,(hl)
	ld	de,tSnatScc
	call	nz,printBDos
	ld	a,(slot1)
	inc	a
	call	nz,printSlot

	pop	hl
	bit	1,(hl)
	ld	de,tSdSnScc
	call	nz,printBDos
	ld	a,(slot2)
	inc	a
	call	nz,printSlot
	jr	excludeType

type128K:	ld	de,t128KScc
	call	printBDos
	ld	a,(slot1)
	inc	a
	call	printSlot
	ld	hl,types
	set	2,(hl)
	res	1,(hl)
	res	0,(hl)

excludeType:	ld	a,(&h80)
	and	a
printUsage:	ld	de,tUsage
	jp	z,printBDos

	call	parseParms

; 1 Find filename
	ld	a,(types)
	and	128
	jr	z,noDos2

	ld	hl,&h80
findPath:	inc	hl
	ld	a,(hl)
	cp	" "
	jr	z,findPath
	cp	9
	jr	z,findPath

	ld	(pathSpec),hl

	ld	bc,&h5b
	ex	de,hl
	call	bDos
	ex	de,hl
	ld	(hl),0

	ld	bc,&h40
	ld	de,(pathSpec)
	ld	ix,fcb
	call	bDos
	jr	openFile

noDos2:	ld	bc,47
	ld	de,fcb + 1
	ld	hl,fcb
	ld	(hl),0
	ldir

	ld	bc,12
	ld	de,fcb
	ld	hl,&h5c
	ldir

; 2 Open file
openFile:	ld	a,(types)
	and	128
	ld	a,1
	ld	c,&h43
	ld	de,(pathSpec)
	jr	nz,fileOpen

	ld	c,15
	ld	de,fcb
fileOpen:	call	bDos
	or	a
	jr	z,checkSize

	call	setRam
	ld	de,tOpenErr
	call	printBDos
	jp	closeFile

; 3 Check filesize
checkSize:	ld	a,(types)
	and	128
	ld	a,b
	ld	(fHandle),a
	ld	hl,(fcb+22)
	jr	nz,sizeCheck
	ld	hl,(fcb+17)

sizeCheck:	add	hl,hl
	add	hl,hl
	add	hl,hl
	ld	a,h
	ld	(blockCount),a
	cp	9
	jr	c,sizeOk
	cp	17
	jr	nc,sizeNotOk
	ld	a,(types)
	and	4
	jr	nz,sizeOk

sizeNotOk:	call	setRam
	ld	de,tMemErr
	call	printBDos
	jr	closeFile

sizeOk:	ld	a,(blockCount)
	ld	b,a
	ld	a,(types)
	and	5
	ld	c,0
	jr	nz,loadInit
	ld	c,8

loadInit:	ld	a,(types)
	and	128
	push	bc
	jr	nz,loadIniDos2
	pop	bc

	ld	hl,0
	ld	(fcb+33),hl
	ld	(fcb+35),hl
	ld	h,32
	ld	(fcb+14),hl

	push	bc
	ld	c,&h1a
	ld	de,dma
	call	bDos

loadIniDos2:	call	setScc2
	ld	de,tLoading
	call	printBDos
	pop	bc

; 4 Load block
loadBlock:	push	bc,bc
	ld	bc,(fHandle - 1)
	ld	c,&h48
	ld	de,dma
	ld	hl,8192
	ld	a,(types)
	and	128
	jr	nz,readBlock

	ld	c,&h27
	ld	de,fcb
	ld	hl,1
readBlock:	call	bDos
	or	a
	jr	z,convBlock

	pop	bc,bc
;              ld      (error),a        ; Debug
	call	setRam
	ld	de,tLoadErr
	call	printBDos

closeFile:	ld	bc,(fHandle - 1)
	ld	c,&h45
	ld	a,(types)
	and	128
;              jr      nz,fileClose      ; Debug
	jp	nz,bDos

	ld	c,16
	ld	de,fcb
;fileClose:    call    bDos             ; Debug
;              ld      a,(error)        ; Debug
;              ld      b,a              ; Debug
;              ld      c,&h62           ; Debug
	jp	bDos

; 5 Convert block
convBlock:	pop	bc
	call	setBank8
	call	checkRom

	call	convMap

	ld	bc,8192
	ld	de,&h8000
	ld	hl,dma
	ldir

; 6 <goto 4 until eof>
	pop	bc
	inc	c
	djnz	loadBlock

; 7 Close file
	call	closeFile

	ld	de,tComplete
	call	printBDos

	ld	a,(parseFlags)
	and	16
	jr	z,execRom

	ld	bc,len16Block
	ld	de,asc16Base
	ld	hl,block16
	ldir

execRom:	ld	h,&h40
	call	setScc
	ld	hl,parseFlags
	call	setBlocks
	bit	1,(hl)	; Reset overrules normal start
	ld	ix,0
	ld	iy,(&hfcc0)
	jp	nz,&h1c
	bit	0,(hl)
	jr	z,setRam
	ld	a,(parseFlags)
	and	96
	ld	hl,(&h8002)
	jr	nz,highExec
	ld	hl,(&h4002)
highExec:	push	hl
	ld	a,(&hfcc1)
	ld	h,0
	jp	&h24
;
setScc2:	ld	h,&h80
setScc:	ld	a,(types)
	and	5
	ld	a,(slot1)
	jp	nz,&h24
	ld	a,(types)
	and	2
	ld	a,(slot2)
	jp	&h24
;
setRam:	ld	a,(&hf342)
	ld	h,&h40
	call	&h24
	ld	a,(&hf342)
	ld	h,&h80
	jp	&h24
;
setBank8:	xor	a
	ld	(&hbffe),a
	ld	a,c
	ld	(&h9000),a
	ld	a,31
	ld	(&hbffe),a
	ret
;
setBlocks:	ld	a,(types)
	and	5
	ld	b,0
	jr	nz,setBank32
	ld	b,8
setBank32:	xor	a
	ld	(&hbffe),a

	ld	a,(blockCount)
	cp	5
	jr	nc,largeSize
	cp	3
	ld	a,b
	jr	nc,size32

	ld	(&h5000),a
	ld	c,4
	ld	de,&h4003
sizeChkLp:	ld	a,(de)
	and	a
	jr	nz,sizeChkDn
	inc	de
	inc	de
	dec	c
	jr	nz,sizeChkLp
	jr	largeSize

sizeChkDn:	rlca
	rlca
	and	3
	dec	a	; Start 4000h
	jr	z,setLoBank
	dec	a	; Start 8000h
	jr	z,size16Hi

largeSize:	ld	a,(hl)
	and	96
	ld	a,b
	jr	nz,halOrder
size32:	call	setLoBank
	jr	setHiBank
halOrder:	call	setHiBank

setLoBank:	ld	(&h5000),a
	inc	a
	ld	(&h7000),a
	inc	a
	ret

size16Hi:	set	5,(hl)

setHiBank:	ld	(&h9000),a
	inc	a
	ld	(&hb000),a
	inc	a
	ret
;
printSlot:	dec	a
	push	af
	call	print	; Primary slot
	pop	af
	bit	7,a
	ret	z
	ld	e,"-"	; Secundary slot
	call	printChr
	rra
	rra

print:	and	3
	add	a,"0"
	ld	e,a
printChr:	ld	c,2
	jp	5
;
noRamScc:	ld	de,tNoRamScc
	jp	printBDos
;
checkRom:	ld	a,(romChkFlg)
	or	a
	ret	nz
	ld	a,-1
	ld	(romChkFlg),a

	ld	a,(dma)
	cp	"A"
	jr	nz,chkRomErr
	ld	a,(dma+1)
	cp	"B"
	ret	z

chkRomErr:	pop	af,af
	call	setRam
	ld	de,tRomErr
	call	printBDos
	jp	closeFile
;
convMap:	ld	a,(parseFlags)	; Conversion requested?
	and	156
	ret	z

;              ld      hl,&hf975        ; Debug
;              ld      b,0
;              add     hl,bc
;              ld      a,(parseFlags)
;              ld      (hl),a           ; Debug

	ld	bc,8192	; Length of block to parse
	ld	hl,dma	; Starting from DMA
convNext:	ld	a,&h32	; Check LD (ADDRESS),A
	cpir
	ret	nz

	ld	a,(parseFlags)
	and	128	; ASCII8 real to Konami5?
	call	nz,realAscii8

	ld	a,(parseFlags)
	and	8	; ASCII8 to Konami5?
	jr	nz,ascii8

	ld	a,(parseFlags)
	and	16	; ASCII16 to Konami5?
	jp	nz,ascii16

	ld	a,(parseFlags)
	and	4	; Konami4 to Konami5?
	jr	z,convNext

	ld	a,(hl)
	and	a
	jr	nz,convNext

	inc	hl
	ld	a,(hl)

konami4:	cp	&h40
	jr	z,cnvKona4
	cp	&h60
	jr	z,cnvKona4
	cp	&h80
	jr	z,cnvKona4
	cp	&ha0
	jr	nz,convNext
cnvKona4:	add	a,&h10
	ld	(hl),a
	dec	hl
	ld	(hl),0
	jr	convNext

realAscii8:	ld	a,(hl)
	and	a
	ret	nz

	inc	hl
	ld	a,(hl)
	cp	&h60
	ld	d,&h50
	jr	z,convAscii
	cp	&h68
	ld	d,&h70
	jr	z,convAscii
	cp	&h70
	ld	d,&h90
	jr	z,convAscii
	cp	&h78
	ld	d,&hb0
	ret	nz

convAscii:	ld	(hl),d
	dec	hl
	ld	(hl),0
	pop	de
	ld	a,(parseFlags)
	and	247
	ld	(parseFlags),a
	jr	convNext
;              ret

ascii8:	inc	hl
	ld	a,(hl)
	cp	&h60
	jr	c,convNext
	cp	&h80
	jr	nc,convNext

	dec	hl
	ld	a,(convFlag)
	cp	-1
	call	nz,setCnvFlg
	ld	a,(convTemp)
	cp	(hl)
	jp	nz,convNext
	inc	hl
	ld	a,(parseFlags)
	and	127
	ld	(parseFlags),a
	ld	a,(hl)

	and	&h18
	srl	a
	srl	a
	srl	a
	ld	d,a
	and	1
	rrca
	rrca
	rrca
	ld	e,a
	ld	a,d
	and	2
	ld	d,a
	rrca
	rrca
	or	e
	ld	e,a
	ld	a,d
	cpl
	and	2
	rrca
	rrca
	rrca
	or	e
	jr	cnvKona4

ascii16:	ld	a,(hl)
	and	a
	jp	nz,convNext
	ld	e,a

	inc	hl
	ld	d,(hl)
	ld	a,(parseFlags)
	and	64
	jr	z,noSlrTest

	ld	a,e
	cp	d
	jp	nz,convNext
	inc	hl
	ld	a,(hl)
	dec	hl
	cp	&h32
	jp	c,convNext

	ld	a,d
	ld	de,asc16Base + 2
	jr	wrtCall

noSlrTest:	ld	a,d
	ld	de,asc16Base
	cp	&h60
	jr	z,wrtCall
	ld	d,a
	ld	a,(parseFlags)
	and	32
	jp	nz,convNext
	ld	a,d
	ld	de,asc16Base + 2
	cp	&h70
	jp	nz,convNext

wrtCall:	ld	(hl),d
	dec	hl
	ld	(hl),e
	dec	hl
	ld	(hl),&hcd
	inc	hl
	jp	convNext

setCnvFlg:	ld	a,-1
	ld	(convFlag),a
	ld	a,(hl)
	ld	(convTemp),a
	ret
;
printBDos:	ld	c,9
	jp	5
;
block16:	jr	setLower
	jr	setHigher
setLower:	di
	push	af
	add	a,a
	ld	(&h5000),a
	inc	a
	ld	(&h7000),a
	pop	af
	ei
	ret
setHigher:	di
	push	af
	add	a,a
	ld	(&h9000),a
	inc	a
	ld	(&hb000),a
	pop	af
	ei
	ret

len16Block	equ	$-block16
;
; Directly lamed from Konami by: BiFi'97
;
fndKonamiRAM:	ld	(blockCheck),bc	; Keep values
	ld	bc,&h400
	ld	hl,&hfcc1
primLoop:	push	bc,hl
	ld	a,(hl)
	bit	7,a
	jr	nz,sub
	ld	a,c
	call	check
	jr	nxtSlt
sub:	call	subChk
nxtSlt:	pop	hl,bc
	ret	c
	inc	hl
	inc	c
	djnz	primLoop
	ld	a,255
	ld	(ramScc),a
	ret

subChk:	and	128
	or	c
	ld	b,4
subLoop:	push	bc
	call	check
	pop	bc
	ret	c
	add	a,4
	djnz	subLoop
	ret

check:	ld	(ramScc),a
	ld	b,a
	ld	a,(types)
	and	64
	jr	z,noIgnore
	ld	a,(ignoreSlot)
	cp	b
	jr	z,nonCarry
noIgnore:	ld	a,(ramScc)
	call	checkScc
	push	af
	ld	a,(&hf342)
	ld	h,&h80
	call	&h24
	pop	af
	jr	nc,nonCarry
yesCarry:	ld	a,(ramScc)
	scf
	ret
nonCarry:	ld	a,(ramScc)
	and	a
	ret

checkScc:	ld	h,&h80
	call	&h24
	call	writeRam
	call	readRam
	ret

readRam:	ld	a,&h20
	ld	(&hbffe),a
	ld	bc,(blockCheck)
rdRamLoop:	ld	a,c
	ld	(&h9000),a
	call	cpByt
	ret	nc
	inc	c
	djnz	rdRamLoop
	scf
	ret

cpByt:	ld	hl,(&h9000)
	call	compare
	ret	nc
	ld	hl,(&h9002)
compare:	ld	a,l
	cp	h
	jr	nz,noRam
	cp	c
	jr	nz,noRam
	scf
	ret
noRam:	and	a
	ret

writeRam:	ld	bc,(blockCheck)
wrRamLoop:	push	bc
	call	nxtBnk
	ld	l,c
	ld	h,c
	ld	(&h9000),hl
	ld	(&h9002),hl
	pop	bc
	inc	c
	djnz	wrRamLoop
	ld	a,&h20
	ld	(&hbffe),a
	ret

nxtBnk:	ld	a,&h20
	ld	(&hbffe),a
	ld	a,c
	ld	(&h9000),a
	ld	a,&h3f
	ld	(&hbffe),a
	ret
;
parseParms:	ld	hl,&h80
	ld	de,parseFlags
	ld	c,(hl)
	ld	b,0
	inc	hl
parseLoop:	ld	a,"/"
	cpir
	ret	nz
	ret	po
	ld	a,(hl)
	ex	de,hl
	or	32
	cp	"s"
	jr	nz,parseNoStart
	set	0,(hl)
parseNoStart:	cp	"r"
	jr	nz,parseNoReset
	set	1,(hl)
parseNoReset:	ld	a,(hl)
	and	124
	jr	nz,parseNext

	ld	a,(de)
	cp	"c"
	jr	nz,parseNoKona4
	set	2,(hl)
parseNoKona4:	cp	"a"
	jr	nz,parseNoAsci8
	set	3,(hl)
	set	7,(hl)
parseNoAsci8:	cp	"1"
	jr	nz,parseNoAsc16
	set	4,(hl)
parseNoAsc16:	cp	"h"
	jr	nz,parseNoHal
	set	4,(hl)
	set	5,(hl)
parseNoHal:	cp	"l"
	jr	nz,parseNoSlr
	set	4,(hl)
	set	6,(hl)
parseNoSlr:
parseNext:	ex	de,hl
	jr	parseLoop
;
parseSlot:	ld	hl,&h80
	ld	ix,types
	ld	c,(hl)
	ld	b,0
	inc	hl
parseSlotLp:	ld	a,"/"
	cpir
	ret	nz
	ret	po
	ld	a,(hl)
	or	32
	cp	"i"
	jr	nz,parseNoSlot
	ld	a,l
	cp	&h83
	call	z,parSlotOnly
	set	6,(ix+0)

	inc	hl
	ld	a,(hl)
	cp	":"
	jr	nz,parSlotEnd
	call	parSlotChk
	ld	(ignoreSlot),a
	push	bc,hl
	ld	hl,&hfcc1
	ld	c,a
	ld	b,0
	add	hl,bc
	ld	a,(hl)
	pop	hl,bc
	and	a
	ret	z
	inc	hl
	ld	a,(hl)
	cp	"-"
	ret	nz
	call	parSlotChk
	add	a,a
	add	a,a
	add	a,128
	ld	b,a
	ld	a,(ignoreSlot)
	or	b
	ld	(ignoreSlot),a
	bit	5,(ix+0)
	ret	nz
parSlotOnly:	xor	a
	ld	(&h80),a
	ret

parseNoSlot:	set	5,(ix+0)
	jr	parseSlotLp

parSlotEnd:	pop	af
	xor	a
	jp	printUsage

parSlotChk:	inc	hl
	ld	a,(hl)
	cp	"0"
	jr	c,parSltChkEnd
	cp	"4"
	jr	nc,parSltChkEnd
	sub	"0"
	ret

parSltChkEnd:	pop	af,af
	ld	de,tNoSlot
	jp	printBDos
;
blockCount:	db	0	; Number of 8 kB blocks in the file
;
parseFlags:	db	0	; Bit 0 = Start ROM when loaded
;                                      ; Bit 1 = Reset system after loading ROM
;                                      ; Bit 2 = Konami4 conversion
;                                      ; Bit 3 = ASCII8 conversion
;                                      ; Bit 4 = ASCII16 conversion
;                                      ; Bit 5 = HAL mapping order
;                                      ; Bit 6 = Super Lode Runner
;                                      ; Bit 7 = ASCII8 internal
;
types:	db	0	; Bit 0 = Snatcher
;                                      ; Bit 1 = SD-Snatcher
;                                      ; Bit 2 = 128 kB
;                                      ; Bit 5 = moreParms Flag
;                                      ; Bit 6 = Ignore slot
;                                      ; Bit 7 = MSX-DOS 2
;
slot1:	db	0	; Slot of Snatcher SCC
slot2:	db	0	; Slot of SD-Snatcher SCC
ramScc:	db	0
ignoreSlot:	db	0
blockCheck:	dw	0
romChkFlg:	db	0
convTemp	equ	blockCheck
convFlag	equ	convTemp + 1
pathSpec:	dw	0
fHandle:	db	0
;
tIntro:	db	"Konami Mega-ROM executor version 1.99",13,10
	db	"Written by: BiFi 2002$"
tUsage:	db	13,10,10,10,"Usage: ROMLOAD <pathspec>"
	db	" [/S] [/R] [/I:P-S] [/{C|A|1|H|L}]"
	db	13,10,10,"<pathspec> = Full path & filename of ROM-image"
	db	13,10,9,"/S = Start ROM when loaded"
	db	13,10,9,"/R = Reset system after loading ROM-image"
	db	13,10,9,"/I = Ignore detection in slot P-S"
	db	13,10,9,"/C = Convert to SCC mapping (Konami5)"
	db	13,10,9,"/A = Convert from ASCII mapping (ASCII8)"
	db	13,10,9,"/1 = Convert from ASCII mapping (ASCII16)"
	db	13,10,9,"/H = HAL mapping (ASCII16 special)"
	db	13,10,9,"/L = Super Lode Runner (16 kB)$"
tNoSlot:	db	13,10,10,"Invalid slot. Valid slots 0-3$"
tNoRamScc:	db	13,10,10,"No Sound-Cartridges detected.$"
tSnatScc:	db	13,10,10,"Snatcher Sound-Cartridge in slot $"
tSdSnScc:	db	13,10,10,"SD-Snatcher Sound-Cartridge in slot $"
t128KScc:	db	13,10,10,"Sound-Cartridge with 128 kB in slot $"
tMemErr:	db	13,10,10,"Not enough memory to load this Mega-ROM.$"
tOpenErr:	db	13,27,"KError opening ROM-image.",13,10,"$"
tLoadErr:	db	13,27,"KError reading ROM-image.",13,10,"$"
tRomErr:	db	13,27,"KNo ROM-image.",13,10,"$"
tLoading:	db	13,10,"Loading...$"
tComplete:	db	13,27,"KROM-image complete.",13,10,"$"
;error:        db      0                ; Debug
;
fcb	equ	$
dma	equ	fcb + 64
