ldrMov	equ	4800h

	defb	254
	defw	start + ldrMov
	defw	einde
	defw	init

	org	&h4000

hook1	equ	&hff02	; hooks 2 use here.
hook2	equ	&hff0c
hook3	equ	&hfedf
hook4	equ	&hfe03
;
start:	ei		; Put the interrupts on again
	and	a	; Set flags
	jr	nz,errBreak	; Hey! A is empty, so SEE YA!
	ex	af,af'	; Keep AF
	ex	de,hl	; Keep HL in DE
	ld	a,(&hf414)	; Read error code
	ld	hl,errList	; Point to top of list
	call	testUnprErr	; Test if it's out of normal range
	jr	c,parseErrTxt	; Time to parse if Carry is set
	ex	de,hl	; Get the shitty back in place
	xor	a	; empty for MemMan
	ex	af,af'
oldHook:	ds	5,0	; See ya!

parseErrTxt:	ld	de,&hf605	; Start of error text buffer
	push	de	; Keep the bufferpointer
parseLp:	ld	a,(hl)	; Get character
	bit	7,a	; Is bit 7 set?
	jr	nz,endOfParse	; Yep! So that's the last character
	ld	(de),a	; Set character into buffer
	inc	hl	; Next char. in errList
	inc	de	; Next char. in buffer
	jr	parseLp	; do it again until bit 7 is set.

endOfParse:	res	7,a	; Reset bit 7 for original character
	ld	(de),a	; Set character into buffer
	inc	de	; Next char in buffer
	xor	a	; Add zero for end of text.
	ld	(de),a
	pop	hl	; Retrieve buffer-pointer for Basic
	ex	af,af'	; emtpy for MemMan (through xor a)
	jr	oldHook	; See ya!

testUnprErr:	cp	28	; x Errors erbij = current + x
	jr	c,mvToErrTxt
	cp	50
	jr	c,unPrintAble
	cp	222	; RAM-disk foutmelding 
	jr	z,noFreSeg	; Hier hebben we wat aan... 
dos:	cp	76
	jr	nc,unPrintAble
	sub	22	; x Errors erbij = current - x
cont:	scf
mvToErrTxt:	dec	a	; Right error text pointer found (=0)?
	ret	z	; Yep! Bye!
mvLoop:	bit	7,(hl)	; Bit 7 set (end of errortext)?
	inc	hl	; Next char. if not
	jr	z,mvLoop	; Nope? Then test next char.
	jr	mvToErrTxt	; Hey! Go through next error text

unPrintAble:	ld	a,23
	jr	cont

noFreSeg:	ld	a,53	; Aanvullende foutmelding
	jr	cont
;
newPrompt:	ld	a,(&hf665)
	and	a
	jr	nz,endHook
	ld	hl,nedPrompt
outPrompt:	ld	a,(hl)
	and	a
	jr	z,endHook
	call	&ha2
	inc	hl
	jr	outPrompt

endHook:	ds	5,0
;
errBreak:	ld	hl,nedBreak
	jr	parseErrTxt
;
stkErr:	xor	a
	ld	(&hf665),a
oldStkErr:	ds	5,0
;
; Nieuwe prompt tekst (overlapt oude prompt)
;
nedPrompt:	db	27,'A','En nu?',13,10,0
;
nedBreak:	dc	'Afgebroken'
nedInLine:	dc	' in regel '
;
; De vertaalde foutlijst. MSX BASIC version 1 en hoger
;
errList:	dc	'NEXT zonder FOR'
	dc	'Fout in schrijfwijze'
	dc	'RETURN zonder GOSUB'
	dc	'Geen DATA gevonden'
	dc	'Onjuiste functieaanroep'
	dc	'Buiten bereik'
	dc	'Geen vrij geheugen meer'
	dc	'Ongedefinieerd regelnummer'
	dc	'Indexnummer buiten bereik'
	dc	'Hergedimensioneerde lijstvariabele'
	dc	'Deling door nul'
	dc	'Rechtstreeks gebruik verboden'
	dc	'Ongelijke soort'
	dc	'Rijvariabele ruimte verbruikt'
	dc	'Rijvariabele te lang'
	dc	'Rijvariabele te complex'
	dc	'Programmahervatting onmogelijk'
	dc	'Ongedefinieerde gebruikersfunctie'
	dc	'Apparaat I/O fout'
	dc	'Controle fout'
	dc	'Geen RESUME'
	dc	'RESUME zonder ERROR'
	dc	'Onbeschrijfbare fout'
	dc	'Ontbrekende parameter'
	dc	'Regelbuffer buiten bereik'
	dc	'Geen SCC gevonden'	; Aanvulling REPLAY27.BIN
	dc	'Printer niet gereed'	; Aanvulling POL.TSR
	dc	'FIELD buiten bereik'
	dc	'Fout in het Basic vertaalprogramma'
	dc	'Verkeerd bestandsnummer'
	dc	'Bestand niet gevonden'
	dc	'Bestand reeds geopend'
	dc	'Invoer voorbij einde'
	dc	'Verkeerde bestandsnaam'
	dc	'Rechtstreeks bevel in bestand'
	dc	'Alleen achtereenvolgende I/O'
	dc	'Bestand niet geOPENd'
;
; Dit gedeelte gaat alleen op voor DOS 1
;
	dc	'Slechte FAT'
	dc	'Verkeerde bestandssoort'
	dc	'Onbekende drive'
	dc	'Sector buiten bereik'
	dc	'Bestand nog steeds geopend'
	dc	'Bestand bestaat reeds'
	dc	'Disk vol'
	dc	'Te veel bestanden'
	dc	'Disk schrijf beveiligd'
	dc	'Disk I/O fout'
	dc	'Disk niet gereed'
	dc	'Herbenoeming over twee drives'
;
; Dit gedeelte gaat alleen op voor DOS 2
;
	dc	'Bestand schrijf beveiligd'
	dc	'Directory bestaat reeds'
	dc	'Directory niet gevonden'
	dc	'RAM disk bestaat reeds'
	dc	'Geen vrije segmenten meer'	; RAM-disk foutmelding
;
rcInit:	ld	a,(&hffa7)	; Test for Disk-Basic
	cp	201	; 'ret' if no Disk-ROM initized
	jr	z,noDisk	; There was no disk
	ld	c,6fh
	call	&hf37d	; Check DOS version
	ld	a,b
	cp	2
	jr	nc,mvHook
	ld	a,72	; When not DOS2... Ignore DOS2 errors
	ld	(dos + 1),a	; DOS1
	jr	mvHook

noDisk:	ld	a,60	; Then all original Disk-errors are
	ld	(dos + 1),a	; not available... So the ET-errors

mvHook:	di		; Disable all interrupts
	push	af	; Keep regs.
	push	bc
	push	de
	push	hl
	ld	a,(&hf665)	; Let's see if it's in a program
	cp	1
	jr	z,prepare	; It's in a program. Don't print text
	ld	de,tIntro
writeLp:	ld	a,(de)
	or	a
	jr	z,prepare
	call	&ha2
	inc	de
	jr	writeLp
prepare:	ld	bc,5	; Length of hook-entry
	push	bc	; Keep it 4 later use
	ld	de,oldHook	; Destination... oldHook
	ld	hl,hook1	; Source........ hook
	push	hl	; 4 later use
	ldir		; Move entry for linking
;
expTbl	equ	&hfcc1	; Beginadres met EXPTBL voor het bepa-
			; len van het expanded slot.
	call	&h138	; Lees primaire slotstructuur.
	rrca		; Zoek juiste element op binnen de
	rrca		; ingeschakelde sloten.
	and	3	; Selecteer relevante deel.
	ld	c,a	; Zet deze in het register BC voor
	ld	b,0	; het optellen bij de EXPTBL van het
	ld	hl,expTbl	; eventuele expanded slot.
	add	hl,bc
	or	(hl)	; Bit 7 hoog voor expanded slot.
	ld	c,a	; Tijdelijk opbergen.
	inc	hl
	inc	hl
	inc	hl
	inc	hl
	ld	a,(hl)	; Huidig ingeschakelde secundaire slot
	and	12	; Selecteer relevante deel
	or	c	; Combineer met de reeds gevonden info
;
	ld	(newHook1 + 1),a	; Keep the slot coding 4 the hooks
	ld	(newHook2 + 1),a
	ld	(newHook3 + 1),a
	ld	(newHook4 + 1),a
;
	pop	de	; Swap HL & DE
	pop	bc	; Retrieve length
	ld	hl,newHook1	; copy the newHook entry to use this
	ldir		; part of the code.

	ld	bc,5
	push	bc
	ld	de,endHook
	ld	hl,hook2
	push	hl
	ldir
	pop	de
	pop	bc
	ld	hl,newHook2
	ldir

	ld	bc,5
	push	bc
	ld	de,oldStkErr
	ld	hl,hook3
	push	hl
	ldir
	pop	de
	pop	bc
	ld	hl,newHook3
	ldir

	ld	bc,5
	push	bc
	ld	de,oldKill
	ld	hl,hook4
	push	hl
	ldir
	pop	de
	pop	bc
	ld	hl,newHook4
	ldir

	pop	hl	; Get regs. back
	pop	de
	pop	bc
	pop	af
	ei		; Gimme those interrupts back
	ret		; Back to the Basic's

tIntro:	db	'Deze TSR vertaalt alle Basic, Disk-Basic 1'
	db	' en Disk-Basic 2',13,10
	db	'foutmeldingen van Engels naar het Nederlands.'
	db	13,10,10,'Deze nieuwe versie door A.Beevendorp -'
	db	' Olympiasoft PD 1994-1997',13,10,10,0
;
; Set IPL command to disable all used hooks (no other "TSR's" on these Hooks)
;
killTsr:	push	af
	push	bc
	push	de
	push	hl

	ld	b,5
	ld	hl,hook1
	ld	de,newHook1
chkHook1:	ld	a,(de)
	cp	(hl)
	jr	nz,doHook2
	inc	de
	inc	hl
	djnz	chkHook1

	ld	bc,5
	ld	de,hook1
	ld	hl,oldHook
	ldir

doHook2:	ld	b,5
	ld	hl,hook2
	ld	de,newHook2
chkHook2:	ld	a,(de)
	cp	(hl)
	jr	nz,doHook3
	inc	de
	inc	hl
	djnz	chkHook2

	ld	bc,5
	ld	de,hook2
	ld	hl,endHook
	ldir

doHook3:	ld	b,5
	ld	hl,hook3
	ld	de,newHook3
chkHook3:	ld	a,(de)
	cp	(hl)
	jr	nz,doHook4
	inc	de
	inc	hl
	djnz	chkHook3

	ld	bc,5
	ld	de,hook3
	ld	hl,oldStkErr
	ldir

doHook4:	ld	bc,5
	ld	de,hook4
	ld	hl,oldKill
	ldir

	pop	hl
	pop	de
	pop	bc
	pop	af
	ld	ix,409bh
	push	ix
	ld	h,40h
	ld	a,(0fcc1h)
	jp	24h
;
oldKill:	ds	5,0
;
newHook1:	rst	&h30	; interslot call
	db	0	; slot
	dw	start
	ret

newHook2:	rst	&h30
	db	0
	dw	newPrompt
	ret

newHook3:	rst	&h30
	db	0
	dw	stkErr
	ret

newHook4:	rst	&h30
	db	0
	dw	killTsr
	ret

	org	$ + ldrMov

init:	ld	h,7fh	; Lamed from S.V.L. software 1987
	call	testRam
	cp	255
	jr	nz,mvCode
	ld	de,errText
wrLoop:	ld	a,(de)
	cp	24h
	ret	z
	call	0a2h
	inc	de
	jr	wrLoop
errText:	defm	'Geen 64k RAM gevonden!$'

testRam:	ld	c,0
testLp:	ld	a,c
	and	3
	ld	d,0
	ld	e,a
	push	hl
	ld	hl,0fcc1h
	add	hl,de
	ld	a,(hl)
	pop	hl
	add	a,c
	ld	(rdSlot + 1),a
	ld	a,255
	ld	(ramSlot),a
	push	bc
	call	rdSlot
	pop	bc
	ld	a,(ramSlot)
	cp	255
	ret	nz
	inc	c
	ld	a,c
	cp	16
	jr	nz,testLp
	ld	a,(ramSlot)
	ret
rdSlot:	ld	a,0
	push	af
	call	0ch
	cpl
	ld	e,a
	pop	af
	push	af
	call	14h
	pop	af
	push	af
	push	de
	call	0ch
	pop	de
	xor	e
	jr	z,ramFound
	pop	af
	ei
	ret
ramFound:	pop	af
	ld	(ramSlot),a
	ei
	ret

ramSlot:	db	0

mvCode:	ld	h,40h
	ld	a,(ramSlot)
	call	24h
	ld	bc,init - start - ldrMov
	ld	de,4000h
	ld	hl,start + ldrMov
	ldir
	call	rcInit
	ld	h,40h
	ld	a,(0fcc1h)
	call	24h
	ei
einde:	ret

	end		; ET21BIN.ASM
