	org	&h100
;
; Check if there is a RAM drive
;
; (c) BiFi'96
;
	jp	start
	db	"CHKRMDRV V1.0 - (c) BiFi'96",26
;
; Start of actual coding
;
start:	ld	bc,&hff68	; Is there a RAM-disk?
	call	5
	ld	a,b
	and	a	; = 0 when no RAM-disk
	jr	z,noRamDisk

exit:	ld	b,a
	ld	c,&h62
	call	5

noRamDisk:	ld	hl,&h80	; Check length of parameter
	ld	b,(hl)
	inc	hl
	inc	b	; No size given... Default of 128KB
	dec	b
	ex	de,hl	; Pointer to ASCII-Size in DE
	ld	hl,16	; 16K size
	jr	z,size128

goToNum:	ld	a,(de)
	cp	"0"	; Ignore previous characters
	jr	c,nxtChar
	cp	"9"+1
	jr	nc,nxtChar
	ld	hl,0
	jr	dbLp

nxtChar:	inc	de
	jr	goToNum

dbLp:	ld	a,(de)
	sub	"0"
	jr	c,adjustSize
	cp	10
	jr	nc,adjustSize
	ld	b,h
	ld	c,l
	add	hl,hl
	add	hl,hl
	add	hl,bc
	add	hl,hl
	ld	c,a
	ld	b,0
	add	hl,bc
	inc	de
	jr	dbLp

adjustSize:	ld	a,l	; Round to blocks of 16 KBytes
	and	15	; Is this mask empty?
	jr	z,size128	; Then it's a nice 16 KBytes like size
	ld	a,l
	or	15	; Fill lower nibble of L
	ld	l,a
	inc	hl	; Increase to 16 KBytes like size

size128:	dec	hl	; Convert size to number of 16K blocks
	srl	h
	rr	l
	srl	h
	rr	l
	srl	h
	rr	l
	srl	h
	rr	l
	inc	l

	ld	b,l	; Create new RAM disk
	ld	c,&h68
	call	5
	jr	exit
