	org	&h100
;
; Check if the A: drive contains a disk
;
; (c) BiFi'96
;
	jp	start
	db	"CHKDRIVE V1.1 - (c) BiFi'96",26
;
; Write character to Keyboard-buffer
;
; Written by: Albert Beevendorp (07-08-1994)
;
; In : A  = Code to write to the buffer
; Out: Z-flag set when the buffer is full
; Chg: PUTPNT, AF
;
wrtBuf:	push	hl
	ld	hl,(&hf3f8)
	ld	(hl),a
	call	endBuf
	push	de
	ld	de,(&hf3fa)
	call	dCompR
	pop	de
	ld	(&hf3f8),hl
	pop	hl
	ret
;
; See if the pointer has reached the end of the buffer
;
endBuf:	inc	hl
	ld	a,l
	cp	&h18
	ret	nz
	ld	hl,&hfbf0
	ret
;
; See if the pointers are equal
;
; Z-Flag set when equal
;
dCompR:	ld	a,h
	sub	d
	ret	nz
	ld	a,l
	sub	e
	ret
;
; Start of actual coding
;
start:	xor	a	; Read from drive A:
	ld	bc,&h1f8	; Read 1 sector from a 1DD disk
	ld	de,0	; Read sector 0
	ld	hl,secBuf
	ld	ix,&h4010	; DSKIO routine in Disk-ROM
	ld	iy,(&hfb21)
	call	&h1c
	jr	c,noDisk	; C-flag set when error
;
yesDisk:	call	toBuf	; Current codes to KB-buffer
	db	"%SRAMD%\CONT"	; Resume with this batch-file
	db	13,0
	ei		; Restart interrupts
	ret
;
noDisk:	call	toBuf	; Current codes to KB-buffer
	db	"BASIC",13,0	; Go to Basic through COMMAND2.COM
	ei		; Restart interrupts
	ret
;
toBuf:	ex	(sp),hl
toBufLoop:	ld	a,(hl)	; Get from the list
	inc	hl
	and	a
	jr	z,toBufEnd
	call	wrtBuf
	jr	toBufLoop
;
toBufEnd:	ex	(sp),hl
	ret
;
secBuf	equ	$
