#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "allegro.h"
#include "tipos.h"
#include "vdp.h"

byte *tabprecalc;
word *tabprecalc16;
byte colisao[256];
unsigned long *tabprecalc32;
unsigned long *tabprecalc32b;

extern BITMAP *minha_tela;

VDP::VDP()
{
  int loop;
  byte temp;
  vdpwaitingdata=0;
  vram=(byte*)malloc(16384);
  if(vram==0) exit(0);
  tabprecalc=(byte *)malloc(512*1024);
  tabprecalc16=(word *)tabprecalc;
  tabprecalc32=(unsigned long *)tabprecalc;
  tabprecalc32b=(unsigned long *)tabprecalc+2;
  memset(tabprecalc, 0 ,512*1024);
  for(loop=0;loop<512*1024;loop+=8)
  {
    byte corfrente,corfundo;
    corfrente=(loop>>11)>>4;
    corfundo=(loop>>11)&0xf;
    temp=(loop>>3)&0xff;
    tabprecalc[loop]=((temp&0x80)?corfrente:corfundo);
    tabprecalc[loop+1]=((temp&0x40)?corfrente:corfundo);
    tabprecalc[loop+2]=((temp&0x20)?corfrente:corfundo);
    tabprecalc[loop+3]=((temp&0x10)?corfrente:corfundo);
    tabprecalc[loop+4]=((temp&0x08)?corfrente:corfundo);
    tabprecalc[loop+5]=((temp&0x04)?corfrente:corfundo);
    tabprecalc[loop+6]=((temp&0x02)?corfrente:corfundo);
    tabprecalc[loop+7]=((temp&0x01)?corfrente:corfundo);
  }
}

VDP::~VDP()
{
  int i,j;
  free(vram);
/*  for(j=0;j<1024;j++)
  {
    printf("\n(%d,%d)%d:",j/(256*16),j/256,j%256);
    for(i=0;i<8;i++)
      printf("%d,",tabprecalc[i+j*8]);
  }*/
  free(tabprecalc);
}

int VDP::in99()
{
  byte aux;
  aux=status;
  if (status&0x80)
  {
    status&=0x1f;
    return aux;
  }
  return status;
}
void VDP::setFrame(bool n)
{
  frame=n;
  montaStatus();
}

void VDP::montaStatus()
{
  status=(frame<<8)|(f5sprite<<7)|(spriteCoincidence<<6)|fifthSprite;
}

int VDP::in98()
{
  int aux;
  if (vdpmode==VDPREAD)
  {
    aux=vdpdata;
    vramPtr=(vramPtr+1)&0x3fff;
    vdpdata=vram[vramPtr];
    return aux;
  }
  else
  {
    aux=vdpdata;
    vdpdata=vram[vramPtr];
    vramPtr=(vramPtr+1)&0x3fff;
    return aux;
  }
}

void VDP::out98(byte dado)
{
  if (vdpmode==VDPWRITE)
  {
    vram[vramPtr]=dado;
    vdpdata=dado;
    vramPtr++;
    vramPtr&=0x3fff;
  }
  else
  {
	  vdpdata=dado;
	  vramPtr++;
	  vramPtr&=0x3fff;
	  vram[vramPtr]=dado;
  }
}


void VDP::out99(byte dado)
{
  static int temp=0;
  static int flag=0;
// puts("\t\t\tout99");

  if (vdpwaitingdata==0) {
	  temp=dado;
	  vdpwaitingdata=1;
	  return;
  }
  vdpwaitingdata=0;
  if ((dado&0xc0)==0) {
    vramPtr=temp+256*(dado&0x3f);
    vdpmode=VDPREAD;
//    printf("\t\tVram:Leitura:%x\n",vramPtr);
    vdpdata=vram[vramPtr];
  }
  if ((dado&0xc0)==0x40) {
    vramPtr=temp+256*(dado&0x3f);
    vdpmode=VDPWRITE;
//    printf("\t\tVram:Escrita:%x\n",vramPtr);
  }
  if ((dado&0xc0)==0x80) {
                    //Registrador de modo do VDP
//     printf("\t\tVDP:Reg:%d=%x\n",dado&0x0f,temp);
    setReg(dado&0x0f, temp);
  }
}
int VDP::getVram(int r)
{
  return vram[r];
}
void VDP::setVram(int r, int v)
{
  vram[r]=(byte)v;
}

int VDP::getReg(int r)
{
  return reg[r];
}
void VDP::setReg(int r, int v)
{
  reg[r]=v;
  switch (r)
  {
      case 0:
	calc_screen();
	nameTable=(reg[2]&0xf)<<10;
	colorTable=(reg[3]<<6);
	patternTable=(reg[4]&0x7)<<11;
	if (screen==2) {
		colorTable&=0x2000; patternTable&=0x2000;
		colorMask=(reg[3]<<6)|63; patternMask=(reg[3]<<6)|63;
	}
	break;
      case 1:
	calc_screen();
	nameTable=(reg[2]&0xf)<<10;
	colorTable=(reg[3]<<6);
	patternTable=(reg[4]&0x7)<<11;
	if (screen==2) {colorTable&=0x2000; patternTable&=0x2000;
		colorMask=(reg[3]<<6)|63; patternMask=(reg[3]<<6)|63;
	}
	break;
      case 2:
	nameTable=(v&0xf)<<10;
	break;
      case 3:
	colorTable=(v<<6);
	if (screen==2) {colorTable=(colorTable&0x2000);
		colorMask=(reg[3]<<6)|63; patternMask=(reg[3]<<6)|63;
	}
	break;
      case 4:
	patternTable=(v&0x7)<<11;
	if (screen==2) patternTable=(patternTable&0x2000);
		
	break;
      case 5:
	spriteAttributeTable=(v&0x7f)<<7;
	break;
      case 6:
	spritePatternTable=(v&7)<<11;
	break;
      case 7:
	backColor=v&0xf;
	frontColor=v>>4;
  }
}

int VDP::calc_screen()
{
  if ((reg[0]&2)==0 && (reg[1]&24)==8){return screen=3;}
  if ((reg[0]&2)==2 && (reg[1]&24)==0){return screen=2;}
  if ((reg[0]&2)==0 && (reg[1]&24)==0){return screen=1;}
  if ((reg[0]&2)==0 && (reg[1]&24)==16){return screen=0;}
}

void VDP::linescreen(byte line)
{
}

void VDP::linesprites(byte line)
{
  if((reg[1]&3)==0)linesprites8p(line);
  else if((reg[1]&3)==1)linesprites8g(line);
  else if((reg[1]&3)==2)linesprites16p(line);
  else linesprites16g(line);
}

void VDP::linesprites8p(byte line)
{
  int i,x,t;
  int img1;
  int activeline;
  int posx,cor;
  int linhay;
  int spritecnt;
  int aux,dif;
  byte *scr, *scr2;
  unsigned long *c;
  c=(unsigned long *) colisao;
  for(i=0;i<64;i++)
    c[i]=0;
  scr=minha_tela->line[line]+13;
  line=line-27;
  spritecnt=0;
  for (t=0;t<=31; t++)
  {
    int outro;
    aux=spriteAttributeTable+(t<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    if (linhay==208) {t--;if(t<0)t=0;break;}
    dif=line-linhay-1;
    if(dif<=7 && dif>=0)
    {
      spritecnt++;
      if (spritecnt==4) {outro=t;}
      if (spritecnt==5) {status|=0x40;status|=t;t=outro;break;}
    }
  }
  for (i=t;i>=0; i--)
  {
    aux=spriteAttributeTable+(i<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    dif=line-linhay-1;
    if(dif<=7 && dif>=0)
    {
      posx=vram[aux+1]-(vram[aux+3]&0x80?32:0);
      cor=vram[aux+3]&0x0f;
      scr2=scr+posx;
      img1=vram[spritePatternTable+((vram[aux+2])<<3)+dif];
      for(x=0;x<8;x++)
      {
        if ((img1&0x80)==0x80 && posx+x>=0 && posx+x<=255)
        {
          if(colisao[posx+(x<<1)]) status|=32; else colisao[posx+(x<<1)]=1;
          if(cor)*scr2++=cor;
        }
        else scr2++;
        img1<<=1;
      }
    }
  }
}
void VDP::linesprites8g(byte line)
{
  int i,x,t;
  int img1;
  int posx,cor;
  int activeline;
  int spritecnt;
  int linhay;
  int aux,dif;
  byte *scr, *scr2;
  unsigned long *c;
  c=(unsigned long *) colisao;
  for(i=0;i<64;i++)
    c[i]=0;
  scr=minha_tela->line[line]+13;
  line=line-27;
  spritecnt=0;
  for (t=0;t<=31; t++)
  {
    int outro;
    aux=spriteAttributeTable+(t<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    if (linhay==208) {t--;if(t<0)t=0;break;}
    dif=line-linhay-1;
    if(dif<=15 && dif>=0)
    {
      spritecnt++;
      if (spritecnt==4) {outro=t;}
      if (spritecnt==5) {status|=0x40;status|=t;t=outro;break;}
    }
  }
  for (i=t;i>=0; i--)
  {
    aux=spriteAttributeTable+(i<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    dif=line-linhay-1;
    if(dif<=15 && dif>=0)
    {
      posx=vram[aux+1]-(vram[aux+3]&0x80?32:0);
      cor=vram[aux+3]&0x0f;
      scr2=scr+posx;
      img1=vram[spritePatternTable+((vram[aux+2])<<3)+(dif>>1)];
      for(x=0;x<8;x++)
      {
        if ((img1&0x80)==0x80 && posx+(x<<1)>=-1 && posx+(x<<1)<=255)
        {
          if(colisao[posx+(x<<1)]) status|=32; else colisao[posx+(x<<1)]=1;
          if(colisao[posx+(x<<1)+1]) status|=32; else colisao[posx+(x<<1)+1]=1;
          if(cor)
          {
            *scr2++=cor;
            *scr2++=cor;
          }
        }
        else scr2+=2;
        img1<<=1;
      }
    }
  }
}

void VDP::linesprites16p(byte line)
{
  int i,x,t;
  int img1, img2;
  int posx,cor;
  int activeline;
  int spritecnt;
  int aux,dif;
  int linhay;
  byte *scr, *scr2;
  unsigned long *c;
  c=(unsigned long *) colisao;
  for(i=0;i<64;i++)
    c[i]=0;
  scr=minha_tela->line[line]+13;
  line=line-27;
  spritecnt=0;
  for (t=0;t<=31; t++)
  {
    int outro;
    aux=spriteAttributeTable+(t<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    if (linhay==208) {t--;if(t<0)t=0;break;}
    dif=line-linhay-1;
    if(dif<=15 && dif>=0)
    {
      spritecnt++;
      if (spritecnt==4) {outro=t;}
      if (spritecnt==5) {status|=0x40;status|=t;t=outro;break;}
    }
  }
  for (i=t;i>=0; i--)
  {
    aux=spriteAttributeTable+(i<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    dif=line-linhay-1;
    if(dif<=15 && dif>=0)
    {
      posx=vram[aux+1]-(vram[aux+3]&0x80?32:0);
      cor=vram[aux+3]&0x0f;
      scr2=scr+posx;
      img1=vram[spritePatternTable+((vram[aux+2]&0xfc)<<3)+dif];
      img2=vram[spritePatternTable+((vram[aux+2]&0xfc)<<3)+dif+16];
      for(x=0;x<8;x++)
      {
        if ((img1&0x80)==0x80 && posx+x>=0 && posx+x<=255)
        {
          if(colisao[posx+x]) status|=32; else colisao[posx+x]=1;
          if(cor)*scr2++=cor;
        }
        else scr2++;
        img1<<=1;
      }
      for(x=0;x<8;x++)
      {
        if ((img2&0x80)==0x80 && posx+x+8>=0 && posx+x+8<=255)
        {
          if(colisao[posx+x+8]) status|=32; else colisao[posx+x+8]=1;
          if(cor)*scr2++=cor;
        }
        else scr2++;
        img2<<=1;
      }
    }
  }
}
void VDP::linesprites16g(byte line)
{
  int i,x,t;
  int img1, img2;
  int posx,cor;
  int spritecnt;
  int activeline;
  int aux,dif;
  int linhay;
  byte *scr, *scr2;
  unsigned long *c;
  c=(unsigned long *) colisao;
  for(i=0;i<64;i++)
    c[i]=0;
  scr=minha_tela->line[line]+13;
  line=line-27;
  spritecnt=0;
  for (t=0;t<=31; t++)
  {
    int outro;
    aux=spriteAttributeTable+(t<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    if (linhay==208) {t--;if(t<0)t=0;break;}
    dif=line-linhay-1;
    if(dif<=31 && dif>=0)
    {
      spritecnt++;
      if (spritecnt==4) {outro=t;}
      if (spritecnt==5) {status|=0x40;status|=t;t=outro;break;}
    }
  }
  for (i=t;i>=0; i--)
  {
    aux=spriteAttributeTable+(i<<2);
    linhay=vram[aux];
    if (linhay>220) linhay=linhay-256;
    dif=line-linhay-1;
    if(dif<=31 && dif>=0)
    {
      posx=vram[aux+1]-(vram[aux+3]&0x80?32:0);
      cor=vram[aux+3]&0x0f;
      scr2=scr+posx;
      img1=vram[spritePatternTable+((vram[aux+2]&0xfc)<<3)+(dif>>1)];
      img2=vram[spritePatternTable+((vram[aux+2]&0xfc)<<3)+(dif>>1)+16];
      for(x=0;x<8;x++)
      {
        if ((img1&0x80)==0x80 && posx+(x<<1)>=-1 && posx+(x<<1)<=255)
        {
          if(colisao[posx+(x<<1)]) status|=32; else colisao[posx+(x<<1)]=1;
          if(colisao[posx+(x<<1)+1]) status|=32; else colisao[posx+(x<<1)+1]=1;
          if(cor)
          {
            *scr2++=cor;
            *scr2++=cor;
          }
        }
        else scr2+=2;
        img1<<=1;
      }
      for(x=0;x<8;x++)
      {
        if ((img2&0x80)==0x80 && posx+(x<<1)+16>=-1 && posx+(x<<1)+16<=255)
        {
          if(colisao[posx+16+(x<<1)]) status|=32; else colisao[posx+16+(x<<1)]=1;
          if(colisao[posx+16+(x<<1)+1]) status|=32; else colisao[posx+16+(x<<1)+1]=1;
          if(cor)
          {
            *scr2++=cor;
            *scr2++=cor;
          }
        }
        else scr2+=2;
        img2<<=1;
      }
    }
  }
}

void VDP::linescreen0(int line)
{
  int activeline;
  word *scr16, *pre16;
  unsigned long *scr;
  byte *scr8, *pre8;
  byte i;
  int caracter, desenho;
  int basevram, basevram2;
  activeline=line-27;
  scr16=(word *)minha_tela->line[line];
  scr=(unsigned long *) scr16;
  scr8=(byte *)scr16;
  pre16=tabprecalc16+(reg[7]<<10);
  pre8=tabprecalc+(reg[7]<<11);
  basevram=nameTable+((activeline>>3)*40);
  basevram2=patternTable+(activeline%8);
  if (reg[1]&0x40 && activeline>=0 && activeline<=191)
  {
    for(i=0; i<19; i++)
    {
      *scr8++=*(pre8);
    }
    scr16=(word *)scr8;
    for(i=0; i<40; i++)
    {
      caracter= vram[basevram+i];
      desenho = vram[basevram2+(caracter<<3)];
      *scr16++=*(pre16+(desenho<<2));
      *scr16++=*(pre16+(desenho<<2)+1);
      *scr16++=*(pre16+(desenho<<2)+2);
    }
    scr8=(byte *)scr16;
    for(i=0; i<25; i++)
    {
      *scr8++=*(pre8);
    }
  }
  else
  {
    for(i=0;i<71;i++)
    {
      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
//      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
    }
  }
}

void VDP::linescreen1(int line)
{
  unsigned long *scr;
  byte *scr8;
  byte i, cor;
  int activeline;
  int caracter, desenho;
  int basevram, basevram2;
  scr=(unsigned long *)minha_tela->line[line];
  scr8=(byte *) scr;
  activeline=line-27;
  basevram=nameTable+((activeline>>3)*32);
  basevram2=patternTable+(activeline%8);
  if(reg[1]&0x40 && activeline>=0 && activeline<=191)
  {
    scr=(unsigned long *)&scr8[13];
    for(i=0; i<32; i++)
    {
      caracter= vram[basevram+i];
      desenho = vram[basevram2+(caracter<<3)];
      cor     = vram[colorTable+(caracter>>3)];
      if((cor&0x0f)==0)cor|=(reg[7]&0x0f);
      if((cor&0xf0)==0)cor|=((reg[7]&0x0f)<<4);
      *scr++=*(tabprecalc32+(cor<<9)+(desenho<<1));
      *scr++=*(tabprecalc32+(cor<<9)+(desenho<<1)+1);
    }
    linesprites(line);
    for(i=0; i<13; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
    scr8+=256;
    for(i=0; i<15; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
  }
  else
    for(i=0;i<71;i++)
    {
      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
//      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
    }
}

void VDP::linescreen2(int line)
{
  unsigned long *scr;
  byte *scr8;
  byte i, cor;
  int activeline;
  int caracter, desenho;
  int basevram, basevram2, basevram3;
  scr=(unsigned long *)minha_tela->line[line];
  activeline=line-27;
  scr8=(byte *)scr;
  basevram=nameTable+((activeline>>3)*32);
  basevram2=patternTable+(activeline%8)+(((activeline>>6)<<11)&patternMask);
  basevram3=colorTable+(activeline%8)+(((activeline>>6)<<11)&colorMask);
  if (reg[1]&0x40 && activeline>=0 && activeline<=191)
  {
    scr=(unsigned long *)&(scr8[13]);
    for(i=0; i<32; i++)
    {
      caracter= vram[basevram+i];
      desenho = vram[basevram2+(caracter<<3)];
      cor     = vram[basevram3+(caracter<<3)];
      if((cor&0x0f)==0)cor|=(reg[7]&0x0f);
      if((cor&0xf0)==0)cor|=((reg[7]&0x0f)<<4);
      *scr++=*(tabprecalc32+(cor<<9)+(desenho<<1));
      *scr++=*(tabprecalc32+(cor<<9)+(desenho<<1)+1);
    }
    linesprites(line);
    for(i=0; i<13; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
    scr8+=256;
    for(i=0; i<15; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
  }
  else
    for(i=0;i<71;i++)
    {
      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
//      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
    }
}
void VDP::linescreen3(int line)
{
  unsigned long *scr;
  byte i, cor;
  int activeline;
  byte *scr8;
  int caracter, desenho;
  int basevram, basevram2, basevram3;
  scr=(unsigned long *)minha_tela->line[line];
  activeline=line-27;
  scr8=(byte *)scr;
  basevram=nameTable+((activeline>>3)*32);
  basevram2=patternTable;
  if (reg[1]&0x40 && activeline>=0 && activeline<=191)
  {
    scr=(unsigned long *)&scr8[13];
    for(i=0; i<32; i++)
    {
      caracter= vram[basevram+i];
      cor     = vram[basevram2+(caracter<<3)+(((activeline/8)*2)%8)+(activeline/4)%2];
      if((cor&0x0f)==0)cor|=(reg[7]&0x0f);
      if((cor&0xf0)==0)cor|=((reg[7]&0x0f)<<4);
      *scr++=*(tabprecalc32+(cor<<9)+(0x1fe));
      *scr++=*(tabprecalc32+(cor<<9)+(0));
    }
    linesprites(line);
    for(i=0; i<13; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
    scr8+=256;
    for(i=0; i<15; i++)
    {
      *scr8++=*(tabprecalc+((reg[7]&0x0f)<<11));
    }
  }
  else
    for(i=0;i<71;i++)
    {
      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
//      *scr++=*(tabprecalc32+((reg[7]&0x0f)<<9));
    }
}


