%{

/* RBC version 1.4 */
/* by Ricardo Bittencourt */

#define RBC_VERSION "1.4"

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <malloc.h>
#include "rbcc.h"

argument_t *local_args=NULL;
int local_jumps=0;
char actual_function[MAX_STRING];
extern int line_number;

%}

%union {
  char strval[MAX_STRING];
  lvalue_t *lval;
  code_t *code;
  argument_t *argument;
  lvalue_list_t *lval_list;
  function_name_t *funcname;
  type_t *typeval;
  int number;
}

%token TOK_INT
%token TOK_DOUBLE
%token TOK_CHAR
%token TOK_OPEN
%token TOK_CLOSE
%token TOK_OPEN_SCOPE
%token TOK_CLOSE_SCOPE
%token TOK_END
%token TOK_COMMA
%token TOK_VOID
%token TOK_PLUS
%token TOK_EQUAL2
%token TOK_EQUAL
%token TOK_IF
%token TOK_NOTEQUAL
%token TOK_WHILE
%token TOK_TIMES
%token TOK_LT
%token TOK_LET
%token TOK_GT
%token TOK_MINUS
%token TOK_RETURN
%token TOK_DIV
%token TOK_PLUS2
%token TOK_FOR
%token TOK_DO
%token TOK_MINUS2
%token TOK_TIMESEQ
%token TOK_MODEQ
%token TOK_DIVEQ
%token TOK_NOT
%token TOK_QUESTION
%token TOK_DOT2
%token TOK_OPEN_ARRAY
%token TOK_CLOSE_ARRAY
%token TOK_PLUSEQ
%token TOK_MINUSEQ
%token TOK_SHL
%token TOK_SHR
%token TOK_BINARYAND
%token <number> TOK_NUMBER
%token <strval> TOK_ID
%token <strval> TOK_STRING

%type <lval> lvalue
%type <lval> lvalue_direct
%type <lval> rvalue
%type <lval> oprval
%type <code> command
%type <code> command_list
%type <code> scope
%type <code> scopeend
%type <code> funcscope
%type <code> action
%type <code> returncom
%type <argument> args
%type <argument> args_list
%type <funcname> function_name
%type <typeval> type
%type <typeval> ovardecl
%type <lval_list> rvalue_list

%right TOK_EQUAL TOK_TIMESEQ TOK_MODEQ TOK_DIVEQ TOK_PLUSEQ TOK_MINUSEQ
%right TOK_QUESTION TOK_DOT2
%left TOK_BINARYAND
%left TOK_EQUAL2 TOK_NOTEQUAL
%left TOK_LT TOK_GT TOK_LET
%left TOK_SHL TOK_SHR
%left TOK_PLUS TOK_MINUS
%left TOK_TIMES TOK_DIV TOK_MOD
%left TOK_PLUS2 TOK_MINUS2 TOK_NOT
%right CAST

%%

program: 
  source {
    fprintf (yyout,"comment 'Code generated by RBC %s'\n",RBC_VERSION);
    fprintf (yyout,"comment 'Copyright 1996,97 by Ricardo Bittencourt'\n\n");
    flush_externs ();
    fprintf (yyout,"\nstartup \n\n");
    flush_strings ();
    flush_variables ();
    flush_functions ();
    fprintf (yyout,"\nendcode \n\n");
  }
  ;

source: 
  | source function 
  | source prototype
  | source vardecl
  ;

vardecl:
  ovardecl TOK_END {
  }
  ;

ovardecl:
  type TOK_ID {
    $1->string=0;
    add_global ($1,$2,0);
    $$=$1;
  }
  | type TOK_ID TOK_EQUAL rvalue {
    if ($4->type->type!=NUMBER_ID && !$4->type->string) 
      yyerror ("cannot initialize global with non-constant value");
    $1->string=$4->type->string;
    add_global ($1,$2,$4->value);
    $$=$1;
  }
  /*| type TOK_ID TOK_EQUAL TOK_STRING {
    if ($1->type!=POINTER_ID && $1->pointed->type!=CHAR_ID) 
      yyerror ("wrong type in initialization");
    $1->string=1;
    add_global ($1,$2,add_string ($4));
    $$=$1;
  }*/
  | ovardecl TOK_COMMA TOK_ID {
    add_global ($1,$3,0);
    $1->string=0;
    $$=$1;
  }
  ;

function_name:
  TOK_ID {
    $$=(function_name_t *) malloc (sizeof (function_name_t));
    $$->name=(char *) malloc (strlen ($1)+1);
    strcpy ($$->name,$1);
    $$->type=(type_t *) malloc (sizeof (type_t));
    $$->type->type=INT_ID;
  }
  | type TOK_ID {
    $$=(function_name_t *) malloc (sizeof (function_name_t));
    $$->name=(char *) malloc (strlen ($2)+1);
    strcpy ($$->name,$2);
    $$->type=(type_t *) malloc (sizeof (type_t));
    $$->type=$1;
  }
  ;

function: 
  function_name args {
    local_args=$2;
    local_jumps=0;
    strcpy (actual_function,$1->name);
    add_function ($1->name,$1->type,NULL,$2);
  } funcscope {
    code_t *code;

    code=append_line ("enter \n",NULL);
    code=append_code ($4,code);
    add_function ($1->name,$1->type,code,$2);
  }
  ;

prototype:
  function_name args TOK_END {
    add_function ($1->name,$1->type,NULL,$2);
  }
  ;

args: 
  TOK_OPEN TOK_CLOSE {
    $$=NULL;
  }
  | TOK_OPEN TOK_VOID TOK_CLOSE {
    $$=NULL;
  }
  | args_list TOK_CLOSE {
    $$=$1;
  }
  ;

args_list: 
  TOK_OPEN type TOK_ID {
    $$=(argument_t *) malloc (sizeof (argument_t));
    $$->type=$2;
    $$->name=(char *) malloc (strlen ($3)+1);
    strcpy ($$->name,$3);
    $$->offset=(char *) malloc (3*sizeof (char));
    switch ($2->type) {
      case CHAR_ID:
        strcpy ($$->offset,"c#");
        break;
      case INT_ID:
        strcpy ($$->offset,"i#");
        break;
      case POINTER_ID:
        strcpy ($$->offset,"p#");
        break;
      default:
        yyerror ("type not implemented");
        break;
    }
    $$->next=NULL;
  }
  | args_list TOK_COMMA type TOK_ID {
    argument_t *p=$1;
    char old[2];

    $$=(argument_t *) malloc (sizeof (argument_t));
    $$->type=$3;
    $$->name=(char *) malloc (strlen ($4)+1);
    strcpy ($$->name,$4);
    $$->offset=(char *) malloc (strlen ($1->offset)+2);
    switch ($3->type) {
      case CHAR_ID:
        strcpy ($$->offset,"c#");
        break;
      case INT_ID:
        strcpy ($$->offset,"i#");
        break;
      case POINTER_ID:
        strcpy ($$->offset,"p#");
        break;
      default:
        yyerror ("type not implemented");
        break;
    }
    strcat ($$->offset,$1->offset+2);
    old[0]=$1->offset[0];
    old[1]=0;
    strcat ($$->offset,old);
    $$->next=$1;
  }
  ;

type:
  TOK_INT {
    $$=(type_t *) malloc (sizeof (type_t));
    $$->type=INT_ID;
  }
  | TOK_DOUBLE {
    $$=(type_t *) malloc (sizeof (type_t));
    $$->type=DOUBLE_ID;
  }
  | TOK_VOID {
    $$=(type_t *) malloc (sizeof (type_t));
    $$->type=VOID_ID;
  }
  | TOK_CHAR {
    $$=(type_t *) malloc (sizeof (type_t));
    $$->type=CHAR_ID;
  }
  | type TOK_TIMES {
    $$=(type_t *) malloc (sizeof (type_t));
    $$->type=POINTER_ID;
    $$->pointed=$1;
  }
  ;

action:
  scope {
    $$=$1;
  }
  | command {
    $$=$1;
  }
  | returncom {
    $$=$1;
  }
  ;

scope: 
  TOK_OPEN_SCOPE TOK_CLOSE_SCOPE {
    $$=NULL;
  }
  | TOK_OPEN_SCOPE command_list TOK_CLOSE_SCOPE {
    $$=append_code ($2,NULL);
  }
  ;

funcscope: 
  TOK_OPEN_SCOPE scopeend {
    $$=$2;
  }
  | TOK_OPEN_SCOPE command_list scopeend {
    $$=append_code ($2,NULL);
    $$=append_code ($3,$$);
  }
  ;

scopeend:
  TOK_CLOSE_SCOPE {
    $$=append_line ("exit \n",NULL);
  }
  | returncom TOK_CLOSE_SCOPE {
    $$=$1;
  }
  ;

command_list:
  command {
    $$=$1;
  }
  | command_list command {
    $$=append_code ($2,$1);
  }
  ;

command:
  rvalue TOK_END {
    $$=append_line ("@begin \n",NULL);
    $$=append_code ($1->code,$$);
    $$=append_line ("@end \n",$$);
  }
  | TOK_IF TOK_OPEN rvalue TOK_CLOSE action {
    char str[MAX_STRING];
    
    switch ($3->type->type) {
      case NUMBER_ID:
        if ($3->value) 
          $$=append_code ($5,NULL);
        else
          $$=NULL;
        break;
      case CHAR_ID:
        $$=append_code ($3->code,NULL);
        sprintf (str,"jpzc  _%s%d\n",actual_function,local_jumps);
        $$=append_line (str,$$);
        $$=append_code ($5,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        $$=append_line (str,$$);
        break;
      case INT_ID:
        $$=append_code ($3->code,NULL);
        sprintf (str,"jpzi  _%s%d\n",actual_function,local_jumps);
        $$=append_line (str,$$);
        $$=append_code ($5,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        $$=append_line (str,$$);
        break;
    }
  }
  | TOK_WHILE TOK_OPEN rvalue TOK_CLOSE action {
    char str[MAX_STRING];

    switch ($3->type->type) {
      case NUMBER_ID:
        if ($3->value) {
          sprintf (str,"label _%s%d\n",actual_function,local_jumps);
          $$=append_line (str,$$);
          $$=append_code ($5,$$);
          sprintf (str,"jp _%s%d \n",actual_function,local_jumps++);
          $$=append_line (str,$$);
        }
        else
          $$=NULL;
        break;
      case CHAR_ID:
        sprintf (str,"label _%s%d\n",actual_function,local_jumps);
        $$=append_line (str,NULL);
        $$=append_code ($3->code,$$);
        sprintf (str,"jpnzc _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+2);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        $$=append_code ($5,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps+2);
        $$=append_line (str,$$);
        local_jumps+=3;
        break;
      case INT_ID:
        sprintf (str,"label _%s%d\n",actual_function,local_jumps);
        $$=append_line (str,NULL);
        $$=append_code ($3->code,$$);
        sprintf (str,"jpnzi _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+2);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        $$=append_code ($5,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps+2);
        $$=append_line (str,$$);
        local_jumps+=3;
        break;
    }
  }
  | TOK_FOR TOK_OPEN oprval TOK_END oprval TOK_END oprval TOK_CLOSE action {
    char str[MAX_STRING];
    code_t *code;

    switch ($5->type->type) {
      case NUMBER_ID:
        if ($5->value) {
          code=NULL;
          if ($3!=NULL) 
            code=append_code ($3->code,code);
          sprintf (str,"label _%s%d \n",actual_function,local_jumps);      
          code=append_line (str,code);
          code=append_code ($9,code);
          if ($7!=NULL) 
            code=append_code ($7->code,code);
          sprintf (str,"jp _%s%d \n",actual_function,local_jumps++);
        }
        else {
          code=NULL;
          if ($3!=NULL) 
            code=append_code ($3->code,code);
        }
        $$=code;
        break;
      case CHAR_ID:
        code=NULL;
        if ($3!=NULL) 
          code=append_code ($3->code,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps);      
        code=append_line (str,code);
        if ($5!=NULL)
          code=append_code ($5->code,code);
        sprintf (str,"jpnzc _%s%d \n",actual_function,local_jumps+1);
        code=append_line (str,code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+2);
        code=append_line (str,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+1);
        code=append_line (str,code);
        code=append_code ($9,code);
        if ($7!=NULL) 
          code=append_code ($7->code,code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        code=append_line (str,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+2);
        code=append_line (str,code);
        local_jumps+=3;
        $$=code;       
        break;
      case INT_ID:
        code=NULL;
        if ($3!=NULL) 
          code=append_code ($3->code,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps);      
        code=append_line (str,code);
        if ($5!=NULL)
          code=append_code ($5->code,code);
        sprintf (str,"jpnzi _%s%d \n",actual_function,local_jumps+1);
        code=append_line (str,code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+2);
        code=append_line (str,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+1);
        code=append_line (str,code);
        code=append_code ($9,code);
        if ($7!=NULL) 
          code=append_code ($7->code,code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        code=append_line (str,code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+2);
        code=append_line (str,code);
        local_jumps+=3;
        $$=code;       
        break;
    }
  }
  | TOK_DO action TOK_WHILE TOK_OPEN rvalue TOK_CLOSE TOK_END {
    char str[MAX_STRING];
    
    switch ($5->type->type) {
      case NUMBER_ID:
        if ($5->value) {
          sprintf (str,"label _%s%d \n",actual_function,local_jumps);
          $$=append_line (str,NULL);
          $$=append_code ($2,$$);
          sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
          $$=append_line (str,$$);
        }
        else 
          $$=append_code ($2,NULL);
        break;
      case CHAR_ID:
        sprintf (str,"label _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,NULL);
        $$=append_code ($2,$$);
        $$=append_code ($5->code,$$);
        sprintf (str,"jpzc _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        local_jumps+=2;
        break;
      case INT_ID:
        sprintf (str,"label _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,NULL);
        $$=append_code ($2,$$);
        $$=append_code ($5->code,$$);
        sprintf (str,"jpzi _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps);
        $$=append_line (str,$$);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps+1);
        $$=append_line (str,$$);
        local_jumps+=2;
        break;
    }
  }
  ;

oprval:
  {
    $$=NULL;
  }
  | rvalue {
    $$=$1;
  }
  ;

returncom:
  TOK_RETURN TOK_END {
    $$=append_line ("exit \n",$$);
  }
  | TOK_RETURN rvalue TOK_END {
    force_cast (function_type (actual_function),$2);
    $$=append_code ($2->code,NULL);
    $$=append_line ("exit \n",$$);
  }
  ;

rvalue_list: 
  rvalue {
    $$=(lvalue_list_t *) malloc (sizeof (lvalue_list_t));
    $$->lvalue=$1;
    $$->next=NULL;
  }
  | rvalue_list TOK_COMMA rvalue {
    $$=(lvalue_list_t *) malloc (sizeof (lvalue_list_t));
    $$->lvalue=$3;
    $$->next=$1;
  }
  ;

rvalue:
  lvalue TOK_OPEN TOK_CLOSE {
    lvalue_t *lval;
    char str[MAX_STRING];

    if ($1->type->type!=FUNCTION_ID)
      yyerror ("not a function");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$1->type->pointed;
    lval->code=append_code ($1->code,NULL);
    lval->code=append_line ("callpp \n",lval->code);
    $$=lval;
  }
  | lvalue TOK_OPEN rvalue_list TOK_CLOSE {
    lvalue_t *lval;
    char str[MAX_STRING];
    lvalue_list_t *p;
    argument_t *args;

    if ($1->type->type!=FUNCTION_ID)
      yyerror ("not a function");
    p=$3;
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$1->type->pointed;
    lval->code=NULL;
    fflush (stdout);
    args=isfunction ($1->type->name)->argument;
    strcpy (str,"restore #");
    while (p!=NULL) {
      force_cast (args->type,p->lvalue);
      lval->code=append_code (p->lvalue->code,lval->code);
      switch (args->type->type) {
        case CHAR_ID:
          lval->code=append_line ("savepc \n",lval->code);
          strcat (str,"c");
          break;
        case INT_ID:
          lval->code=append_line ("savepi \n",lval->code);
          strcat (str,"i");
          break;
        case POINTER_ID:
          lval->code=append_line ("savepp \n",lval->code);
          strcat (str,"p");
          break;
        default:
          yyerror ("type not implemented");
          break;
      }
      p=p->next;
      args=args->next;
    }
    strcat (str," \n");
    lval->code=append_code ($1->code,lval->code);
    lval->code=append_line ("callpp \n",lval->code);
    lval->code=append_line (str,lval->code);
    $$=lval;
  }
  | lvalue {
    lvalue_t *lval;

    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$1->type;
    lval->code=append_code ($1->code,NULL);
    switch ($1->type->type) {
      case CHAR_ID:
        lval->code=append_line ("ldpppc \n",lval->code);
        break;
      case INT_ID:
        lval->code=append_line ("ldpppi \n",lval->code);
        break;
      case POINTER_ID:
        lval->code=append_line ("ldpppp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | TOK_NUMBER {
    lvalue_t *lval;    
    char str[MAX_STRING];

    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=(type_t *) malloc (sizeof (type_t));
    lval->type->type=NUMBER_ID;
    lval->value=$1;
    lval->code=NULL;
    $$=lval;
  }
  | TOK_STRING {
    lvalue_t *lval;
    char str[MAX_STRING];

    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=(type_t *) malloc (sizeof (type_t));
    lval->type->type=POINTER_ID;
    lval->type->string=1;
    lval->type->pointed=(type_t *) malloc (sizeof (type_t));
    lval->type->pointed->type=CHAR_ID;
    lval->type->pointed->string=0;
    sprintf (str,"ldipp $string%d \n",add_string ($1));
    lval->code=append_line (str,NULL);
    $$=lval;
  }
  | rvalue TOK_PLUS rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=$1->value+$3->value;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("addscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($3->code,lval->code);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("addsipi \n",lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
      case POINTER_ID:
        if ($3->type->type!=INT_ID)
          yyerror ("must be an integer");
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("addsipp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_SHL rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value<<$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("shlscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("shlsipi \n",lval->code);
        break;
      case POINTER_ID:
        yyerror ("shl: must be an integer");
        break;
      default:
        yyerror ("shl: type not implemented");
        break;
    }
    $$=lval;
  }
  | rvalue TOK_SHR rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value>>$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("shrscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("shrsipi \n",lval->code);
        break;
      case POINTER_ID:
        yyerror ("shr: must be an integer");
        break;
      default:
        yyerror ("shr: type not implemented");
        break;
    }
    $$=lval;
  }
  | rvalue TOK_MINUS rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=$1->value-$3->value;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("subscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("subsipi \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_BINARYAND rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value&$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("andscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("andsipi \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_TIMES rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=$1->value*$3->value;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("mulscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("mulsipi \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_DIV rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=$1->value/$3->value;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("divscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($3->code,lval->code);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("divsipi \n",lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_MOD rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=$1->value%$3->value;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("modscpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($3->code,lval->code);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("modsipi \n",lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_EQUAL rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($3->code,lval->code);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldsipp \n",lval->code);
        lval->code=append_line ("ldpppi \n",lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldscpp \n",lval->code);
        lval->code=append_line ("ldpppc \n",lval->code);
        break;
      case POINTER_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpp \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsp \n",lval->code);
        lval->code=append_line ("ldsppp \n",lval->code);
        lval->code=append_line ("ldpppp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_TIMESEQ rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("mulscpc \n",lval->code);
        lval->code=append_line ("ldpctp \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("mulsipi \n",lval->code);
        lval->code=append_line ("ldpitp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_PLUSEQ rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("addscpc \n",lval->code);
        lval->code=append_line ("ldpctp \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("addsipi \n",lval->code);
        lval->code=append_line ("ldpitp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_MINUSEQ rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("subscpc \n",lval->code);
        lval->code=append_line ("ldpctp \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("subsipi \n",lval->code);
        lval->code=append_line ("ldpitp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_MODEQ rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("modscpc \n",lval->code);
        lval->code=append_line ("ldpctp \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("modsipi \n",lval->code);
        lval->code=append_line ("ldpitp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | lvalue TOK_DIVEQ rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    force_cast ($1->type,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("divscpc \n",lval->code);
        lval->code=append_line ("ldpctp \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("divsipi \n",lval->code);
        lval->code=append_line ("ldpitp \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_EQUAL2 rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->value=($1->value==$3->value);
        lval->code=NULL;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        sprintf (str,"jpnec _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        sprintf (str,"jpnei _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_LT rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value<$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        sprintf (str,"jplc _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($3->code,lval->code);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        sprintf (str,"jpli _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_LET rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value<=$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        sprintf (str,"jpgc _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        sprintf (str,"jpgi _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }
    $$=lval;
  }
  | rvalue TOK_GT rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->code=NULL;
        lval->value=($1->value>$3->value);
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        sprintf (str,"jpgc _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        sprintf (str,"jpgi _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }      
    $$=lval;
  }
  | rvalue TOK_NOTEQUAL rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    check_type ($1,$3);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        lval->type=$1->type;
        lval->value=($1->value!=$3->value);
        lval->code=NULL;
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpc \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsc \n",lval->code);
        sprintf (str,"jpnec _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($3->code,NULL);
        lval->code=append_line ("pushpi \n",lval->code);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("popsi \n",lval->code);
        sprintf (str,"jpnei _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0 \n",lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1 \n",lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }
    $$=lval;
  }
  | TOK_NOT rvalue {
    lvalue_t *lval;    
    char str[MAX_STRING];
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($2->type->type) {
      case NUMBER_ID:
        lval->type=$2->type;
        lval->code=NULL;
        lval->value=!$2->value;
        break;
      case CHAR_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        sprintf (str,"jpnzc _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 1\n",lval->code);
        sprintf (str,"jp _%s%d\n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipc 0\n",lval->code);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        sprintf (str,"jpnzi _%s%d\n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 1\n",lval->code);
        sprintf (str,"jp _%s%d\n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_line ("ldipi 0\n",lval->code);
        sprintf (str,"label _%s%d\n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }
    $$=lval;
  } 
  | TOK_OPEN rvalue TOK_CLOSE {
    lvalue_t *lval;    
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$2->type;
    lval->code=append_code ($2->code,NULL);
    $$=lval;
  } 
  | lvalue TOK_PLUS2 {
    lvalue_t *lval;    
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("inctpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_line ("@begin \n",NULL);
        lval->code=append_code ($1->code,lval->code);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("inctpi \n",lval->code);
        lval->code=append_line ("@end \n",lval->code);
        break;
      case POINTER_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppp \n",lval->code);
        lval->code=append_line ("inctpp \n",lval->code);
        break;
    }
    $$=lval;
  }     
  | lvalue TOK_MINUS2 {
    lvalue_t *lval;    
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        lval->code=append_line ("dectpc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        lval->code=append_line ("dectpi \n",lval->code);
        break;
    }
    $$=lval;
  }     
  | TOK_MINUS2 lvalue {
    lvalue_t *lval;    
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($2->type->type) {
      case CHAR_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        lval->code=append_code ($2->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("dectpc \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        lval->code=append_code ($2->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("dectpi \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        break;
    }
    $$=lval;
  }     
  | TOK_PLUS2 lvalue {
    lvalue_t *lval;    
    
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($2->type->type) {
      case CHAR_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        lval->code=append_code ($2->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("inctpc \n",lval->code);
        lval->code=append_line ("ldtppc \n",lval->code);
        break;
      case INT_ID:
        lval->type=$2->type;
        lval->code=append_code ($2->code,NULL);
        lval->code=append_code ($2->code,NULL);
        lval->code=append_line ("ldpptp \n",lval->code);
        lval->code=append_line ("inctpi \n",lval->code);
        lval->code=append_line ("ldtppi \n",lval->code);
        break;
    }
    $$=lval;
  }     
  | rvalue TOK_QUESTION rvalue TOK_DOT2 rvalue {
    lvalue_t *lval;
    char str[MAX_STRING];

    force_cast ($1->type,$3);
    force_cast ($1->type,$5);
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    switch ($1->type->type) {
      case NUMBER_ID:
        if ($1->value) {
          lval->type=$3->type;
          lval->code=$3->code;
          lval->value=$3->value;
        }
        else {
          lval->type=$5->type;
          lval->code=$5->code;
          lval->value=$5->value;
        }
        break;
      case CHAR_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        sprintf (str,"jpzc _%s%d \n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_code ($3->code,lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_code ($5->code,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
      case INT_ID:
        lval->type=$1->type;
        lval->code=append_code ($1->code,NULL);
        sprintf (str,"jpzi _%s%d \n",actual_function,local_jumps);
        lval->code=append_line (str,lval->code);
        lval->code=append_code ($3->code,lval->code);
        sprintf (str,"jp _%s%d \n",actual_function,local_jumps+1);
        lval->code=append_line (str,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        lval->code=append_code ($5->code,lval->code);
        sprintf (str,"label _%s%d \n",actual_function,local_jumps++);
        lval->code=append_line (str,lval->code);
        break;
    }
    $$=lval;
  }
  | TOK_OPEN type TOK_CLOSE rvalue %prec CAST {
    lvalue_t *lval;
    char str[MAX_STRING];

    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->code=append_code ($4->code,NULL);
    lval->type=$4->type;
    lval->value=$4->value;
    force_cast ($2,lval);
    $$=lval;
  }
  ;

lvalue_direct:
  TOK_ID {
    code_t *code;
    char str[MAX_STRING];
    argument_t *arg;

    if ((arg=isargument ($1))!=NULL) {
      $$=(lvalue_t *) malloc (sizeof (lvalue_t));
      sprintf (str,"leafppp %s \n",arg->offset);
      $$->code=append_line (str,NULL);
      $$->type=arg->type;
    }
    else if (isvariable ($1)) {
      $$=(lvalue_t *) malloc (sizeof (lvalue_t));
      sprintf (str,"leaipp _%s \n",$1);
      $$->code=append_line (str,NULL);
      $$->type=variable_type ($1);
    }
    else if (isfunction ($1)!=NULL) {
      $$=(lvalue_t *) malloc (sizeof (lvalue_t));
      sprintf (str,"leaipp _%s \n",$1);
      $$->code=append_line (str,NULL);
      $$->type=(type_t *) malloc (sizeof (type_t));
      $$->type->type=FUNCTION_ID;
      $$->type->pointed=function_type ($1);
      $$->type->name=(char *) malloc (strlen ($1)+1);
      strcpy ($$->type->name,$1);
      function_used ($1);
    }
    else 
      yyerror ("variable not found");
  }
  | TOK_OPEN rvalue TOK_CLOSE TOK_OPEN_ARRAY rvalue TOK_CLOSE_ARRAY {
    lvalue_t *lval;

    if ($2->type->type!=POINTER_ID)
      yyerror ("not a pointer");
    check_type ($2,$5);
    if ($5->type->type!=INT_ID)
      yyerror ("array index must be an integer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$2->type->pointed;
    lval->code=append_code ($5->code,NULL);
    lval->code=append_line ("pushpi \n",lval->code);
    lval->code=append_code ($2->code,lval->code);
    lval->code=append_line ("popsi \n",lval->code);
    lval->code=append_line ("addsipp \n",lval->code);
    $$=lval;
  }
  | lvalue_direct TOK_OPEN_ARRAY rvalue TOK_CLOSE_ARRAY {
    lvalue_t *lval;
    
    if ($1->type->type!=POINTER_ID)
      yyerror ("not a pointer");
    check_type ($1,$3);
    if ($3->type->type!=INT_ID)
      yyerror ("array index must be an integer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$1->type->pointed;
    lval->code=append_code ($3->code,NULL);
    lval->code=append_line ("pushpi \n",lval->code);
    lval->code=append_code ($1->code,lval->code);
    lval->code=append_line ("ldpppp \n",lval->code);
    lval->code=append_line ("popsi \n",lval->code);
    lval->code=append_line ("addsipp \n",lval->code);
    $$=lval;
  }
  ;

lvalue:
  lvalue_direct {
    $$=$1;
  }
  | TOK_TIMES TOK_OPEN rvalue TOK_CLOSE {
    lvalue_t *lval;
    
    if ($3->type->type!=POINTER_ID)
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$3->type->pointed;
    lval->code=append_code ($3->code,NULL);
    $$=lval;
  }
  | TOK_TIMES lvalue {
    lvalue_t *lval;

    if ($2->type->type!=POINTER_ID)
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$2->type->pointed;
    lval->code=append_code ($2->code,NULL);
    lval->code=append_line ("ldpppp \n",lval->code);
    $$=lval;
  }
  | TOK_TIMES TOK_PLUS2 lvalue {
    lvalue_t *lval;

    if ($3->type->type!=POINTER_ID) 
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$3->type->pointed;
    lval->code=append_code ($3->code,NULL);
    lval->code=append_line ("ldpptp \n",lval->code);
    lval->code=append_line ("inctpp \n",lval->code);
    lval->code=append_line ("ldtppp \n",lval->code);
    $$=lval;
  }
  | TOK_TIMES TOK_MINUS2 lvalue {
    lvalue_t *lval;    

    if ($3->type->type!=POINTER_ID) 
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$3->type->pointed;
    lval->code=append_code ($3->code,NULL);
    lval->code=append_line ("ldpptp \n",lval->code);
    lval->code=append_line ("dectpp \n",lval->code);
    lval->code=append_line ("ldtppp \n",lval->code);
    $$=lval;
  }
  | TOK_TIMES lvalue TOK_PLUS2 {
    lvalue_t *lval;    

    if ($2->type->type!=POINTER_ID) 
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$2->type->pointed;
    lval->code=append_code ($2->code,NULL);
    lval->code=append_line ("ldpptp \n",lval->code);
    lval->code=append_line ("ldtppp \n",lval->code);
    lval->code=append_line ("inctpp \n",lval->code);
    $$=lval;
  }
  | TOK_TIMES lvalue TOK_MINUS2 {
    lvalue_t *lval;    

    if ($2->type->type!=POINTER_ID) 
      yyerror ("not a pointer");
    lval=(lvalue_t *) malloc (sizeof (lvalue_t));
    lval->type=$2->type->pointed;
    lval->code=append_code ($2->code,NULL);
    lval->code=append_line ("ldpptp \n",lval->code);
    lval->code=append_line ("ldtppp \n",lval->code);
    lval->code=append_line ("dectpp \n",lval->code);
    $$=lval;
  }
  ;

%%

int yyerror (char *s) {
  printf ("error on line %d: %s\n",line_number,s);
  exit (1);
}

