; Demostracin sencilla de programa binario cargable desde MSX-BASIC (bload)
; Muestra un grfico y espera una pulsacin de tecla para volver al BASIC
; Para ensamblar con asMSX v.0.01a
; Eduardo A. Robsy Petrus, 6 de Julio del 2.000

; Opciones de ensamblado
.msx
.basic
.start inicio

org $9000

inicio:

di

; Inicializa en modo grfico, con colores adecuados
ld hl,$f3e9
ld [hl],15
inc hl
ld [hl],0
inc hl
ld [hl],0
call INIGRP

; Deshabilita la visualizacin
call DISSCR

; Copia el mapa de bits del grfico a la VRAM
ld bc,6144
ld de,0
ld hl,grafico
call LDIRVM

; Copia los atributos del grfico a la VRAM
ld bc,6144
ld de,8192
ld hl,grafico+6144
call LDIRVM

; Recupera la visualizacin
call ENASCR

; Borra el buffer de teclado
call KILBUF

; Espera que se pulse una tecla
call CHGET

; Borra de nuevo el buffer de teclado
call KILBUF

; Vuelve al modo de texto de 40 columnas
call INITXT

; Imprime unas lneas de texto
ld hl,texto
@@bucle:
 ld a,[hl]
 inc hl
 or a
 jr z,@@fin
 call CHPUT
 jr @@bucle

; Devuelve el control al BASIC
@@fin: ret

; Datos del programa a continuacin
texto: db "Programa de ejemplo de asMSX v.0.01a",10,13
       db "Eduardo A. Robsy Petrus [06/07/2000]",10,13,0
grafico:
.incbin "logotipo.scr"


