;	V9t9: the TI Emulator! v6.0 Source 
;	Copyright (c) 1996-2000 by Edward Swartz

;==========================================================================
;	RAM definitions for V9t9 FORTH ROM.
;
;==========================================================================

;	WPs:	we reserve >8300 - >83FF

mainws	equ	>8300		; main FORTH workspace
intws	equ >8320		; interrupt workspace
xopws	equ >8380		; XOP workspace (shared, ints off)
vidws	equ >83E0		; video & term workspace
dskws	equ >83E0		; disk workspace

;	STACKs:  we reserve >2000 - >2800

	aorg	>2000

sysstack bss	>40			; system stack
sysstacksize equ $ sysstack -

uptime	bss	4			; time in 1/60 seconds
timeout	bss	2			; timeout counter
userint bss	2			; user int routine (bl @xxxx)

vregs	bss	2			; VDP registers 0 and 1
vscreen	bss	2			; VDP addr of screen
vpatts	bss	2			; VDP addr of patterns
vcolors bss	2			; VDP addr of colors
vsprites bss	2			; VDP addr of sprites
vsprpat bss	2			; VDP addr of sprite patterns
vsprmot	bss	2			; VDP addr of sprite motion
vfree	bss	2			; usable space

vwidth	bss	1			; width in chars
vheight	bss	1			; height in chars
vdrawchar bss	2			; draw char in window (BLWP @)
vscroll	bss	2			; scroll window up a line (BLWP @)
vclear	bss	2			; clear window (BLWP @)

vcoordaddr bss	2			; get SIT addr of R0 coord

vcrstimer bss	1			; timer for blink
vcrsblink bss	1			; limit in 1/60 s
vcursor	bss	2			; cursor blinker (BLWP @)
vcurs	bss	1			; cursor blink state (0 or >80)
vcursunder bss	1			; char under cursor

vstacksize equ 	>20
vstack	bss	vstacksize		; video stack

;-----------------------------------

@kbdstart equ	$

kbdgradr bss	2			; saved GROM addr
kbdlast	bss	1			; last char pressed (or 0)
kbdtimer bss	1			; timer (1/60 s) since last repeat
kbdscan bss	1			; most recent scancode	   (0-47)
kbdshft	bss	1			; most recent shift status (>70)
kbdhead	bss	1			; head of kbd buffer
kbdtail	bss	1			; tail of kbd buffer  
					; head==tail => empty

kbdbufsize equ	32
kbdbuf	bss	kbdbufsize			

kbdlimit bss	1			; 1/60s before repeating
kbddelay bss	1			; delay between keyscans
kbdflag	bss	1			; flag:  0=waiting to repeat, 1=r'ing
kbdmode	bss	1			; how we interpret keyboard
					; | >80 = no translation to ASCII
					; | >40 = no buffering

@kbdlength equ	$ @kbdstart -

kbdreturn bss	2			; return addr

;---------------------------------------

vfg	bss	1			; foreground color
vbg	bss	1			; background color
vch	bss	1			; current char

vcurschar bss	1			; char of cursor

vwx	bss	1			; window left
vwy	bss	1			; window right
vwxs	bss	1			; width of window
vwys	bss	1			; height of window
vwcy	bss	1			; last cleared row
	bss	1

vx	bss	1			; x-coord of cursor in window
vy	bss	1			; y-coord of cursor in window

vmono	bss	1
vidmode	bss	1			; what mode are we in?  (M_xxxx)

M_text	equ	0
M_graph	equ	1
M_bit	equ	2			; both mono and color


vlinex	bss	2
vliney	bss	2


;--------------------------------------

dskstacksize 	equ	>20
dskstack bss	dskstacksize

forthdsk bss	10			; filename for FORTH disk

;--------------------------------------

temp	equ	$			; COMPLETELY temporary workspace.
					; not to store ANYTHING useful.

;---------------

;	To conform with DSRs

	aorg	>8370

vdplimit bss	2			; VDP memory size


