
\	Dictionary words... these cover memory spaces, threading and compiler issues
\	related to structure of the dictionary.
\

$1F constant dict-name-mask
$40 constant dict-name-immed
$80 constant dict-name-smudge

\	\\\\\\\\\\\\\\

\ too damn slow and memory hogging
0 [if]
\	Wordlist stuff.
\
\	We will keep the link field and name field in the 
\	data/code space as in Forth-83, but will supplement
\	this with a hash table.
\
\	The hash table is indexed by a key derived from the
\	name of the word, and divided into N buckets of M-1
\	entries each.  The M-1 entry is 0 for the end of the
\	bucket chain or points to a new chain.  The ROM
\	dictionary must know the starting point for the RAM
\	hash buckets so there may be a unified searching
\	algorithm.
\
\	When defining new words, we will overwrite existing
\	entries pointing to the same name.

1 include commonhash.fs

\ set up main wordlist
[[ FORTH-wordlis @ ]] constant FORTH-WORDLIST

[then]

\	\\\\\\\\\\\\\\

\	Custom dictionary stuff

: nfa>xt
	1 traverse
;

: xt>nfa
	-1 traverse
;

: nfa>imm?	( nfa -- t/f )
	c@ dict-name-immed and 0<>
;

: lfa>nfa
	2+
;

: id.		( nfa -- )
	count $1f and type
;

$1F constant width		\ max length of a name

\	\\\\\\\\\\\\\\\\\

\	dictionary words

[IFUNDEF] DP
User DP
[THEN]

[IFUNDEF] '
: '	
\   Skip leading space delimiters. Parse name delimited by a space. Find name and return xt, the execution token for name. An
\   ambiguous condition exists if name is not found.
\
\   Similarly, the use of ' and ['] with compiling words is unclear if the precise compilation behavior of those words is not
\   specified, so ANS Forth does not permit a Standard Program to use ' or ['] with compiling words.

	bl word	find 
	0= if count type ." not found" 0 then		\ !!!
;
[THEN]

[IFUNDEF] ,
: ,
\   Reserve one cell of data space and store x in the cell. If the data-space pointer is aligned when , begins execution, it
\   will remain aligned when , finishes execution. An ambiguous condition exists if the data-space pointer is not aligned
\   prior to execution of ,.
 	here ! #cell dp +!	
;
[THEN]

[IFUNDEF] >BODY
: >BODY
\        ( xt -- a-addr )
\   a-addr is the data-field address corresponding to xt. An ambiguous condition exists if xt is not for a word defined via
\   CREATE.
	3 cells +
;
[THEN]

[IFUNDEF] ALIGN
: ALIGN
	here aligned dp !
;
[THEN]

[IFUNDEF] ALIGNED
: ALIGNED	( addr -- addr )
	#cell  1-  swap over +  swap and
;
[THEN]

[IFUNDEF] ALLOT
: ALLOT
	here + dp !
;
[THEN]

[IFUNDEF] C,
: C,
	here c!  0 char+  dp +!
;
[THEN]

[IFUNDEF] FIND
: FIND	\ ( c-addr -- c-addr 0  |  xt 1  |  xt -1 )
\   Find the definition named in the counted string at c-addr. If the definition is not found after searching all the word
\   lists in the search order, return c-addr and zero. If the definition is found, return xt. If the definition is immediate,
\   also return one (1); otherwise also return minus-one (-1). For a given string, the values returned by FIND while compiling
\   may differ from those returned while not compiling.

[ 1 [if] ]
	latest			\ !!! need real wordlist
	(find)			\ ( c-addr 0 | nfa 1 )

[ [else] ]

\	Use hash table
	forth-wordlist	\ !!! need latest wordlist
	hash>find
\	over .

[ [then] ]

	if
		dup nfa>xt 
		swap c@ 
		dict-name-immed and if 1 else -1 then
	else
		0
	then
;
[THEN]
: wordtofind s" _2*" ;
test" find hex 21 wordtofind pad swap cmove pad 2 over c! find 2dup . . if execute 42 = else 0 then decimal "

[IFUNDEF] HERE
: HERE
	dp @
;
[THEN]

[IFUNDEF] [']
: [']
	' ' compile,	
; immediate
[THEN]

[IFUNDEF] IMMEDIATE
: IMMEDIATE
	latest lfa>nfa dup c@ dict-name-immed or swap c!
;
[THEN]

[IFUNDEF] UNUSED
: UNUSED
	0 here -
;
[THEN]

[IFUNDEF] WORDS
: WORDS
	latest		\ !!! need real wordlist
	begin
		dup lfa>nfa id. space
		@ dup
		0= (pause?) or
	until
	drop
;
[THEN]

has? profiling [if]
: prof
	latest		\ !!! need real wordlist
	begin
		@ dup
	while
		dup lfa>nfa
		dup	nfa>xt #cell - @ @ 5 .r space
			id. cr
	repeat
	drop
;
[then]

