;	V9t9: the TI Emulator! v6.0 Source 
;	Copyright (c) 1996 by Edward Swartz

;	DEV.INC
;
;	Peripheral device access.
;
;


;==========================================================================
;	Device init.
;
;	Execute each DSR's initialization routine.
;==========================================================================

haa	byte	>aa
	byte	0

dinit	li	0,>3fff
	mov	0,@vdplimit			; set up 16k VDP RAM

	lwpi	>83e0  				; be standard
	li	13,>9800
	li	14,>100
	li	15,>8c02

	li	12,>0f00			; start below first DSR
di00	sbz	0
	ab	@h01,12				; point to next DSR
	ci	12,>2000
	jhe	diout				; done

	sbo	0					; turn on ROM
	cb	@>4000,@haa			; legal rom?
	jne	di00				; nope

	mov	@>4004,1			; get init ptr
	jeq	di00				; none
di01	mov	@2(1),11			; get addr for init
	mov	12,@>83d0
	bl	*11				; call powerup routine
	mov	*1,1				; get next powerup
	jne	di01				; if it exists
	jmp	di00

diout	lwpi	mainws				; restore WP
	rt


;--------------------------------------------------------------------------
;	Disk init.
;
;	We want to limit to two buffers, since bitmap mode would otherwise
;	overwrite it.
;
;	With this setup we will ONLY use the emulated disk DSR for stuff.
;	So, we'll simply write the new info for the real DSR, if installed,
;	and probe the emulated disk DSR.
;--------------------------------------------------------------------------

noemuerr db	"No emulated disk DSR found!",>ff
	db	"Please install the emulated disk DSR",>ff
	db	"by adding 'EmuDisk' to the DSRCombo",>ff
	db	"variable in FORTH.CNF.",>ff,>ff
	db	"(See DISKS.TXT for info.)",>ff,>ff
	db	"Press Ctrl+Break to halt."
	db	0

forthdskdef db	"FORTHDSK  "
	even

diskinit dect	SP
	mov	11,*SP

	li	0,>3fff
	mov	0,@vdplimit			; setup

	li	12,>1000			; DSR base for emulated DSR
	sbo	0				; turn on
	cb	@haa,@>4000			; installed?
	jeq	dskiokay

	li	2,noemuerr			; print error message
	b	@dieerr

dskiokay:
	sbz	0

	li	0,forthdskdef
	li	1,forthdsk
	li	2,10
dskifn	movb	+*0,+*1
	dec	2
	jgt	dskifn

	mov	+*SP,11
	rt

