\ cr order  cr words

0 ,			\ start address for ((cold)), patched later
0 ,			\ start address for ((quit)), patched later

\	basic
2 constant #cell
1 constant #char

decimal 211 constant bksp hex

\ \\\\\\\\\\\\\\\\\\\\\\\\\

\	Backend words for implementing the basic FORTH word types

\	no-operation
Code noop
	NEXT
end-code

\	enable/disable v9t9 debugger
Code (dbg)
	dbg
	NEXT
end-code

\	push literal from instruction stream
code lit
	PUSH
	mov *IP+ , TOS
	NEXT
end-code

\	push length-prefixed string from instruction stream
Code (s")
\	DBG
	PUSH
	movb *IP+ , T1
	srl T1 , 8 #
	mov IP , TOS
	PUSH
	mov T1 , TOS
	a	T1 , IP
	inc IP
	andi IP , $fffe #
\	-dbg
	NEXT
end-code
\ ' slit ALIAS (s")

\	standard threading is indirect threaded (slow)
has? standard-threading [IF]

\	execute deferred word
." :dodefer" cr
code: :dodefer
\	:dodefer 
	dbg
	-dbg
	NEXT
end-code

\	Entry to :docol --
\	IP is (possible) other :docol word's 
\	instruction pointer, which we save and 
\	restore at NEXT.
\	WA points to the PFA of the colon definition
\	(originally the CFA, a pointer to whose address
\	was incremented after reading this entry point).
\	
." :dodoes" cr
code: :dodoes
	PUSH
	mov WA , TOS
	mov *TOS , WA
	inct TOS
	jmp 1 $f
end-code

\	push context and execute colon word
." :docol" cr
code: :docol 
	dect RP
	mov IP , *RP
	mov WA , IP
	inct IP
end-code

\	execute next colon-definition word
." @Next" cr
code: @Next
	mov *IP+ , WA
	\ drop through
end-code

\	EXECUTE entry point.  
\	WA contains the XT of a word.
\	We read the CFA and branch to it,
\	and leave WA pointing to the PFA.
." ExEntry" cr
code: ExEntry
1 $:
	mov *WA+ , R0
	b	*R0
end-code

\	generic CREATE handler has already pushed PFA
Code :dovar
	NEXT
End-code

\	push address of user variable
Code :douser
	mov *TOS , TOS
	ai TOS , StartUser #
	NEXT
End-code

\	push constant
Code :docon
	mov *TOS , TOS
	NEXT
end-code

\	unwind colon definition
Code ;S
	mov *RP+ , IP
	mov *IP+ , WA
	mov *WA+ , R0
	b	*R0
end-code

[ELSE]		\ direct threading

\	Execute deferred word
." :dodefer" cr
code: :dodefer
\	dbg
	mov *R11+ , R0
	b	*R0
end-code

\	???
." :dordefer" cr
code: :dordefer
\	dbg
	mov *R11+ , R0
	mov	*R0 , R0
	b	*R0
end-code

\	Execute does> part of word
." :dodoes" cr
code: :dodoes
\	:dodoes is entered through BL *DODOES leaving R11 
\	pointing to the CA of the does> part, followed by the PFA of the word.
	PUSH
	mov *R11+ , R0
	mov R11 , TOS
	b	*R0
end-code

." :docol" cr
code: :docol 
\	:docol is entered through BL *DOCOL leaving R11
\	pointing to the list of CAs
	dect RP
	mov IP , *RP
	mov R11 , IP
end-code

." @Next" cr
code: @Next
\	drop through
\	mov *IP+ , R0
\	b	*R0
end-code

." ExEntry" cr
code: ExEntry
1 $:
[ has? profiling [if] ]
\	dbg
	mov *IP , R0
	dect R0
	mov *R0 , R0
	inc *R0
\	-dbg
[ [then] ]
	mov *IP+ , R0
	b	*R0
end-code

\	generic CREATE already pushed PFA
Code :dovar
	NEXT
end-code

\	push addr of user var
Code :douser
	mov *TOS , TOS
	ai TOS , StartUser #
	NEXT
End-code

\	push constant
Code :docon
	mov *TOS , TOS
	NEXT
end-code

\	unwind colon definition
Code ;S
	mov *RP+ , IP
\	mov *IP+ , R0
\	b	*R0
	NEXT
end-code

[ENDIF]

Code branch
	A *IP , IP
	NEXT
end-code

Code ?branch
	MOV TOS , TOS
	JEQ 1 $f
	inct IP		\ skip offset
	POP
	NEXT
1 $:
	POP
	a *IP , IP
	NEXT
end-code

\ \\\\\\\\\\\\\\\\\\\\\\\\\\\\

\ 	========================
\	stack manipulation words
\	========================

Code DUP
	PUSH
	NEXT
end-code

Code 2DUP
	dect SP
	mov TOS , *SP
	dect SP
	mov 4 @>(SP) , *SP
	NEXT
end-code

Code ?DUP
	mov TOS , TOS
	jeq 0 $f
	PUSH
0 $: NEXT
end-code

Code DROP
	POP
	NEXT
end-code

Code 2DROP
	POP2
	NEXT
end-code

Code SWAP
	mov TOS , T1
	mov *SP , TOS
	mov T1 , *SP
	NEXT
end-code

Code 2SWAP
	mov TOS , T1
	mov 2 @>(SP) , TOS
	mov T1 , 2 @>(SP)

	mov *SP , T1
	mov 4 @>(SP) , *SP
	mov T1 , 4 @>(SP)
	NEXT
end-code

Code OVER
	PUSH
	mov 2 @>(SP) , TOS
	NEXT
end-code

Code 2OVER
	PUSH
	mov 6 @>(SP) , TOS
	PUSH
	mov 6 @>(SP) , TOS
	NEXT
end-code

Code ROT	( a b c -- b c a )
	mov 2 @>(SP) , T1
	mov *SP , 2 @>(SP)
	mov TOS , *SP
	mov T1 , TOS
	NEXT
end-code

Code NIP 	( a b -- b )
	mov  TOS , *SP
	POP
	NEXT
end-code

Code PICK	( ix* n -- x[n] )
	a TOS , TOS
	a SP , TOS
	mov *TOS , TOS
1 $:
	NEXT
end-code

Code >R
	dect RP
	mov TOS , *RP
	POP
	NEXT
end-code
	
Code R>
	PUSH
	mov *RP+ , TOS
	NEXT
end-code

Code R@
	PUSH
	mov *RP , TOS
	NEXT
end-code

Code RDROP
	inct RP
	NEXT
end-code

Code 2>R
	ai RP , -4 #
	mov TOS , *RP
	mov *SP+ , 2 @>(RP)
	POP
	NEXT
end-code
test" 2>r 45. 2>r 2r> 45. d="	

Code 2R>
	PUSH
	mov 2 @>(RP) , TOS
	PUSH
	mov *RP+ , TOS
	inct RP
	NEXT
end-code

Code 2R@
	PUSH
	mov 2 @>(RP) , TOS
	PUSH
	mov *RP , TOS
	NEXT
end-code

Code 2RDROP
	ai RP , 4 #
	NEXT
end-code


\	========================
\	math words
\	========================

code: shifter
0 $:
	mov	TOS , R0		\ shift count
	POP
	x	T1
	NEXT
end-code

Code RSHIFT
	li	T1 , 0800 rTOS + #		\ SRA
	jmp	0 $b
end-code

Code LSHIFT
	li	T1 , 0a00 rTOS + #		\ SLA
	jmp	0 $b
end-code

Code urshift
	li	T1 , 0900 rTOS + #		\ SRL
	jmp 0 $b
end-code

Code cshift
	li	T1 , 0b00 rTOS + #		\ SRC
	jmp	0 $b
end-code

Code UM*
	mov TOS , T1
	mpy *SP , T1
	mov T2 , *SP
	mov T1 , TOS
	NEXT
end-code
test" um* 50 8 um* 280. d="

Code AND
	inv TOS
	szc TOS , *SP
	POP
	NEXT
end-code

Code OR
	soc *SP+ , TOS
	NEXT
end-code

Code XOR
	xor *SP+ , TOS
	NEXT
end-code
test" xor $55 $aa xor $ff ="

\	========================

has? standard-threading [if]

Code EXECUTE
	mov TOS , WA
	POP
	b ' ExEntry @>
end-code

[else]

Code EXECUTE
\	dbg
	mov TOS , R0
	POP
	b	*R0
end-code

[endif]

Code (of)		\ ( itm itm? -- <> | itm ) IP:branch
	mov TOS , T1
	POP
	c 	TOS , T1
	jne	1 $f
	POP
	inct IP
	NEXT
1 $:
	a	*IP , IP
	NEXT	
end-code

Code (loop)
	inc	*RP	  				\ increment
	c	*RP , 2 @>(RP)		\ done?
	jne	1 $f				\ nope
	ai	RP , 4 #			\ yup... lose loop limits
	inct IP					\ & skip jump amount
	NEXT
1 $:
	a	*IP , IP
	NEXT
end-code

Code (+loop)
	mov	2 @>(RP) , T1
	mov	T1 , T2				\ limit
\	dec T1					\ limit-1
	s	*RP , T1
	a	TOS , *RP
	s	*RP , T2
	POP
	xor T2 , T1
	jlt	0 $f
	a	*IP , IP
	NEXT
0 $:
	ai	RP , 4	#			\ lose limits
	inct IP					\ done, skip jump amount
	NEXT
end-code

Code (do)
	ai	RP , -4 #			\ make room 
	mov	TOS , *RP			\ put start
	mov	*SP+ , 2 @>(RP)		\ put limit
	POP
	NEXT
end-code

Code (?do)
	ai	RP , -4 #			\ make room 
	mov TOS , T1
	mov	T1 , *RP			\ put start
	mov	*SP , 2 @>(RP)		\ put limit
	s	*SP+ , T1
	jne 1 $f				\ continue
	a 	*IP , IP
	ai	RP , 4 #			\ pop limits
	POP
	NEXT
1 $:
	inct IP					\ skip branch
	POP
	NEXT
end-code

Code UNLOOP
\	dbg
	ai	RP , 4 #
	NEXT
end-code

Code: rpick	
0 $:
	PUSH
	a RP , T1
	mov *T1 , TOS
	NEXT
end-code
	
Code I
	PUSH
	mov	*RP , TOS
	NEXT
end-code

Code i'
	li T1 , 2 #
	jmp 0 $b
end-code

Code J
	li T1 , 4 #
	jmp 0 $b
end-code

Code j'
	li T1 , 6 #
	jmp 0 $b
end-code

Code k
	li T1 , 8 #
	jmp 0 $b
end-code

Code DIGIT					\ (b c -- d -1 | 0)
\ 	determine if 'c' is a legal digit in base 'b'

	mov *SP+ , T1			\ base
							\ digit in TOS
	ci	TOS , $61 #			\ lowercase a-*
	jhe	3 $f
	ci	TOS , $41 #			\ uppercase A-*
	jhe	4 $f
	ci	TOS , $3a #
	jhe	1 $f
	ci	TOS , $30 #			\ 0-9
	jl	1 $f

	ai	TOS , -$30 #
	jmp 0 $f
3 $: ai	TOS , -$20 #		\ make uppercase
4 $: ai	TOS , -$37 #		\ make binary
0 $: c	TOS , T1			\ compare digit to base...
	jhe	1 $f

	PUSH
	seto TOS				\ good
	NEXT

1 $: clr	TOS  			\ error
	NEXT
end-code

Code m/mod		( ud un -- un.r ud.q )
\	dbg
\	divide high word by dividend
	mov TOS , T3
	mov *SP , T2
	clr T1
	div T3 , T1			\ T1:ud.h*10000/r  T2:ud.h*10000%r
	mov T1 , TOS		\ TOS:ud.h*10000/r (hi word of quotient)
	mov T2 , T1
	mov 2 @>(SP) , T2 	\ T1:ud.h*10000%r  T2:ud.l
\	divide low word + previous remainder*10000
	div T3 , T1			
	mov T2 , 2 @>(SP)	\ T2:ud%r
	mov T1 , *SP		\ lo word of quotient
\	-dbg
	NEXT
end-code

Code (find)
	\ find word in dictionary	 ( c-addr lfa -- 0 | nfa 1 )	
	\ lfa is nfa-2

\   	dbg
	mov	TOS , TOS			\ TOS=LFA
	jeq	9 $f				\ fail

\	search list 

	clr T3
	clr T4
2 $:
	inct TOS				\ LFA>NFA
	mov TOS , T1			\ new NFA to check

	mov	*SP , T2			\ R4=char ptr
	movb *T2 , R0
	srl R0 , 8 #

	movb *T1+ , T3
	jgt	4 $f				\ hidden word ($80 not set)

	sb *T2+ , T3
	andi T3 , $1F00 #		\ compare lengths 
	jne 4 $f				\ nope

3 $: cb *T1 , *T2			\ exact match?
	jeq 1 $f
	movb *T1 , T3
	movb *T2 , T4
	xor T4 , T3
	ci T3 , $2000 #			\ differ in case bit?
	jne 4 $f
1 $:
	inc T1
	inc T2
	dec R0
	jgt	3 $b

	mov	TOS , *SP			\ overwrite c-addr
	seto TOS
\	-dbg
	NEXT

4 $: mov -2 @>(TOS) , TOS	\ get LFA to new one...
	jne	2 $b				\ if not end...

9 $:	inct SP				\ lose one param
	clr	TOS					\ failed
\	-dbg
	NEXT
end-code

Code (nfa=)		( caddr nfa -- 1|0 )
	dbg
	mov TOS , T1
	POP
	mov TOS , T2
	movb *T1+ , T3		\ length of nfa
	jgt	1 $f			\ whoops, hidden

	andi T3 , $1f00 #
	cb T3 , *T2+		\ lengths equal?
	jne 1 $f
	srl T3 , 8 #
2 $:
	cb *T1+ , *T2+
	jne 1 $f
	dec T3
	jgt 2 $b
	seto TOS
	-dbg
	NEXT
1 $:
	clr TOS
	-dbg
	NEXT
end-code

Code traverse 	( xt|nfa dir -- nfa|xt )
\	traverse from one end of definition to the other
\	dir<0 means xt->nfa, dir>0 means nfa->xt

\	add a field for profiler

\	dbg

	mov TOS , T1
	POP
	mov T1 , T1
	jlt	0 $f

		\ nfa -> xt
	movb *TOS+ , T1		\ length+info byte
	andi T1 , $1f00 #	\ mask length
	srl T1 , 8 #
	inc T1				\ align
	a T1 , TOS
	andi TOS , $fffe #

[ has? profiling [if] ]
	inct TOS
[ [then] ]
	jmp 2 $f

0 $:	\ xt -> nfa
	li T1 , $0100 #
	clr T2

[ has? profiling [if] ]
	dect TOS
[ [then] ]

	dec TOS
	movb *TOS , T2
	ci T2 , $2000 #				\ blank
	jne 1 $f
	dec TOS
1 $: dec TOS
	movb *TOS , T3 
	jgt 3 $f					\ len byte has $80 set
	andi T3 , $1F00 #
	cb T1 , T3
	jeq 2 $f
3 $:
	ai T1 , $0100 #
	jgt 1 $b
2 $: 
 	NEXT
end-code

Code FILL		( start | count | ch -- )
	sla TOS , 8 #
	mov *SP+ , T2
	mov *SP+ , T3
	mov T2 , T2
	jmp 2 $f	
1 $: movb TOS , *T3+
	dec T2
2 $: jgt 1 $b
	POP
	NEXT
end-code

\	facility
Code (KEY?)
	PUSH
	xop	TOS , 1 #
	$01 data			\ !!! 01 = keyavail?
	NEXT
end-code
DeferROM KEY?
\ ' (KEY?) ROMIS KEY?

Code (KEY)
\	dbg
	PUSH
0 $: xop TOS , 1 #
	$01 data					\ !!! 01 = keyavail
	movb TOS , TOS
	jeq	0 $b
	xop TOS , 1 #
	$02 data					\ !!! 02 = readkey
\	-dbg
	NEXT
end-code
DeferROM KEY
\ ' (KEY) ROMIS KEY

Code (EMIT)
\	dbg
\	sla TOS , 8 #
	xop TOS , 1 #
	$03 data					\ !!! 03 = emit
	POP
\	-dbg
	NEXT
end-code
DeferROM EMIT
\ ' (EMIT) ROMIS EMIT

Code (emit8)
\	sla TOS , 8 #
	xop TOS , 1 #
	$04 data					\ !!! 04 = emit8
	pop
	NEXT
end-code
DeferROM emit8
\ ' (emit8) ROMIS emit8

\	This version dumps to V9t9 console
Code (EMIT99)
	xop TOS , 1 #
	$03 data					\ !!! 03 = emit
	swpb TOS
	emitchar TOS
	POP
	NEXT
end-code

Code (type)
	mov *SP , T2
	mov TOS , T1
	jeq 1 $f
0 $: movb *T2+ , TOS
	srl TOS , 8 #
	xop TOS , 1 #
	$03 data
	dec T1
	jne 0 $b
1 $: POP2
	NEXT
end-code

Code /STRING	( addr n delta -- addr+delta n-delta )
	s	TOS , *SP
	a	TOS , 2 @>(SP)
	POP
	NEXT
end-code

Code AT-XY		( col row -- )
	mov *SP , T1
	sla T1 , 8 #
	andi TOS , $ff #
	soc TOS , T1
	POP2
	xop T1 , 1 #
	$05 data			\ !!! 05 = gotoXY
	NEXT
end-code

Code cls
	clr T1
	xop T1 , 1 #
	$06 data			\ !!! 06 = cls
	NEXT
end-code

Code window				( cols row col row -- )
	mov *SP , T1
	sla T1 , 8 #
	andi TOS , $ff #
	soc TOS , T1
	POP2					\ offs coords in T1

	mov *SP , T2
	sla T2 , 8 #
	andi TOS , $ff #
	soc TOS , T2
	POP2					\ size coords in T2

	xop T1 , 1 #
	$07 data				\ !!! 07 = window
	NEXT
end-code

Code full
	clr T1
	seto T2
	xop T1 , 1 #
	$07 data
	NEXT
end-code

Code CMOVE
0 $: mov TOS , T2			\ # bytes
	mov *SP , T1			\ dst
	POP2					\ src = TOS
	mov	T2 , T2  			\ 0 bytes?
	jeq	1 $f
\	dbg
2 $: movb	*TOS+ , *T1+
	dec	T2
	jne	2 $b
1 $: \ -dbg
	POP 
	NEXT
End-code

Code CMOVE>
0 $: mov TOS , T2			\ # bytes
	mov *SP , T1			\ dst
	POP2					\ src = TOS
	mov	T2 , T2  			\ 0 bytes?
	jeq	1 $f
\	dbg
	a T2 , TOS
	a T2 , T1
2 $: dec TOS
	dec T1
	movb	*TOS , *T1
	dec	T2
	jne	2 $b
1 $: \ -dbg
	POP 
	NEXT
End-code

\ T3 is input char; ( caddr u -- ) on stack
Code: filler
0 $: mov TOS , T1			\ # bytes
	POP						\ src = TOS
	mov	T1 , T1  			\ 0 bytes?
	jeq	1 $f
2 $: movb T3 , *TOS+
	dec	T1
	jne	2 $b
1 $:
	POP 
	NEXT
end-code

Code ERASE
	clr T3
	jmp 0 $b
end-code

Code BLANK
	li T3 , $2020 #
	jmp 0 $b
end-code

Code: vwaddr
	ori r0 , 4000 #
Code: vraddr
	swpb r0
	movb r0 , 8c02 @>
	swpb r0
	movb r0 , 8c02 @>
	b *r11
end-code

Code vc!
	mov TOS , R0
	POP
	limi 0 #
	bl ' vwaddr @>
	swpb TOS
	movb TOS , 8c00 @>
	limi 1 #
	POP
	NEXT
end-code

Code vc@
	mov TOS , R0
	POP
	limi 0 #
	bl ' vraddr @>
	PUSH
	movb 8800 @> , TOS
	limi 1 #
	srl TOS , 8 #
	NEXT
end-code

Code v!
	mov TOS , R0
	POP
	limi 0 #
	bl ' vwaddr @>
	movb TOS , 8c00 @>
	swpb TOS
	movb TOS , 8c00 @>
	limi 1 #
	POP
	NEXT
end-code

Code v@
	mov TOS , R0
	POP
	limi 0 #
	bl ' vraddr @>
	PUSH
	movb 8800 @> , TOS
	swpb TOS
	movb 8800 @> , TOS
	swpb TOS
	limi 1 #
	NEXT
end-code

\	Execute these with interrupts off

Code vaddr
	mov TOS , R0
	POP
	bl ' vraddr @>
	NEXT
end-code

Code ,vc!
	swpb TOS
	movb TOS , 8c00 @>
	POP
	NEXT
end-code

Code ,vc@
	PUSH
	movb 8800 @> , TOS	
	srl TOS , 8 #
	NEXT
end-code

Code limi0
	limi 0 #
	NEXT
end-code

Code limi1
	limi 1 #
	NEXT
end-code

Code vcmove	( vaddr caddr u -- )
	mov 2 @>(SP) , R0
	mov *SP , T1
	limi 0 #
	bl ' vraddr @>
	mov TOS , TOS
	jeq 2 $f
1 $: movb 8800 @> , *T1+
	dec TOS
	jne 1 $b
2 $:
	limi 1 #
	POP3
	NEXT
end-code

Code cvmove 	( caddr vaddr u -- )
	mov *SP , R0
	mov 2 @>(SP) , T1
	limi 0 #
	bl ' vwaddr @>
	mov TOS , TOS
	jeq 2 $f
1 $: movb *T1+ , 8c00 @>
	dec TOS
	jne 1 $b
2 $:
	limi 1 #
	POP3
	NEXT
end-code

Code vfill 		( vaddr u char -- )
	mov TOS , T2
	swpb T2
	mov *SP , T1
	mov 2 @>(SP) , R0
	limi 0 #
	bl ' vwaddr @>
	mov T1 , T1
	jeq 2 $f
1 $: movb T2 , 8c00 @>
	dec T1
	jne 1 $b
2 $: 
	limi 1 #
	POP3
	NEXT
end-code

Code COMPARE	( addr addr u -- -1/0/1 )
	mov TOS , T2
	mov *SP , T1
	mov 2 @>(SP) , T3
	0POP2
	mov	T2 , T2
	jeq	1 $f
0 $: movb *T3+ , TOS
	sb 	*T1+ , TOS
	sra TOS , 8 #
	jne 1 $f
	dec	T2
	jne	0 $b
1 $: 
	NEXT
end-code

Code swpb
	swpb TOS
	NEXT
end-code

Code sp@
	PUSH
	mov SP , TOS			\ stack minus TOS
	inct TOS
	NEXT
end-code

Code rp@
	PUSH
	mov RP , TOS
	NEXT
end-code

Code sp!
	mov TOS , SP
\ 	don't pop!
	NEXT
end-code

Code rp!
	mov TOS , RP
	POP
	NEXT
end-code

Code 0=
	mov TOS , TOS
2 $:
	clr TOS			\ doesn't touch status
	jne 1 $f
	seto TOS
1 $: 
	NEXT
end-code

Code D0=
	soc *SP+ , TOS
	jmp 2 $b
end-code

Code 0<>
	mov TOS , TOS
	seto TOS			\ doesn't touch status
2 $:
	jne 1 $f
	clr TOS
1 $: 
	NEXT
end-code

Code D0<>
	soc *SP+ , TOS
	jmp 2 $b
end-code

Code 0<
	sra TOS , $0f #
	NEXT
end-code

Code D0<
	sra TOS , $0f #
	0POP
	NEXT	
end-code

Code 0>
	neg TOS
	sra TOS , $0f #
	NEXT
end-code

Code +
	a	*SP+ , TOS
	NEXT
end-code

\	TOS = hi1
\	*SP = lo1
\	@2(SP) = hi2
\	@4(SP) = lo2
Code D+		\ ( lo2 hi2 lo1 hi1 )
	mov TOS , T2
	mov *SP+ , T1
	POP
	a	T2 , TOS
	a	T1 , *SP
	jnc	1 $f
	inc	TOS
1 $: 
	NEXT
end-code

code NEGATE
	neg	TOS
	NEXT
end-code

\	changed dminus to dnegate
Code DNEGATE
1 $:
	inv TOS
	inv	*SP
	inc *SP
	jnc 0 $f
	inc TOS
0 $:
	NEXT
end-code

Code DABS
	mov TOS , TOS
	jlt 1 $b	\ DNEGATE
	NEXT
end-code

Code UM/MOD		( ud u1 -- u2 u3 )

\ Divide ud by u1, giving the quotient u3 and the remainder u2. 
\ All values and arithmetic are unsigned. An ambiguous
\ condition exists if u1 is zero or if the quotient lies outside 
\ the range of a single-cell unsigned integer.
\
\	ud=u3*u1+u2, 0<=u2<u1
\
	mov *SP+ , T1
	mov *SP , T2
	div TOS , T1
	mov T1 , TOS
	mov T2 , *SP
	NEXT
end-code
test" um/mod 2d. 6 um/mod 7 = swap 3 = and"
test" um/mod 1ff. f um/mod 22 = swap 1 = and"

Code +!
	a 	*SP+ , *TOS
	POP
	NEXT
end-code
test" +! base @ 2 base +! base @  $a base !  $c = swap $a = and"


\	specific to us	( addr bitmask -- )
Code toggle
	swpb TOS
	mov *SP+ , T1
	movb *T1 , T2
	xor TOS , T2
	movb T2 , *T1
	POP
	NEXT
end-code

Code @
	mov	*TOS , TOS
	NEXT
end-code

Code C@
	movb *TOS , TOS
	srl TOS , 8 #
	NEXT
end-code

Code !
	mov *SP+ , *TOS
	POP
	NEXT
end-code

Code C!
	movb 1 @>(SP) , *TOS
	inct SP
	POP
	NEXT
end-code

\	Order says that highest word on stack goes
\	at lower address.
Code D!
	mov *SP+ , *TOS+
	mov *SP+ , *TOS+
	POP
	NEXT
end-code	

Code D@
	dect SP
	mov 2 @>(TOS) , *SP
	mov *TOS , TOS
	NEXT
end-code

Code 1+
	inc TOS
	NEXT
end-code

Code 2+
	inct TOS
	NEXT
end-code

Code 2*
	a	TOS , TOS
	NEXT
end-code

Code 2/
	mov TOS , TOS
	jgt 1 $f
	inc TOS
1 $:
	sra TOS , 1 #
	NEXT
end-code

Code 1-
	dec TOS
	NEXT
end-code

Code 2-
	dect TOS
	NEXT
end-code

Code -
	s	TOS , *SP
	POP
	NEXT
end-code

\	!!! =cells (C_EqC) changed to ALIGNED
Code ALIGNED
	inc TOS
	andi TOS , $fffe #
	NEXT
end-code

Code CELLS
	a 	TOS , TOS
	NEXT
end-code

Code CELL+
	inct TOS
	NEXT
end-code

Code CHARS
	NEXT
end-code

Code CHAR+
	inc TOS
	NEXT
end-code

Code S>D
	PUSH
	sra TOS , $0f #
	NEXT
end-code

\	double
Code D>S
	POP
	NEXT
end-code

Code ABS
	abs TOS
	NEXT
end-code

Code MIN 
	c	*SP , TOS
	jgt	0 $f
	mov *SP , TOS
0 $: 0POP
	NEXT
end-code

Code MAX
	c	*SP , TOS
	jlt 0 $f
	mov	*SP , TOS
0 $: 0POP
	NEXT
end-code

Code U<
	mov TOS , T1
	clr TOS
	c	*SP+ , T1
	jhe 1 $f
	inv TOS
1 $: NEXT
end-code

Code U>
	mov TOS , T1
	clr TOS
	c 	*SP+ , T1
	jle	1 $f
	inv	TOS
1 $: NEXT
end-code

Code <
	mov TOS , T1
	seto TOS
	c	*SP+ , T1
	jlt 1 $f
	clr TOS
1 $:
	NEXT
end-code
test" < 9 9 < 0="
test" < 45 56 <"
test" < -45 56 <"
test" < -56 -45 <"

Code <=
	mov TOS , T1
	clr TOS
	c	*SP+ , T1
	jgt 1 $f
	seto TOS
1 $:
	NEXT
end-code

Code >
	mov TOS , T1
	seto TOS
	c	*SP+ , T1
	jgt 1 $f
	clr TOS
1 $:
	NEXT
end-code
test" > 8 8 > 0="
test" > 9 8 >"
test" > 7 8 > 0="
test" > 56 45 >"
test" > 56 -45 >"
test" > -45 -56 >"

Code >=
	mov TOS , T1
	clr TOS
	c	*SP+ , T1
	jlt 1 $f
	seto TOS
1 $:
	NEXT
end-code

Code =
	mov TOS , T1
	seto TOS
	c	*SP+ , T1
	jeq	1 $f
	clr TOS
1 $: NEXT
end-code
test" = 5 6 = 0="

Code <>
	mov TOS , T1
	seto TOS
	c	*SP+ , T1
	jne	1 $f
	clr TOS
1 $: NEXT
end-code
test" <> 5 6 <>"
test" <> 13 13 <> 0="

Code D=
	mov TOS , T1
	seto TOS
	c	4 @>(SP) , *SP		\ low word more likely to differ
	jne	1 $f
	c	2 @>(SP) , T1
	jeq 2 $f
1 $: clr TOS 
2 $: ai SP , 6 #
	NEXT
end-code	
test" d= 45. 23382838. d= 0="
test" d= 2938484. 2dup d="

Code WITHIN	( test low high -- flag)
	mov TOS , T1
	s *SP , T1		\ magnitude of range
	mov 2 @>(SP) , T2
	s *SP , T2		\ test - low
	ai SP , 4 #		\ cleanup stack
	seto TOS		
	c T2 , T1		\ (test-low) < range?
	jle 1 $f
	clr TOS
1 $:  
	NEXT
end-code

\ \\\\\\\\\\\\\\\\

: (boot)
	(cold)
;

Code ((cold))
1 $:
\	dbg

	\ temporary!
	li RP , 3020 #
	li SP , 3040 #

	li rNEXT R , ' @Next #

has? standard-threading [IF]
	li WA , ' (boot) #
	li IP , ' (boot) >body #

	\ infinite loop
	limi 1 #

	b 	' ExEntry @>
[ELSE]
	li	R11 , ' (boot) 2 +  #	\ !!
	li DODOES , ' :dodoes #
	li DOCOL , ' :docol #
	\ infinite loop
	limi 1 #

	b	rDOCOL *R
[ENDIF]

end-code

code BYE
	blwp 0 @>
end-code

: clearstack
	sp0 @ sp!
;

: (clrsrc)
	0 blk ! 0 loadfile ! 0 loadline !
;

: (quit)
	clearstack 
	(clrsrc)
	quit
;

: ABORT
	." aborted" cr
\	forth definitions			\ !!!
	(quit)
;

Code ((abort))
has? standard-threading [IF]
	li WA , ' ABORT #
	li IP , ' ABORT >body #
	b 	' ExEntry @>
[ELSE]
	li	R11 , ' ABORT 2 +  #	\ !!
	b	rDOCOL *R
[ENDIF]

end-code


has? standard-threading [if]
' ((cold)) >body
' ((abort))  >body
[else]
' ((cold))
' ((abort))
[then]

[[ ROM-start-addr ]] 2 + !		\ break
[[ ROM-start-addr ]] 0 + !		\ boot







