\	Equates global to V9t9 FORTH
\

>cross also assembler \ also T assembler H also cross
order cr ." woowo"
\ only forth also assembler definitions
\ cr order cr cr

>assembler
$0E	constant	rRP		\ return stack pointer
$0F	constant	rSP		\ stack pointer
$0D	constant	rIP		\ instruction pointer
\ $0C not assigned: CRU stuff
\ $0B not assigned: BL return val
\ env-has? standard-threading [if]
T has? standard-threading H [if]
$08	constant	rWA		\ work address
[else]
$08	constant	rDOCOL	\ ptr to DOCOL
$07 constant	rDODOES	\ ptr to DODOES
[then]
$06	constant	rNEXT	\ ptr to NEXT
$05	constant	rT4		\ temp #4
$04	constant	rT3		\ temp #3
$03	constant	rT2		\ temp #2
$02	constant	rT1		\ temp #1
$01	constant	rTOS	\ top of stack

also assembler
rTOS R:	TOS		rTOS *R: *TOS	rTOS *R+: *TOS+		rTOS @>(R):	@>(TOS)
rT1 R:	T1		rT1 *R: *T1		rT1 *R+: *T1+		rT1 @>(R):	@>(T1)
rT2 R:	T2		rT2 *R: *T2		rT2 *R+: *T2+		rT2 @>(R):	@>(T2)
rT3 R:	T3		rT3 *R: *T3		rT3 *R+: *T3+		rT3 @>(R):	@>(T3)
rT4 R:	T4		rT4 *R: *T4		rT4 *R+: *T4+		rT4 @>(R):	@>(T4)
rRP	R:	RP		rRP	*R:	*RP		rRP *R+: *RP+		rRP	@>(R):	@>(RP)
rIP	R:	IP		rIP	*R:	*IP		rIP *R+: *IP+		rIP	@>(R):	@>(IP)
rSP	R:	SP		rSP	*R:	*SP		rSP *R+: *SP+		rSP	@>(R):	@>(SP)
\ rNEXT R: NEXT	rNEXT *R: *NEXT	\ rNEXT *R+: *NEXT+	rNEXT @>(R):	@>(NEXT)

\ env-has? standard-threading [if]
T has? standard-threading  <A> [if]

rWA	R:	WA		rWA *R+: *WA+
[else]
rDODOES R: DODOES
rDOCOL R: DOCOL
[endif]

1	constant	USING-TOS	\ caching TOS or using pure stack?
1	constant	THREADED	\ standard threading?

\	push TOS to stack 
: PUSH
	dect SP
	mov TOS , *SP
; immediate

\	pop TOS from stack
: POP
	mov *SP+ , TOS
; immediate

\	drop and pop TOS from stack
: POP2
	inct SP
	mov *SP+ , TOS
; immediate

\	drop 2 and pop TOS from stack
: POP3
	ai SP , 4 #
	mov *SP+ , TOS
; immediate

\	drop, not changing TOS
: 0POP
	inct SP
; immediate

\	drop 2, not changing TOS
: 0POP2
	ai SP , 4 #
; immediate

\ env-has? inlining-next [if]
\ 	env-has? standard-threading [if]
T has? inlining-next <A> [if]
 	T has? standard-threading <A> [if]
		: NEXT
			mov *IP+ , WA
			mov *WA+ , R0
			b	*R0
		;	immediate
	[else]
		: NEXT
			mov *IP+ , R0
			b	*R0
		;	immediate
	[endif]
[else]
	: NEXT
		b 	rNEXT *R
	; 	immediate
[endif]

previous

>cross

: VECTOR ( ip wp -- )
	T ,  , H
;

: vector! ( ip wp addr -- )
	dup >r T ! H r> T ! H
;


