#include <signal.h>
#include <fcntl.h>
#include <unistd.h>
#include <sys/time.h>

#include "Xv9t9.h"

#include "v9t9_common.h"
#include "system.h"
#include "timer.h"
#include "v9t9.h"

#include "command_rl.h"
#include "moduleconfig.h"
#include "v9t9_module.h"

#include "unixmain.h"

#if defined(X_WIN_VIDEO) && defined(X_WIN_KEYBOARD)

#define _L	 LOG_INTERNAL | LOG_INFO

#include "xlibrsrc.h"

#define SIZEOF_OPS	4
XrmOptionDescRec xlib_opTable[SIZEOF_OPS] = {
	 {"-geometry", 	".geometry", 	XrmoptionSepArg, (XPointer) NULL},
	 {"-xrm", 		NULL, 			XrmoptionResArg, (XPointer) NULL},
	 {"-display", 	".display", 	XrmoptionSepArg, (XPointer) NULL},
	 {"-iconic", 	"*iconStartup", XrmoptionNoArg,  (XPointer) NULL},
};

XrmDatabase xlib_rDB;

extern Display *x11_dpy;
extern Window vwin;
extern int  x11_screen;

void xlib_get_resources(const char *appname, XrmDatabase cmdlineDB)
{
	XrmDatabase homeDB, serverDB, appDB;
	char filenamebuf[1024];
	char *str;

	/*	Get merged resource database  */

	/*	Read app-defaults... */
	strcpy(filenamebuf, "/usr/lib/X11/app-defaults/");
	strcat(filenamebuf, appname);
	appDB = XrmGetFileDatabase(filenamebuf);
	if (appDB) XrmMergeDatabases(appDB, &xlib_rDB);

	/*	Read server defaults... */
	if ((str = XResourceManagerString(x11_dpy)) != NULL) {
		serverDB = XrmGetStringDatabase(str);
	} else {
		/* Open .Xdefaults file */
		strcpy(filenamebuf, (str = getenv("HOME")) ? str : ".");
		strcat(filenamebuf, "/.Xdefaults");
		serverDB = XrmGetFileDatabase(filenamebuf);
	}
	if (serverDB) XrmMergeDatabases(serverDB, &xlib_rDB);

	/*	Get local defaults for server */
	if ((str = getenv("XENVIRONMENT")) == NULL) {
		int len;
		strcpy(filenamebuf, (str = getenv("HOME")) ? str : ".");
		strcat(filenamebuf, "/.Xdefaults-");
		len = strlen(filenamebuf);
		gethostname(filenamebuf+len, sizeof(filenamebuf)-len);
		str = filenamebuf;
	}
	homeDB = XrmGetFileDatabase(str);
	if (homeDB) XrmMergeDatabases(homeDB, &xlib_rDB);

	/*	Command line is priority */
	if (cmdlineDB) XrmMergeDatabases(cmdlineDB, &xlib_rDB);
}

/*
 *	Initialize what we can and return 1 if we are to use
 *	the xlib loop.
 */	
int
xlib_system_init(void)
{
	XrmDatabase cmdlineDB = 0;
	XrmValue    value;
	char 		*display;
	char        *str_type[20];

	/*  Read command-line args */
	XrmParseCommand(&cmdlineDB, xlib_opTable, SIZEOF_OPS, 
					OS_GetFileNamePtr(v9t9_argv[0]), 
					&v9t9_argc, v9t9_argv);

	/* Initialize X context */
	if (XrmGetResource(cmdlineDB, "v9t9.display", "V9t9.Display",
						str_type, &value)) {
		display = (char *)value.addr;
	} else {
		display = NULL;
	}

	if ((x11_dpy = XOpenDisplay(display)) == NULL) {
		logger(_L | LOG_USER, "Cannot connect to X server '%s'\n",
			XDisplayName(display));
		return 0;
	}

	xlib_get_resources(OS_GetFileNamePtr(v9t9_argv[0]), cmdlineDB);

	x11_screen = DefaultScreen(x11_dpy);

	return 1;
}

int
xlib_system_loop(void)
{
	XEvent      Event;
	int			ret;

	while (1) {
		while (TM_Ticked) {
			TM_TickHandler(0);
//			TM_Ticked--;
			TM_Ticked = 0;
		}
		while (XCheckWindowEvent(x11_dpy, vwin, ~0, &Event)) {
			logger(_L | L_2, "Event = %d\n\n\n", Event.type);
			x_handle_kbd_event(&Event);
			x_handle_video_event(&Event);
		}
//		XSync(x11_dpy, False);

		ret = v9t9_execute();
		if (ret == em_TooFast)
			unix_system_pause();
		else if (ret == em_Quitting || ret == em_Dying)
			break;
	}
	return ret == em_Dying;
}

#endif	// defined(X_WIN_VIDEO) && defined(X_WIN_KEYBOARD)
