
/*


*/

#ifndef __SPEECH_H__
#define __SPEECH_H__

#include "16bit.h"
#include "command.h"

#include "centry.h"

extern	char	speechromfilename[64];

extern 	void	speech_memory_init(void);

extern 	u16		speech_mmio_get_addr(void);
extern 	void	speech_mmio_set_addr(u16 addr);
extern	bool 	speech_mmio_addr_is_complete(void);

extern	void	speech_mmio_write(u8 val);
extern	s8		speech_mmio_read(void);

struct	tms5200
{
	u8	status;		/* as returned via read-status */
#define	SS_TS	0x80	/* talk status */
#define SS_BL	0x40	/* buffer low */
#define	SS_BE	0x20	/* buffer empty */
#define SS_SPEAKING 1	/* internal */

	u8	gate;		/* how do we route Writes and Reads? */
#define GT_WCMD	0x1		/* write -> command */
#define GT_WDAT	0x2		/* write -> speech external data */
#define	GT_RSTAT 0x4	/* read -> status */
#define GT_RDAT	0x8		/* read -> data */	

	u32	addr;		/* address -- 20 bits */

	u8	fifo[16];	/* fifo buffer */
	u8	out,in;		/* ptrs.  out==in --> empty */
	u8	len;		/* # bytes in buffer */
	
	u8	bit;		/* bit offset of whatever we're reading */
	u8	bits;		/* # bits read */
	
	u8	command;	/* last command */
	u8	data;		/* data register for reading */	
	
	u8	timeout;	

	int addr_pos;	/* for debugger: position of address (0=complete) */

};

/*	One equation uses this struct  */
struct	LPC
{
	int		rpt;				/* repeat */
	int		pnv,env;			/* pitch, energy new value */
	int		pbf,ebf;			/* pitch, energy buffer */
	int		knv[12],kbf[12];	/* K new values, buffer */

	u8		decode;			/* speech flags */
#define FL_unvoiced 1		/* unvoiced? */
#define FL_nointerp 2		/* no interpolation */
#define FL_first	4		/* first frame? */
#define FL_last		8		/* stop frame seen */

	int		b[12],y[12];	/* lattice filter */
	u32		ns1,ns2;		/* unvoiced hiss registers */
	int		ppctr;			/* pitch counter */
};

//extern	u8	*speechrom;
//extern	u32	*spchaddr;

#define SPEECHABLE (FE_SPEECH|FE_PLAYSPEECH)
#define PLAYSPEECH ((features&SPEECHABLE)==SPEECHABLE)

int	speech_preconfiginit(void);
int	speech_postconfiginit(void);
int speech_restart(void);
void speech_restop(void);
void speech_shutdown(void);

void	speech_intr(void);

DECL_SYMBOL_ACTION(speech_machine_state);

#include "cexit.h"

#endif
