#ifndef __MIX_SERVER_H__
#define __MIX_SERVER_H__

/*		MIXER SERVER		*/

/*	This is a OS-generic module for mixing digitized samples together. 
	Internally, it operates as a 24-bit mixer, scaled down to the desired
	format.
*/

#include "16bit.h"
#include "clstandardtypes.h"

#include "centry.h"

/*	values for the channel argument. */
enum
{
	mix_CHN0, mix_CHN1, mix_CHN2, mix_Noise, 	/* tone channels */
	mix_Speech,									/* data channels */
	mix_AudioGate								/* toggle channels */
};

typedef struct 
{
	s8		*data;					/* circular buffer (may be NULL) */
	u32		len, used;				/* total alloc'd len */
	u32		st, en;					/* start and end of buffer */
	u32		div, delta, clock, vol;	/* timing info */
	u32		iswhite, ns1, ns2;		/* noise info */
}	sample;

// v0-v2 are tones
// v3 is noise
// v4 is speech
// v5 is audio gate
typedef struct
{
	sample	voices[6];
	u32		soundhz;
	s32		*buffer;
	u32		bufsize;
	bool	issigned, eightbit, swapendian;
}	mix_context;

void 	mix_init(mix_context *m, u32 hertz, u32 bufsize,
				bool issigned, bool eightbit, bool bigendian);
void 	mix_term(mix_context *m);
void 	mix_restart(mix_context *m);

void	mix_mixit(mix_context *m, u32 advance, u32 samples);
void	mix_advance(mix_context *m, int samples);

void 	mix_handle_voice(mix_context *m, u8 channel, u32 hertz, u8 volume);
void 	mix_handle_noise(mix_context *m, u8 channel, u32 hertz, u8 volume, 
						 int iswhite);
void 	mix_handle_data(mix_context *m, u8 channel, u32 hertz, u8 volume, 
						u32 len, s8 *data);

void	mixer_init_commands(void);

#include "cexit.h"

#endif
