
/*
	DSR (device service routine) emulation.  All devices that
	conform to the TI standard file API have hardware
	emulation (through CRU traps) and possibly software
	emulation (through the DSR routine).
	
	The way to add a new DSR is:  (1) make a new CRU module
	for the I/O address space (like >1200...>12FF).  The handler
	for SBO >0 should turn on the ROM for the DSR at >4000 and
	update currentdsr.  See examples.  (2) possibly add a handler
	
*/

#ifndef __DSR_H__
#define __DSR_H__

#include "centry.h"

void	dsr_set_active(vmModule *dsrmodule);

int		dsr_get_disk_count(void);		

// disks 1..x are valid for these calls

#ifdef REAL_DISK_DSR
int		dsr_is_real_disk(int disk);		// disk==1..5
#endif

#ifdef EMU_DISK_DSR
int		dsr_is_emu_disk(int disk);		// disk==1..5
#endif

const char *dsr_get_disk_info(int disk);
int   	dsr_set_disk_info(int disk, const char *path);

extern OSPathSpec emudiskpath[5];

extern char *diskimagepath;
extern char diskname[3][OS_NAMESIZE];

#include "cexit.h"

#endif
