
/*
	DSR rom

*/

#include "v9t9_common.h"
#include "dsr.h"
#include "9900.h"
#include "memory.h"
#include "moduleconfig.h"
#include "config.h"
#include "opcode_callbacks.h"

static vmModule *active = NULL;

void
dsr_set_active(vmModule * module)
{
	if (!module)
		active = NULL;
	else {
		if (module->type != vmTypeDSR)
			logger(LOG_FATAL | LOG_INTERNAL,
				   "dsr_set_active:  trying to install bogus module");
		active = module;
	}
}

void
emulate_dsr(void)
{
	u16         callpc = pc - 2;
	u16			opcode = memory_read_word(callpc);
	u16			crubase = memory_read_word(0x83D0);

	if (callpc >= 0x4000 && callpc < 0x6000) {
		u32         base;

		/*  Only respond if we have an active module whose
		   base matches that which DSRLNK is currently scanning. */
		if (active && active->m.dsr->getcrubase(&base) == vmOk
			&& crubase == base) {
			logger(LOG_CPU | LOG_INFO | L_1, "emulate_dsr:  pc = %d [%4X]\n",
				   callpc, opcode);

			// on success, return to DSR handler, to return an
			// error or otherwise terminate instead of continuing
			// to scan CRU bases
			if (active->m.dsr->filehandler(opcode - OP_DSR) == vmOk) {
				pc = register (11);
			}
		}
	}
}

int dsr_get_disk_count(void)
{
#ifdef EMU_DISK_DSR
	if (emuDiskDSR.runtimeflags & vmRTInUse)
		return 5;
#endif
#ifdef REAL_DISK_DSR
	if (realDiskDSR.runtimeflags & vmRTInUse)
		return 3;
#endif
	return 0;
}

#ifdef REAL_DISK_DSR
int dsr_is_real_disk(int disk)
{
	if (realDiskDSR.runtimeflags & vmRTInUse)
#ifdef EMU_DISK_DSR
		if (emuDiskDSR.runtimeflags & vmRTInUse)
			return disk == 1 || disk == 2;
		else	
#endif
			return disk >= 1 && disk <= 3;
	else
		return 0;
}
#endif

#ifdef EMU_DISK_DSR
int dsr_is_emu_disk(int disk)
{
	if (emuDiskDSR.runtimeflags & vmRTInUse)
#ifdef REAL_DISK_DSR
		if (realDiskDSR.runtimeflags & vmRTInUse)
			return disk >= 3 && disk <= 5;
		else
#endif
			return disk >= 1 && disk <= 5;
	else
		return 0;
}
#endif

const char *dsr_get_disk_info(int disk)
{
#ifdef REAL_DISK_DSR
	if (dsr_is_real_disk(disk))
		//return OS_NameSpecToString1(&diskname[disk-1]);
		return diskname[disk-1];
	else 
#endif
#ifdef EMU_DISK_DSR
	if (dsr_is_emu_disk(disk))
		return OS_PathSpecToString1(&emudiskpath[disk-1]);
	else
#endif
		return 0L;
}

int	dsr_set_disk_info(int disk, const char *path)
{
	char command[1024];
#ifdef REAL_DISK_DSR
	if (dsr_is_real_disk(disk)) {
		snprintf(command, sizeof(command), "DiskImage%d = \"%s\"\n", disk, escape(path,0));
		return command_parse_text(command);
	}
#endif
#ifdef EMU_DISK_DSR
	if (dsr_is_emu_disk(disk)) {
		snprintf(command, sizeof(command), "DSK%dPath = \"%s\"\n", disk, escape(path,0));
		return command_parse_text(command);
	}
#endif
	return 0;
}
