
#ifndef __CONFIG_H__
#define __CONFIG_H__

#include "command.h"

/*
 *	Escape an outgoing quoted string
 */
char *escape(const char *str, int quote);

DECL_SYMBOL_ACTION(load_config);
DECL_SYMBOL_ACTION(save_config);
DECL_SYMBOL_ACTION(load_session);
DECL_SYMBOL_ACTION(save_session);

int 
config_load_spec(const OSSpec *spec, bool session);
int 
config_save_spec(const OSSpec *spec, bool session);
int
config_find_file(const char *filename, const char *path, OSSpec *spec);
int 
config_load_file(const char *path, const char *filename, bool session);
int 
config_save_file(const char *path, const char *filename, bool session);

#endif
