
/*	Parser file for configuration engine */

%{

#include <stdarg.h>
#include <stdlib.h>
#include <string.h>

#include "StringUtils.h"
#include "xmalloc.h"
#include "command.h"
#include "command_parser.h"

#include "log.h"
#define _L	LOG_COMMANDS|LOG_INFO

//#define YYDEBUG 1
#define YYERROR_VERBOSE 1

int yyerror(char *s);
int yylex(void);

extern command_symbol_table *command_scope;

extern void lexer_error(char *format, ...);

#define  ASSIGNSTMT(x,y)	do { if (x.u.sym) \
								command_set_args(NULL, x.u.sym, &y, NULL); \
							} while (0)
						
#define  ASSIGN(z,x,y)	do { if (!x.u.sym || \
							!command_set_args(&z, x.u.sym,&y, NULL)) \
								  z.type = ca_VOID; } while (0)

#define  NUMBINOP(z,px,x,n,OP,py,y)	do { if (x.type == y.type && x.type == ca_NUM) { \
								z.type = ca_NUM; \
								z.u.num = px x.u.num OP py y.u.num; \
							} else { \
								parse_error("expected numeric arguments for '" n "'"); \
							  	z.type = ca_VOID; \
							} } while (0)

#define  NUMUNOP(z,n,OP,px,x) do { if (x.type == ca_NUM) { \
								z.type = ca_NUM; \
								z.u.num = OP px x.u.num ; \
							} else { \
								parse_error("expected numeric argument for '" n "'"); \
							  	z.type = ca_VOID; \
							} } while (0)

%}

%union 
{
	command_exprval		expr;
	command_symbol *sym;
}

%token <expr>	NUM
%token <expr>	STRING
%token <expr>	IDSTRING
/*
%token <expr>	ID
*/
%token <expr>	ERR

%token LSHIFT
%token RSHIFT
%token COMPLE
%token COMPGE
%token COMPEQ
%token COMPNE
%token COMPAND
%token COMPOR
%token COMPXOR

%token PRINT

%type <expr>	comma
%type <expr>	expr
%type <expr>	atom
%type <expr>	unary
%type <expr>	term
%type <expr>	comp
%type <expr>	shift
%type <expr>	factor
%type <expr>	cond
%type <expr>	logcond
%type <expr>	binlogcond
%type <expr>	assign assignline id
%type <expr>	compeq

%right '='
%left '-' '+' '&'
%right '*' '/' '|'
%left NEG

%%

input:	/* empty */
		| input line
;

eol:	';'
		| '\n'

line:	/* empty */
		| assignstmt
		| printstmt
		| eol
;

printstmt: PRINT printexprlist { logger(_L|LOG_USER, "\n"); }
;

printexprlist: 	/* empty */
			| printexprlist expr { if ($2.type == ca_NUM) logger(_L|LOG_USER, "%d", $2.u.num);
								else if ($2.type == ca_STRING) { 
									logger(_L|LOG_USER, "%s", $2.u.str); xfree($2.u.str); }
								}
;


expr:	assign				{ $$=$1; }
;

id:		IDSTRING			{ 
				char *str = $1.u.str;
				if (command_match_symbol(command_scope, str, &$$.u.sym))
				{
					$$.type = ca_SYM;
//					logger(_L | LOG_USER, "got an ID (%s)\n", str);
				}
				else
				{
								logger(_L |LOG_USER|LOG_ERROR, "unknown identifier '%s'\n", 
										str);
								$$.type = ca_SYM;
								$$.u.sym = NULL;
				}
							}


assignstmt:	id '=' comma { ASSIGNSTMT($1, $3);  }
/*
			| id		 {
								if ($1.u.sym != NULL) 
								   command_set_args(NULL, $1.u.sym, NULL);
						}
*/
			| assignline	{ $1.type = ca_VOID; }
/*			| cond  		{ if ($1.type != ca_VOID) 
								logger(_L|LOG_USER, "<%s thrown away>\n", ca_types[$1.type]); 
								}*/
;

	/* invoke string as a command with arguments */
assignline: id expr expr expr expr expr expr {
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, &$3, &$4, &$5, &$6, &$7, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

			| id expr expr expr expr expr {
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, &$3, &$4, &$5, &$6, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

			| id expr expr expr expr	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, &$3, &$4, &$5, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

			| id expr expr expr {
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, &$3, &$4, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

			| id expr expr		{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, &$3, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

			| id expr 		{ 
								 if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$2, NULL)) {
										$$.type = ca_VOID;	// error case
									}
								}
			| id		 {
								if ($1.u.sym != NULL) 
								   command_set_args(NULL, $1.u.sym, NULL);
						}


comma: 	cond					{ $$ = $1; }
		| comma ',' cond		{ NUMBINOP($$,,$1,",",|,,$3);
								 }
;

/* comma does not use this */
assign:		/* invoke ID with an argument */
			id '=' assign		{ ASSIGN($$, $1, $3); }
			| cond				{ $$ = $1; }
;

cond:		logcond				{ $$ = $1; }
			| logcond '?' expr ':' cond {
								if ($1.type == ca_NUM && $1.u.num)
									$$ = $3;
								else if ($1.type == ca_NUM && !$1.u.num)
									$$ = $5;
								else if ($1.type == ca_STRING && *$1.u.str)
									$$ = $3;
								else if ($1.type == ca_STRING && !*$1.u.str)
									$$ = $5;
								else 
									parse_error("invalid arguments to '?:'");
									
								}
;

logcond:	binlogcond			{ $$ =  $1; }
			| logcond COMPAND binlogcond { NUMBINOP($$,,$1,"&&",&&,,$3);	}

			| logcond COMPOR binlogcond { NUMBINOP($$,,$1,"||",||,,$3); }

			| logcond COMPXOR binlogcond { NUMBINOP($$,!!, $1, "^^", !=, !!,$3); }
;

binlogcond:	compeq				{ $$ = $1; }
			| binlogcond '&' compeq	 { NUMBINOP($$,,$1, "&", &,,$3); }

			| binlogcond '|' compeq	 { NUMBINOP($$,,$1, "|", |,,$3); }

			| binlogcond '^' compeq	 { NUMBINOP($$,,$1, "^", ^,,$3); }
;

compeq:		comp					{ $$ = $1; }
			
			| compeq COMPEQ comp 	{ NUMBINOP($$,,$1,"==",==,,$3); }
			| compeq COMPNE comp 	{ NUMBINOP($$,,$1,"!=",!=,,$3); }
;

comp:		shift					{ $$ = $1; }

			| comp COMPLE shift 	{ NUMBINOP($$,,$1,"<=",<=,,$3); }

			| comp COMPGE shift 	{ NUMBINOP($$,,$1,">=",>=,,$3); }

			| comp '>' shift 		{ NUMBINOP($$,,$1,">",>,,$3); }

			| comp '<' shift 		{ NUMBINOP($$,,$1,"<",<,,$3); }
;								

shift:		factor					{ $$ = $1; }
			| shift LSHIFT factor 	{ NUMBINOP($$,,$1,"<<",<<,,$3); }
			| shift RSHIFT factor  	{ NUMBINOP($$,,$1,">>",>>,,$3); }

factor:		term					{ $$ = $1; }
			| factor '+' term 	{
								if ($1.type == ca_NUM && $3.type == ca_NUM) {
									$$.type = ca_NUM;
									$$.u.num = $1.u.num + $3.u.num;
								} else if ($1.type == ca_STRING && 
											$3.type == ca_STRING) {
									$$.type = ca_STRING;
									$$.u.str = (char *)xrealloc($1.u.str, 
												strlen($1.u.str) + strlen($3.u.str) + 1);
									strcat($$.u.str, $3.u.str);
									free($3.u.str);
								} else {
									$$.type = ca_VOID;
									parse_error("type mismatch in '+'");
								}
								}

			| factor '-' term 	{ NUMBINOP($$,,$1,"-",-,,$3); }
;

term:		 unary				{
								$$ = $1; 
								}
			| term '*' unary 	{ NUMBINOP($$,,$1,"*",*,,$3); }
			| term '/' unary 	{
								if ($1.type == ca_NUM && $3.type == ca_NUM) {
									$$.type = ca_NUM;
									if ($3.u.num <= $$.u.num / 65536) {
										parse_error("divide overflow in '/'");
										$$.u.num = 0;
									} else {
										$$.u.num /= $3.u.num;
									}
								} else {
									$$.type = ca_VOID;
									parse_error("expected numeric arguments for '/'");
								}
								}

;

unary:		atom				{ $$ = $1; }

			| '-' unary			{ NUMUNOP($$,"unary minus",-,,$2); }

			| '!' unary			{ NUMUNOP($$,"!",!,,$2); }

			| '~' unary			{ NUMUNOP($$,"~",~,,$2); }

;

atom:		 ERR				{ printf("!!! error !!!\n"); 
									yyerrok; }
			| NUM				{ //printf("!!! num (%d)\n",$1.u.num); 
									$$.type = ca_NUM; $$.u.num = $1.u.num; }

			| STRING			{ //printf("ID\n"); 	
									$$.type = ca_STRING; $$.u.str = $1.u.str;
								}
			| IDSTRING			{ 
									$$ = $1;
								}
								
				/* invoke ID as a function with no arguments
				 is disabled -- you must use (id) for this purpose.
				My grammar is bad somewhere; enabling this rule
				causes id to be overloaded as an LHS and RHS. */
/*			| id				{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}
*/

				/* invoke ID as a function with arguments */
			| id '(' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, NULL)) {
										$$.type = ca_VOID;	// error case
									}
								}
								

				/* invoke ID as a function with arguments */
			| id '(' expr ',' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, &$5, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

				/* invoke ID as a function with arguments */
			| id '(' expr ',' expr ',' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, &$5, &$7, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

				/* invoke ID as a function with arguments */
			| id '(' expr ',' expr ',' expr ',' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, &$5, &$7, &$9, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

				/* invoke ID as a function with arguments */
			| id '(' expr ',' expr ',' expr ',' expr ',' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, &$5, &$7, &$9, &$11, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}

				/* invoke ID as a function with arguments */
			| id '(' expr ',' expr ',' expr ',' expr ',' expr ',' expr ')'	{
								if ($1.u.sym == NULL) {
									$$.type = ca_VOID;	// error case
								} else if (!command_set_args(&$$, $1.u.sym, 
											&$3, &$5, &$7, &$9, &$11, &$13, NULL)) {
									$$.type = ca_VOID;	// error case
								}
								}


			| '(' id ')'  {
									if (!$2.u.sym || !command_get_val($2.u.sym, &$$)) {
										$$.type = ca_VOID;	// error case
									}
								}

			| '(' expr ')'	 	{
									$$ = $2;
								}

;


%%

void parse_error(const char *format, ...)
{
	va_list va;
	static char buf[256], *bptr;
	va_start(va, format);
	bptr = mvprintf(buf, sizeof(buf), format, va);
	lexer_error("%s", bptr);
}

int yyerror(char *s)
{
	parse_error("%s\n",s);
	return 0;
}

int	command_parse(command_symbol_table *universe)
{
	command_scope = universe;
	// ignore errors
	while (yyparse());
	return 1;
}

