#include "OSLib.h"

#include <string.h>
#include <stdio.h>
#include <string.h>
#if __MWERKS__ && __POWERPC__
#include <alloca.h>
#else
#include <malloc.h>
#endif
#include <ctype.h>

#include <stdlib.h>
#include <assert.h>

#include <Errors.h>		/* Mac error codes */

#include <clendian.h>
//#include "CLMemUtilities.h"

/*************************
	Mac filetype routines	 
 *************************/

//typedef struct FileTypeMappings FileTypeMappings;

static OSFileTypeMappings *defaultList = NULL;

static OSFileTypeMappings **fmList = &defaultList;

_DLL _PAS void	
OS_AddFileTypeMappingList(OSFileTypeMappings **list, const OSFileTypeMappingList *entry)
{
	OSFileTypeMappings **scan;
	
	if (list==NULL) list = fmList;
	
	scan = list;
	while (*scan)
		scan = &((*scan)->next);
	
	*scan = (OSFileTypeMappings *)malloc(sizeof(OSFileTypeMappings));
	assert(*scan != NULL);
	(*scan)->mappingList = entry;
	(*scan)->next = NULL;
}

_DLL _PAS void	
OS_UseFileTypeMappings(OSFileTypeMappings *list)
{
	fmList = list ? &list : &defaultList;
}

/* 
	Set Macintosh file type on an existing file.
	
	Uses table set up with OS_RegisterFileTypes; if type
	not found, text is assumed.
 */
_DLL _PAS void
OS_MacType_To_OSType(unsigned long mactype, OSFileType *type)
{
	OSFileTypeMappings *list;
	
	list = *fmList;
		
	while (list != NULL)
	{
		const OSFileTypeMappingList *scan = list->mappingList;
		int idx = 0;
		
		while (idx < scan->numMappings)
		{
			if (scan->mappings[idx].mactype==mactype)
		{
#if defined(WIN32_FS)

			memset((void *)type, 0, sizeof(*type));
			
#elif defined(BEWORKS_FS)

			char *mime;
			if (scan->mappings[idx].mimetype != NULL)
				strcpy(type->mime, scan->mappings[idx].mimetype);
			else
				*type->mime = 0;
			type->perm = scan->mappings[idx].executable ? 0777 : 0666;
			
#elif defined(POSIX_FS)

			type->perm = scan->mappings[idx].executable ? 0777 : 0666;
			
#elif defined(MAC_FS)

			*type = scan->mappings[idx].mactype;
			
#else
#error
#endif
			return;
		}				
			idx++;
		}
		
		list = list->next;
	}


#ifdef DEBUG
	if (mactype != 'TEXT' && mactype != 'rsrc')
	{
		fprintf(stderr, "OS_MacType_To_OSType:  unknown type '%c%c%c%c'\n", 
						GET_BIG_CHARS4(mactype));
	}
#endif
	
	*type = OS_TEXTTYPE;
}

/* 
	Set Macintosh file type on an existing file.
 */
_DLL _PAS OSError	
OS_SetMacFileType(const OSSpec *spec, unsigned long mactype)
{
	OSFileType type;
	
	OS_MacType_To_OSType(mactype, &type);
	return OS_SetFileType(spec, &type);
}


/*
	Get Macintosh file type.
	
	Do this by reading the magic word of the file and looking
	it up in our magic table.
	
	This routine assumes the worst about existing files, namely, that they
	have the wrong filetype set wherever possible.  Even when hosting on
	MacOS, we scan through the table, since we don't want to get caught
	returning an incorrect or outdated filetype, thus confusing the
	importer.
*/
int _PAS
(*__OS_ExtendedGetMacFileTypeHook)(const OSSpec *spec, unsigned long *mactype);

_DLL _PAS OSError	
OS_GetMacFileType(const OSSpec *spec, unsigned long *mactype)
{
	OSFileTypeMappings *list;
	
	OSRef ref;
	OSError err;
	char buffer[32];
	OSSize count;
	OSSize flen;

	if (OS_ISERR(err=OS_Open(spec, OSReadOnly, &ref)))
		return err;
		
	OS_GetSize(ref, &flen);
	count=32;
	err=OS_Read(ref, buffer, &count);
	
	OS_Close(ref);
	
	if (!OS_ISERR(err) && count>0)
	{	
		list = *fmList;
			
		while (list != NULL)
		{
			const OSFileTypeMappingList *scan = list->mappingList;
			int idx = 0;
				
			while (idx < scan->numMappings)
			{
				if (scan->mappings[idx].length <= count &&
					scan->mappings[idx].magic &&
					memcmp(buffer, scan->mappings[idx].magic, scan->mappings[idx].length)==0)
				{
					*mactype = scan->mappings[idx].mactype;
					return OS_NOERR;
				}
					else
						idx++;
			}
			
			list = list->next;
		}
	}
	
	if (__OS_ExtendedGetMacFileTypeHook == NULL ||
		!__OS_ExtendedGetMacFileTypeHook(spec,mactype))
	{
		/*  Try for a resource file. */
		
		if (flen == 0)
		{
			OSSpec rsrc;
			if (OS_GetRsrcOSSpec(spec, &rsrc, false) == OS_NOERR)
			{
				OSSize rsize;
				OSRef ref;
				if (OS_Open(&rsrc, OSReadOnly, &ref) == OS_NOERR)
				{
					OS_GetSize(ref, &rsize);
					if (rsize > 0)
					{
						*mactype = 'rsrc';
						return OS_NOERR;
					}
					OS_Close(ref);
				}
			}
		}
	
		*mactype = 'TEXT';
	}
	
	return OS_NOERR;
}

/*	set Macintosh creator and filetype */
_DLL _PAS OSError
OS_SetMacFileCreatorAndType(const OSSpec *spec, unsigned long maccreator, unsigned long mactype)
{
#if defined(MAC_FS)
	FInfo finfo;
	OSErr err;
	
	if ((err = HGetFInfo (spec->path.vRefNum, spec->path.parID, spec->name, &finfo)) != noErr)
		return err;
	
	finfo.fdType = mactype;
	finfo.fdCreator = maccreator;
	
	if ((err = HSetFInfo (spec->path.vRefNum, spec->path.parID, spec->name, &finfo)) != noErr)
		return err;
		
	return noErr;

#else

	// ignore creator
	
	return OS_SetMacFileType(spec, mactype);

#endif
}


