
/*
	Null video module.
*/

#include "v9t9_common.h"
#define _L LOG_USER|LOG_INFO

static      vmResult
nullvideo_detect(void)
{
	return vmOk;
}

static      vmResult
nullvideo_init(void)
{
	return vmOk;
}

static      vmResult
nullvideo_enable(void)
{
	return vmOk;
}

static      vmResult
nullvideo_disable(void)
{
	return vmOk;
}

static      vmResult
nullvideo_restart(void)
{
	logger(LOG_WARN|LOG_USER, "No video driver loaded\n");
	return vmOk;
}

static      vmResult
nullvideo_restop(void)
{
	return vmOk;
}

static      vmResult
nullvideo_term(void)
{
	return vmOk;
}

/**************/

static      vmResult
nullvideo_updatelist(struct updateblock *ptr, int num)
{
	return vmOk;
}

static      vmResult
nullvideo_resize(u32 newxsize, u32 newysize)
{
	return vmOk;
}

static      vmResult
nullvideo_setfgbg(u8 fg, u8 bg)
{
	return vmOk;
}

static      vmResult
nullvideo_setblank(u8 bg)
{
	return vmOk;
}

static      vmResult
nullvideo_resetfromblank(void)
{
	return vmOk;
}

/***********************************************************/

static vmVideoModule nullvideo_videoModule = {
	3,
	nullvideo_updatelist,
	nullvideo_resize,
	nullvideo_setfgbg,
	nullvideo_setblank,
	nullvideo_resetfromblank
};

vmModule    nullVideo = {
	3,
	"Null video",
	"vidNull",

	vmTypeVideo,
	vmFlagsExclusive,

	nullvideo_detect,
	nullvideo_init,
	nullvideo_term,
	nullvideo_enable,
	nullvideo_disable,
	nullvideo_restart,
	nullvideo_restop,
	{(vmGenericModule *) & nullvideo_videoModule}
};
