#include "v9t9_common.h"
#include "sound.h"

static      vmResult
nullspeaker_detect(void)
{
	return vmOk;
}

static      vmResult
nullspeaker_init(void)
{
	return vmOk;
}

static      vmResult
nullspeaker_term(void)
{
	return vmOk;
}

static      vmResult
nullspeaker_enable(void)
{
	return vmOk;
}

static      vmResult
nullspeaker_disable(void)
{
	return vmOk;
}

static      vmResult
nullspeaker_restart(void)
{
	logger(LOG_WARN|LOG_USER, "No sound driver loaded\n");
	return vmOk;
}

static      vmResult
nullspeaker_restop(void)
{
	return vmOk;
}

static vmSoundModule nullSoundModule = {
	3,
	NULL,
	NULL,
	NULL
};

vmModule    nullSound = {
	3,
	"Null sound",
	"sndNull",

	vmTypeSound,
	vmFlagsExclusive,

	nullspeaker_detect,
	nullspeaker_init,
	nullspeaker_term,
	nullspeaker_enable,
	nullspeaker_disable,
	nullspeaker_restart,
	nullspeaker_restop,

	{(vmGenericModule *) & nullSoundModule}
};
