
#include "v9t9_common.h"
#include "v9t9.h"

#include "timer.h"

#include "keyboard.h"
#define _L LOG_USER|LOG_INFO

static      vmResult
nullkeyboard_detect(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_init(void)
{
	features |= FE_KEYBOARD;
	return vmOk;
}

static      vmResult
nullkeyboard_enable(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_disable(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_restart(void)
{
	realshift = 0;
	memset(crukeyboardmap, 0, 6);
	crukeyboardmap[6] = crukeyboardmap[7] = 0x0;
	logger(LOG_WARN|LOG_USER, "No keyboard driver loaded\n");
	return vmOk;
}

static      vmResult
nullkeyboard_restop(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_term(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_scan(void)
{
	return vmOk;
}

static      vmResult
nullkeyboard_getspecialkeys(SpecialKey ** list)
{
	static SpecialKey none[] = { 0 };

	*list = none;
	return vmOk;
}

static vmKeyboardModule nullKbdModule = {
	3,
	nullkeyboard_scan,
	nullkeyboard_getspecialkeys
};

vmModule    nullKeyboard = {
	3,
	"Null keyboard",
	"kbdNull",

	vmTypeKeyboard,
	vmFlagsExclusive,

	nullkeyboard_detect,
	nullkeyboard_init,
	nullkeyboard_term,
	nullkeyboard_enable,
	nullkeyboard_disable,
	nullkeyboard_restart,
	nullkeyboard_restop,
	{(vmGenericModule *) & nullKbdModule}
};
