
/*
 *	Internal RS232 handler.
 *
 */

#include "v9t9_common.h"
#include "dsr_rs232.h"

#define _L 	LOG_RS232|LOG_INFO

int         
Init_RS232_SysDeps(void)
{
	return vmOk;
}

int
Enable_RS232_SysDeps(void)
{
	return vmOk;
}

int
Disable_RS232_SysDeps(void)
{
	return vmOk;
}

int
Term_RS232_SysDeps(void)
{
	return vmOk;
}

void
Reset_RS232_SysDeps(rs232regs * rs)
{
}


void
Set_CTRL_Register(rs232regs * rs)
{
	logger(_L|L_1, "Setting CTRL register to %04X\n", rs->ctrl);
}

void
Set_INVL_Register(rs232regs * rs)
{
	logger(_L|L_1, "Setting INVL register to %04X\n", rs->invl);
}

void
Set_RCVRATE_Register(rs232regs * rs)
{
	logger(_L|L_1, "Setting RCVRATE register to %04X\n", rs->rcvrate);
}

void
Set_XMITRATE_Register(rs232regs * rs)
{
	logger(_L|L_1, "Setting XMITRATE register to %04X\n", rs->xmitrate);

}

void
Set_Control_Bits(rs232regs * rs, u32 old, int bit)
{
	logger(_L|L_1, "Setting control bits to %04X\n", rs->wrport);
}

void
Transmit_Char(rs232regs * rs)
{
	logger(_L|L_1, "Transmitting char %02X (%c)\n", rs->txchar, rs->txchar);
}

void
Read_Status_Bits(rs232regs * rs)
{
	rs->rdport |= RS_RTS | RS_DSR | RS_CTS | RS_XBRE;
	logger(_L|L_2, "Reading status bits as %08X\n", rs->rdport);
}

void
Receive_Data(rs232regs * rs)
{
	rs->rdport = (rs->rdport & ~0xff) | '*';
	logger(_L|0, "Receiving char %02X (%c)\n", rs->rdport, rs->rdport);
}
