/*
	Portable TI99 tape encoder/decoder

	tifile.h: Header file for tifile.c

	Raphael Nabet 2002
*/

/*
	Disk structure:

	Sector 0: see below
	Sector 1: catalog: array of 0 through 128 words, number of the fdr sector for
		the file.  Sorted according to the file name.
	Remaining sectors are used for fdr and data.
*/

#if 0
/*
	Disk sector 0
*/
typedef struct sc0
{
	char name[10];				/* volume name (10 characters, pad with spaces) */
	unsigned char totsecsMSB;	/* disk length in sectors (big-endian) (usually 360, 720 or 1440) */
	unsigned char totsecsLSB;
	unsigned char secspertrack;	/* sectors per track (usually 9 or 18) */
	unsigned char id[4];		/* 'DSK ' */
	unsigned char tracksperside;/* tracks per side (usually 40) */
	unsigned char sides;		/* sides (1 or 2) */
	unsigned char density;		/* 1 (FM) or 2 (MFM) */
	unsigned char res[36];		/* reserved */
	unsigned char abm[200];		/* allocation bitmap: 1 for each sector in use (sector 0 is LSBit of byte 0, sector 7 is MSBit of byte 0, sector 8 is LSBit of byte 1, etc.) */
} sc0;
#endif

/*
	flags for fdr (and tifiles)
*/
enum
{
	fdr99_f_program	= 0x01,		/* set for program files */
	fdr99_f_int		= 0x02,		/* set for binary files */
	fdr99_f_wp		= 0x08,		/* set if file is write-protected */
	fdr99_f_var		= 0x80		/* set if file uses variable-length records*/
};

#if 0
/*
	fdr record: used on TI disks, and with v9t9 FIAD stand-alone files (FIAD fdr is only
	128-byte-long, and it does not include a link table)
*/
typedef struct fdr
{
	char name[10];			/* file name (10 characters, pad with spaces) */
	char res10[2];			/* reserved */
	char flags;				/* see above */
	char recspersec;		/* records per sector */
	char secsused_MSB;		/* file length in sectors (big-endian) */
	char secsused_LSB;
	char eof;				/* current position of eof in last sector (0->256)*/
	char reclen;			/* bytes per record ([1,255] 0->256) */
	char fixrecs_LSB;		/* file length in records (little-endian) */
	char fixrecs_MSB;
	char res20[8];			/* reserved */
	char lnks[256-28];		/* link table: 0 through 76 entries (0-terminated): 12 bits: sector #, 12 bits: length of fragment */
} fdr;
#endif

/*
	tifile header: stand-alone file 
*/
typedef struct tifile_header
{
	char tifiles[8];			/* always '\7TIFILES' */
	unsigned char secsused_MSB;	/* file length in sectors (big-endian) */
	unsigned char secsused_LSB;
	char flags;					/* see above */
	unsigned char recspersec;	/* records per sector */
	unsigned char eof;			/* current position of eof in last sector (0->256)*/
	unsigned char reclen;		/* bytes per record ([1,255] 0->256) */
	unsigned char fixrecs_MSB;	/* file length in records (big-endian) */
	unsigned char fixrecs_LSB;
	char unused[128-16];	/* reserved */
} tifile_header;


typedef enum { ftype_program, ftype_data } ftype_t;

typedef struct tifile_in_t tifile_in_t;

struct tifile_in_t
{
	FILE *handle;

	ftype_t type;
	int reclen;
	int secsused;
	int eof;
	int fixrecs;

	int cursec;
	int curpos;
};

typedef struct tifile_out_t tifile_out_t;

struct tifile_out_t
{
	FILE *handle;

	ftype_t type;
	unsigned int reclen;

	int fixrecs;
	int cursec;
	int curpos;
};

error_t open_tifile_in(FILE *handle, tifile_in_t *tifile, ftype_t default_type, unsigned int default_reclen);
extern error_t tifile_read(unsigned char *dest, tifile_in_t *tifile);

extern error_t open_tifile_out(FILE *handle, tifile_out_t *tifile, ftype_t type, unsigned int reclen);
extern error_t tifile_write(const unsigned char *src, tifile_out_t *tifile);
extern error_t close_tifile_out(tifile_out_t *tifile);

