/*
	Portable TI99 tape encoder/decoder

	common.h: Common include file

	Raphael Nabet 2002
*/

/*
	Look if we have C99
*/
#if defined(__STDC_VERSION__) && (__STDC_VERSION__ >= 199901L)
	#define C99 1
#else
	#define C99 0
#endif

/*
	Define various error codes
*/
typedef enum
{
	no_error = 0,

	invalid_parameters,			/* function parameters do not respect requirements */

	invalid_multi_record_tape,	/* the tape cannot be a multi-record tape */
	cant_auto_record_len,		/* a specific record lenght value is required */
	invalid_record_len,			/* provided record len cannot be correct */

	bad_wave_format,			/* wave file is incorrect */
	unsupported_wave_format,	/* wave file may be correct, but belongs to a type that the program does not support */

	cant_open,					/* can't open file */
	read_error,					/* error or unexpected EOF when reading file */
	write_error,				/* error when writing file */

	eof_error,					/* expected EOF when reading file */
	time_out,					/* timed out while looking for data */

	invalid_tifile_format,		/* TI file is incorrect */
	unsupported_tifile_format,	/* TI file cannot be converted to tape */

	error_string_len		/* total number of error codes */
} error_t;

#define DISPLAY_PROGRESS 1
