* Protocol implementation file
* Currently, only ICMP is implemented, and only the ECHO
* request is processed.
* TCP and UDP are detected, but not processed

* Author: Michael Zapf
* Created: 1998-06-06

* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301, USA
* http://www.fsf.org/licensing/licenses/gpl.html

***********************************************************************
* Defines:      ICMP, TCP, UDP
*               Called via: BLWP
*
* References:   symbols from SLIP0_X, IP2_X
*
* NOTE: In this version, ICMP accesses the slip driver directly.
* This is deprecated.

       DEF  ICMP,TCP,UDP
       REF  SL0OUT
       REF  SRCIP,DSTIP,CHKS1C

PROTWS BSS  32

ICMP   DATA PROTWS,ICMPST
TCP    DATA PROTWS,NOTIMP
UDP    DATA PROTWS,NOTIMP

NOTIMP RTWP                     Ignore it for this time

* ICMP protocol
* We have R1 as a pointer to the IP datagram
* and the length in R2

PINGRQ DATA >0800               Echo request
PINGRP DATA >0000               Echo reply

ICMPST MOV  @>0002(R13),R7
       MOV  @>0004(R13),R5

       MOV  R7,R4
       MOV  R7,R1
       AI   R4,20
       CB   *R4,@PINGRQ       Is it the Echo request?
       JNE  ICMPEN            Ignore otherwise.

* We build a new message just by modifying the received message.
* This is of course not possible in every case (we could need the
* data).
* The 'correct' way would be to build a new message by allocating
* some memory, copying the ICMP data in the message, put in the
* source and destination address and call the IP driver with
* the destination address and a pointer to this datagram as parameters.

       MOVB @PINGRP,*R4       Build new ICMP message: Echo reply
       CLR  @>0002(R4)        Clear ICMP checksum
       LI   R0,DSTIP
       AI   R1,12
       MOV  *R0+,*R1+         Swap destination address
       MOV  *R0,*R1+
       LI   R0,SRCIP
       MOV  *R0+,*R1+         with source address
       MOV  *R0,*R1

       MOV  R5,R2             Length of datagram
       AI   R2,-20            First 20 bytes are IP header
       MOV  R4,R1
       BLWP @CHKS1C           Calculate new checksum
       MOV  R3,@>0002(R4)

       MOV  R5,R2
       MOV  R7,R1
       BLWP @SL0OUT           Output the answer directly to the SLIP driver
ICMPEN RTWP

       END
