DECLARE SUB AlphaDir (DestDisk$)

' Import to TI99-PC image format a selection of DOS files
' Create a TI99-PC image file and transfer all selected files to it.
'
' - Paolo Bagnaresi, May 2001 - e-mail: paolo_bagnaresi@libero.it
'
' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.
DECLARE SUB ShowHex (A$, K$)
DECLARE SUB Fischio ()
DECLARE SUB ERRSOUND ()
DECLARE FUNCTION CalcWord% (A$, P%)
DECLARE SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
DECLARE SUB box (Y%, X%, W%, H%)
DECLARE SUB ShortName (A$)
DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

DEFINT A-Z
		
DIM DiskSize(1 TO 12)  AS INTEGER    ' Sectors per Disk. 360, 720, 1440, 2880
DIM SecTrack(1 TO 12)  AS INTEGER    ' Sector per Track. 9 or 18
DIM TrackSide(1 TO 12)  AS INTEGER   ' Track/side 40 or 80
DIM NumSides(1 TO 12)  AS INTEGER    ' Number of Sides. 1= Single Side, 2=Double Side
DIM DskDens(1 TO 12)  AS INTEGER     ' Disk Density. 1=Single Density, 2=Double Density
DIM LowestSect(1 TO 12)  AS INTEGER  ' Lowest sector where to begin to copy Data Sectors
DIM UpperABM(1 TO 12)  AS INTEGER    ' Highest byte in Allocation Bit Map in sector zero

DIM TmpRec AS STRING * 256	     ' Temporary string to read a sector from a Binary file

		DiskSize(1) = 360  ' Sectors per Disk.
		DiskSize(2) = 720
		DiskSize(3) = 720
		DiskSize(4) = 1440
		DiskSize(5) = 1440
		DiskSize(6) = 2880
		DiskSize(7) = 720
		DiskSize(8) = 1440
		DiskSize(9) = 1440
		DiskSize(10)= 2880
		DiskSize(11)= 2880
		DiskSize(12)= 5760
		
		SecTrack(1) = 9    ' Sector per Track. 9 or 18
		SecTrack(2) = 9
		SecTrack(3) = 18
		SecTrack(4) = 18
		SecTrack(5) = 36
		SecTrack(6) = 36
		SecTrack(7) = 9
		SecTrack(8) = 9
		SecTrack(9) = 18
		SecTrack(10) = 18
		SecTrack(11) = 36
		SecTrack(12) = 36
		
		
		
		
		
		TrackSide(1) = 40  ' Track/side 40 or 80
		TrackSide(2) = 40
		TrackSide(3) = 40
		TrackSide(4) = 40
		TrackSide(5) = 40
		TrackSide(6) = 40
		
		TrackSide(7) = 80
		TrackSide(8) = 80
		TrackSide(9) = 80
		TrackSide(10) = 80
		TrackSide(11) = 80
		TrackSide(12) = 80
		
		
		NumSides(1) = 1    ' Number of Sides. 1= Single Side, 2=Double Side
		NumSides(2) = 2
		NumSides(3) = 1
		NumSides(4) = 2
		NumSides(5) = 1
		NumSides(6) = 2
		NumSides(7) = 1
		NumSides(8) = 2
		NumSides(9) = 1
		NumSides(10) = 2
		NumSides(11) = 1
		NumSides(12) = 2
		
		
		
		DskDens(1) = 1     ' Disk Density. 1=Single Density, 2=Double Density, 3=High Density
		DskDens(2) = 1
		DskDens(3) = 2
		DskDens(4) = 2
		DskDens(5) = 3
		DskDens(6) = 3
		DskDens(7) = 1
		DskDens(8) = 1
		DskDens(9) = 2
		DskDens(10) = 2
		DskDens(11) = 3
		DskDens(12) = 3
		
		
		
		LowestSect(1) = 34 ' Lowest sector where to begin to copy Data Sectors
		LowestSect(2) = 34
		LowestSect(3) = 34
		LowestSect(4) = 34
		LowestSect(5) = 34
		LowestSect(6) = 130
		LowestSect(7) = 34
		LowestSect(8) = 34
		LowestSect(9) = 34
		LowestSect(10) = 130
		LowestSect(11) = 130
		LowestSect(12) = 258
		
		
		UpperABM(1) = 45   ' Highest byte in Allocation Bit Map in sector zero
		UpperABM(2) = 90
		UpperABM(3) = 90
		UpperABM(4) = 180
		UpperABM(5) = 180
		UpperABM(6) = 180   ' With 2880 sectors each bit counts for 2 adjacent sectors
		
		UpperABM(7) = 90
		UpperABM(8) = 180
		UpperABM(9) = 180
		UpperABM(10) = 180  ' With 2880 sectors each bit counts for 2 adjacent sectors
		UpperABM(11) = 180  ' With 2880 sectors each bit counts for 2 adjacent sectors
		UpperABM(12) = 180  ' With 5760 sectors each bit counts for 4 adjacent sectors
		
		DummyRec$ = STRING$(256, CHR$(&HE5))
		
DEFINT A-Z
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType
		

' Structure of RECORD 1 (96 bytes) in "Selected$" file
'+----------------+----------------+----------------+----------------+----------------+
'|  byte  1-20    |  byte  21-40   |  byte  41-60   |  byte  61-80   |  byte  81-96   |
'+----------------+----------------+----------------+----------------+----------------+
'|Pointer to Last | Total FILES    | Total SIZE     |     Total      |    Dummy       |
'| Used record    |                |                |  Directories   |    Field       |
'| as plain ASCII | as plain ASCII | as plain ASCII | as plain ASCII |                |
'+----------------+----------------+----------------+----------------+----------------+
'|  PntLastUsed%  | TotFiles2Copy% | TotSize2Copy&  |   TotDirs%     |                |
'|     Pntr       |      TFIL      |     TSIZ      |       TDir      |                |
'+----------------+----------------+----------------+----------------+----------------+

' Structure of Other Records (96 bytes) in "Selected$" file
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+
'|  byte  1       |  byte  2-80    |   81  |   82  |   83  |   84  |   85  |  byte  86-96   |
'+----------------+----------------+---------------------------------------+----------------+
'| Field Length=1 |      79        |    1  |    1  |    1  |    1  |    1  |       11       |
'+----------------+----------------+---------------------------------------+----------------+
'|   Copy Mark    |  DOS Filename  | File  | File  |  ARK  |Unused |Unused |   TI Filename  |
'| as plain ASCII | as plain ASCII | Type  | Length|SubFile|       |       |                |
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+
'|  CpyMark       |       SL       | DTyp  | DLen  | DArk  | DFre1 | DFre2 |   TINAME       |
'+----------------+----------------+-------+-------+-------+-------+-------+----------------+

' CpyMark = C,K, or 0-9. C=Copy; K=UnArk an Ark file.
' DArk    = Blank or K.  K=ARK Sub File, that is a TI file contained in an ARK or TIFILES Structure.
'                        Blank = Current File is not an Ark Subfile
' DTyp    = P=PROGRAM, V=DIS/VAR, F=DIS/FIX, v=INT/VAR, f=INT/FIX, TI File Type

		
		TYPE FHead
		Pntr AS STRING * 20
		TFIL AS STRING * 20
		TSIZ AS STRING * 20
		TDir AS STRING * 20
		Noth AS STRING * 16
		END TYPE
		DIM SHARED FiHeader AS FHead
		
		TYPE SelecType
		CpyMark AS STRING * 1
		SL AS STRING * 79
		DTyp AS STRING * 1
		DLen AS STRING * 1
		DArk AS STRING * 1
		DFre1 AS STRING * 1
		DFre2 AS STRING * 1
		TINAME AS STRING * 11
		END TYPE
		DIM SHARED Sel AS SelecType
		
		
		
		CLS
		SourcePath$ = MyName$(3)
		DestinPath$ = MyName$(5)
		FirstDestinPath$ = DestinPath$
' Get filename    
		FOR T% = LEN(DestinPath$) TO 1 STEP -1
		T$ = MID$(DestinPath$, T%, 1): IF T$ = "\" THEN A$ = (RIGHT$(DestinPath$, LEN(DestinPath$) - T%)): GOTO DskNFound
		NEXT T%
		A$ = DestinPath$
DskNFound:      A$ = RTRIM$(LTRIM$(A$))
		
' Do away with extension
		FOR T% = 1 TO LEN(A$)
		T$ = MID$(A$, T%, 1): IF T$ = "." THEN DskName$ = (LEFT$(A$, T% - 1)): GOTO DsknameFound
		NEXT T%
		DskName$ = A$
DsknameFound:   DskName$ = RTRIM$(LTRIM$(DskName$))
		IF LEN(DskName$) >8 THEN DskName$=LEFT$(DskName$,8)
		FOR T%=1 TO LEN(DskName$)
		T$ = MID$(DskName$, T%, 1): IF T$ = " " THEN MID$(DskName$,T%)="-"
		NEXT T
		
		
		REDIM FilName$(1)
		IF DestinPath$ = "" THEN DestinPath$ = SourcePath$: MID$(DestinPath$, LEN(DestinPath$), 1) = "1"
		Incr% = 1  ' File Output number
		GOTO OpenFile

' Exit point with F9
Abort:          'MyName$(2) = ""
		GOTO LeaveIt2

Leaveit:        'MyName$(2) = SourcePath$
LeaveIt2:       ERASE FilName$
		CLOSE #1
		CLOSE #2
		CLOSE #5
		CHAIN MyName$(0)

OpenFile:
		
		
		
		Selected$ = "~DOS2IB.TMP"
		' OPEN Selected$ FOR RANDOM ACCESS READ AS #5 LEN = LEN(Sel)
		GET #5, 1, FiHeader
		PntLastUsed% = VAL(FiHeader.Pntr)
		TotFiles2Copy% = VAL(FiHeader.TFIL)
		TotSize2Copy& = VAL(FiHeader.TSIZ)
		TotDirs% = VAL(FiHeader.TDir)
		IF TotFiles2Copy% = 0 THEN GOTO Leaveit
		TFNames% = TotFiles2Copy%
		

'==========================
' COPY DISK STARTS HERE
'==========================

StartCopying:
		CALL box(1, 3, 76, 24)

		IF MyVal(1) <> 0 THEN BEEP
		LOCATE 2, 28: PRINT "AVAILABLE DISK SIZES"
		LOCATE 4, 5: PRINT " 1)   90K  - SSSD   -  360 sectors -  9 sctr/trk - 40 tracks"
		COLOR  14,0
		LOCATE 5, 5: PRINT " 2)  180K  - DSSD   -  720 sectors -  9 sctr/trk - 40 tracks <"
		COLOR 7,0
		LOCATE 6, 5: PRINT " 3)  180K  - SSDD   -  720 sectors - 18 sctr/trk - 40 tracks"
		COLOR  14,0
		LOCATE 7, 5: PRINT " 4)  360K  - DSDD   - 1440 sectors - 18 sctr/trk - 40 tracks <"
		COLOR 7,0
		LOCATE 8, 5: PRINT " 5)  360K  - SSHD   - 1440 sectors - 36 sctr/trk - 40 tracks"
		LOCATE 9, 5: PRINT " 6)  720K  - DSHD   - 2880 sectors - 36 sctr/trk - 40 tracks"


		LOCATE 11, 5: PRINT " 7)  180K  - SSSD   -  720 sectors -  9 sctr/trk - 80 tracks"
		LOCATE 12, 5: PRINT " 8)  360K  - DSSD   - 1440 sectors -  9 sctr/trk - 80 tracks"

		LOCATE 13, 5: PRINT " 9)  360K  - SSQD   - 1440 sectors - 18 sctr/trk - 80 tracks"
		LOCATE 14, 5: PRINT " A)  720K  - DSQD   - 2880 sectors - 18 sctr/trk - 80 tracks"

		LOCATE 15, 5: PRINT " B)  720K  - SSHD   - 2880 sectors - 36 sctr/trk - 80 tracks"
		LOCATE 16, 5: PRINT " C) 1440K  - DSHD   - 5760 sectors - 36 sctr/trk - 80 tracks"



UsrChoice:      COLOR  14,0
		LOCATE 21, 5: PRINT " < marks the most common formats"
		COLOR 7,0
		LOCATE 19, 6
		PRINT "Your choice: ";
		DO
		T$ = INKEY$
		LOOP UNTIL T$ <> ""
		IF T$=CHR$(0) + CHR$(59) THEN CALL ThisHelp("HELP - GENERAL FILE", "Manual.dat", "Manual.idx", "18.04.03"): CLS: GOTO StartCopying
		IF T$ = CHR$(27) THEN GOTO Leaveit
		IF LEN(T$)>1 THEN GOTO StartCopying
		IF INSTR("abc",T$)>0 THEN T$=CHR$(ASC(RIGHT$(T$, 1) ) AND (255-32)) ' Force Uppercase
		Size=INSTR("123456789ABC",T$)
		IF Size=0 THEN GOTO StartCopying
		TmpSize = Size
		PRINT T$;
		
		' March 11, 2004 V9T9$ new variable. New default is V9T9 format.
		' IF V9T9$="" THEN do not add Error Table at the end of the file. It's useless anyway!
		' Add some code here if you want to give the user a chance to create an IMG format file.
		
'===================
' START COPYING
'===================
StartCopying2:
		CLS
		' Get all Filenames with vital parameters
		
'********************************=
' CURRENT FILENAME : START OF LOOP
'********************************=
		
		Skipped% = 0
		Done% = 0
		DisksRound% = 0
		FirstDisk$ = ""
		AtLeast$ = ""
		LowLimit% = INT(LowestSect(TmpSize) / 8)
		Remaindr% = LowestSect(TmpSize) MOD 8
		
		PRINT "Importing from DOS..."
		PRINT
'
' FIRST OFF, WORK OUT THE NUMBER OF FILES TO BE ARKED, IF ANY
'
		FOR Itm% = 1 TO PntLastUsed% - 1		
		GET #5, 1 + Itm%, Sel
		IF Sel.CpyMark = "K" THEN ARKTot% = ARKTot% + 1 
		NEXT Itm%
		IF ARKTot%=0 THEN GOTO PastToBeArked ' No file to be ARKed, skip this section
		GOSUB MakeOutfile : GOSUB CreateDisk: : AtLeast$ = "X" ' Create a new Disk Image File
		GOSUB ARKthese	' ARK these files and import them
PastToBeArked:
		SEEK #5,2 	' Reload Pointer to first record after the header record
		
' NOW, ADD ALL THE REMAINING FILES
		IF AtLeast$ = "" THEN SelStr$ = "0123456789C" ELSE SelStr$ = "C0123456789"
		FOR Order% = 1 TO LEN(SelStr$)
		Tell$ = MID$(SelStr$, Order%, 1)
		
		FOR Itm% = 1 TO PntLastUsed% - 1
		GET #5, 1 + Itm%, Sel
		IF MID$(Sel.SL, 1, 4) = "<DIR" THEN CurrArk$ = "": CurrPath$ = RTRIM$(MID$(Sel.SL, 7, LEN(Sel.SL))): GOTO NxtItm
		
		' ARK SubFiles are listed in a unique block in ~DOS2IB.TMP file. When we find an "<ARK>" entry, we have to:
		' - 1) Open the ARK file with the DECOMP4.COM DeArchiver, and output the unzipped content to the ~DOS2I2.TMP file.
		' - 2) Each next ARK SubFile will be found on the above ~DOS2I2.TMP unzipped file.
		' - 3) As soon as we find another "<DIR>" entry, erase the CurrArk$ variable
		IF MID$(Sel.SL, 1, 4) <> "<ARK" THEN GOTO NotARKgroup
		CurrArk$ = RTRIM$(MID$(Sel.SL, 7, 8)) + "." + RTRIM$(MID$(Sel.SL, 16, 3))
		KPath$=CurrPath$ + CurrArk$
		CALL ShortName(KPath$)
		Exec$ = "Decomp4.com " + KPath$ + " ~tmpfile.tmp >NULL"
		SHELL Exec$
		GOTO NxtItm
		
		
NotARKgroup:    IF Sel.CpyMark = "T" AND TELL$="C" THEN GOTO TrimFIFILES
		IF Sel.Dark = "X" AND TELL$="C" THEN GOTO ARKFile
		IF Sel.CpyMark <> Tell$ THEN GOTO NxtItm 
		GOTO NormalFile
		
' ARK File		
ARKFile:	SArkFilName$ = MID$(Sel.SL, 1, 10)
		GOSUB TxferThisArk
		GOTO NxtItm

' Trim TIFILES Header. "T" command key files will be processed at the same time of "C" command key files
		
TrimFIFILES:   	TIF$ = CurrPath$ + RTRIM$(MID$(Sel.SL, 1, 8)) + "." + RTRIM$(MID$(Sel.SL, 10, 3))
		Exec$ = "Decomp4.com  " + TIF$ + " ~tmpfile.tmp /T >NULL"
		SHELL Exec$
		PRINT TIF$; " ("; RTRIM$(MID$(Sel.SL, 45, 23)); ")"; " as "; LEFT$(Sel.TINAME, 10)  ' Filename
		FullFile$="~tmpfile.tmp"
		GOTO NormalFile22

' Normal File; 0-9, C
NormalFile:     FullFile$ = CurrPath$ + RTRIM$(MID$(Sel.SL, 1, 8)) + "." + RTRIM$(MID$(Sel.SL, 10, 3))
		PRINT FullFile$; " ("; RTRIM$(MID$(Sel.SL, 45, 23)); ")"; " as "; LEFT$(Sel.TINAME, 10)  ' Filename
NormalFile22:   GOSUB TxferThisFile
		
		GOSUB Add2Image
		Done% = Done% + 1
NxtItm:       
		NEXT Itm%
 
		IF AtLeast$ <> "" THEN GOSUB CloseOutput : AtLeast$ = ""
		
		NEXT Order%
		
StopIt:
		

'******************************=
' CURRENT FILENAME : END OF LOOP
'******************************=


		PRINT
		PRINT "=      WHAT HAPPENED       ="
		IF ARKDone%>0 THEN 
		PRINT "- Total Arked Files        :"; ARKDone%
		PRINT "- Total ARK Sector Size    :"; ARKGlobalSectors 
		END IF 
		PRINT "- Total Files Added (TFA)  :"; Done% - Skipped%
		PRINT "- Sector Size of TFA       :"; GlobalSectors
		PRINT "- Total Files Skipped      :"; Skipped%
		PRINT "- Total Disks              :"; DisksRound%
		PRINT "- Disk Size (Sectors)      :"; DiskSize(TmpSize)
		PRINT "- First Disk name          : "; FirstDestinPath$
		PRINT "- Last  Disk name          : "; DestinPath$
		PRINT
		PRINT "Press any key to continue"
		CopiedDirs$(ChosenDir%) = "Y"
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		CLS
		
		GOTO Leaveit

' *******************************		
' ARK these files and import them		
' *******************************
ARKthese:	
' NEXT, CREATE THE ARK FILE
		
		SEEK #5,2 	' Reload Pointer to first record after the header record
		
		CrArkFilName$ = "~2Barked.ARK" ' Our Temporary ARK file
		FOR Itm% = 1 TO PntLastUsed% - 1		
		GET #5, 1 + Itm%, Sel
		IF MID$(Sel.SL, 1, 4) = "<DIR" THEN CurrArk$ = "": CurrPath$ = RTRIM$(MID$(Sel.SL, 7, LEN(Sel.SL))): GOTO NotToBeArked
		IF Sel.CpyMark <> "K" THEN GOTO NotToBeArked
		IF CreatedArk% > 0 THEN GOTO ToBeArked
		
			
		CALL KillFile(CrArkFilName$)	' Make sure to Delete the temp file, if any
		GOSUB CreateArkFile		' Open Temporary Output File as #8
		
ToBeArked:	FullFile$ = CurrPath$ + RTRIM$(MID$(Sel.SL, 1, 8)) + "." + RTRIM$(MID$(Sel.SL, 10, 3))
		PRINT FullFile$; " ("; RTRIM$(MID$(Sel.SL, 45, 23)); ")"; " as "; LEFT$(Sel.TINAME, 10)  ' Filename
		GOSUB TxferThisFile		' Create a TI file sector image, no FDR yet
		
		OPEN TmpFilName$ FOR RANDOM ACCESS READ AS #1 LEN = 256
		FIELD #1, 256 AS d$
		GET #1, 1
		FHeader$=d$
		A$ = MID$(FHeader$, 1, 10)     ' Filename
		A$ = A$ + MID$(FHeader$, 13, 1)' Byte  13    (byte 1=first) = FileType
		A$ = A$ + MID$(FHeader$, 14, 1)' Byte  14    (byte 1=first) = Max. numb. of records/sector or AU
		A$ = A$ + MID$(FHeader$, 15, 2)' Bytes 15,16 (byte 1=first) = Filelength, reversed bytes
		A$ = A$ + MID$(FHeader$, 17, 1)' Byte  17    (byte 1=first) = End of file Offset
		A$ = A$ + MID$(FHeader$, 18, 1)' Byte  18    (byte 1=first) = Logical record Length
		A$ = A$ + MID$(FHeader$, 19, 2)' Bytes 19,20 (byte 1=first) = Number of Fixed Length Record -OR- Number of Sectors used by variable Length Records
		
		PUT #8, HeaderPos%, A$: HeaderPos% = HeaderPos% + 18
		CreatedArk% = CreatedArk% + 1 : IF CreatedArk% MOD 14 = 0 THEN HeaderPos% = HeaderPos% + 4
		TmpFileSects% = CalcWord(FHeader$, 15)
		FOR T = 1 TO  TmpFileSects%
		GET #1
		PUT #8, ArkBytePos&, d$: ArkBytePos& = ArkBytePos& + 256 
		NEXT T 
		CLOSE #1
		ARKDone% = ARKDone% + 1
NotToBeArked:	NEXT Itm%
		Done% = Done% + 1
' GET THE TI FILENAME THE USER CHOSE IN DOS2I2.BAS  		
		     
		OPEN "ARKNAME.DEF" FOR INPUT AS #99   ' Avoid creation of file is file doesn't exist
		LINE INPUT #99, TIArkFilName$
		LINE INPUT #99, Compression$
		CLOSE #99

' COMPRESS ARK FILE, IF REQUIRED 
	
		IF Compression$<>"C" THEN GOTO AddFDRsector
		CLOSE #8
		
		A$=MyName$(1) + "~4Barked.ARK"  ' New Filename 
		B$=MyName$(1) + CrArkFilName$	' Old filename 
		CALL ShortName(A$)
		CALL ShortName(B$)
		CALL KillFile(A$)		' Make sure we don't already have an old file with that name 
		
		NAME B$ AS A$			' "~2Barked.ARK" becomes "~4Barked.ARK"
		
		Exec$ = "Comp2.com " + A$ + " " + B$ + " >NULL" ' Create "~2Barked.ARK", COMPRESSED 
		SHELL Exec$
		
		'CALL KillFile(CrArkFilName$)	' Make sure to Delete the temp file, if any
		OPEN CrArkFilName$ FOR BINARY ACCESS READ AS #8
		ArkBytePos&=LOF(8)		' New Length of Ark File

		
' CREATE FDR SECTOR 
 AddFDRsector:
		OutSect$ = STRING$(256, CHR$(0))
		MID$(OutSect$, 1) = LEFT$(TIArkFilName$, 10)' Filename
		TtSect&=INT((ArkBytePos&/256)) 
		IF ArkBytePos& MOD 256 > 0 THEN TtSect& = TtSect& + 1
		ARKGlobalSectors = TtSect& + 1		' We can do this because "K" files are processed first 
 	 
		B1% = INT(TtSect&/ 256)
		B2% = TtSect& - (B1% * 256)
		MID$(OutSect$, 15) = CHR$(B1%) + CHR$(B2%)' Byte 14-15 = Status Flag
		TotRec%=INT(ArkBytePos&/128) 
		IF ArkBytePos& MOD 128 > 0 THEN TotRec% = TotRec% + 1
		SELECT CASE Compression$
		
		CASE "U"       ' DIS FIX
		MID$(OutSect$, 13) = CHR$(&H0)         	' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(2)		' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 18) = CHR$(128)		' Byte 17 = Logical Record Length
		B1% = INT(TotRec% / 256): B2% = TotRec% - (B1% * 256)
		MID$(OutSect$, 19) = CHR$(B2%) + CHR$(B1%)' Byte 18-19 = Number of Fixed Length Records
		
		CASE "C"       ' INT FIX	
		MID$(OutSect$, 13) = CHR$(&H2)         	' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(2)		' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 18) = CHR$(128)		' Byte 17 = Logical Record Length
		B1% = INT(TotRec% / 256): B2% = TotRec% - (B1% * 256)
		MID$(OutSect$, 19) = CHR$(B2%) + CHR$(B1%)' Byte 18-19 = Number of Fixed Length Records
		END SELECT

' COPY ARK FILE TO A NEW FILE, THIS TIME WITH FDR SECTOR.
		TmpFilName$ = "~tmpfil.tmp"
		
		OPEN TmpFilName$ FOR RANDOM ACCESS WRITE AS #1 LEN = 256
		BytePos& = 1
		FIELD #1, 256 AS d$
		LSET d$ = OutSect$
		PUT #1,1
 
		FOR T = 1 TO TtSect& 
		
		GET #8, BytePos&, TmpRec : BytePos& = BytePos& + 256 
		
		LSET d$ = TmpRec

		PUT #1,T+1
		NEXT T
		CLOSE #8
		CLOSE #1

' ADD TO FINAL DISK IMAGE FILE
                TmpFileSects% = TtSect&
		GOSUB Add2Image
		
		RETURN 

'*************************
' TRANSFER THE ARK SUBFILE
'*************************
TxferThisArk:   TmpFilName$ = "~tmpfil.tmp"
		' Make sure to Delete the temp file, if any
		OPEN TmpFilName$ FOR BINARY ACCESS WRITE AS #1
		CLOSE #1
		KILL TmpFilName$
		
		OPEN TmpFilName$ FOR BINARY ACCESS WRITE AS #1
		
		TmpFileSects% = 0' Count of Temporary File Sectors
		OutSect$ = ""
		OutLen% = 0
		BytePos& = 1  ' Start of TmpFilName$
		TotRec% = 0
		' Now search the SubArk file inside the Ark File. Logic:
		' - 1) Read the first filename. Get sector count in SArkSektCnt. Compare to our filename.
		'      Match?
		' - 2) No, add Store sector count to Sectors2Skip accumulator and process next filename
		' - 3) Yes, Save Filename to first >100 bytes (FDR) of TmpFilName$ output file.
		' - 4) Add all the FDR info (reclen, file record count, etc) and replace the file type
		'      with the one chosen by user
		' - 5) Go and find the "END!" string (End Of Filename Table Marker).
		' - 6) From End Of Table Marker skip as many sectors as those counted in in Sectors2Skip
		' - 7) Now, transfer as many sectors as those in SArkSektCnt to TmpFilName$ output file
		' - 8) We're done
		OPEN "~tmpfile.tmp" FOR RANDOM ACCESS READ AS #7 LEN = 256
		Sectors2Skip = 0: ArkRecord = 0
		FIELD #7, 256 AS d$
		' Search Filename in SubArkFile
		WHILE NOT EOF(7)
		ArkRecord = ArkRecord + 1
		GET #7, ArkRecord
		FOR T = 1 TO 14 * 18 STEP 18
		
		TmpFileSects% = CalcWord(d$, T + 12)
		
		IF MID$(d$, T, 10) = SArkFilName$ THEN GOTO TxferArk10
		Sectors2Skip = Sectors2Skip + TmpFileSects%
		NEXT T
		WEND
		GOTO TxferArk40
		
TxferArk10:     ' Transfer FDR
		A$ = LEFT$(Sel.TINAME, 10)       ' >00->09 = Filename
		A$ = A$ + STRING$(2, CHR$(0))   ' >0A->0B = 2 Bytes Reserved for Future Expansion
		A$ = A$ + MID$(d$, T + 10, 1)   ' >0C     = Filetype
		A$ = A$ + MID$(d$, T + 11, 1)   ' >0D     = Maximum Number of Records per Sector or AU
		A$ = A$ + MID$(d$, T + 12, 2)   ' >0E->0F = Total Number of Sectors Used
		A$ = A$ + MID$(d$, T + 14, 1)   ' >10     = End of File Offset
		A$ = A$ + MID$(d$, T + 15, 1)   ' >11     = Logical Record Length
		A$ = A$ + MID$(d$, T + 16, 2)   ' >12->13 = Number of Fixed Length Records or
		A$ = A$ + STRING$(236, CHR$(0)) ' >14->FF = Pad the FDR record with zeroes

		PUT #1, BytePos&, A$: BytePos& = BytePos& + 256
		' Search the first sector with Data (first sector after "END!" End of File Table Marker)
		IF MID$(d$, 253, 4) = "END!" THEN GOTO TxferArk20
		WHILE NOT EOF(7)
		GET #7: ArkRecord = ArkRecord + 1
		IF MID$(d$, 253, 4) = "END!" THEN GOTO TxferArk20
		WEND
		PRINT : PRINT "Error. END! (End of Files Marker) not found for SubArk File " + SArkFilName$ + "  inside " + CurrArk$ + " ARK file!": INPUT ccc$
		GOTO TxferArk60

TxferArk20:    ' Actually extract SubArkFile Data
		ArkRecord = ArkRecord + Sectors2Skip
		FOR T = 1 TO TmpFileSects%
		GET #7, ArkRecord + T
		PUT #1, BytePos&, d$: BytePos& = BytePos& + 256
		NEXT T
		GOTO TxferArk60

TxferArk40:     PRINT : PRINT "Error. Sub Ark File " + SArkFilName$ + " found inside " + CurrArk$ + " ARK file!": INPUT ccc$
TxferArk60:     CLOSE #7
		CLOSE #1
		
		' print SArkFilName$: input ccc$
		GOSUB Add2Image
		RETURN

'		
' CREATE TEMPORARY ARK FILE 
'		
CreateArkFile:	CALL KillFile(CrArkFilName$)	' Make sure to Delete the temp file, if any
		OPEN CrArkFilName$ FOR BINARY ACCESS READ WRITE AS #8
		BytePos& = 257  ' Leave room for ARK FDR
		' 14 Files/sector
		'Total sector needed to contain all the Filenames for this ARK file
		T = INT(ARKTot% / 14)
		IF ARKTot% MOD 14 > 0 THEN T = T + 1
		ARKHeader$ = STRING$(256 * T, CHR$(0))
		MID$(ARKHeader$, LEN(ARKHeader$) - 3) = "END!"
		PUT #8, 1, ARKHeader$
		HeaderPos% = 1
		ArkBytePos& = LEN(ARKHeader$) + 1
		RETURN 
		

'		
' OPEN TEMPORARY OUTPUT FILE 
'		
OpenTempFile:	TmpFilName$ = "~tmpfil.tmp"
		CALL KillFile(TmpFilName$)	' Make sure to Delete the temp file, if any
		OPEN TmpFilName$ FOR BINARY ACCESS WRITE AS #1
		BytePos& = 257  ' Leave room for FDR
		RETURN 
		


'*************************
' TRANSFER THE FILE
'*************************
TxferThisFile:  GOSUB OpenTempFile
		TmpFileSects% = 0' Count of Temporary File Sectors
		OutSect$ = ""
		OutLen% = 0
		BytePos& = 257  ' Leave room for FDR
		TotRec% = 0
		
		CALL ShortName(FullFile$)
		SELECT CASE Sel.DTyp
		CASE "V"       ' DIS VAR
		GOSUB DisVar
		CASE "F"       ' DIS FIX
		GOSUB DisFix
		CASE "v"       ' INT VAR
		GOSUB IntVar
		CASE "f"       ' INT FIX
		GOSUB DisFix
		CASE "P"       ' PROGRAM
		GOSUB Program
		CASE ELSE
		CLOSE #1: GOTO TxferThisFile2
		END SELECT
	
		CLOSE #1 
TxferThisFile2:          
		
		RETURN
		
'===========================================================================      


'===========================================================================      
'*************************
' DIS VAR FILE TYPE
'*************************
DisVar:         OPEN FullFile$ FOR INPUT AS #7
		
		WHILE NOT EOF(7)
		LINE INPUT #7, DR$
		IF DR$ = "" THEN TIR$ = "": GOSUB Add2Sector: GOTO NextDVRec

' Chop DOS Records longer than 254 bytes
ChopMoreDV:     IF LEN(DR$) > 254 THEN TIR$ = LEFT$(DR$, 254): DR$ = RIGHT$(DR$, LEN(DR$) - 254): GOSUB Add2Sector: GOTO ChopMoreDV
		IF DR$ <> "" THEN TIR$ = DR$: GOSUB Add2Sector
		
NextDVRec:      WEND
		IF LEN(OutSect$) > 0 THEN GOSUB SaveSector
		GOSUB CreateFDR: PUT #1, 1, OutSect$
		
		CLOSE #7
		RETURN

'***************
' ADD TO SECTOR
'***************
		
Add2Sector:     LTIR% = LEN(TIR$)
		IF LTIR% + OutLen% > 254 THEN GOSUB SaveSector' Leave room for Length Byte and >FF End Of Sector Marker
		OutSect$ = OutSect$ + CHR$(LTIR%) + TIR$
		OutLen% = LEN(OutSect$)
		TotRec% = TotRec% + 1
		RETURN
		
SaveSector:     OutSect$ = OutSect$ + CHR$(255)
		EOFilOffset% = LEN(OutSect$) - 1
		IF LEN(OutSect$) < 256 THEN OutSect$ = OutSect$ + STRING$(256 - LEN(OutSect$), CHR$(0))
		PUT #1, BytePos&, OutSect$: BytePos& = BytePos& + 256
		
		' PRINT OutSect$
		OutSect$ = ""
		OutLen% = 0
		TmpFileSects% = TmpFileSects% + 1
		RETURN
'===========================================================================      
'*************************
' INT VAR FILE TYPE
'*************************                           
IntVar:      
		OPEN FullFile$ FOR BINARY ACCESS READ AS #7
		WHILE NOT EOF(7)
		RLen$ = INPUT$(1, 7)
		IF RLen$ = "" THEN GOTO NextIVRec
		
		DR$ = INPUT$(ASC(RLen$), 7)
		
		IF DR$ = "" THEN TIR$ = "": GOSUB Add2Sector: GOTO NextIVRec

' Chop DOS Records longer than 254 bytes
ChopMoreIV:     IF LEN(DR$) > 254 THEN TIR$ = LEFT$(DR$, 254): DR$ = RIGHT$(DR$, LEN(DR$) - 254): GOSUB Add2Sector: GOTO ChopMoreIV
		IF DR$ <> "" THEN TIR$ = DR$: GOSUB Add2Sector
		
NextIVRec:      WEND
		IF LEN(OutSect$) > 0 THEN GOSUB SaveSector
		GOSUB CreateFDR: PUT #1, 1, OutSect$
		
		CLOSE #7
		RETURN
		
'===========================================================================      
'*************************
' DIS FIX FILE TYPE
'*************************
Program:        DFLen% = 256
		GOTO DisFix1

'===========================================================================      
'*************************
' DIS FIX FILE TYPE
'*************************

DisFix:         DFLen% = ASC(Sel.DLen)
DisFix1:     
		OPEN FullFile$ FOR RANDOM ACCESS READ AS #7 LEN = DFLen%

		'Calculate number of records in the file
		FileRecs% = LOF(7) \ DFLen%

		EOFilOffset% = LOF(7) MOD 256' Used for PROGRAM file type
		FIELD #7, DFLen% AS d$
		LofModLen% = LOF(7) MOD DFLen%
		
DisFix2:        IF EOF(7) THEN GOTO DisFix4
		OutSect$ = ""
		FOR T = 1 TO INT(256 / DFLen%)
		IF EOF(7) THEN GOTO DisFix3

		'If the filesize is an even multiple of the record size, 
		'check to see if we're already read all the records.
		' Fix by "jonathan andersson" <fallout@brainwashme.com>
		' on January 2004. Thank you Jonathan!
		If (LofModLen% = 0) AND (TotRec% = FileRecs%) Then GoTo DisFix4
		
		GET #7
		
		OutSect$ = OutSect$ + d$
		TotRec% = TotRec% + 1
		NEXT T	
	
DisFix3:     
		IF LEN(OutSect$) < 256 THEN OutSect$ = OutSect$ + STRING$(256 - LEN(OutSect$), CHR$(0))
		
		PUT #1, BytePos&, OutSect$: BytePos& = BytePos& + 256
		TmpFileSects% = TmpFileSects% + 1
		GOTO DisFix2
DisFix4:        GOSUB CreateFDR: PUT #1, 1, OutSect$
		CLOSE #7
		RETURN





'*****************************
' CREATE FDR FOR ANY FILE TYPE
'*****************************
		
CreateFDR:      OutSect$ = STRING$(256, CHR$(0))
		MID$(OutSect$, 1) = LEFT$(Sel.TINAME, 10)' Filename
		B1% = INT(TmpFileSects% / 256)
		B2% = TmpFileSects% - (B1% * 256)
		MID$(OutSect$, 15) = CHR$(B1%) + CHR$(B2%)' Byte 14-15 = Status Flag
		VarSectr$ = CHR$(B2%) + CHR$(B1%)
		
		SELECT CASE Sel.DTyp
		CASE "V"       ' DIS VAR
		MID$(OutSect$, 13) = CHR$(&H80)        ' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(INT(256 / ASC(Sel.DLen)))' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 17) = CHR$(EOFilOffset%)' Byte 16 = End Of File Offset
		MID$(OutSect$, 18) = CHR$(ASC(Sel.DLen))' Byte 17 = Logical Record Length
		MID$(OutSect$, 19) = VarSectr$         ' Byte 18-19 = Number of Sectors used by Variable Length Records
		
		CASE "F"       ' DIS FIX
		MID$(OutSect$, 13) = CHR$(&H0)         ' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(INT(256 / ASC(Sel.DLen)))' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 18) = CHR$(ASC(Sel.DLen))' Byte 17 = Logical Record Length
		B1% = INT(TotRec% / 256): B2% = TotRec% - (B1% * 256)
		MID$(OutSect$, 19) = CHR$(B2%) + CHR$(B1%)' Byte 18-19 = Number of Fixed Length Records
		
		CASE "v"       ' INT VAR
		MID$(OutSect$, 13) = CHR$(&H82)        ' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(INT(256 / ASC(Sel.DLen)))' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 17) = CHR$(EOFilOffset%)' Byte 16 = End Of File Offset
		MID$(OutSect$, 18) = CHR$(ASC(Sel.DLen))' Byte 17 = Logical Record Length
		MID$(OutSect$, 19) = CHR$(B1%) + CHR$(B2%)' Byte 18-19 = Number of Sectors used by Variable Length Records
		
		CASE "f"       ' INT FIX
		MID$(OutSect$, 13) = CHR$(&H2)         ' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(INT(256 / ASC(Sel.DLen)))' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 18) = CHR$(ASC(Sel.DLen))' Byte 17 = Logical Record Length
		B1% = INT(TotRec% / 256): B2% = TotRec% - (B1% * 256)
		MID$(OutSect$, 19) = CHR$(B2%) + CHR$(B1%)' Byte 18-19 = Number of Fixed Length Records
		
		CASE " "       '
		MID$(OutSect$, 13) = CHR$(&H2)         ' Byte 12 = Status Flag
		MID$(OutSect$, 14) = CHR$(INT(256 / ASC(Sel.DLen)))' Byte 13 = Maximum # of Records or AU
		MID$(OutSect$, 18) = CHR$(ASC(Sel.DLen))' Byte 17 = Logical Record Length
		
		CASE "P"       ' PROGRAM
		MID$(OutSect$, 13) = CHR$(&H1)         ' Byte 12 = Status Flag
		MID$(OutSect$, 17) = CHR$(EOFilOffset%)' Byte 16 = End Of File Offset
		END SELECT
		
		RETURN



'===========================================================================
'****************************
' ADD TEMP FILE TO DISK IMAGE
'****************************

Add2Image:      IF AtLeast$ = "" THEN GOSUB MakeOutfile : GOSUB CreateDisk: : AtLeast$ = "X"
		OPEN TmpFilName$ FOR RANDOM ACCESS READ AS #1 LEN = 256
		FIELD #1, 256 AS d$
		
ThisFileAgain:
		LeftOver% = 0
		GET #1, 1
		FHeader$ = d$
		FOut$ = MID$(FHeader$, 1, 10)
		'PRINT "("; FileToCopy%; ") "; FOut$
		
		OutFDRSectr$ = d$ ' Current File Descriptor Record in Output File
		MID$(OutFDRSectr$, 29) = STRING$(228, CHR$(0))' Blank the Data Chain Pointer Block area
		FIDChain% = 29 ' Pointer to First In Data Chain Pointer Block in Output File Descriptor Record
		SectorLength# = CalcWord(FHeader$, 15) + 1
		
' FIND FREE SECTORS IN SECTOR ZERO
 
		' Check if file fits
	
		IF SectorLength# > DiskSize(TmpSize) - 2 THEN GOTO SkipThisFile
		IF StillFree% - SectorLength# < 0 THEN GOTO AbortThisFile
		
		' Get a free block (2 consecutive bytes: 1-2, 3-4, and so on ..) in sector 1
		' File Descriptor Index Record
		
		FOR FDIRT% = 1 TO 256 STEP 2
		B1$ = MID$(OutSectrOne$, FDIRT%, 1): B2$ = MID$(OutSectrOne$, FDIRT% + 1, 1)
		IF ASC(B1$) = 0 AND ASC(B2$) = 0 THEN GOTO FreeEntryFound
		NEXT FDIRT%
		GOTO AbortThisFile
		
		'
FreeEntryFound: ' Also, Find a free sector for FDR (File Descriptor Record)
		'
		FOR T% = 1 TO 200
		CV% = ASC(MID$(OutSectrZero$, 56 + T%, 1))
		IF CV% = 255 THEN GOTO NextBlock
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotFreeSec
		NEXT ex%
		
NextBlock:      NEXT T%
		BEEP
		INPUT "UNKNOWN ERROR IN ALLOCATION BIT MAP IN SECTOR ZERO. ", C$:
		GOSUB CloseOutput              'Close Output file
		GOTO GoLeaveXfer
		
GotFreeSec:     '*------- Update Sector Zero
		CV% = CV% + 2 ^ ex%
		MID$(OutSectrZero$, 56 + T%) = CHR$(CV%)' Mark that sector as used on Sector Zero
		NewFDR% = (T% - 1) * 8 + ex%   ' Get the free sector number (first sect. is sect. 0)
		IF DiskSize(TmpSize) = 2880 THEN NewFDR% = NewFDR% * 2: StillFree% = StillFree% - 1' Update Free sector/disk
		IF DiskSize(TmpSize) = 5760 THEN NewFDR% = NewFDR% * 4: StillFree% = StillFree% - 3' Update Free sector/disk
		'*------- Update Sector 1
		L1$ = CHR$(INT(NewFDR% / 256)): L2$ = CHR$(NewFDR% MOD 256)

		MID$(OutSectrOne$, FDIRT%) = L1$ + L2$' Update Sector 1 (File Descriptor Index Record)
		
		StillFree% = StillFree% - 1' Update Free sector/disk


		OldFreeSect% = 0           ' Old Current Output File New Sector
		Z = 0                      ' Offset in Input File Chain Pointer Block
		GlobalInpOffset% = 0       ' GLOBAL Offset in Input  File Chain Pointer Block
		GlobalOutOffset% = 0       ' GLOBAL Offset in Output File Chain Pointer Block
		SectorCnt% = SectorLength# - 1' Sector Length of this file
		
		
'****************************************
' CURRENT FILENAME : START OF CHAIN BLOCK
'****************************************
		CurSec% = 1
NextClusterPr:
 		CurSec% = CurSec% + 1
		IF CurSec% > TmpFileSects% + 1 THEN GOTO EOThisFilePr

		GET #1, CurSec%
		
		IF OldFreeSect% = 0 THEN
		  	GOSUB GetAFreeSect         ' Get Current Output File New Sector
		  	IF NewFreeSect% = 0 THEN GOTO AbortThisFile
		  	FirstFreeSectIDC% = NewFreeSect% ' First Free sector for Data Chain Pointer Block
		  	OldFreeSect% = NewFreeSect%: GOTO SectorsInARow
		END IF
		
		GOSUB GetAFreeSect      ' Get Current Output File New Sector
		
		IF NewFreeSect% = 0 THEN GOTO AbortThisFile
		IF OldFreeSect% = NewFreeSect% THEN GOTO SectorsInARow
		
		'Print "1) OldFreeSect, NewFreeSect =";OldFreeSect%;NewFreeSect% : INPUT CCC$
		'FlagSect$="Y"
		GOSUB WriteChainPointers
		'if FlagSect$="Y" then Print "2) OldFreeSect, NewFreeSect =";OldFreeSect%;NewFreeSect% : INPUT CCC$
		GlobalOutOffset% = GlobalOutOffset% + 1  ' Adjust Global Output Offset
		IF FIDChain% = 0 THEN GOTO NotThisOne  ' Error case: File Index Directory Table is full!
		
SectorsInARow:  LSET DataSec$ = d$
		PUT #2, NewFreeSect% + 1
		
		
NichtBadSect:   OldFreeSect% = OldFreeSect% + 1   ' Old Current Output File New Sector
		GOTO NextClusterPr
		
		'<------------>
		'<------------> END OF THE SAME CHAIN BLOCK
		'<------------>
		
'**************************************
' CURRENT FILENAME : END OF CHAIN BLOCK
'**************************************
		
AbortThisFile:  GOSUB CloseOutput   'Close Output file
		GOSUB MakeOutfile   ' Get next output Filename
		GOSUB CreateDisk    ' Create and open next output Filename
		GOTO ThisFileAgain  ' Process current file again
		
SkipThisFile:   CALL ERRSOUND
		PRINT "File "; FOut$; " is too long ("; SectorLength#; "sectors) and doesn't fit into the chosen"
		PRINT "empty disk ("; DiskSize(TmpSize); " sectors). It will be skipped!"
		INPUT "", C$
		Skipped% = Skipped% + 1
		C$="S": GOTO TxferEnd      ' Process Nextfile
EOThisFilePr:
		GOSUB UpdateChainPointers
		GlobalSectors = GlobalSectors + TmpFileSects% + 1
		
NotThisOne:     C$ = "": GOTO TxferEnd
GoLeaveXfer:    C$ = "UEABM"' Error condition: UNKNOWN ERROR IN ALLOCATION BIT MAP IN SECTOR ZERO
TxferEnd:       CLOSE #1                ' Close Input File
		RETURN
		
'=======================
' UDPADTE CHAIN POINTERS
'=======================

UpdateChainPointers:
		GOSUB WriteChainPointers       ' Update Data Chain Pointers
WriteFDR:
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1              ' Write FDR

		LSET DataSec$ = OutSectrZero$
		PUT #2, 1
		LSET DataSec$ = OutSectrOne$
		PUT #2, 2
		RETURN

'=================
'CLOSE OUTPUT FILE
'=================
CloseOutput:	
		LSET DataSec$ = OutSectrZero$
		PUT #2, 1
		LSET DataSec$ = OutSectrOne$
		PUT #2, 2
		
		IF V9T9$="" THEN GOTO CloseOutput2   ' Default is now V9T9 format
		
		T$ = MID$(OutErrTable$, 1, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 1
		T$ = MID$(OutErrTable$, 1 + 256, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 2
		T$ = MID$(OutErrTable$, 1 + 256 + 256, 256)
		LSET DataSec$ = T$
		PUT #2, DiskSize(TmpSize) + 3
CloseOutput2:		
		CALL AlphaDir(DxPath$)        ' Reorder alphabetically the Disk Image File just created
		CLOSE #2

		RETURN

'===================================
' GET A NEW FREE SECTOR
'===================================
' To get a free sector we have to look up the Allocation Bit Map in Sector Zero.
' It starts at offset 56 from the beginning.
' Each bit is a sector
' +-----------------+---------------+
' |  1st byte = 0   | 1st byte = 1  |
' |  in sector      | in sector     |
' +-----------------+---------------+
' |  Offset = 56    | Offset =57    |
' +-----------------+---------------+
'


GetAFreeSect:   
		IF DiskSize(TmpSize) = 2880 AND LeftOver% <> 0 THEN NewFreeSect% = LeftOver%: LeftOver% = 0: GOTO NewFreeSectExit
'if FlagSect$="Y" then Print "3) LeftOver%, UTM%, Remaindr =";LeftOver%;UTM%;Remaindr% : INPUT CCC$
		IF DiskSize(TmpSize) <> 5760 OR LeftOver% = 0 THEN GOTO GetAFreeSect1

		NewFreeSect% = LeftOver%: LeftOver% = LeftOver% + 1
		UTM% = UTM% - 1: IF UTM% = 1 THEN LeftOver% = 0
		' PRINT UTM% ; NewFreeSect% : INPUT XX$
		GOTO NewFreeSectExit
GetAFreeSect1:     
		' Check first with remainder
		IF Remaindr% = 0 THEN GOTO GetAFreeSect2
		T% = LowLimit%
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		FOR ex% = Remaindr% TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%
		
		' Then, check starting from Lowest Data sector
GetAFreeSect2:
		FOR T% = LowLimit% + 1 TO UpperABM(TmpSize) - 1
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		IF CV% = 255 THEN GOTO GetAFreeSect3
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%
		
GetAFreeSect3:  NEXT T%

		' Finally , check the FDR area
		FOR T% = 0 TO LowLimit%
		CV% = ASC(MID$(OutSectrZero$, 57 + T%, 1))
		IF CV% = 255 THEN GOTO GetAFreeSect4
		FOR ex% = 0 TO 7
		IF (CV% AND 2 ^ ex%) = 0 THEN GOTO GotNewFreeSec
		NEXT ex%
		
GetAFreeSect4:  NEXT T%
		BEEP
		PRINT
		
		PRINT "ERROR: FREE SECTOR NOT FOUND IN ALLOCATION BIT MAP IN SECTOR ZERO. "
		PRINT "CURRENT FILE ON THIS DISK ("; DestinPath$; ") WILL BE ABORTED"; : INPUT "", C$
		GOSUB WriteChainPointers       ' Update Data Chain Pointers
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1              ' Write FDR
		NewFreeSect% = 0
		GOTO NewFreeSectExit

GotNewFreeSec:   '*------- Update Sector Zero
		CV% = CV% + 2 ^ ex%
		MID$(OutSectrZero$, 57 + T%) = CHR$(CV%) ' Mark that sector as used on Sector Zero
		NewFreeSect% = T% * 8 + ex%   ' Get the free sector number
		UTM% = 1
		IF DiskSize(TmpSize) = 2880 THEN NewFreeSect% = NewFreeSect% * 2: LeftOver% = NewFreeSect% + 1: UTM% = 2
		IF DiskSize(TmpSize) = 5760 THEN NewFreeSect% = NewFreeSect% * 4: LeftOver% = NewFreeSect% + 1: UTM% = 4
		IF FirstFreeSectIDC% = 0 THEN FirstFreeSectIDC% = NewFreeSect%
		
		StillFree% = StillFree% - UTM%' Update Free sector/disk
NewFreeSectExit:
		RETURN
		
'===============================================
' CALCULATE CURRENT ENTRY IN CHAIN POINTER TABLE
'===============================================
' The second 3 nibble block contains the highest OFFSET within each Chain Block.
' This value must never be higher than SectorCnt% - 1, which is the file total length - 2,
' as it appears on Disk Catalog.
' This corrects the bug on 80 track disks, that have the last second 3 nibble block wrong on
' ODD LENGTH FILES (1 sector longer).
' If not corrected, this bug would create an error on lower size disks.

CalcClusters:
		A = ASC(MID$(FHeader$, 28 + 1 + Z, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z, 1))
		BA% = B MOD 16
		BB% = INT(B / 16)
		StSec% = BA% * 256 + A
		IF TotSect% > 3000 THEN StSec% = StSec% * 4
		Offs% = C * 16 + BB
		IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		OffsVal% = 0               ' Offset in EACH Input  File Chain Pointer Block
		
		GOTO CalcClustend     ' Skip the below check, which has been superseeded by the simpler
		' above approach:  IF Offs% > SectorCnt% - 1 THEN Offs% = SectorCnt% - 1
		' Nonetheless, I leave it where it is because it might be still needed for some
		' 80 track disks that have a wrong file length, besides having
		' a wrong chain point table length.
		
' 
' Special case: in a 80 track Double Side Disk, when file length is EVEN (SectorLength# in my code), the
' Chain Point Table reports 1 sector more than what it should. When copying, we have to avoid using
' that extra sector. Method: always check if there is a next Data Chain. If there is, do nothing. Otherwise,
' that means we are are the end of the Data Chain, and we have to use a sector less.
' SectorLength#

		
		IF Dens% < 2 OR Tracks < 80 THEN GOTO CalcClustend
		IF SectorLength# <> (INT(SectorLength# / 2)) * 2 THEN GOTO CalcClustend
		A = ASC(MID$(FHeader$, 28 + 1 + Z + 3, 1))
		B = ASC(MID$(FHeader$, 29 + 1 + Z + 3, 1))
		C = ASC(MID$(FHeader$, 30 + 1 + Z + 3, 1))
		IF A <> 0 OR B <> 0 OR C <> 0 THEN GOTO CalcClustend
		Offs% = Offs% - 1
CalcClustend:
		
		RETURN
		
'===============================
' WRITE DATA CHAIN POINTER BLOCK
'===============================
WriteChainPointers:
		
		IF FIDChain% < 253 THEN GOTO WriteChainP2
		PRINT "Data Chain Pointer Block Table Full for file: "; FOut$; ". Disk is too fractured!"
		PRINT "This file will be closed and will remain uncomplete.";
		INPUT "", C$
		LSET DataSec$ = OutFDRSectr$
		PUT #2, NewFDR% + 1               ' Write FDR
		FIDChain% = 0                  ' This to make the caller understand that table is full
		GOTO NoChainPointr
		
WriteChainP2:
		Other% = OldFreeSect% - FirstFreeSectIDC% - 1
		GlobalOutOffset% = GlobalOutOffset% + Other%
		FFreeSectIDC% = FirstFreeSectIDC%
		IF DiskSize(TmpSize) < 3000 THEN GOTO WriteChainP3 ' Special Case: DSHD disk (5760 Sectors) have chain block/4
		FFreeSectIDC% = INT(FirstFreeSectIDC% / 4)
WriteChainP3:
		ss3% = INT(FFreeSectIDC% / 256)
		ss1% = FFreeSectIDC% MOD 16
		ss2% = FFreeSectIDC% - (ss3% * 256) - ss1%
		ss2% = INT(ss2% / 16)
		
		of3% = INT(GlobalOutOffset% / 256)
		of1% = GlobalOutOffset% MOD 16
		of2% = GlobalOutOffset% - (of3% * 256) - of1%
		of2% = INT(of2% / 16)
		T$ = CHR$(ss2% * 16 + ss1%) + CHR$(of1% * 16 + ss3%) + CHR$(of3% * 16 + of2%)
		MID$(OutFDRSectr$, FIDChain%) = T$
		
		FIDChain% = FIDChain% + 3
		'LeftOver% = 0              ' No Left Over for 2880 sector disk on this Chain
		OldFreeSect% = NewFreeSect%
		FirstFreeSectIDC% = NewFreeSect%
NoChainPointr:
		RETURN
		
'============================
' CREATE OUTPUT FILENAME
'============================
MakeOutfile:    IF FirstDisk$ = "" THEN FirstDisk$ = "X": GOTO MakeOutfile3
		Incr% = Incr% + 1
		
		Last$ = MID$(DestinPath$, LEN(DestinPath$), 1)
		IF Last$ = "9" THEN Last$ = "A": GOTO MakeOutfile2
		IF Last$ = "Z" OR Last$ = "z" THEN Last$ = "A": GOTO MakeOutfile2
		Last$ = CHR$(ASC(Last$) + 1)
MakeOutfile2:   MID$(DestinPath$, LEN(DestinPath$), 1) = Last$
		IF DisksRound% = 0 THEN FirstDestinPath$ = DestinPath$
MakeOutfile3:
		RETURN
		
'=======================================
' CREATE VIRTUAL DISK (EMPTY IMAGE FILE)
'=======================================
CreateDisk:
		TmpSize = Size         ' User's Size
		PRINT "New Disk name: "; DestinPath$
		DxPath$=DestinPath$
		CALL CreateShortName(DxPath$,CR$)
		IF CR$<>"" then GOTO CreateGoOn3
		ON ERROR GOTO CreateNoExists
		OPEN DxPath$ FOR INPUT ACCESS READ AS #2   ' Avoid creation of file is file doesn't exist
		CLOSE #2: ON ERROR GOTO 0

CreateExists:   BEEP
CreateExists2:  CALL box(1, 2, 77, 12)
		LOCATE 2, 3: PRINT "The following disk image file:";
		LOCATE 4, 3: PRINT DestinPath$;
		LOCATE 5, 3: PRINT "already exists. ";
		LOCATE 7, 3: PRINT "You may:"
		LOCATE 8, 3: PRINT "- Overwrite [O]";
		LOCATE 9, 3: PRINT "- Skip      [S]"
		LOCATE 10, 3: PRINT "- Append    [A]"
		LOCATE 12, 15: PRINT "Your choice: O/S/A ? ";
				PRINT K$
		IF K$ = "O" THEN CLS : GOTO CreateGoOn2
		IF K$ <> "A" THEN GOTO NotAppend
		CLS : GOSUB CreateOpen: GOSUB SubtrUsdSectors
		IF AppendF$="Y" THEN RETURN
		CLOSE #2 :K$="S"  ' Else skip this file

NotAppend:      IF K$ = "S" THEN CLS : GOSUB MakeOutfile: DisksRound% = DisksRound% - 1 : GOTO CreateDisk' Try again withj new filename
		DO: K$ = INKEY$: LOOP UNTIL K$ <> "": K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO Leaveit
		CALL ERRSOUND: GOTO CreateExists2

		
CreateNoExists: RESUME CreateGoOn
CreateGoOn:     ON ERROR GOTO 0
		
CreateGoOn2:    OPEN DxPath$ FOR BINARY ACCESS WRITE AS #2
		CLOSE #2
		KILL DxPath$
		DxPath$=DestinPath$
		CALL CreateShortName(DxPath$,CR$)
CreateGoOn3:    DisksRound% = DisksRound% + 1
		OPEN DxPath$ FOR BINARY ACCESS WRITE AS #2
		Z = 0: Tog% = 1: BytePos& = 1

		' Add termination to TI99/4A filename '01', '02' and son on
		
		Incr$ = RTRIM$(LTRIM$(STR$(Incr%)))
		IF LEN(Incr$) < 2 THEN Incr$ = "0" + Incr$
		NewName$ = DskName$ + Incr$
		IF LEN(NewName$) < 10 THEN NewName$ = NewName$ + SPACE$(10 - LEN(NewName$))
		
		' Sector/ disk
		L1$ = CHR$(INT(DiskSize(TmpSize) / 256)): L2$ = CHR$(DiskSize(TmpSize) MOD 256)
		
		SectorZero$ = NewName$ + L1$ + L2$ + CHR$(SecTrack(TmpSize)) + "DSK " + CHR$(TrackSide(TmpSize)) + CHR$(NumSides(TmpSize)) + CHR$(DskDens(TmpSize))
		IF DiskSize(TmpSize) >= 2880 THEN T$ = CHR$(1) ELSE T$ = CHR$(3)
		'SectorZero$ = SectorZero$ + STRING$(36, CHR$(0)) + T$ + STRING$(199, CHR$(0))
		SectorZero$ = SectorZero$ + STRING$(36, CHR$(0)) + T$ + STRING$(UpperABM(TmpSize) - 1, CHR$(0))
		SectorZero$ = SectorZero$ + STRING$(256 - LEN(SectorZero$), CHR$(&HFF))
		
		PUT #2, BytePos&, SectorZero$: BytePos& = BytePos& + 256
		FillZero$ = STRING$(256, CHR$(0))
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256
		
		FOR Record = 3 TO DiskSize(TmpSize) ' Sector 0 and 1 are already out, add remaining sectors
		PUT #2, BytePos&, DummyRec$: BytePos& = BytePos& + 256
		NEXT Record
		
		
		OutErrTable$ = FillZero$
		MID$(OutErrTable$, 1) = "Bad Sectors:       0"
		
		IF V9T9$="" THEN GOTO CreateGoOn4   ' Default is now V9T9 format
		PUT #2, BytePos&, OutErrTable$: BytePos& = BytePos& + 256
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256
		PUT #2, BytePos&, FillZero$: BytePos& = BytePos& + 256
CreateGoOn4:		
		OutErrTable$ = OutErrTable$ + FillZero$ + FillZero$
		
		CLOSE #2
		GOSUB CreateOpen   ' Open Output file and get fundamental sectors (0 and 1)
		StillFree% = DiskSize(TmpSize) - 2
		RETURN
		
' Open Output file and get fundamental sectors
CreateOpen:
		OPEN DxPath$ FOR RANDOM ACCESS READ WRITE AS #2 LEN = 256
		FIELD #2, 256 AS DataSec$
		GET #2, 1
		OutSectrZero$ = DataSec$
		GET #2, 2
		OutSectrOne$ = DataSec$
		
		
		RETURN
		
'SUBTRACT USED SECTORS FROM OPENED FILE         
SubtrUsdSectors:
		DSect = CalcWord(OutSectrZero$, 11)
		DTracks% = ASC(MID$(OutSectrZero$, 18, 1))
		DSides% = ASC(MID$(OutSectrZero$, 19, 1)): IF DSides% = 0 THEN DSides% = 1
		DDens%  = ASC(MID$(OutSectrZero$, 20, 1)): IF DDens% = 0 THEN DDens% = 1
		DSideDensity$=MID$("SD", DSides%, 1) + "S" + MID$("SDH", DDens%, 1) + "D"

		SELECT CASE DSideDensity$
		CASE "SSSD"
		TmpSize = 1
		CASE "DSSD"
		TmpSize = 2
		CASE "SSDD"
		TmpSize = 3
		CASE "DSDD"
		TmpSize = 4
		CASE "SSHD"
		TmpSize = 5
		CASE "DSHD"
		TmpSize = 6

		CASE ELSE
		CALL ERRSOUND: PRINT "Unknown disk size in SubtrUsdSectors: routine": INPUT C$: GOTO Leaveit
		END SELECT
  		TmpSize = TmpSize + ((ASC(MID$(OutSectrZero$,18,1))/40)-1)*6
		StillFree% = DiskSize(TmpSize)

		FOR J = 0 TO UpperABM(TmpSize)
		T$ = MID$(OutSectrZero$, 57 + J, 1)
		IF ASC(T$) = 0 THEN GOTO CrNextByte
		IF ASC(T$) < 255 THEN GOTO SubtrUsdSect2
		StillFree% = StillFree% - 8
		IF DiskSize(TmpSize) = 2880 THEN StillFree% = StillFree% - 8
		IF DiskSize(TmpSize) = 5760 THEN StillFree% = StillFree% - 24
		GOTO CrNextByte

SubtrUsdSect2: 
		FOR W = 0 TO 7
		IF ASC(T$) AND 2 ^ W THEN StillFree% = StillFree% - 1: IF DiskSize(TmpSize) = 2880 THEN StillFree% = StillFree% - 1 ELSE IF DiskSize(TmpSize) = 5760 THEN StillFree% = StillFree% - 3
		NEXT W
CrNextByte:      NEXT J
		' PRINT "StillFree%="; StillFree%; : INPUT "", C$
		PRINT "Disk to append to: "
		PRINT "Diskname     = " ; DxPath$
		PRINT "Disk Type    = "; DSideDensity$
		PRINT "Capacity     =";DSect;"sectors
		PRINT "Track/side   ="; ASC(MID$(OutSectrZero$,18,1))
		PRINT "sector/track =" ;ASC(MID$(OutSectrZero$,13,1))
		PRINT "Free sectors = "; StillFree%
		PRINT "Used sectors = "; DSect-StillFree%

		IF TmpSize<>Size THEN PRINT "The disk size doesn't match the disk size you've selected."
		PRINT
		PRINT "Do you want to use this disk ";
		IF TmpSize<>Size THEN PRINT "anyway (Y/N)?"; ELSE PRINT "(Y/N)?";
		DO: K$ = INKEY$: LOOP UNTIL K$ <> "": K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN K$="N"
		PRINT
		AppendF$= K$
		RETURN
		
SectorLength:   ' Calculate file length, in sectors
		SectorLength# = CalcWord(FilName$(CurrentFilename%), 15) + 1
		RETURN
DispFilestoCopy: ' Display total files to be copied
		LOCATE 6, 58, 1
		PRINT TotFiles2Copy%; " ";
		LOCATE 6, 73, 1
		PRINT TotSizeFiles2Copy#; " ";
		RETURN
		
SUB AlphaDir (DestDisk$) ' Alphabetically reorder an Image Disk (Sector 1)
' Example:
' Call AlphaDir("C:\TEM\TI-PC.IMG")

		OPEN DestDisk$ FOR RANDOM ACCESS READ WRITE AS #9 LEN = 256
		FIELD #9, 256 AS DSec$
		GET #9, 2               ' Get Sector 1: Filename Table, alphabetically ordered
		SectrOne$ = DSec$

		TFNames% = 0           ' We have to work out how many filenames there are
NextFilNam:     sn% = CalcWord(SectrOne$, (TFNames% + 1) * 2 - 1)
		IF sn% <> 0 THEN TFNames% = TFNames% + 1: GOTO NextFilNam

		IF TFNames% = 0 THEN  GOTO AlphaDirZ

		REDIM FilName$(TFNames%)   ' DIM exactly our arrays
		REDIM StSect$(TFNames%)   ' DIM exactly our arrays
		FOR T = 1 TO TFNames%
		StSect$(T) = MID$(SectrOne$, (T * 2 - 1), 2)
		StartSect% = CalcWord(SectrOne$, (T * 2 - 1))
		GET #9, StartSect% + 1
		FilName$(T) = MID$(DSec$, 1, 10)
		' print t; StartSect%;FilName$(T)
		NEXT T
		
	
		
		' AVOID DUP NAMES
		' Dup names will be renamed with a leading Tilde character ("~"), for instance: "~filename"
		L!=0
		FOR K = 1 to TFNames% - 1
		FOR T = K + 1 TO TFNames%
		IF FilName$(K) <> FilName$(T) THEN GOTO NoDup
		A1$ = RTRIM$(FilName$(T))
		IF LEN(A1$) < 10 THEN A1$ = "~" + A1$ + SPACE$(10 - LEN(A1$) - 1) ELSE A1$ = "~" + LEFT$(A1$,9)
		PRINT "Incoming file "; FilName$(T); " will be renamed as ";A1$;" to avoid a duplicate name"
		L! = L! + 1
		IF INT(L!/20) = L!/20 THEN CALL PressToContinue
		
		FilName$(T) = A1$
		StartSect% = CalcWord(StSect$(T),1)
		GET #9, StartSect% + 1
		A2$ = DSec$ 
		MID$(A2$, 1, 10) = FilName$(T)
		LSET DSec$ = A2$
		PUT #9, StartSect% + 1
		
NoDup:		NEXT T
		NEXT K
		IF L! = 0 THEN GOTO NoDupEnd
		PRINT L!; "filenames have been renamed to avoid duplicate names."
		CALL PressToContinue
		
		
NoDupEnd:		
		
		' REORDER ALPHABETICALLY
		' Find Lowest element. Start from element 1; compare all others with element 1. If lowest found, swap with element 1
		' Next round, Find lowest starting from element 2; compare all others with element 2. If lowest found, swap with element 2
		' Next round, Find lowest starting from element 3; compare all others with element 3. If lowest found, swap with element 3
		' Next round, ...
		
		IF TFNames% = 1 THEN GOTO InOrder3
		K = 1	
LoopBack:       L = K: T = K + 1
LoopBack2:      IF FilName$(L) <= FilName$(T) THEN GOTO InOrder
		L = T   ' New lowest element found
InOrder:        T = T + 1
		IF T <= TFNames% THEN GOTO LoopBack2
		IF L = K THEN GOTO InOrder2
		'Swap lowest element with first element
		A1$ = FilName$(K): A2$ = StSect$(K)
		FilName$(K) = FilName$(L): StSect$(K) = StSect$(L)
		FilName$(L) = A1$: StSect$(L) = A2$
InOrder2:              
		K = K + 1: IF K < TFNames% THEN GOTO LoopBack
InOrder3:       
		FOR T = 1 TO TFNames%
		MID$(SectrOne$, (T * 2 - 1), 2) = StSect$(T)
		NEXT T
		' CALL ShowHex(SectrOne$,K$)

		LSET DSec$ = SectrOne$
		PUT #9, 2                ' Write Sector 1: Filename Table, alphabetically ordered

		ERASE FilName$  ' Free memory
		ERASE StSect$
AlphaDirZ:	CLOSE #9
	
END SUB

SUB box (Y, X, W, H)

		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		
		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";


END SUB

FUNCTION CalcWord (A$, P%)
		IF P% < 1 THEN INPUT "Wrong Position in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		IF LEN(A$) < P% + 1 THEN INPUT "Wrong String in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B1% * 256) + B2%
CalcWord1:      CalcWord = (V%)
END FUNCTION


SUB PressToContinue
		PRINT " - Press any key to continue - "
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
END SUB

SUB ERRSOUND
		SOUND 110, 4

END SUB

SUB Fischio
		IF MyVal(1) = 0 THEN EXIT SUB
		FOR i% = 3000 TO 4000 STEP 200
		SOUND i%, .1  'i% / 1000
		NEXT i%
		
END SUB

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE
		
Repeat:
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:     
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow: 
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB

DEFSNG A-Z
SUB ThisHelp (Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Will use Chapter 7 from help file "Manual.dat", indexed in "Manual.idx" file.
' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.
'
' Get .IDX file values into an array, that is,
' Get Array Parameters from Index (IDX) file
GetIDX:
		
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR T = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(T) = LTRIM$(IDXRecord.Section)
		IdxStart(T) = IDXRecord.StartRec
		IdxLength(T) = IDXRecord.RecLength
		IDXSect$(T) = LTRIM$(RTRIM$(IDXSect$(T)))
		NEXT T
		CLOSE #3
		
		RETURN
		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================
NextLineName:
		COLOR 7, 0
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL Fischio
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey13
		GOTO EnterKey

OthKey13:
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:     TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR T = 1 TO LEN(TL$): IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO StrtFound
		NEXT T
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - T + 1)
		
		FOR T = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, T, 1) <> " " AND MID$(TL$, T, 1) <> "*" THEN GOTO EndFnd
		NEXT T
EndFnd:         TL$ = LEFT$(TL$, T)
		PRINT IDXSect$(CurntLine%); TAB(12); TL$; SPACE$(79 - 12 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================
BotLine:
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN

		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:
		FirstRec# = SectCurr#
SectNewLine:
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:
		GOTO NewRound
SectExit:
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:
		CLOSE #59
END SUB

' Make sure to Delete the temp file, if any
SUB KillFile(FilName$)	
		OPEN FilName$ FOR BINARY ACCESS WRITE AS #200
		CLOSE #200
		KILL FilName$
END SUB 

SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
END SUB

SUB CreateShortName (A$,B$)
' Get short filename (8.3 characters). If it fails, create that file with
' Long Filename, then return the corresponding  short filename. 
' If file has been created, a second record, containing the string "CR!"
' will be returned too. 
' If wrong path, no filename is returned.

		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT716C.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, A$
		B$=""
		IF EOF(71) <> 0 THEN GOTO CrShName2
		LINE INPUT #71, B$
CrShName2:      CLOSE #71
		KILL "--"

END SUB
