' CONVANA.BAS - July 2000 - Paolo Bagnaresi ( paolo_bagnaresi@libero.it )

' This module can be Launched with a CHAIN qbasic instruction by a different qbasic program.
' Just add the same COMMON arrays to your launcher. (DIM Vector, MyName$, MyVal and the 3 corresponding COMMON Shared declarations).
' These arrays are used only as a parameter passing between chained qbasic programs.

DECLARE SUB box (Y%, X%, W%, H%)
DECLARE SUB ShowHex (A$, K$)
DECLARE SUB ERRSOUND ()
DECLARE SUB Fischio ()
DECLARE FUNCTION CalcWord! (A$, P%)
DECLARE FUNCTION RevCalcWord! (A$, P%)


DIM Vector(0 TO 10)      AS INTEGER
DIM MyName$(0 TO 30)
DIM MyVal(0 TO 10)      AS INTEGER

COMMON SHARED Vector() AS INTEGER
COMMON SHARED MyName$()
COMMON SHARED MyVal() AS INTEGER

DEFINT A-Z      
		TYPE IDXType
		Section AS STRING * 20
		StartRec AS DOUBLE
		RecLength AS SINGLE
		END TYPE
		DIM SHARED IDXRecord AS IDXType

DEFINT A-Z

' CONVANA.BAS - July 2000 - Paolo Bagnaresi ( paolo_bagnaresi@libero.it )
' This program will convert a DUMP file obtained from Anadisk v. 2.07 to TI99-PC
' standard format. TI99-PC standard format has 3 additional sectors, placed at the end of the file, for a Bad sector
' bit map table.
'
' The DUMP file must be obtained win the with the INCLUDE SECTOR ID INFORMATION enabled (mark YES).
'
' PROGRAM LOGIC:
' 1) Search sector zero. Must be within 36 sectors from the beginning. 1.44 MB disk have 36 sectors.
'    No TI-99/4A - Geneve disk can have a higher sector.
' 2) Build an empty file as big as needed (read parameters from sector zero)
' 3) Add a bad sector table (3 additional sectors)
' 4) Assume all sectors are bad
' 6) Sectors can come in in any order.
' 7) When a sector is found, it will be placed in its right place. At the same time, the Bad Sector
'    Bit Map Table will be decremented by one. Good and Bad Sector Counter will be updated
' 8) A good disk will result with zero Bad Sectors.
' 9) If a disk has zero Bad Sectors, chances are that it is really a good disk.
'   


		CLS
		LOCATE 2, 4, 0, 6, 7
		PRINT TAB(18); "ANADISK DUMP FILE TO TI99-PC IMAGE FILE FORMAT"
		SourcePath$ = MyName$(3)
		DestinPath$ = MyName$(5)
		
Down0:          IF SourcePath$ <> "" THEN GOTO Down1
		PRINT "Source      path and filename="; : INPUT "", SourcePath$ : GOTO Down0
Down1:          IF DestinPath$ <> "" THEN GOTO Down2
		PRINT "Destination path and filename="; : INPUT "", DestinPath$: GOTO Down1
Down2:          GOTO BEGIN



' Exit point with F9
Abort:          
Leaveit:        
LeaveIt2:        CLOSE #1
		CLOSE #2
		
		
		IF MyName$(0) = "" THEN GOTO TODOS
		CHAIN MyName$(0)
		
TODOS:           SYSTEM
		END
		
BEGIN:   
'===============              
' GET PARAMETERS
'===============

		ON ERROR GOTO FileNotFound
		DOSPath$=SourcePath$
		CALL TellPathFrom (DestinPath$, MPath$, OutName$)
		IF OutName$="" GOTO DestMissing
		CALL ShortName(DOSPath$)
		OPEN DOSPath$ FOR INPUT ACCESS READ AS #1   ' Avoid creation of file is file doesn't exist
		CLOSE #1: ON ERROR GOTO 0
		
		OPEN DOSPath$ FOR RANDOM ACCESS READ AS #1 LEN = 256 + 8
		FIELD #1, 256 + 8 AS DS$
		SectZero$ = CHR$(0) + CHR$(0) + CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) + CHR$(0) + CHR$(1)

		FOR NSect% = 0 TO 36
		GET #1, NSect% + 1
		SectHead$ = LEFT$(DS$, 8)
		IF SectHead$ = SectZero$ THEN GOTO ZeroFound
		NEXT NSect%
'===============     
' WRONG FILENAME
'===============
		CALL ERRSOUND
		CALL box(2, 10, 66, 10)
		LOCATE 3, 12
		PRINT "ANADISK Dump File:"; SourcePath$
		LOCATE 5, 12
		PRINT "Error. The above filename doesn't contain"
		LOCATE 6, 12
		PRINT "a standard TI-99/4A sector zero."
		LOCATE 8, 22
		PRINT "Press any key to abort...."
		BEEP
		DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		GOTO Leaveit
		
' FILE NOT FOUND             
		
FileNotFound:   CALL ERRSOUND:
		CALL box(1, 10, 66, 10)
		LOCATE 2, 12, 1, 6
		PRINT "ANADISK Dump Filename:"; SourcePath$
		LOCATE 4, 12
		PRINT "Error! The above filename doesn't exist"
FileNotFound2:  LOCATE 5, 12
		PRINT "Please correct and try again"
		LOCATE 7, 22
		PRINT "Press any key"
		BEEP
SomeMore:       DO: U$ = INKEY$: LOOP UNTIL U$ <> ""
		GOTO Leaveit
		
DestMissing:
		CALL box(1, 10, 66, 10)
		LOCATE 2, 12
		PRINT "Destination filename is missing:"
		LOCATE 3, 12
		PRINT DestinPath$
		GOTO FileNotFound2
		


		
'===================================
' SECTOR ZERO HAS FINALLY BEEN FOUND
'===================================
ZeroFound:      'CALL Fischio: PRINT "SECTOR ZERO HAS BEEN FOUND..."; : INPUT "", c$
		d$ = RIGHT$(DS$, 256)
		'K$ = " ": CALL ShowHex(d$, K$)

		DskName$ = MID$(d$, 1, 10)
		IF MID$(d$, 14, 3) = "DSK" THEN GOTO IdentFound
		CALL box(2, 10, 66, 12)
		LOCATE 3, 12
		PRINT "TI-99/4A DiskName: "; DskName$;
		LOCATE 5, 12
		PRINT "Warning....";
		LOCATE 6, 12
		PRINT "This file doesn't appear to be a true TI99-PC image file ";
		LOCATE 7, 12
		PRINT "('DSK' missing in sector 0).";
		LOCATE 10, 12
		PRINT "Do you still want to go on? (Y/N) ";
		LOCATE 10, 46, 1
		DO: C$ = INKEY$: LOOP UNTIL C$ <> ""
		IF UCASE$(C$) = "Y"  THEN GOTO IdentFound ELSE GOTO Abort
'================================
' OUTPUT DISK NAME AND PARAMETERS
'================================
IdentFound:     
		TotSect% = CalcWord(d$, 11)
		SectTrack% = ASC(MID$(d$, 13, 1))
		Tracks% = ASC(MID$(d$, 18, 1))
		Sides% = ASC(MID$(d$, 19, 1)): IF Sides% = 0 THEN Sides% = 1
		Dens% = ASC(MID$(d$, 20, 1)): IF Dens% = 0 THEN Dens% = 1

		SideDensity$ = "(" + MID$("SD", Sides%, 1) + "S/" + MID$("SD8", Dens%, 1) + "D)"
		IF Tracks = 80 AND Dens% < 3 THEN MID$(SideDensity$, 5, 1) = "Q"
		CALL box(1, 1, 80, 15)
		LOCATE 2, 4, 0, 6, 7
		PRINT TAB(18); "ANADISK DUMP FILE TO TI99-PC IMAGE FILE FORMAT"
		LOCATE 4, 3
		PRINT "TI-99/4A DiskName:"; DskName$; " Sect/Track:"; SectTrack%; " Tracks:"; Tracks%; " Sides:"; Sides%; " Dens:"; Dens%;
		LOCATE 5, 3
		PRINT "Total Sectors:"; TotSect%;
		PRINT TAB(43); "Disk Type: "; SideDensity$
		LOCATE 6, 3
		PRINT "PC Source File= "; SourcePath$;
		LOCATE 7, 3
		PRINT "PC Destin File= "; DestinPath$;
		PRINT
		CALL TellPathFrom (DestinPath$, MPath$, MName$)
		CALL ShortName(MPath$): DestinPath$= MPath$+ MName$
		
		OPEN DestinPath$ FOR RANDOM ACCESS WRITE AS #2 LEN = 256 * 40
		FIELD #2, 256 * 40 AS Out$
		LSET Out$ = STRING$(256 * 40, CHR$(&HBA))
		FOR T = 1 TO (TotSect% / 40)
		PUT #2, T
		NEXT T
		CLOSE #2

'===================
' CREATE OUTPUT FILE
'===================
		OPEN DestinPath$ FOR RANDOM ACCESS WRITE AS #2 LEN = 256
		FIELD #2, 256 AS Out$

		GlobErr% = TotSect% / 8

		OutErrTable$ = "Bad Sectors:       0"

		OutErrTable$ = OutErrTable$ + STRING$(32 - LEN(OutErrTable$), CHR$(0)) + STRING$(GlobErr%, CHR$(&HFF))
		OutErrTable$ = OutErrTable$ + STRING$(256 * 3 - LEN(OutErrTable$), &H0)
		
		MidDisk% = TotSect% / 2
		GlobErr% = TotSect%
		
'=======================
' MAIN LOOP STARTS HERE
'=======================
		FOR NSect% = 0 TO TotSect%
		GET #1, NSect% + 1
		SectHead$ = LEFT$(DS$, 8)
		d$ = RIGHT$(DS$, 256)

		ACyl% = ASC(MID$(SectHead$, 1, 1))     ' Actual Cylinder
		ASide% = ASC(MID$(SectHead$, 2, 1))    ' Actual Side
		RCyl% = ASC(MID$(SectHead$, 3, 1))     ' Read Cylinder
		RSide% = ASC(MID$(SectHead$, 4, 1))    ' Read Side
		RSect% = ASC(MID$(SectHead$, 5, 1))    ' Read Sector
		LenCode% = ASC(MID$(SectHead$, 6, 1))  ' Sector Length code: 0,1,2..
		DCount% = RevCalcWord(SectHead$, 7)  ' Data Count. If zero, no Data

		IF ACyl% <> RCyl% THEN A = 1: GOTO InconsistData
		IF ASide% <> RSide% THEN A = 2: GOTO InconsistData
		IF LenCode% <> 1 THEN A = 3: GOTO InconsistData
		IF DCount% <> 256 THEN A = 4: GOTO InconsistData
		IF RSide% > 1 THEN A = 5: GOTO InconsistData
		IF RSide% > Sides% THEN A = 6: GOTO InconsistData
		IF RSect% > SectTrack% THEN GOTO GhostSect

		IF RSide% = 0 THEN CurrRec% = ACyl% * SectTrack% + RSect% ELSE Trk% = Tracks% - 1 - ACyl%: CurrRec% = (Tracks% * SectTrack%) + (Trk% * SectTrack% + RSect%)

		LSET Out$ = d$
		PUT #2, CurrRec% + 1
		
		LOCATE 8, 3: PRINT "Processing Sector="; CurrRec%;
		ByteOff% = INT(CurrRec% / 8)
		BitOff% = CurrRec% MOD 8
		T% = ASC(MID$(OutErrTable$, 32 + 1 + ByteOff%, 1))
		
		'LOCATE 10, 1: PRINT "T%="; T%; "ByteOff%="; ByteOff%; " - BitOff%="; BitOff%; "Val="; 2 ^ BitOff%;
		R = T% AND 2 ^ BitOff%
		' PRINT " - AND="; R; "   ";
		T% = T% - 2 ^ BitOff%
		' PRINT " - New T%="; T%; "   "; ' : INPUT "", C$
		
		IF R > 0 THEN GOTO NoDupe
		CALL ERRSOUND: LOCATE 13, 3: PRINT "Error! Duplicated sector="; CurrRec%;
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ = CHR$(27) THEN GOSUB WANNASTOP: IF K$ = CHR$(27) THEN GOTO Leaveit
		GOTO GoOn
		
NoDupe:         MID$(OutErrTable$, 32 + 1 + ByteOff%, 1) = CHR$(T%)
		GlobErr% = GlobErr% - 1
		Done% = Done% + 1
		
		GOTO GoOn
GhostSect:           
		Ghost% = Ghost% + 1
		LOCATE 11, 3: PRINT "Ghost sectors="; Ghost%;
		GOTO GoOn
		
InconsistData:  IF GlobErr% = 0 THEN GOTO GoOn
		Inconsist% = Inconsist% + 1
		LOCATE 12, 3: PRINT "Inconsistent IDs="; Inconsist%;
		PRINT " a="; A; : INPUT "", c$
		' K$ = " ": CALL ShowHex(DS$, K$)

GoOn:           LOCATE 9, 3: PRINT "Bad Sectors      ="; GlobErr%;
		LOCATE 10, 3: PRINT "Good Sectors     ="; Done%
		K$ = INKEY$
		IF K$ <> CHR$(27) THEN GOTO GoOn2
		GOSUB WANNASTOP
		IF K$ = CHR$(27) THEN CLOSE #1: CLOSE #2: GOTO Leaveit
		
		
GoOn2:    
		NEXT NSect%
'====================
' MAIN LOOP ENDS HERE
'====================

		T$ = STR$(GlobErr%): T$ = SPACE$(8 - LEN(T$)) + T$
		MID$(OutErrTable$, 13, 8) = T$
		d$ = MID$(OutErrTable$, 1, 256)
		LSET Out$ = d$
		PUT #2, TotSect% + 1
		d$ = MID$(OutErrTable$, 1 + 256, 256)
		LSET Out$ = d$
		PUT #2, TotSect% + 2
		d$ = MID$(OutErrTable$, 1 + 256 + 256, 256)
		LSET Out$ = d$
		PUT #2, TotSect% + 3
		LOCATE 9, 3, 1, 6, 7: PRINT "Bad Sectors      ="; GlobErr%;
		LOCATE 10, 3: PRINT "Good Sectors     ="; Done%
		PRINT
		IF GlobErr% = 0 THEN CALL Fischio ELSE CALL ERRSOUND
		GOSUB EOTASK
		GOTO Leaveit
		
		
WANNASTOP:
		CALL box(16, 5, 72, 3)
		LOCATE 17, 10
		PRINT "ESC pressed. Press ESC again to abort, any other key to resume.";
		
		CALL Fischio
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		LOCATE 16, 1
		FOR T = 1 TO 3: PRINT SPACE$(80): NEXT T
		RETURN

EOTASK:
		CALL box(16, 5, 72, 3)
		LOCATE 17, 25
		PRINT "End of task. Press any key to exit.";
		
		
		DO: K$ = INKEY$: LOOP UNTIL K$ <> ""
		IF K$ <> CHR$(0) + CHR$(59)  THEN GOTO EOTASK2
		CALL ThisHelp("HELP - GENERAL FILE", "MenuHlp.dat", "MenuHlp.idx", "A8.1")
EOTASK2:        
		LOCATE 16, 1
		FOR T = 1 TO 3: PRINT SPACE$(80): NEXT T
		RETURN

		SUB box (Y, X, W, H)
		' Call Box(StartRow, StartColumn, Width, Hight)
		' Y=StartRow,X=StartColumn; W=Width,H=Hight)
		LOCATE Y, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";

		FOR V = 1 TO H - 2
		LOCATE Y + V, X
		PRINT ""; TAB(X + W - 1); : PRINT "";
		NEXT V

		LOCATE Y + H - 1, X
		PRINT ""; : FOR T = 1 TO W - 2: PRINT ""; : NEXT T: PRINT "";
		END SUB

DEFSNG A-Z
		FUNCTION CalcWord (A$, P%)
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B1% * 256) + B2%
		CalcWord = (V%)
		END FUNCTION

SUB ERRSOUND
		SOUND 110, 4
END SUB

SUB Fischio             
		IF MyVal(1)=0 THEN EXIT SUB
		SOUND 1 * 400 + 500, 1
		SOUND 2 * 400 + 500, 1
		SOUND 3 * 400 + 500, 1
		SOUND 4 * 400 + 500, 1
		SOUND 5 * 400 + 500, 1
		SOUND 6 * 400 + 500, 1
END SUB

		FUNCTION RevCalcWord (A$, P%)
		B1% = ASC(MID$(A$, P%, 1))
		B2% = ASC(MID$(A$, P% + 1, 1))
		V% = (B2% * 256) + B1%
		RevCalcWord = (V%)
		END FUNCTION

SUB ShowHex (A$, K$)
' This is simply to help during debugging
' Syntax: CALL ShowHex(A$,K$) ' A$ usually contains an entire TI Sector (256 bytes)
		Col% = 3
		B$ = ""
		FOR T = 1 TO LEN(A$)
		C$ = HEX$(ASC(MID$(A$, T, 1))): IF LEN(C$) = 1 THEN C$ = "0" + C$
		B$ = B$ + C$ + " "
		NEXT T
		
		LOCATE 10, Col% + 2
		PRINT "Addr. 0  1  2  3  4  5  6  7  8  9  A  B  C  D  E  F ";
		
		IF K$ = "" THEN T = LEN(B$) - (8 * 16 * 3 - 1) ELSE T = 1
'===============LOOP STARTS HERE   
		
Repeat:    
		T$ = MID$(B$, T, 16 * 3)
		LOCATE 10 + 1 + Row%, Col% + 2:
		H$ = HEX$(T / 3): IF LEN(H$) = 1 THEN H$ = "0" + H$
		PRINT USING "\  \"; H$;
		LOCATE 10 + 1 + Row%, Col% + 5
		PRINT " - "; T$;
		PRINT "  ";
		FOR J = 1 TO 16
		J$ = MID$(A$, (T - 1) / 3 + J, 1)
		IF ASC(J$) < 32 OR ASC(J$) > 126 THEN PRINT " ";  ELSE PRINT J$;
		
		NEXT J
		
		Row% = Row% + 1: IF Row% < 8 THEN GOTO NextRow ELSE Row% = 0
		'locate 21,1: print len(B$)
		'locate 22,1: print t
		'locate 23,1: print (t-1)/(3*16)
		DO
		K$ = INKEY$
		LOOP UNTIL K$ <> ""
		K$ = UCASE$(K$)
		IF K$ = CHR$(27) THEN GOTO GEXIT
		
		' Arrow Down
		IF K$ <> CHR$(0) + CHR$(80) THEN GOTO ArrowUPkey
		T = T - (16 * 3 * 6): IF T < 1 THEN T = 1
		GOTO Repeat
		
ArrowUPkey:      ' Arrow UP
		IF K$ <> CHR$(0) + CHR$(72) AND K$ <> CHR$(0) + CHR$(73) THEN GOTO NextRow
		IF K$ <> CHR$(0) + CHR$(72) THEN GOTO PageUPKey
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 8): IF T < 1 THEN T = 1
		GOTO Repeat
PageUPKey:             
		' Page UP
		IF T < 8 * 16 * 3 THEN K$ = CHR$(0) + CHR$(72): GOTO GEXIT
		T = T - (16 * 3 * 15): IF T < 1 THEN T = 1
		GOTO Repeat

NextRow:   
		T = T + (16 * 3)
		IF T < LEN(B$) THEN GOTO Repeat
		K$ = "Y"
'===============LOOP ENDS HERE
GEXIT:
END SUB


SUB ShortName (A$)
' Get short filename (8.3 characters)
		IF MyVal(0) <> -1 THEN EXIT SUB  'Windows not running!
		C$ = "INT7160.com " + A$ + ">--"'Redirect output to a file named "--"
		SHELL C$
		OPEN "--" FOR INPUT AS #71
		IF EOF(71) <> 0 THEN GOTO ShortName2
		LINE INPUT #71, A$
ShortName2:     CLOSE #71
		KILL "--"
ShortNameEnd:
END SUB

SUB TellPathFrom (Full$, Path$, File$)
' Tell Path from File
		FOR T = LEN(Full$) TO 1 STEP -1
		IF MID$(Full$, T, 1) = "\" THEN GOTO TPath1
		NEXT T
		Path$ = "": File$ = Full$
		P = INSTR(File$, ":"): IF P > 0 THEN Path$ = LEFT$(Full$, P): File$ = RIGHT$(Full$, LEN(Full$) - P)
		GOTO TPath2

TPath1:          Path$ = LEFT$(Full$, T): File$ = RIGHT$(Full$, LEN(Full$) - T)
TPath2:
END SUB

DEFSNG A-Z

SUB ThisHelp(Banner$, DatFile$, IDXFile$, Argum$)
		GOTO GetHelp

' Because of MS QBasic quirks, GetIDX routine has to be placed before the rest of the code.

' Get .IDX file values into an array, that is, 
' Get Array Parameters from Index (IDX) file
GetIDX:         
		OPEN IDXFile$ FOR RANDOM ACCESS READ AS #3 LEN = LEN(IDXRecord)
		GET #3, , IDXRecord
		TLines% = IDXRecord.StartRec' First record is special: total records that follow
		
		
		REDIM IDXSect$(TLines%)
		REDIM IdxStart(TLines%)
		REDIM IdxLength(TLines%)
		FOR t = 1 TO TLines%
		GET #3, , IDXRecord
		IDXSect$(t) = LTRIM$(IDXRecord.Section)
		IdxStart(t) = IDXRecord.StartRec
		IdxLength(t) = IDXRecord.RecLength
		IDXSect$(t) = LTRIM$(RTRIM$(IDXSect$(t)))
		NEXT t
		CLOSE #3
		
		RETURN
		

		

GetHelp:        CLS
		LOCATE 1, 26: PRINT Banner$
		InizRw% = 2
		TotScrRws% = 12
		CurrScrRw% = 1
		
		GOSUB RedrawBox
		GOSUB GetIDX
		FOR Arg% = 1 TO TLines%
		IF Argum$ = IDXSect$(Arg%) THEN GOTO ArgFnd
		NEXT Arg%
		Arg% = 1
		
ArgFnd:         CurntLine% = Arg%
		RcLen% = 77 + 2
		OPEN DatFile$ FOR RANDOM ACCESS READ AS #59 LEN = RcLen%
		FIELD #59, RcLen% - 2 AS DL$
		FIELD #59, 2 AS CRLF$
		
'===================================
' MAIN LOOP STARTS HERE
'===================================       
NextLineName:
		COLOR 7, 0
		
		IF CurrScrRw% = 1 THEN FstLine% = CurntLine%   ' Get Number of first Line only
		GOSUB DisplayRw
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		CurrScrRw% = CurrScrRw% + 1  ' Next Screen Row
		IF CurrScrRw% < TotScrRws% + 1 AND CurntLine% <= TLines% THEN GOTO NextLineName
'===================================
' MAIN LOOP ENDS HERE
'===================================
'           
		GOSUB BotLine              ' Clear Unused Bottom Lines
		LastLine% = CurntLine% - 1
		CurntLine% = FstLine%  ' Current Line is now first Line in screen
		
		CurrScrRw% = 1
		IF KeepCursBot% = 0 THEN GOTO LocCursor2
		' Last key used was Arrow Down. Move Cursor and FileNumber pointer to last Line in Screen
		CurrScrRw% = TotScrRws%: KeepCursBot% = 0: CurntLine% = LastLine%
		GOTO LocCursor2
		
LocCursor:
		GOSUB HeRestColor

LocCursor2:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		COLOR 0, 7: GOSUB DisplayRw: COLOR 7, 0 ' Display Current Row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		OldScrRw% = CurrScrRw%
		OldLine% = CurntLine%
		IF GoToThisDir% <> 0 THEN CurntLine% = GoToThisDir%: GoToThisDir% = 0: GOTO Exekit
		'GOSUB ShowValues    ' My little Debugger
		
		
DoHeAgain:      GOSUB GetChar

		' IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO DoHeAgain

		' ESCape Key
		IF UH$ = CHR$(27) THEN GOTO HAbort
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO IsArrDown
EnterKey:       CALL FISCHIO
		GOSUB ThisSect
		GOSUB RePaintHelp
		GOTO NMatch

IsArrDown:     ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO OthKey0
		IF CurrScrRw% < LastScrRw% THEN CurrScrRw% = CurrScrRw% + 1: CurntLine% = CurntLine% + 1: GOTO LocCursor
		IF CurntLine% = TLines% THEN GOTO LocCursor
		CurntLine% = FstLine% + 1
		KeepCursBot% = 1
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
OthKey0:         'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO OthKey1
		IF CurntLine% = 1 THEN GOTO NMatch
		IF CurrScrRw% > 1 THEN CurrScrRw% = CurrScrRw% - 1: CurntLine% = CurntLine% - 1: GOTO LocCursor
		CurntLine% = FstLine% - 1: IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit
		
OthKey1:         ' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO OthKey2
		CurntLine% = FstLine% - TotScrRws%
		IF CurntLine% < 1 THEN CurntLine% = 1
		GOTO Exekit

OthKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO OthKey7
		IF LastLine% + 1 + TotScrRws% > TLines% THEN CurntLine% = TLines% - TotScrRws% + 1: IF CurntLine% < 1 THEN CurntLine% = 1: GOTO Exekit
		CurntLine% = FstLine% + TotScrRws%
		IF CurntLine% > TLines% THEN CurntLine% = FstLine%
		GOTO Exekit
		
OthKey7:         ' Home Key : simply move cursor to top
		IF UH$ <> CHR$(0) + CHR$(71) THEN GOTO OthKey8
		CurrScrRw% = 1: CurntLine% = FstLine%: GOTO LocCursor

OthKey8:         ' End Key : simply move cursor to bottom
		IF UH$ <> CHR$(0) + CHR$(79) THEN GOTO OthKey9
		CurrScrRw% = LastScrRw%: CurntLine% = LastLine%
		GOTO LocCursor
		
OthKey9:        ' F3 = Show Error List
		IF UH$ <> CHR$(0) + CHR$(61) THEN GOTO OthKey10
		GOSUB RePaintHelp
		GOTO NMatch

OthKey10:       ' F7 = Show Sector as Hex
		IF UH$ <> CHR$(0) + CHR$(65) THEN GOTO OthKey11
		GOSUB RePaintHelp
		GOTO NMatch
		
OthKey11:       'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO OthKey12
		GOTO EnterKey
OthKey12:           
		GOTO NMatch


Exekit:         CurrScrRw% = 1     ' Cursor on first screen row
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GOTO NextLineName   ' Start next round

NMatch:         GOTO LocCursor
		
RePaintHelp:     
		GOSUB RedrawBox
		SaveCurrLine% = CurntLine%
		SavCurrScrRw% = CurrScrRw%
		CurntLine% = FstLine%
		FOR CurrScrRw% = 1 TO TotScrRws%
		GOSUB DisplayRw  ' Display Current Row
		CurntLine% = CurntLine% + 1 ' Next Line
		LastScrRw% = CurrScrRw%      ' Save last Screen Row used
		IF CurntLine% > TLines% THEN CurrScrRw% = CurrScrRw% + 1: GOTO RePaintHelp2
		NEXT CurrScrRw%   ' Next Screen Row
		
RePaintHelp2:          
		
		CurntLine% = SaveCurrLine%
		CurrScrRw% = SavCurrScrRw%
		RETURN

HeRestColor:    TempScreenRw% = CurrScrRw%
		TempLine% = CurntLine%
		CurrScrRw% = OldScrRw%
		CurntLine% = OldLine%
		COLOR 7, 0: GOSUB DisplayRw ' Display Current Row
		CurrScrRw% = TempScreenRw%
		CurntLine% = TempLine%
		RETURN

'==========================
' DISPLAY CURRENT ROW
'==========================
DisplayRw:
		LOCATE InizRw% + CurrScrRw%, 2, 1
		GET #59, IdxStart(CurntLine%)
		TL$ = DL$
		FOR t = 1 TO LEN(TL$): IF MID$(TL$, t, 1) <> " " AND MID$(TL$, t, 1) <> "*" THEN GOTO StrtFound
		NEXT t
StrtFound:      TL$ = RIGHT$(TL$, LEN(TL$) - t + 1)
		
		FOR t = LEN(TL$) TO 1 STEP -1: IF MID$(TL$, t, 1) <> " " AND MID$(TL$, t, 1) <> "*" THEN GOTO EndFnd
		NEXT t
EndFnd:         TL$ = LEFT$(TL$, t)
		PRINT IDXSect$(CurntLine%); TAB(10); TL$; SPACE$(79 - 10 - LEN(TL$));
		RETURN
		
'====================
' CLEAR BOTTOM LINES
'====================       
BotLine: 
		
		LOCATE InizRw% + CurrScrRw%, 2, 1

		IF CurrScrRw% >= TotScrRws% THEN GOTO HlpClear ' Blank all unused screen rows, if any

		FOR V = CurrScrRw% TO TotScrRws%
		LOCATE InizRw% + V, 2, 1
		PRINT "                                                                              "
		NEXT V
		
HlpClear:        LOCATE 23, 1: PRINT "Enter=Get Doc. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		RETURN

		
' Create Box
RedrawBox:      CALL box(2, 1, 80, TotScrRws% + 2)
		RETURN
Pranyk:

		PRINT "                         - press any key to return -"
		GOSUB GetChar
		RETURN
		
GetChar:
		DO: UH$ = INKEY$: LOOP UNTIL UH$ <> ""
		RETURN


ThisSect:       TotSectRws% = 19
		SectInizRw% = 2
		SectCurrRw% = 1
		SectStart# = IdxStart(CurntLine%)
		SectCount# = IdxLength(CurntLine%)
		SectCurr# = 0
		Blank$ = SPACE$(78)
		LOCATE 23, 1: PRINT "Enter=Line Down. ArrowUp, ArrowDown, PageUp, PageDown to move around. ESC=Exit"
		CALL box(2, 1, 80, TotSectRws% + 2)
NewRound:             
		FirstRec# = SectCurr#
SectNewLine:             
		GET #59, SectStart# + SectCurr#
		LOCATE SectInizRw% + SectCurrRw%, 2, 1
		PRINT DL$;
		SectCurr# = SectCurr# + 1
		LastSectRw% = SectCurrRw%      ' Save last Screen Row used
		SectCurrRw% = SectCurrRw% + 1
		IF SectCurrRw% < TotSectRws% + 1 AND SectCurr# < SectCount# THEN GOTO SectNewLine
		
		FOR V = SectCurrRw% TO TotSectRws%
		LOCATE SectInizRw% + V, 2
		PRINT Blank$;
		NEXT V
		
GetAnother:     GOSUB GetChar
		'IF INSTR(AllowedKey$, UH$) = 0 THEN GOTO GetAnother
		SectCurr# = FirstRec#
		SectCurrRw% = 1
		' ESC Key
		IF UH$ = CHR$(27) THEN GOTO SectExit
		
		' ENTER Key
		IF UH$ <> CHR$(13) THEN GOTO SectArrowDown
SectEnter:      IF SectCurr# < SectCount# - 6 THEN SectCurr# = SectCurr# + 1
		GOTO NewRound
		
SectArrowDown:  ' Arrow Down Key
		IF UH$ <> CHR$(0) + CHR$(80) THEN GOTO SectKey0
		GOTO SectEnter
		
SectKey0:       'Arrow up Key
		IF UH$ <> CHR$(0) + CHR$(72) THEN GOTO SectKey1
		IF SectCurr# > 0 THEN SectCurr# = SectCurr# - 1
		GOTO NewRound
SectKey1:           
		' Page Up Key
		IF UH$ <> CHR$(0) + CHR$(73) THEN GOTO SectKey2
SectPageUp:     SectCurr# = SectCurr# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey2:        ' Page Down Key
		IF UH$ <> CHR$(0) + CHR$(81) THEN GOTO SectKey11
SectPageDown:   SectCurr# = SectCurr# + TotSectRws%
		IF SectCurr# > SectCount# - TotSectRws% THEN SectCurr# = SectCount# - TotSectRws%
		IF SectCurr# < 0 THEN SectCurr# = 0
		GOTO NewRound
		
SectKey11:      'CTRL Page Down
		IF UH$ <> CHR$(0) + CHR$(118) THEN GOTO SectKey12
		GOTO SectPageDown
		
SectKey12:      'CTRL Page Up
		IF UH$ <> CHR$(0) + CHR$(132) THEN GOTO SectKey13
		GOTO SectPageUp
SectKey13:          
		GOTO NewRound
SectExit:               
		V = InizRw% + TotScrRws%
		LOCATE V, 1, 1
		IF V >= 22 THEN GOTO DontDoit ' Blank all unused screen rows, if any

		FOR V = V TO 23
		LOCATE V, 1, 1
		PRINT SPACE$(80)
		NEXT V
DontDoit:
		
		RETURN
HAbort:             
		CLOSE #59
END SUB





DEFINT A-Z
