' Everyting you need to add Virtual Sector to your source code
		DIM SHARED FileNum AS INTEGER
		DIM SHARED Gap1%            ' Start of track Gap
		DIM SHARED PreIDGap%           '
		DIM SHARED PreDatGap%
		DIM SHARED SLength%
		DIM SHARED TrkLen&
		DIM SHARED TrackSing(1) AS STRING * 3253
		DIM SHARED TrackDoub(1) AS STRING * 6872
		DIM SHARED V9T9Sekt(1) AS STRING * 256
		DIM SHARED OldTrack&
		DIM SHARED OldDskSide&
		DIM SHARED SideLen&

		DIM SHARED SekTrack%
		DIM SHARED FType$
		
		
		DIM SHARED MHTB&
		DIM SHARED MHSectZero&
		DIM SHARED MHSecLen%
		DIM SHARED MHSekt256(1) AS STRING * 256
		DIM SHARED MHSekt512(1) AS STRING * 512
		DIM SHARED MHFloppy$
		DIM SHARED SubDirStAddr(0 TO 10)  AS INTEGER
		DIM SHARED SubDirName$(0 TO 10)
		DIM SHARED SectPerAU%
		DIM SHARED SourcePath$


' ESTABLISH MEDIA OF A PC99 OR V9T9 DISK AND GET SECTOR ZERO
' Ex. Call GetVirtualZero (1, d$)
'       .... will return
'FType$ = "VS" if V9T9 disk
'FType$ = "PS" if PC99 Single density disk
'FType$ = "PD" if PC99 Double density disk
'FType$ = "MH" if Messa Hard Disk
SUB GetVirtualZero (FileNum%, d$)
		
		ByteOff& = 1
		MHSecLen% = 256
		DIM DAT(1) AS STRING * 256
		CALL TellWhatDisk(FileNum%, d$, WhatDisk$)
		DAT(1)=d$
		FType$ = WhatDisk$
		
		IF WhatDisk$<>"MH" THEN GOTO GetVirtV9T9
		
'*** MESS HARD DISK ***		
	
		ERASE V9T9Sekt
		ERASE TrackSing
		ERASE TrackDoub
		
		' Mess Hard Disk
		MHTB& = CalcDWord&(DAT(1), 28 + 1)  ' Get Total # of Blocks
		MHMapStart& = CalcDWord&(DAT(1), 8 + 1)  ' Get Hard Disk Header Size
		MHMapEnd& = MHTB& * 8 + MHMapStart&  ' Get Total # of Blocks * 8 + Hard Disk Header Size
		MHSectZero& = MHMapEnd& + 8
		MHSecLen% = CalcDWord&(DAT(1), 76 + 1) ' Get Hard Disk Sector Len
		
		ByteOff& = MHSectZero&
		IF MHSecLen% = 256 THEN ERASE MHSekt512 ELSE ERASE MHSekt256
		SELECT CASE MHSecLen%
		
		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)

		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		CASE ELSE
		PRINT "Unexpected Sector Length in Mess Hard Disk": SYSTEM
		END SELECT
		GOTO EstMedExit
		
GetVirtV9T9:	
		ERASE MHSekt256
		ERASE MHSekt512
		
		IF WhatDisk$<>"VS" THEN GOTO GetVirtPC99SD
'*** V9T9 DISK ***			 
	
		ERASE TrackSing
		ERASE TrackDoub
		
		
		' V-9T9 S-ingle density
		d$ = MID$(DAT(1), 1, 256)
		GOTO EstMedExit

GetVirtPC99SD:	
		ERASE V9T9Sekt
		P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO EstMedAbort
		IF WhatDisk$<>"PS" THEN GOTO GetVirtPC99DD
		
'*** PC99 SINGLE DENSITY DISK ***		
		ERASE TrackDoub
			
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(1) THEN GOTO EstMedAbort
		IF P <> 23 THEN GOTO EstMedAbort
		Gap1% = 16             ' Start of track Gap
		PreIDGap% = 7          '
		PreDatGap% = 31
		SLength% = 334
		SekTrack% = 9
		
		CONST TrkLenS% = 3253
		TrkLen& = TrkLenS%

		GET #FileNum%, 1, TrackSing(1)
		d$ = TrackSing(1)
		FType$ = "PS"          ' P-C99 S-ingle density
		
		GOTO GetSZero2

		
'*** PC99 DOUBLE DENSITY DISK ***  
GetVirtPC99DD: 
		IF WhatDisk$<>"PD" THEN GOTO EstMedAbort
		ERASE TrackSing
		
		IF P <> 54 THEN GOTO EstMedAbort
		Gap1% = 40             ' Start of track Gap
		PreIDGap% = 14
		PreDatGap% = 58
		SLength% = 340
		SekTrack% = 18
		
		CONST TrkLenD% = 6872
		TrkLen& = 6872
		GET #FileNum%, 1, TrackDoub(1)
		d$ = TrackDoub(1)

GetSZero2:
		OldTrack& = 0
		OldDskSide& = 0
		SideLen& = TrkLen& * 40
		FOR T = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (T - 1))
		A$ = MID$(d$, P, 4)
		
		IF A$ = CHR$(0) + CHR$(0) + CHR$(0) + CHR$(1) THEN GOTO SZeroFnd
		NEXT T
		GOTO EstMedAbort
SZeroFnd:       P = 1 + Gap1% + PreDatGap% + (SLength% * (T - 1))
		d$ = MID$(d$, P, 256)
		GOTO EstMedExit
		

EstMedAbort:    FType$ = ""  : d$ = ""
EstMedExit:     ERASE DAT
END SUB

SUB TellWhatDisk(FileNum%, d$, WhatDisk$)
		MHSecLen% = 256
		DIM DAT(1) AS STRING * 256
		GET #FileNum%, 1, DAT(1)
		d$=DAT(1)
		IF MID$(DAT(1), 1, 8) <> "MComprHD" THEN GOTO TellDSKDetect
		WhatDisk$="MH" : GOTO TellWhatDExit
TellDSKDetect: 
		
		IF MID$(DAT(1), 14, 3) <> "DSK" THEN GOTO TellPC99Detect
		WhatDisk$="VS" : GOTO TellWhatDExit
TellPC99Detect: P = INSTR(DAT(1), CHR$(&HFE)): IF P = 0 THEN GOTO TellWhatDAbort
		A$ = MID$(DAT(1), P + 4, 1)
		IF A$ <> CHR$(&H1) THEN GOTO TellWhatDAbort
		A$ = MID$(DAT(1), P - 3, 3)
		IF A$ = CHR$(&HA1) + CHR$(&HA1) + CHR$(&HA1) THEN WhatDisk$="PD" : GOTO TellWhatDExit
		IF A$ <> CHR$(0) + CHR$(0) + CHR$(0) THEN GOTO TellWhatDAbort
		WhatDisk$="PS" : GOTO TellWhatDExit
		
TellWhatDAbort: WhatDisk$ = ""  : d$ = ""

TellWhatDExit:  ERASE DAT
END SUB 

DEFSNG A-Z
' READ A SECTOR FROM ANY OF THE FOLLOWING : PC99 DISK, V9T9 DISK, TI99-PC DISK, MESS HARD DISK
SUB GetVirtualSect (FileNum%, Sektor&, d$)
		Sekr& = Sektor& - 1
		
		IF FType$ <> "MH" THEN GOTO NoMHDisk            ' See if it is a Mess Hard Disk
		ByteOff& = Sekr& + 1
		ByteOff& = ByteOff& * MHSecLen% + MHSectZero&
		SELECT CASE MHSecLen%
		CASE 256
		GET #FileNum%, ByteOff& + 1, MHSekt256(1)
		d$ = MHSekt256(1)
		CASE 512
		GET #FileNum%, ByteOff& + 1, MHSekt512(1)
		d$ = MHSekt512(1)
		END SELECT
		GOTO GetSectExit
		
		
		
NoMHDisk: 
		IF FType$ <> "VS" THEN GOTO PC99disk            ' V-9T9 S-ingle density
		ByteOff& = Sekr&
		ByteOff& = ByteOff& * MHSecLen%
		GET #FileNum%, ByteOff& + 1, V9T9Sekt(1)
		d$ = V9T9Sekt(1)
		GOTO GetSectExit
	
PC99disk:       Trk& = INT(Sekr& / SekTrack%)
		DskSide& = 0
		IF Trk& > 39 THEN Trk& = 79 - Trk&: DskSide& = 1
		Skt% = Sekr& MOD SekTrack%
		
		IF FType$ = "PD" THEN GOTO GetSectD
		IF FType$ = "PS" THEN GOTO GetSectS

'*** SINGLE DENSITY DISK ***
GetSectS:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectS03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackSing(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&
		
GetSectS03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackSing(1), P, 4)
		 
		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectS05
		d$ = MID$(TrackSing(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit
		
GetSectS05:     NEXT WHT%
		
		GOTO GetSectBad:
				
'*** DOUBLE DENSITY DISK ***
GetSectD:       IF Trk& = OldTrack& AND DskSide& = OldDskSide& THEN GOTO GetSectD03
		ByteOff& = SideLen& * DskSide& + Trk& * TrkLen&
		GET #FileNum%, ByteOff& + 1, TrackDoub(1)
		OldTrack& = Trk&: OldDskSide& = DskSide&
		
GetSectD03:     FOR WHT% = 1 TO SekTrack%
		P = 1 + Gap1% + PreIDGap% + (SLength% * (WHT% - 1))
		A$ = MID$(TrackDoub(1), P, 4)
		 
		IF A$ <> CHR$(Trk&) + CHR$(DskSide&) + CHR$(Skt%) + CHR$(1) THEN GOTO GetSectD05
		d$ = MID$(TrackDoub(1), 1 + Gap1% + PreDatGap% + (SLength% * (WHT% - 1)), 256)
		GOTO GetSectExit
		
GetSectD05:     NEXT WHT%

GetSectBad:     d$ = ""
		
GetSectExit:
END SUB



FUNCTION CalcDWord& (A$, P%)
		IF LEN(A$) < P% + 3 THEN INPUT "Wrong String in CalcDoubleWord Subroutine", C$: V& = 0: GOTO CalcDWord1
		
		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		B3& = ASC(MID$(A$, P% + 2, 1))
		B4& = ASC(MID$(A$, P% + 3, 1))
		V& = (B1& * 16777216) + (B2& * 65536) + (B3& * 256) + B4&
		
CalcDWord1:     CalcDWord& = (V&)
		  
END FUNCTION

FUNCTION CalcWord& (A$, P%)
		IF LEN(A$) < P% + 1 THEN INPUT "Wrong String in CalcWord Subroutine", C$: V% = 0: GOTO CalcWord1
		B1& = ASC(MID$(A$, P%, 1))
		B2& = ASC(MID$(A$, P% + 1, 1))
		V& = (B1& * 256) + B2&
CalcWord1:      CalcWord& = (V&)
END FUNCTION
