WRITE_HANDLER( pc1640_port60_w );
READ_HANDLER( pc1640_port60_r );

READ_HANDLER( pc1640_mouse_x_r );
READ_HANDLER( pc1640_mouse_y_r );

WRITE_HANDLER( pc1640_mouse_x_w );
WRITE_HANDLER( pc1640_mouse_y_w );

READ_HANDLER( pc1640_port3d0_r );
READ_HANDLER( pc200_port378_r );
READ_HANDLER( pc1640_port378_r );
READ_HANDLER( pc1640_port4278_r );
READ_HANDLER( pc1640_port278_r );

#define PC200_MODE (input_port_1_r(0)&0x30)
#define PC200_MDA 0x30

#define AMSTRAD_HELPER(bit, text, key1, key2) \
	PORT_BITX( bit, 0x0000, IPT_KEYBOARD, text, key1, key2 )

#define AMSTRAD_KEYBOARD \
    PORT_START  /* IN4 */\
	PORT_BIT ( 0x0001, 0x0000, IPT_UNUSED ) 	/* unused scancode 0 */\
	AMSTRAD_HELPER( 0x0002, "Esc",          KEYCODE_ESC,        CODE_NONE ) \
	AMSTRAD_HELPER( 0x0004, "1 !",          KEYCODE_1,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0008, "2 @",          KEYCODE_2,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010, "3 #",          KEYCODE_3,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0020, "4 $",          KEYCODE_4,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0040, "5 %",          KEYCODE_5,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080, "6 ^",          KEYCODE_6,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0100, "7 &",          KEYCODE_7,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0200, "8 *",          KEYCODE_8,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0400, "9 (",          KEYCODE_9,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800, "0 )",          KEYCODE_0,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x1000, "- _",          KEYCODE_MINUS,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000, "= +",          KEYCODE_EQUALS,     CODE_NONE ) \
	AMSTRAD_HELPER( 0x4000, "<--",          KEYCODE_BACKSPACE,  CODE_NONE ) \
	AMSTRAD_HELPER( 0x8000, "Tab",          KEYCODE_TAB,        CODE_NONE ) \
		\
	PORT_START	/* IN5 */\
	AMSTRAD_HELPER( 0x0001, "Q",            KEYCODE_Q,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0002, "W",            KEYCODE_W,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0004, "E",            KEYCODE_E,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0008, "R",            KEYCODE_R,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010, "T",            KEYCODE_T,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0020, "Y",            KEYCODE_Y,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0040, "U",            KEYCODE_U,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080, "I",            KEYCODE_I,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0100, "O",            KEYCODE_O,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0200, "P",            KEYCODE_P,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0400, "[ {",          KEYCODE_OPENBRACE,  CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800, "] }",          KEYCODE_CLOSEBRACE, CODE_NONE ) \
	AMSTRAD_HELPER( 0x1000, "Enter",        KEYCODE_ENTER,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000, "Ctrl",			KEYCODE_LCONTROL,   CODE_NONE ) \
	AMSTRAD_HELPER( 0x4000, "A",            KEYCODE_A,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x8000, "S",            KEYCODE_S,          CODE_NONE ) \
		\
	PORT_START	/* IN6 */\
	AMSTRAD_HELPER( 0x0001, "D",            KEYCODE_D,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0002, "F",            KEYCODE_F,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0004, "G",            KEYCODE_G,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0008, "H",            KEYCODE_H,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010, "J",            KEYCODE_J,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0020, "K",            KEYCODE_K,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0040, "L",            KEYCODE_L,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080, "; :",          KEYCODE_COLON,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0100, "' \"",         KEYCODE_QUOTE,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0200, "` ~",          KEYCODE_TILDE,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0400, "L-Shift",      KEYCODE_LSHIFT,     CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800, "\\ |",         KEYCODE_BACKSLASH,  CODE_NONE ) \
	AMSTRAD_HELPER( 0x1000, "Z",            KEYCODE_Z,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000, "X",            KEYCODE_X,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x4000, "C",            KEYCODE_C,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x8000, "V",            KEYCODE_V,          CODE_NONE ) \
		\
	PORT_START	/* IN7 */\
	AMSTRAD_HELPER( 0x0001, "B",            KEYCODE_B,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0002, "N",            KEYCODE_N,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0004, "M",            KEYCODE_M,          CODE_NONE ) \
	AMSTRAD_HELPER( 0x0008, ", <",          KEYCODE_COMMA,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010, ". >",          KEYCODE_STOP,       CODE_NONE ) \
	AMSTRAD_HELPER( 0x0020, "/ ?",          KEYCODE_SLASH,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0040, "R-Shift",      KEYCODE_RSHIFT,     CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080, "KP * (PrtScr)",KEYCODE_ASTERISK,   CODE_NONE ) \
	AMSTRAD_HELPER( 0x0100, "Alt",          KEYCODE_LALT,       CODE_NONE ) \
	AMSTRAD_HELPER( 0x0200, "Space",        KEYCODE_SPACE,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0400, "Caps",         KEYCODE_CAPSLOCK,   CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800, "F1",           KEYCODE_F1,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x1000, "F2",           KEYCODE_F2,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000, "F3",           KEYCODE_F3,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x4000, "F4",           KEYCODE_F4,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x8000, "F5",           KEYCODE_F5,         CODE_NONE ) \
		\
	PORT_START	/* IN8 */\
	AMSTRAD_HELPER( 0x0001, "F6",           KEYCODE_F6,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x0002, "F7",           KEYCODE_F7,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x0004, "F8",           KEYCODE_F8,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x0008, "F9",           KEYCODE_F9,         CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010, "F10",          KEYCODE_F10,        CODE_NONE ) \
	AMSTRAD_HELPER( 0x0020, "NumLock",      KEYCODE_NUMLOCK,    CODE_NONE ) \
	AMSTRAD_HELPER( 0x0040, "ScrLock",      KEYCODE_SCRLOCK,    CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080, "KP 7 (Home)",  KEYCODE_7_PAD,      KEYCODE_HOME )\
	AMSTRAD_HELPER( 0x0100, "KP 8 (Up)",    KEYCODE_8_PAD,      CODE_NONE )  \
	AMSTRAD_HELPER( 0x0200, "KP 9 (PgUp)",  KEYCODE_9_PAD,      KEYCODE_PGUP) \
	AMSTRAD_HELPER( 0x0400, "KP -",         KEYCODE_MINUS_PAD,  CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800, "KP 4 (Left)",  KEYCODE_4_PAD,      CODE_NONE )\
	AMSTRAD_HELPER( 0x1000, "KP 5",         KEYCODE_5_PAD,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000, "KP 6 (Right)", KEYCODE_6_PAD,      CODE_NONE )\
	AMSTRAD_HELPER( 0x4000, "KP +",         KEYCODE_PLUS_PAD,   CODE_NONE ) \
	AMSTRAD_HELPER( 0x8000, "KP 1 (End)",   KEYCODE_1_PAD,      KEYCODE_END ) \
		\
	PORT_START	/* IN9 key codes 0x50 */\
	AMSTRAD_HELPER( 0x0001, "KP 2 (Down)",  KEYCODE_2_PAD,      CODE_NONE ) \
	AMSTRAD_HELPER( 0x0002, "KP 3 (PgDn)",  KEYCODE_3_PAD,      KEYCODE_PGDN ) \
	AMSTRAD_HELPER( 0x0004, "KP 0 (Ins)",   KEYCODE_0_PAD,      KEYCODE_INSERT ) \
	AMSTRAD_HELPER( 0x0008, "KP . (Del)",   KEYCODE_DEL_PAD,    KEYCODE_DEL ) \
	PORT_BIT ( 0x0030, 0x0000, IPT_UNUSED )\
	AMSTRAD_HELPER( 0x0040, "?(84/102)\\",	KEYCODE_BACKSLASH2,	CODE_NONE ) \
	PORT_BIT ( 0xff80, 0x0000, IPT_UNUSED )\
		\
	PORT_START	/* IN10 */\
	PORT_BIT ( 0xffff, 0x0000, IPT_UNUSED )\
		\
	PORT_START	/* IN11 key codes 0x70 */\
	PORT_BIT ( 0x806e, 0x0000, IPT_UNUSED )\
	AMSTRAD_HELPER( 0x0001, "-->",			CODE_DEFAULT,    CODE_NONE ) \
	AMSTRAD_HELPER( 0x0010,	"?Enter",		CODE_DEFAULT,    CODE_NONE ) \
	AMSTRAD_HELPER( 0x0100,	"Amstrad Joystick Button 1",KEYCODE_RALT, CODE_NONE ) \
	AMSTRAD_HELPER( 0x0080,	"Amstrad Joystick Button 2",KEYCODE_RCONTROL, CODE_NONE ) \
	AMSTRAD_HELPER( 0x0200,	"Amstrad Joystick Right",	KEYCODE_RIGHT, CODE_NONE ) \
	AMSTRAD_HELPER( 0x0400,	"Amstrad Joystick Left",	KEYCODE_LEFT, CODE_NONE ) \
	AMSTRAD_HELPER( 0x0800,	"Amstrad Joystick Down",	KEYCODE_DOWN, CODE_NONE ) \
	AMSTRAD_HELPER( 0x1000,	"Amstrad Joystick Up",		KEYCODE_UP, CODE_NONE ) \
	AMSTRAD_HELPER( 0x4000,	"Amstrad Mouse Button left",	KEYCODE_F11, CODE_NONE ) \
	AMSTRAD_HELPER( 0x2000,	"Amstrad Mouse Button right",	KEYCODE_F12, CODE_NONE ) \
	PORT_START	/* IN12 */\
	PORT_BIT ( 0xffff, 0x0000, IPT_UNUSED )\
	PORT_START /* IN13 Mouse - X AXIS */ \
	PORT_ANALOGX( 0xff, 0x00, IPT_TRACKBALL_X | IPF_REVERSE|IPF_PLAYER1, 100, 0, 0, 0, \
				  CODE_DEFAULT, CODE_DEFAULT, CODE_NONE, CODE_NONE ) \
	PORT_START /* IN14 Mouse - Y AXIS */ \
	PORT_ANALOGX( 0xff, 0x00, IPT_TRACKBALL_Y | IPF_PLAYER1, 100, 0, 0, 0, \
				  CODE_DEFAULT, CODE_DEFAULT, CODE_NONE, CODE_NONE )
