
enum
{
	vdt911_chr_region = REGION_GFX1
};

enum
{
	/* 10 bytes per character definition */
	vdt911_single_char_len = 10,

	vdt911_US_chr_offset		= 0,
	vdt911_UK_chr_offset		= vdt911_US_chr_offset+128*vdt911_single_char_len,
	vdt911_german_chr_offset	= vdt911_UK_chr_offset+128*vdt911_single_char_len,
	vdt911_swedish_chr_offset	= vdt911_german_chr_offset+128*vdt911_single_char_len,
	vdt911_norwegian_chr_offset = vdt911_swedish_chr_offset+128*vdt911_single_char_len,
	vdt911_frenchWP_chr_offset	= vdt911_norwegian_chr_offset+128*vdt911_single_char_len,
	vdt911_japanese_chr_offset	= vdt911_frenchWP_chr_offset+128*vdt911_single_char_len,

	vdt911_chr_region_len	= vdt911_japanese_chr_offset+256*vdt911_single_char_len
};

extern struct GfxDecodeInfo vdt911_gfxdecodeinfo[];

extern unsigned char vdt911_palette[];
extern unsigned short vdt911_colortable[];
enum
{
	vdt911_palette_size = 3 /** 3*/,
	vdt911_colortable_size = 4 * 2
};


typedef enum { char_960, char_1920 } vdt911_screen_size_t;
typedef enum
{
	vdt911_model_US,
	vdt911_model_UK,
	vdt911_model_French,
	vdt911_model_German,
	vdt911_model_Swedish,	/* Swedish/Finnish */
	vdt911_model_Norwegian,	/* Norwegian/Danish */
	vdt911_model_Japanese,	/* Katakana Japanese */
	/*vdt911_model_Arabic,*//* Arabic */
	vdt911_model_FrenchWP	/* French word processing */
} vdt911_model_t;

typedef struct vdt911_init_params_t
{
	vdt911_screen_size_t screen_size;
	vdt911_model_t model;
	void (*int_callback)(int state);
} vdt911_init_params_t;

void palette_init_vdt911(unsigned short *colortable, const unsigned char *dummy);

void vdt911_init(void);
int vdt911_init_term(int unit, const vdt911_init_params_t *params);

void vdt911_reset(void);

int vdt911_cru_r(int offset, int unit);
void vdt911_cru_w(int offset, int data, int unit);

READ16_HANDLER(vdt911_0_cru_r);
WRITE16_HANDLER(vdt911_0_cru_w);

void vdt911_refresh(struct mame_bitmap *bitmap, int unit, int x, int y);

void vdt911_keyboard(int unit);

#define VDT911_KEY_PORTS																		\
	PORT_START	/* keys 1-16 */																	\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F1",     KEYCODE_F1, IP_JOY_NONE)		\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F2",     KEYCODE_F2, IP_JOY_NONE)		\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F3",     KEYCODE_F3, IP_JOY_NONE)		\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F4",     KEYCODE_F4, IP_JOY_NONE)		\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F5",     KEYCODE_F5, IP_JOY_NONE)		\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F6",     KEYCODE_F6, IP_JOY_NONE)		\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F7",     KEYCODE_F7, IP_JOY_NONE)		\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F8",     KEYCODE_F8, IP_JOY_NONE)		\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "CMD",    KEYCODE_F9, IP_JOY_NONE)		\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(red)",  KEYCODE_F10, IP_JOY_NONE)		\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "ERASE FIELD", KEYCODE_END, IP_JOY_NONE)	\
		PORT_BITX(0x0800, IP_ACTIVE_HIGH, IPT_KEYBOARD, "ERASE INPUT", KEYCODE_PGDN, IP_JOY_NONE)	\
		PORT_BITX(0x1000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(grey)", KEYCODE_F11, IP_JOY_NONE)		\
		PORT_BITX(0x2000, IP_ACTIVE_HIGH, IPT_KEYBOARD | IPF_TOGGLE, "UPPER CAPS LOCK", KEYCODE_CAPSLOCK, IP_JOY_NONE)	\
		PORT_BITX(0x4000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "1 !",    KEYCODE_1, IP_JOY_NONE)		\
		PORT_BITX(0x8000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "2 @",    KEYCODE_2, IP_JOY_NONE)		\
																								\
	PORT_START	/* keys 17-32 */																\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "3 #",    KEYCODE_3, IP_JOY_NONE)		\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "4 $",    KEYCODE_4, IP_JOY_NONE)		\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, "5 %",    KEYCODE_5, IP_JOY_NONE)		\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, "6 ^",    KEYCODE_6, IP_JOY_NONE)		\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "7 &",    KEYCODE_7, IP_JOY_NONE)		\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "8 *",    KEYCODE_8, IP_JOY_NONE)		\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "9 (",    KEYCODE_9, IP_JOY_NONE)		\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, "0 )",    KEYCODE_0, IP_JOY_NONE)		\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "+ [",    KEYCODE_MINUS, IP_JOY_NONE)	\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "- ]",    KEYCODE_EQUALS, IP_JOY_NONE)	\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "_ =",    KEYCODE_BACKSPACE, IP_JOY_NONE)	\
		PORT_BITX(0x0800, IP_ACTIVE_HIGH, IPT_KEYBOARD, "ESC",    KEYCODE_ESC, IP_JOY_NONE)		\
		PORT_BITX(0x1000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "7 (numpad)", KEYCODE_7_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x2000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "8 (numpad)", KEYCODE_8_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x4000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "9 (numpad)", KEYCODE_9_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x8000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "PRINT",  KEYCODE_PRTSCR, IP_JOY_NONE)	\
																								\
	PORT_START	/* keys 33-48 */																\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(up)",   KEYCODE_UP, IP_JOY_NONE)		\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "REPEAT", KEYCODE_LALT, IP_JOY_NONE)	\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, "ENTER",  KEYCODE_ENTER_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, "Q",      KEYCODE_Q, IP_JOY_NONE)		\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "W",      KEYCODE_W, IP_JOY_NONE)		\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "E",      KEYCODE_E, IP_JOY_NONE)		\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "R",      KEYCODE_R, IP_JOY_NONE)		\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, "T",      KEYCODE_T, IP_JOY_NONE)		\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "Y",      KEYCODE_Y, IP_JOY_NONE)		\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "U",      KEYCODE_U, IP_JOY_NONE)		\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "I",      KEYCODE_I, IP_JOY_NONE)		\
		PORT_BITX(0x0800, IP_ACTIVE_HIGH, IPT_KEYBOARD, "O",      KEYCODE_O, IP_JOY_NONE)		\
		PORT_BITX(0x1000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "P",      KEYCODE_P, IP_JOY_NONE)		\
		PORT_BITX(0x2000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "CHAR (left/right)", KEYCODE_OPENBRACE, IP_JOY_NONE)	\
		PORT_BITX(0x4000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "FIELD (left/right)", KEYCODE_CLOSEBRACE, IP_JOY_NONE)	\
		PORT_BITX(0x8000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "RETURN", KEYCODE_ENTER, IP_JOY_NONE)	\
																								\
	PORT_START	/* keys 49-64 */																\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "4 (numpad)", KEYCODE_4_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "5 (numpad)", KEYCODE_5_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, "6 (numpad)", KEYCODE_6_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(left)", KEYCODE_LEFT, IP_JOY_NONE)	\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "HOME",   KEYCODE_HOME, IP_JOY_NONE)	\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(right)",KEYCODE_RIGHT, IP_JOY_NONE)	\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "CONTROL",KEYCODE_LCONTROL, IP_JOY_NONE)	\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, "A",      KEYCODE_A, IP_JOY_NONE)		\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "S",      KEYCODE_S, IP_JOY_NONE)		\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "D",      KEYCODE_D, IP_JOY_NONE)		\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "F",      KEYCODE_F, IP_JOY_NONE)		\
		PORT_BITX(0x0800, IP_ACTIVE_HIGH, IPT_KEYBOARD, "G",      KEYCODE_G, IP_JOY_NONE)		\
		PORT_BITX(0x1000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "H",      KEYCODE_H, IP_JOY_NONE)		\
		PORT_BITX(0x2000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "J",      KEYCODE_J, IP_JOY_NONE)		\
		PORT_BITX(0x4000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "K",      KEYCODE_K, IP_JOY_NONE)		\
		PORT_BITX(0x8000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "L",      KEYCODE_L, IP_JOY_NONE)		\
																								\
	PORT_START	/* keys 65-80 */																\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "; :",    KEYCODE_COLON, IP_JOY_NONE)	\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "' \"",   KEYCODE_QUOTE, IP_JOY_NONE)	\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(not on US keyboard)", KEYCODE_BACKSLASH, IP_JOY_NONE)	\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, "SKIP TAB", KEYCODE_TAB, IP_JOY_NONE)	\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "1 (numpad)", KEYCODE_1_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "2 (numpad)", KEYCODE_2_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "3 (numpad)", KEYCODE_3_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, "INS CHAR", KEYCODE_INSERT, IP_JOY_NONE)	\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(down)", KEYCODE_DOWN, IP_JOY_NONE)	\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "DEL CHAR", KEYCODE_DEL, IP_JOY_NONE)	\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "SHIFT",  KEYCODE_LSHIFT, IP_JOY_NONE)	\
		PORT_BITX(0x0800, IP_ACTIVE_HIGH, IPT_KEYBOARD, "Z",      KEYCODE_Z, IP_JOY_NONE)		\
		PORT_BITX(0x1000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "X",      KEYCODE_X, IP_JOY_NONE)		\
		PORT_BITX(0x2000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "C",      KEYCODE_C, IP_JOY_NONE)		\
		PORT_BITX(0x4000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "V",      KEYCODE_V, IP_JOY_NONE)		\
		PORT_BITX(0x8000, IP_ACTIVE_HIGH, IPT_KEYBOARD, "B",      KEYCODE_B, IP_JOY_NONE)		\
																								\
	PORT_START	/* keys 81-91 */																\
		PORT_BITX(0x0001, IP_ACTIVE_HIGH, IPT_KEYBOARD, "N",      KEYCODE_N, IP_JOY_NONE)		\
		PORT_BITX(0x0002, IP_ACTIVE_HIGH, IPT_KEYBOARD, "M",      KEYCODE_M, IP_JOY_NONE)		\
		PORT_BITX(0x0004, IP_ACTIVE_HIGH, IPT_KEYBOARD, ", <",    KEYCODE_COMMA, IP_JOY_NONE)	\
		PORT_BITX(0x0008, IP_ACTIVE_HIGH, IPT_KEYBOARD, ". >",    KEYCODE_STOP, IP_JOY_NONE)	\
		PORT_BITX(0x0010, IP_ACTIVE_HIGH, IPT_KEYBOARD, "/ ?",    KEYCODE_SLASH, IP_JOY_NONE)	\
		PORT_BITX(0x0020, IP_ACTIVE_HIGH, IPT_KEYBOARD, "SHIFT",  KEYCODE_RSHIFT, IP_JOY_NONE)	\
		PORT_BITX(0x0040, IP_ACTIVE_HIGH, IPT_KEYBOARD, "0 (numpad)", KEYCODE_0_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0080, IP_ACTIVE_HIGH, IPT_KEYBOARD, ". (numpad)", KEYCODE_DEL_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0100, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(not on US keyboard)", KEYCODE_MINUS_PAD, IP_JOY_NONE)	\
		PORT_BITX(0x0200, IP_ACTIVE_HIGH, IPT_KEYBOARD, "SPACE",  KEYCODE_SPACE, IP_JOY_NONE)	\
		PORT_BITX(0x0400, IP_ACTIVE_HIGH, IPT_KEYBOARD, "(not on US keyboard)", KEYCODE_PLUS_PAD, IP_JOY_NONE)

