REM Example of creating an Ti994w and V9t9 compatable program
REM using the C99 cross compiler, LGMA cross assembler, 
REM C99O optimizer, C99X X-files optimizer and L99 the linker
REM
REM When using C99X you do need the supplied CSUP

set SPACE=
set PATH=d:\Ti994w\utl;%path%
set VIEWER=NOTEPAD.EXE

if %1.==. goto callerr
if %2.==. goto callerr
 
:compile
@echo Start Compiling
if exist .\obj\%1.err del .\obj\%1.err
@echo C99C.EXE %1.%2 .\obj\%1.a99
C99C.EXE %1.%2 .\obj\%1.a99 .\obj\%1.err /t
CD .\OBJ
find /I "No errors found" %1.err
if errorlevel 1 goto comperr

@echo Start Optimizing
@echo C99O.EXE %1.a99 %1.o99
C99O.EXE %1.a99 %1.o99

@echo Start X-Optimizing
@echo C99X.EXE %1.o99 %1.s
C99X.EXE %1.o99 %1.s

:A99
@echo Start Assembling
if exist %1.aer del %1.aer
@echo TASM.EXE +ROL -C %1.S
TASM.EXE +ROL -C %1.S 2>%1.aer
find /I "Assembler done.  Errors: 0" %1.aer
if errorlevel 1 goto asmerr

:link
cd ..
@echo Start Linking
if exist %1.ler del %1.ler
@echo L99.EXE %1.L99
@echo L99.EXE %1.L99 >%1.ler
L99.EXE -L%1.L99 -E%1.ler -M%1.map
if errorlevel 1 goto linkerr
goto end

:comperr
@echo Compiler errors
start /WAIT wmessage -MCompiler errors -TC99 -K1 -I4
%VIEWER% %1.ERR
goto end

:asmerr
@echo Assembler errors
start /WAIT wmessage -MAssembler errors -TTasm -K1 -I4
%VIEWER% %1.AER
goto end

:linkerr
start /WAIT wmessage -MLinker errors -TL99 -K1 -I4
%VIEWER% %1.ler
goto end

:callerr
start /WAIT wmessage -MUsage: Make Name Extension -TMake.bat -K1 -I4
goto end

:end

